#ifndef MAINTENANCE_H_
#define MAINTENANCE_H_

#include "config.h"
#include "meta.h"
#include "sockio.h"
#include "acbuf.h"

class maintenance
{
public:
	maintenance(int fd);
	virtual ~maintenance();
	
	/*!
	 *  @brief Main execution method for maintenance tasks.
	 */
	virtual void Run(const MYSTD::string &cmd)=0;

protected:
	inline void SendChunk(const MYSTD::string &x) { SendChunk(x.data(), x.size()); }
	inline void SendChunk(const tSS &x){ SendChunk(x.data(), x.size()); }
	virtual void SendChunk(const char *data, size_t size);
	bool SendRawData(const char *data, size_t len, int flags);
	virtual void EndTransfer();
	MYSTD::string & GetHostname();
	//void SendDecoration(bool bBegin, const char *szDecoFile=NULL);
	void SendChunkedPageHeader(const char *httpcode=NULL, const char *mimetype=NULL);
	void SetStyle(MYSTD::string&);
	int m_reportFD;
	const char *m_szDecoFile;
private:
	maintenance(const maintenance&);
	maintenance& operator=(const maintenance&);
	MYSTD::string m_sHostname;
};


void DispatchAndRunMaintTask(const MYSTD::string &, int, const char*);

#endif /*MAINTENANCE_H_*/
