#!/usr/bin/perl -w
#	@(#) setup.pl -- Setup script for apt-cacher.pl
#	$ Revision: $
#	$ Source: $
#	$ Date: $
#
#	Safe to run multiple times; later versions of this script will
#	remove obsolete directories or files and not touch required
#	directories or files.
#
#	Usage: setup.pl cache-dir

my $path = $ENV{PATH_INFO};

#############################################################################
### configuration ###########################################################
# Include the library for the config file parser
require '/usr/share/apt-cacher/apt-cacher-lib.pl';

# Read in the config file and set the necessary variables
my $configfile = '/etc/apt-cacher/apt-cacher.conf';

my $configref;
eval {
        $configref = read_config($configfile);
};
my %config = %$configref;

# not sure what to do if we can't read the config file...
die "Could not read config file: $@" if $@;

# Now set some things from the config file
# $logfile used to be set in the config file: now we derive it from $logdir
$config{logfile} = "$config{logdir}/access.log";

# $errorfile used to be set in the config file: now we derive it from $logdir
$config{errorfile} = "$config{logdir}/error.log";

my $private_dir = "$config{cache_dir}/private";

################################################
# Check that the cache_dir has been set and continue on (note: this should never happen
# because cache_dir is preset to a default value prior to loading the config file)
die "Warning: config file could not be parsed ($configfile)/ (cache_dir is not set)\n" if ($config{cache_dir} eq '');

foreach my $file (qw/README README.txt/) {
	print "Checking for $file ...\n";
	if (-f $file) {
		print "Unlinking $file (obsolete)\n";
		unlink($file);
	}
}

foreach my $dir ($config{cache_dir}, "$config{cache_dir}/private", "$config{cache_dir}/tmp") {
	if (!-d $dir) {
		print "Doing mkdir($dir, 0755)\n";
		mkdir($dir, 0755);
	}
	if (!-w $dir) {
		die "$dir is not writeable by you!\n";
	}
}

# Remove these directories if they exist (obsolete)
# later rmdir $cache_dir/tmp, just not now as I may want it in future
foreach my $rmdir ("$config{cache_dir}/head") {
	if (-d $rmdir) {
		print "Doing 'rm -rf $rmdir' (obsolete)\n";
		system("rm -rf $rmdir");
	}
}

# At the moment we need to create empty access and error logs so apt-cacher
# doesn't barf the first time it's run. Probably should change apt-cacher
# so it can handle missing logs, and create them itself if required.
`chown www-data.www-data $config{logdir}`;
`touch $config{logfile}`;
`chown www-data.www-data $config{logfile}`;
`touch $config{errorfile}`;
`chown www-data.www-data $config{errorfile}`;

# These ownership changes are a cludge: need to make them check httpd.conf for the Apache
# user and set ownership to that, and do it with Perl instead of shell
`chown -R www-data.www-data $config{cache_dir}`;

# Define the include directive that will be added to httpd.conf
my $config_line = "\n# This line has been appended by the Apt-cacher install script\nInclude /etc/apt-cacher/apache.conf";

# Tack the include line onto the end of Apache's httpd.conf and restart Apache.
# This *should* check first to see whether the include line already exists.
if(-f "/etc/apache/httpd.conf" ) {
	open(APACHEFILE,">>/etc/apache/httpd.conf") or die;
	print APACHEFILE "$config_line\n";
	close APACHEFILE;
	if ( -f "/etc/init.d/apache" ) {
		print "Restarting Apache...";
		`/etc/init.d/apache restart`;
		print " done.\n";
	} else {
		print "Apache startup script was not found. Please restart Apache manually.\n";
	}
}

# Tack the include line onto the end of Apache-SSL's httpd.conf and restart Apache-SSL.
# This *should* check first to see whether the include line already exists.
if(-f "/etc/apache-ssl/httpd.conf" ) {
	open(APACHEFILE,">>/etc/apache-ssl/httpd.conf") or die;
	print APACHEFILE "$config_line\n";
	close APACHEFILE;
	if ( -f "/etc/init.d/apache-ssl" ) {
		print "Restarting Apache-SSL...";
		`/etc/init.d/apache-ssl restart`;
		print " done.\n";
	} else {
		print "Apache-SSL startup script was not found. Please restart Apache-SSL manually.\n";
	}
}

exit(0);
