#
# bug.rb - ruby interface for debian bug
# Copyright (c) 2002 Masato Taruishi <taru@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#

module Debian
  class Bug

    def initialize (pkg_name, bug_number, severity,
		    stat, desc, tags = [], mergeids = [])
      @pkg_name = pkg_name
      @bug_number = bug_number
      @severity = severity
      @stat = stat
      @desc = desc
      @tags = tags
      @mergeids = mergeids
      @log = nil
    end

    def to_s
      "#" + @bug_number + ":" + @pkg_name + ":" + @desc
    end
    
    def inspect
      @bug_number + " - " +
	@pkg_name + " - " +
	@severity + " - " +
	@stat + " - " +
	@tags.to_s + " - " + 
	@desc + " merged with: " + @mergeids.join(', ')
    end
    
    attr_accessor :pkg_name, :bug_number, :severity,
      :stat, :desc, :tags, :mergeids, :log
    
  end
  
  class Bugs < Array

    def each_by_category (pkg, sev, stat)
      each do |bug|
	yield bug if bug.pkg_name == pkg &&
	  bug.severity == sev &&
	  bug.stat == stat
      end
    end

    def sub(type, val)
      sub = Bugs.new
      each do |bug|
	a = "sub << bug if bug.#{type} == val"
	eval a
      end
      sub
    end

  end

end
