# library file sourced by apt-zip-*

APTZIPVERSION=0.13.5
export APTZIPVERSION

CONFFILE=/etc/apt/apt-zip.conf
METHODSDIR=/usr/share/apt-zip
SKIPMOUNT=no
APTGETEXTRAOPTS=""

KNOWNAPTGETACTIONS=" dselect-upgrade upgrade dist-upgrade "
KNOWNOPTIONS="TAR GNUTAR SOLARISTAR RESTART"

DEFAULT_TAR=tar
DEFAULT_GNUTAR=tar
DEFAULT_SOLARISTAR=tar

APTZIPTARFILE=debs-$(uname -n).tar
APTZIPINSFILE=apt-zip.options
export APTZIPINSFILE
export APTZIPTARFILE

error()
{
    echo >&2 "$(basename $0): $*"
    exit 1
}

version_exit()
{
    echo "$(basename $0) version ${APTZIPVERSION}"
    exit 0
}

usage()
{
cat <<EOF
Usage:
	$(basename $0) [options]

where options can be:
 -h, --help   	     Print this help message
 -v, --version       Print version and exit
 -M, --method=METH   Fetch method METH used on download host
 -m, --medium=DIR    Removable medium at mountpoint DIR for the transfers
 -o, --options=LIST  List of options
 -a, --aptgetaction=ACTION
 		     Action ACTION done by apt-get
 -p, --packages=LIST
  	  	     List of extra packages to install
 -A, --accept=LIST   List of accepted protocols for download (http,ftp,..)
 -R, --reject=LIST   List of rejected protocols for download (file,cdrom,..)
 -f, --fix-broken    Call apt-get with this flag
 -s, --skip-mount    Do not mount a device on the dir specified by --medium 
EOF
}

usage_exit()
{
    usage
    exit 0
}

syntax_error()
{
    echo 2>&1 "$(basename $0): $*"
    usage
    exit 1
}

check_method()
{
    FILTER="${SHAREDIR}/methods/$METHOD"
    if [ ! -x "$FILTER" ]
    then
	error "No $METHOD method installed."
    fi
}

check_medium()
{
    [ -d "$MEDIUM" ] || error "$MEDIUM does not exist (no mountpoint)"
}

az_filter()
{
    [ -n "$GREP" ] && GREP=${GREP//^/^\'}
    if [ -n "$ACCEPT" ] ; then 
	ACCEPT=${ACCEPT#, }
	ACCEPT=^$(echo "$ACCEPT" | sed -e "s/[, ]\+/\\\|^/g")
	GREP="'$ACCEPT"
    elif [ -n "$REJECT" ] ; then
	REJECT=${REJECT#, }
	REJECT=^$(echo "$REJECT" | sed -e "s/[, ]\+/\\\|^/g")
	GREP="-v '$REJECT"
    fi
}
check_packages()
{
    PACKAGES=$(echo "$PACKAGES" | sed -e "s/[, ]\+/ /g")
}
check_aptgetaction()
{
    [ -n "$APTGETACTION" ] && 
	echo "$KNOWNAPTGETACTIONS" | grep " $APTGETACTION " &> /dev/null || 
	    error "Unknown apt-get action $APTGETACTION"
}
az_loadconf()
{
    [ -r $CONFFILE ] && . $CONFFILE
    METHOD=${METHOD-wget}
    MEDIUM=${MEDIUM-/ZIP}
    GREP=${GREP-^http\\\|^ftp}
}

az_process_commandline ()
{
    while [ $# -gt 0 ]
    do
	case $1 in
	--method=*)
	    METHOD=${1#--method=}
	    shift
	    ;;
	--method|-M)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    METHOD=$2
	    shift
	    shift
	    ;;
	--medium=*)
	    MEDIUM=${1#--medium=}
	    shift
	    ;;
	--medium|-m)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    MEDIUM=$2
	    #mount point might be relative ( . or .. are legal ;-)
	    CWD=`pwd`
	    cd "$MEDIUM"
	    MEDIUM=`pwd`
	    cd "${CWD}"	#if path is relative, it might contain spaces
	    shift
	    shift
	    ;;
	--options=*)
	    OPTIONS="$OPTIONS, ${1#--options=}"
	    shift
	    ;;
	--options|-o)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    OPTIONS="$OPTIONS, $2"
	    shift
	    shift
	    ;;
	--aptgetaction=*)
	    APTGETACTION=${1#--aptgetaction=}
	    shift
	    ;;
	--aptgetaction|-a)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    APTGETACTION=$2
	    shift
	    shift
	    ;;
	--packages=*)
	    PACKAGES="$PACKAGES, ${1#--packages=}"
	    shift
	    ;;
	--packages|-p)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    PACKAGES="$PACKAGES, $2"
	    shift
	    shift
	    ;;
	--accept=*)
	    ACCEPT="$ACCEPT, ${1#--accept=}"
	    shift
	    ;;
	--accept|-A)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    ACCEPT="$ACCEPT, $2"
	    shift
	    shift
	    ;;
	--reject=*)
	    REJECT="$REJECT, ${1#--reject=}"
	    shift
	    ;;
	--reject|-R)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    REJECT="$REJECT, $2"
	    shift
	    shift
	    ;;
	--fix-broken|-f)
	    APTGETEXTRAOPTS="${APTGETEXTRAOPTS} $1"
	    shift
	    ;;
	--skip-mount|-s)
	    SKIPMOUNT=yes
	    shift
	    ;;
	--version|-V)
	    version_exit
	    ;;
	--help|-h)
	    usage_exit
	    ;;
	-*)
	    syntax_error "Unknown option \`$1'"
	    ;;
	*)
	    syntax_error "No non-option arguments allowed"
	    ;;
	esac
    done
}

az_process_options()
{
    OPTIONS=$(echo "$OPTIONS" | awk 'BEGIN { RS = ", *" ; ORS = " " ; FS = "=" } { print toupper($1) ( $2 != "" ? "=" $2 : "" ) }'
)
    export OPTIONS

    # ensure known opts are set to 0 if not requested
    for kopt in $KNOWNOPTIONS
    do
	eval export OPTION_${kopt}=0
    done
    
    for opt in $OPTIONS
    do
	# Warn if unknown option
	local opt_known=0
	for kopt in $KNOWNOPTIONS
	do
	    case $opt in $kopt|NO$kopt|$kopt=*) opt_known=1 ;; esac
	done
	[ $opt_known = 0 ] && echo >&2 "WARNING: Unknown option \`$opt'"

	# Export option
	case ${opt} in
	*=*)
	    eval export OPTION_${opt}
#	    eval export OPTION_${opt%=*}=${opt#*=}
	    ;;
	NO*)
	    eval export OPTION_${opt#NO}=0
	    ;;
	*)
	    eval export OPTION_${opt}=\${DEFAULT_${opt}-1}
	    ;;
	esac
    done

    # Special case: set TAR to the 1st of GNUTAR and SOLARISTAR if one is set
    if [ "$OPTION_TAR" = 0 ] ; then
       [ "$OPTION_SOLARISTAR" != 0 ] && OPTION_TAR=$OPTION_SOLARISTAR
       [ "$OPTION_GNUTAR" != 0 ] && OPTION_TAR=$OPTION_GNUTAR
    fi
}

az_mount()
{
    if [ "$SKIPMOUNT" = no ]
    then
	# Maybe mount removable medium
	MNTENTRY=$(mount | egrep "^[^ ]+ on $MEDIUM type ")
	if [ "$MNTENTRY" ]
	then
	    WAS_MOUNTED=1
	    if mount | grep "${MEDIUM}.*[(,]ro[,)]" >/dev/null
	    then
		error "$MEDIUM is mounted READ ONLY"
	    fi
	else
	    WAS_MOUNTED=0
	    echo "Mounting $MEDIUM"
	    local out=$(env LC_ALL=C mount $MEDIUM 2>&1)
	    if [ "$out" != "" ]
	    then
		if echo $out | grep "write-protected" >/dev/null
		then
		    error "$MEDIUM is write-protected"
		else
		    error $out
		fi
	    fi
	fi
    fi
}

az_umount()
{
    if [ "$SKIPMOUNT" = no ]
    then
	# Maybe umount removable medium
	if [ "$WAS_MOUNTED" = 0 ]
	then
	    echo "UnMounting $MEDIUM"
	    umount "$MEDIUM"
	fi
    fi
}

az_exit()
{
    az_umount
    exithook
}

az_init()
{
    az_loadconf
    az_process_commandline $*
    az_process_options
    check_packages
    az_filter
    check_method
    check_medium
    az_mount
}
#
# Init code
#
trap az_exit EXIT || error "error setting EXIT trap"
az_init $*
