// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTagsToOnPremisesInstances = "AddTagsToOnPremisesInstances"

// AddTagsToOnPremisesInstancesRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToOnPremisesInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToOnPremisesInstances for more information on using the AddTagsToOnPremisesInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToOnPremisesInstancesRequest method.
//    req, resp := client.AddTagsToOnPremisesInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances
func (c *CodeDeploy) AddTagsToOnPremisesInstancesRequest(input *AddTagsToOnPremisesInstancesInput) (req *request.Request, output *AddTagsToOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opAddTagsToOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToOnPremisesInstancesInput{}
	}

	output = &AddTagsToOnPremisesInstancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToOnPremisesInstances API operation for AWS CodeDeploy.
//
// Adds tags to on-premises instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation AddTagsToOnPremisesInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstanceNameRequiredException "InstanceNameRequiredException"
//   An on-premises instance name was not specified.
//
//   * ErrCodeInvalidInstanceNameException "InvalidInstanceNameException"
//   The specified on-premises instance name was specified in an invalid format.
//
//   * ErrCodeTagRequiredException "TagRequiredException"
//   A tag was not specified.
//
//   * ErrCodeInvalidTagException "InvalidTagException"
//   The specified tag was specified in an invalid format.
//
//   * ErrCodeTagLimitExceededException "TagLimitExceededException"
//   The maximum allowed number of tags was exceeded.
//
//   * ErrCodeInstanceLimitExceededException "InstanceLimitExceededException"
//   The maximum number of allowed on-premises instances in a single call was
//   exceeded.
//
//   * ErrCodeInstanceNotRegisteredException "InstanceNotRegisteredException"
//   The specified on-premises instance is not registered.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/AddTagsToOnPremisesInstances
func (c *CodeDeploy) AddTagsToOnPremisesInstances(input *AddTagsToOnPremisesInstancesInput) (*AddTagsToOnPremisesInstancesOutput, error) {
	req, out := c.AddTagsToOnPremisesInstancesRequest(input)
	return out, req.Send()
}

// AddTagsToOnPremisesInstancesWithContext is the same as AddTagsToOnPremisesInstances with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToOnPremisesInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) AddTagsToOnPremisesInstancesWithContext(ctx aws.Context, input *AddTagsToOnPremisesInstancesInput, opts ...request.Option) (*AddTagsToOnPremisesInstancesOutput, error) {
	req, out := c.AddTagsToOnPremisesInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetApplicationRevisions = "BatchGetApplicationRevisions"

// BatchGetApplicationRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetApplicationRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetApplicationRevisions for more information on using the BatchGetApplicationRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetApplicationRevisionsRequest method.
//    req, resp := client.BatchGetApplicationRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions
func (c *CodeDeploy) BatchGetApplicationRevisionsRequest(input *BatchGetApplicationRevisionsInput) (req *request.Request, output *BatchGetApplicationRevisionsOutput) {
	op := &request.Operation{
		Name:       opBatchGetApplicationRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetApplicationRevisionsInput{}
	}

	output = &BatchGetApplicationRevisionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetApplicationRevisions API operation for AWS CodeDeploy.
//
// Gets information about one or more application revisions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetApplicationRevisions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeRevisionRequiredException "RevisionRequiredException"
//   The revision ID was not specified.
//
//   * ErrCodeInvalidRevisionException "InvalidRevisionException"
//   The revision was specified in an invalid format.
//
//   * ErrCodeBatchLimitExceededException "BatchLimitExceededException"
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplicationRevisions
func (c *CodeDeploy) BatchGetApplicationRevisions(input *BatchGetApplicationRevisionsInput) (*BatchGetApplicationRevisionsOutput, error) {
	req, out := c.BatchGetApplicationRevisionsRequest(input)
	return out, req.Send()
}

// BatchGetApplicationRevisionsWithContext is the same as BatchGetApplicationRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetApplicationRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) BatchGetApplicationRevisionsWithContext(ctx aws.Context, input *BatchGetApplicationRevisionsInput, opts ...request.Option) (*BatchGetApplicationRevisionsOutput, error) {
	req, out := c.BatchGetApplicationRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetApplications = "BatchGetApplications"

// BatchGetApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetApplications for more information on using the BatchGetApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetApplicationsRequest method.
//    req, resp := client.BatchGetApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications
func (c *CodeDeploy) BatchGetApplicationsRequest(input *BatchGetApplicationsInput) (req *request.Request, output *BatchGetApplicationsOutput) {
	op := &request.Operation{
		Name:       opBatchGetApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetApplicationsInput{}
	}

	output = &BatchGetApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetApplications API operation for AWS CodeDeploy.
//
// Gets information about one or more applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetApplications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeBatchLimitExceededException "BatchLimitExceededException"
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetApplications
func (c *CodeDeploy) BatchGetApplications(input *BatchGetApplicationsInput) (*BatchGetApplicationsOutput, error) {
	req, out := c.BatchGetApplicationsRequest(input)
	return out, req.Send()
}

// BatchGetApplicationsWithContext is the same as BatchGetApplications with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) BatchGetApplicationsWithContext(ctx aws.Context, input *BatchGetApplicationsInput, opts ...request.Option) (*BatchGetApplicationsOutput, error) {
	req, out := c.BatchGetApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetDeploymentGroups = "BatchGetDeploymentGroups"

// BatchGetDeploymentGroupsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDeploymentGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetDeploymentGroups for more information on using the BatchGetDeploymentGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetDeploymentGroupsRequest method.
//    req, resp := client.BatchGetDeploymentGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups
func (c *CodeDeploy) BatchGetDeploymentGroupsRequest(input *BatchGetDeploymentGroupsInput) (req *request.Request, output *BatchGetDeploymentGroupsOutput) {
	op := &request.Operation{
		Name:       opBatchGetDeploymentGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDeploymentGroupsInput{}
	}

	output = &BatchGetDeploymentGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetDeploymentGroups API operation for AWS CodeDeploy.
//
// Gets information about one or more deployment groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetDeploymentGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeDeploymentGroupNameRequiredException "DeploymentGroupNameRequiredException"
//   The deployment group name was not specified.
//
//   * ErrCodeInvalidDeploymentGroupNameException "InvalidDeploymentGroupNameException"
//   The deployment group name was specified in an invalid format.
//
//   * ErrCodeBatchLimitExceededException "BatchLimitExceededException"
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentGroups
func (c *CodeDeploy) BatchGetDeploymentGroups(input *BatchGetDeploymentGroupsInput) (*BatchGetDeploymentGroupsOutput, error) {
	req, out := c.BatchGetDeploymentGroupsRequest(input)
	return out, req.Send()
}

// BatchGetDeploymentGroupsWithContext is the same as BatchGetDeploymentGroups with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetDeploymentGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) BatchGetDeploymentGroupsWithContext(ctx aws.Context, input *BatchGetDeploymentGroupsInput, opts ...request.Option) (*BatchGetDeploymentGroupsOutput, error) {
	req, out := c.BatchGetDeploymentGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetDeploymentInstances = "BatchGetDeploymentInstances"

// BatchGetDeploymentInstancesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDeploymentInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetDeploymentInstances for more information on using the BatchGetDeploymentInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetDeploymentInstancesRequest method.
//    req, resp := client.BatchGetDeploymentInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentInstances
func (c *CodeDeploy) BatchGetDeploymentInstancesRequest(input *BatchGetDeploymentInstancesInput) (req *request.Request, output *BatchGetDeploymentInstancesOutput) {
	op := &request.Operation{
		Name:       opBatchGetDeploymentInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDeploymentInstancesInput{}
	}

	output = &BatchGetDeploymentInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetDeploymentInstances API operation for AWS CodeDeploy.
//
// Gets information about one or more instance that are part of a deployment
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetDeploymentInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeploymentIdRequiredException "DeploymentIdRequiredException"
//   At least one deployment ID must be specified.
//
//   * ErrCodeDeploymentDoesNotExistException "DeploymentDoesNotExistException"
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeInstanceIdRequiredException "InstanceIdRequiredException"
//   The instance ID was not specified.
//
//   * ErrCodeInvalidDeploymentIdException "InvalidDeploymentIdException"
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * ErrCodeInvalidInstanceNameException "InvalidInstanceNameException"
//   The specified on-premises instance name was specified in an invalid format.
//
//   * ErrCodeBatchLimitExceededException "BatchLimitExceededException"
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeploymentInstances
func (c *CodeDeploy) BatchGetDeploymentInstances(input *BatchGetDeploymentInstancesInput) (*BatchGetDeploymentInstancesOutput, error) {
	req, out := c.BatchGetDeploymentInstancesRequest(input)
	return out, req.Send()
}

// BatchGetDeploymentInstancesWithContext is the same as BatchGetDeploymentInstances with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetDeploymentInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) BatchGetDeploymentInstancesWithContext(ctx aws.Context, input *BatchGetDeploymentInstancesInput, opts ...request.Option) (*BatchGetDeploymentInstancesOutput, error) {
	req, out := c.BatchGetDeploymentInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetDeployments = "BatchGetDeployments"

// BatchGetDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetDeployments for more information on using the BatchGetDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetDeploymentsRequest method.
//    req, resp := client.BatchGetDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments
func (c *CodeDeploy) BatchGetDeploymentsRequest(input *BatchGetDeploymentsInput) (req *request.Request, output *BatchGetDeploymentsOutput) {
	op := &request.Operation{
		Name:       opBatchGetDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDeploymentsInput{}
	}

	output = &BatchGetDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetDeployments API operation for AWS CodeDeploy.
//
// Gets information about one or more deployments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetDeployments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeploymentIdRequiredException "DeploymentIdRequiredException"
//   At least one deployment ID must be specified.
//
//   * ErrCodeInvalidDeploymentIdException "InvalidDeploymentIdException"
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * ErrCodeBatchLimitExceededException "BatchLimitExceededException"
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetDeployments
func (c *CodeDeploy) BatchGetDeployments(input *BatchGetDeploymentsInput) (*BatchGetDeploymentsOutput, error) {
	req, out := c.BatchGetDeploymentsRequest(input)
	return out, req.Send()
}

// BatchGetDeploymentsWithContext is the same as BatchGetDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) BatchGetDeploymentsWithContext(ctx aws.Context, input *BatchGetDeploymentsInput, opts ...request.Option) (*BatchGetDeploymentsOutput, error) {
	req, out := c.BatchGetDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetOnPremisesInstances = "BatchGetOnPremisesInstances"

// BatchGetOnPremisesInstancesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetOnPremisesInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetOnPremisesInstances for more information on using the BatchGetOnPremisesInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetOnPremisesInstancesRequest method.
//    req, resp := client.BatchGetOnPremisesInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances
func (c *CodeDeploy) BatchGetOnPremisesInstancesRequest(input *BatchGetOnPremisesInstancesInput) (req *request.Request, output *BatchGetOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opBatchGetOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetOnPremisesInstancesInput{}
	}

	output = &BatchGetOnPremisesInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetOnPremisesInstances API operation for AWS CodeDeploy.
//
// Gets information about one or more on-premises instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation BatchGetOnPremisesInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstanceNameRequiredException "InstanceNameRequiredException"
//   An on-premises instance name was not specified.
//
//   * ErrCodeInvalidInstanceNameException "InvalidInstanceNameException"
//   The specified on-premises instance name was specified in an invalid format.
//
//   * ErrCodeBatchLimitExceededException "BatchLimitExceededException"
//   The maximum number of names or IDs allowed for this request (100) was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/BatchGetOnPremisesInstances
func (c *CodeDeploy) BatchGetOnPremisesInstances(input *BatchGetOnPremisesInstancesInput) (*BatchGetOnPremisesInstancesOutput, error) {
	req, out := c.BatchGetOnPremisesInstancesRequest(input)
	return out, req.Send()
}

// BatchGetOnPremisesInstancesWithContext is the same as BatchGetOnPremisesInstances with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetOnPremisesInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) BatchGetOnPremisesInstancesWithContext(ctx aws.Context, input *BatchGetOnPremisesInstancesInput, opts ...request.Option) (*BatchGetOnPremisesInstancesOutput, error) {
	req, out := c.BatchGetOnPremisesInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opContinueDeployment = "ContinueDeployment"

// ContinueDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the ContinueDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ContinueDeployment for more information on using the ContinueDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ContinueDeploymentRequest method.
//    req, resp := client.ContinueDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment
func (c *CodeDeploy) ContinueDeploymentRequest(input *ContinueDeploymentInput) (req *request.Request, output *ContinueDeploymentOutput) {
	op := &request.Operation{
		Name:       opContinueDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ContinueDeploymentInput{}
	}

	output = &ContinueDeploymentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ContinueDeployment API operation for AWS CodeDeploy.
//
// For a blue/green deployment, starts the process of rerouting traffic from
// instances in the original environment to instances in the replacement environment
// without waiting for a specified wait time to elapse. (Traffic rerouting,
// which is achieved by registering instances in the replacement environment
// with the load balancer, can start as soon as all instances have a status
// of Ready.)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ContinueDeployment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeploymentIdRequiredException "DeploymentIdRequiredException"
//   At least one deployment ID must be specified.
//
//   * ErrCodeDeploymentDoesNotExistException "DeploymentDoesNotExistException"
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeDeploymentAlreadyCompletedException "DeploymentAlreadyCompletedException"
//   The deployment is already complete.
//
//   * ErrCodeInvalidDeploymentIdException "InvalidDeploymentIdException"
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * ErrCodeDeploymentIsNotInReadyStateException "DeploymentIsNotInReadyStateException"
//   The deployment does not have a status of Ready and can't continue yet.
//
//   * ErrCodeUnsupportedActionForDeploymentTypeException "UnsupportedActionForDeploymentTypeException"
//   A call was submitted that is not supported for the specified deployment type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ContinueDeployment
func (c *CodeDeploy) ContinueDeployment(input *ContinueDeploymentInput) (*ContinueDeploymentOutput, error) {
	req, out := c.ContinueDeploymentRequest(input)
	return out, req.Send()
}

// ContinueDeploymentWithContext is the same as ContinueDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See ContinueDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ContinueDeploymentWithContext(ctx aws.Context, input *ContinueDeploymentInput, opts ...request.Option) (*ContinueDeploymentOutput, error) {
	req, out := c.ContinueDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication
func (c *CodeDeploy) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWS CodeDeploy.
//
// Creates an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation CreateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationAlreadyExistsException "ApplicationAlreadyExistsException"
//   An application with the specified name already exists with the applicable
//   IAM user or AWS account.
//
//   * ErrCodeApplicationLimitExceededException "ApplicationLimitExceededException"
//   More applications were attempted to be created than are allowed.
//
//   * ErrCodeInvalidComputePlatformException "InvalidComputePlatformException"
//   The computePlatform is invalid. The computePlatform should be Lambda or Server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateApplication
func (c *CodeDeploy) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentRequest method.
//    req, resp := client.CreateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment
func (c *CodeDeploy) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &CreateDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeployment API operation for AWS CodeDeploy.
//
// Deploys an application revision through the specified deployment group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeDeploymentGroupNameRequiredException "DeploymentGroupNameRequiredException"
//   The deployment group name was not specified.
//
//   * ErrCodeInvalidDeploymentGroupNameException "InvalidDeploymentGroupNameException"
//   The deployment group name was specified in an invalid format.
//
//   * ErrCodeDeploymentGroupDoesNotExistException "DeploymentGroupDoesNotExistException"
//   The named deployment group does not exist with the applicable IAM user or
//   AWS account.
//
//   * ErrCodeRevisionRequiredException "RevisionRequiredException"
//   The revision ID was not specified.
//
//   * ErrCodeRevisionDoesNotExistException "RevisionDoesNotExistException"
//   The named revision does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeInvalidRevisionException "InvalidRevisionException"
//   The revision was specified in an invalid format.
//
//   * ErrCodeInvalidDeploymentConfigNameException "InvalidDeploymentConfigNameException"
//   The deployment configuration name was specified in an invalid format.
//
//   * ErrCodeDeploymentConfigDoesNotExistException "DeploymentConfigDoesNotExistException"
//   The deployment configuration does not exist with the applicable IAM user
//   or AWS account.
//
//   * ErrCodeDescriptionTooLongException "DescriptionTooLongException"
//   The description is too long.
//
//   * ErrCodeDeploymentLimitExceededException "DeploymentLimitExceededException"
//   The number of allowed deployments was exceeded.
//
//   * ErrCodeInvalidTargetInstancesException "InvalidTargetInstancesException"
//   The target instance configuration is invalid. Possible causes include:
//
//      * Configuration data for target instances was entered for an in-place
//      deployment.
//
//      * The limit of 10 tags for a tag type was exceeded.
//
//      * The combined length of the tag names exceeded the limit.
//
//      * A specified tag is not currently applied to any instances.
//
//   * ErrCodeInvalidAutoRollbackConfigException "InvalidAutoRollbackConfigException"
//   The automatic rollback configuration was specified in an invalid format.
//   For example, automatic rollback is enabled but an invalid triggering event
//   type or no event types were listed.
//
//   * ErrCodeInvalidLoadBalancerInfoException "InvalidLoadBalancerInfoException"
//   An invalid load balancer name, or no load balancer name, was specified.
//
//   * ErrCodeInvalidFileExistsBehaviorException "InvalidFileExistsBehaviorException"
//   An invalid fileExistsBehavior option was specified to determine how AWS CodeDeploy
//   handles files or directories that already exist in a deployment target location
//   but weren't part of the previous successful deployment. Valid values include
//   "DISALLOW", "OVERWRITE", and "RETAIN".
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   The service role ARN was specified in an invalid format. Or, if an Auto Scaling
//   group was specified, the specified service role does not grant the appropriate
//   permissions to Auto Scaling.
//
//   * ErrCodeInvalidAutoScalingGroupException "InvalidAutoScalingGroupException"
//   The Auto Scaling group was specified in an invalid format or does not exist.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   An API function was called too frequently.
//
//   * ErrCodeInvalidUpdateOutdatedInstancesOnlyValueException "InvalidUpdateOutdatedInstancesOnlyValueException"
//   The UpdateOutdatedInstancesOnly value is invalid. For AWS Lambda deployments,
//   false is expected. For EC2/On-premises deployments, true or false is expected.
//
//   * ErrCodeInvalidIgnoreApplicationStopFailuresValueException "InvalidIgnoreApplicationStopFailuresValueException"
//   The IgnoreApplicationStopFailures value is invalid. For AWS Lambda deployments,
//   false is expected. For EC2/On-premises deployments, true or false is expected.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeployment
func (c *CodeDeploy) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) CreateDeploymentWithContext(ctx aws.Context, input *CreateDeploymentInput, opts ...request.Option) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeploymentConfig = "CreateDeploymentConfig"

// CreateDeploymentConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeploymentConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeploymentConfig for more information on using the CreateDeploymentConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentConfigRequest method.
//    req, resp := client.CreateDeploymentConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig
func (c *CodeDeploy) CreateDeploymentConfigRequest(input *CreateDeploymentConfigInput) (req *request.Request, output *CreateDeploymentConfigOutput) {
	op := &request.Operation{
		Name:       opCreateDeploymentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentConfigInput{}
	}

	output = &CreateDeploymentConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeploymentConfig API operation for AWS CodeDeploy.
//
// Creates a deployment configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation CreateDeploymentConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDeploymentConfigNameException "InvalidDeploymentConfigNameException"
//   The deployment configuration name was specified in an invalid format.
//
//   * ErrCodeDeploymentConfigNameRequiredException "DeploymentConfigNameRequiredException"
//   The deployment configuration name was not specified.
//
//   * ErrCodeDeploymentConfigAlreadyExistsException "DeploymentConfigAlreadyExistsException"
//   A deployment configuration with the specified name already exists with the
//   applicable IAM user or AWS account.
//
//   * ErrCodeInvalidMinimumHealthyHostValueException "InvalidMinimumHealthyHostValueException"
//   The minimum healthy instance value was specified in an invalid format.
//
//   * ErrCodeDeploymentConfigLimitExceededException "DeploymentConfigLimitExceededException"
//   The deployment configurations limit was exceeded.
//
//   * ErrCodeInvalidComputePlatformException "InvalidComputePlatformException"
//   The computePlatform is invalid. The computePlatform should be Lambda or Server.
//
//   * ErrCodeInvalidTrafficRoutingConfigurationException "InvalidTrafficRoutingConfigurationException"
//   The configuration that specifies how traffic is routed during a deployment
//   is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentConfig
func (c *CodeDeploy) CreateDeploymentConfig(input *CreateDeploymentConfigInput) (*CreateDeploymentConfigOutput, error) {
	req, out := c.CreateDeploymentConfigRequest(input)
	return out, req.Send()
}

// CreateDeploymentConfigWithContext is the same as CreateDeploymentConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeploymentConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) CreateDeploymentConfigWithContext(ctx aws.Context, input *CreateDeploymentConfigInput, opts ...request.Option) (*CreateDeploymentConfigOutput, error) {
	req, out := c.CreateDeploymentConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeploymentGroup = "CreateDeploymentGroup"

// CreateDeploymentGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeploymentGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeploymentGroup for more information on using the CreateDeploymentGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentGroupRequest method.
//    req, resp := client.CreateDeploymentGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup
func (c *CodeDeploy) CreateDeploymentGroupRequest(input *CreateDeploymentGroupInput) (req *request.Request, output *CreateDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentGroupInput{}
	}

	output = &CreateDeploymentGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeploymentGroup API operation for AWS CodeDeploy.
//
// Creates a deployment group to which application revisions will be deployed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation CreateDeploymentGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeDeploymentGroupNameRequiredException "DeploymentGroupNameRequiredException"
//   The deployment group name was not specified.
//
//   * ErrCodeInvalidDeploymentGroupNameException "InvalidDeploymentGroupNameException"
//   The deployment group name was specified in an invalid format.
//
//   * ErrCodeDeploymentGroupAlreadyExistsException "DeploymentGroupAlreadyExistsException"
//   A deployment group with the specified name already exists with the applicable
//   IAM user or AWS account.
//
//   * ErrCodeInvalidEC2TagException "InvalidEC2TagException"
//   The tag was specified in an invalid format.
//
//   * ErrCodeInvalidTagException "InvalidTagException"
//   The specified tag was specified in an invalid format.
//
//   * ErrCodeInvalidAutoScalingGroupException "InvalidAutoScalingGroupException"
//   The Auto Scaling group was specified in an invalid format or does not exist.
//
//   * ErrCodeInvalidDeploymentConfigNameException "InvalidDeploymentConfigNameException"
//   The deployment configuration name was specified in an invalid format.
//
//   * ErrCodeDeploymentConfigDoesNotExistException "DeploymentConfigDoesNotExistException"
//   The deployment configuration does not exist with the applicable IAM user
//   or AWS account.
//
//   * ErrCodeRoleRequiredException "RoleRequiredException"
//   The role ID was not specified.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   The service role ARN was specified in an invalid format. Or, if an Auto Scaling
//   group was specified, the specified service role does not grant the appropriate
//   permissions to Auto Scaling.
//
//   * ErrCodeDeploymentGroupLimitExceededException "DeploymentGroupLimitExceededException"
//   The deployment groups limit was exceeded.
//
//   * ErrCodeLifecycleHookLimitExceededException "LifecycleHookLimitExceededException"
//   The limit for lifecycle hooks was exceeded.
//
//   * ErrCodeInvalidTriggerConfigException "InvalidTriggerConfigException"
//   The trigger was specified in an invalid format.
//
//   * ErrCodeTriggerTargetsLimitExceededException "TriggerTargetsLimitExceededException"
//   The maximum allowed number of triggers was exceeded.
//
//   * ErrCodeInvalidAlarmConfigException "InvalidAlarmConfigException"
//   The format of the alarm configuration is invalid. Possible causes include:
//
//      * The alarm list is null.
//
//      * The alarm object is null.
//
//      * The alarm name is empty or null or exceeds the 255 character limit.
//
//      * Two alarms with the same name have been specified.
//
//      * The alarm configuration is enabled but the alarm list is empty.
//
//   * ErrCodeAlarmsLimitExceededException "AlarmsLimitExceededException"
//   The maximum number of alarms for a deployment group (10) was exceeded.
//
//   * ErrCodeInvalidAutoRollbackConfigException "InvalidAutoRollbackConfigException"
//   The automatic rollback configuration was specified in an invalid format.
//   For example, automatic rollback is enabled but an invalid triggering event
//   type or no event types were listed.
//
//   * ErrCodeInvalidLoadBalancerInfoException "InvalidLoadBalancerInfoException"
//   An invalid load balancer name, or no load balancer name, was specified.
//
//   * ErrCodeInvalidDeploymentStyleException "InvalidDeploymentStyleException"
//   An invalid deployment style was specified. Valid deployment types include
//   "IN_PLACE" and "BLUE_GREEN". Valid deployment options include "WITH_TRAFFIC_CONTROL"
//   and "WITHOUT_TRAFFIC_CONTROL".
//
//   * ErrCodeInvalidBlueGreenDeploymentConfigurationException "InvalidBlueGreenDeploymentConfigurationException"
//   The configuration for the blue/green deployment group was provided in an
//   invalid format. For information about deployment configuration format, see
//   CreateDeploymentConfig.
//
//   * ErrCodeInvalidEC2TagCombinationException "InvalidEC2TagCombinationException"
//   A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but
//   only one of these data types can be used in a single call.
//
//   * ErrCodeInvalidOnPremisesTagCombinationException "InvalidOnPremisesTagCombinationException"
//   A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet,
//   but only one of these data types can be used in a single call.
//
//   * ErrCodeTagSetListLimitExceededException "TagSetListLimitExceededException"
//   The number of tag groups included in the tag set list exceeded the maximum
//   allowed limit of 3.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The specified input was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/CreateDeploymentGroup
func (c *CodeDeploy) CreateDeploymentGroup(input *CreateDeploymentGroupInput) (*CreateDeploymentGroupOutput, error) {
	req, out := c.CreateDeploymentGroupRequest(input)
	return out, req.Send()
}

// CreateDeploymentGroupWithContext is the same as CreateDeploymentGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeploymentGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) CreateDeploymentGroupWithContext(ctx aws.Context, input *CreateDeploymentGroupInput, opts ...request.Option) (*CreateDeploymentGroupOutput, error) {
	req, out := c.CreateDeploymentGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication
func (c *CodeDeploy) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for AWS CodeDeploy.
//
// Deletes an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteApplication
func (c *CodeDeploy) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeploymentConfig = "DeleteDeploymentConfig"

// DeleteDeploymentConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeploymentConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeploymentConfig for more information on using the DeleteDeploymentConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeploymentConfigRequest method.
//    req, resp := client.DeleteDeploymentConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig
func (c *CodeDeploy) DeleteDeploymentConfigRequest(input *DeleteDeploymentConfigInput) (req *request.Request, output *DeleteDeploymentConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteDeploymentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeploymentConfigInput{}
	}

	output = &DeleteDeploymentConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeploymentConfig API operation for AWS CodeDeploy.
//
// Deletes a deployment configuration.
//
// A deployment configuration cannot be deleted if it is currently in use. Predefined
// configurations cannot be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation DeleteDeploymentConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDeploymentConfigNameException "InvalidDeploymentConfigNameException"
//   The deployment configuration name was specified in an invalid format.
//
//   * ErrCodeDeploymentConfigNameRequiredException "DeploymentConfigNameRequiredException"
//   The deployment configuration name was not specified.
//
//   * ErrCodeDeploymentConfigInUseException "DeploymentConfigInUseException"
//   The deployment configuration is still in use.
//
//   * ErrCodeInvalidOperationException "InvalidOperationException"
//   An invalid operation was detected.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentConfig
func (c *CodeDeploy) DeleteDeploymentConfig(input *DeleteDeploymentConfigInput) (*DeleteDeploymentConfigOutput, error) {
	req, out := c.DeleteDeploymentConfigRequest(input)
	return out, req.Send()
}

// DeleteDeploymentConfigWithContext is the same as DeleteDeploymentConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeploymentConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) DeleteDeploymentConfigWithContext(ctx aws.Context, input *DeleteDeploymentConfigInput, opts ...request.Option) (*DeleteDeploymentConfigOutput, error) {
	req, out := c.DeleteDeploymentConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeploymentGroup = "DeleteDeploymentGroup"

// DeleteDeploymentGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeploymentGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeploymentGroup for more information on using the DeleteDeploymentGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeploymentGroupRequest method.
//    req, resp := client.DeleteDeploymentGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup
func (c *CodeDeploy) DeleteDeploymentGroupRequest(input *DeleteDeploymentGroupInput) (req *request.Request, output *DeleteDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeploymentGroupInput{}
	}

	output = &DeleteDeploymentGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDeploymentGroup API operation for AWS CodeDeploy.
//
// Deletes a deployment group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation DeleteDeploymentGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeDeploymentGroupNameRequiredException "DeploymentGroupNameRequiredException"
//   The deployment group name was not specified.
//
//   * ErrCodeInvalidDeploymentGroupNameException "InvalidDeploymentGroupNameException"
//   The deployment group name was specified in an invalid format.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   The service role ARN was specified in an invalid format. Or, if an Auto Scaling
//   group was specified, the specified service role does not grant the appropriate
//   permissions to Auto Scaling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteDeploymentGroup
func (c *CodeDeploy) DeleteDeploymentGroup(input *DeleteDeploymentGroupInput) (*DeleteDeploymentGroupOutput, error) {
	req, out := c.DeleteDeploymentGroupRequest(input)
	return out, req.Send()
}

// DeleteDeploymentGroupWithContext is the same as DeleteDeploymentGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeploymentGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) DeleteDeploymentGroupWithContext(ctx aws.Context, input *DeleteDeploymentGroupInput, opts ...request.Option) (*DeleteDeploymentGroupOutput, error) {
	req, out := c.DeleteDeploymentGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGitHubAccountToken = "DeleteGitHubAccountToken"

// DeleteGitHubAccountTokenRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGitHubAccountToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGitHubAccountToken for more information on using the DeleteGitHubAccountToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGitHubAccountTokenRequest method.
//    req, resp := client.DeleteGitHubAccountTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteGitHubAccountToken
func (c *CodeDeploy) DeleteGitHubAccountTokenRequest(input *DeleteGitHubAccountTokenInput) (req *request.Request, output *DeleteGitHubAccountTokenOutput) {
	op := &request.Operation{
		Name:       opDeleteGitHubAccountToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGitHubAccountTokenInput{}
	}

	output = &DeleteGitHubAccountTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGitHubAccountToken API operation for AWS CodeDeploy.
//
// Deletes a GitHub account connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation DeleteGitHubAccountToken for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeGitHubAccountTokenNameRequiredException "GitHubAccountTokenNameRequiredException"
//   The call is missing a required GitHub account connection name.
//
//   * ErrCodeGitHubAccountTokenDoesNotExistException "GitHubAccountTokenDoesNotExistException"
//   No GitHub account connection exists with the named specified in the call.
//
//   * ErrCodeInvalidGitHubAccountTokenNameException "InvalidGitHubAccountTokenNameException"
//   The format of the specified GitHub account connection name is invalid.
//
//   * ErrCodeResourceValidationException "ResourceValidationException"
//   The specified resource could not be validated.
//
//   * ErrCodeOperationNotSupportedException "OperationNotSupportedException"
//   The API used does not support the deployment.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeleteGitHubAccountToken
func (c *CodeDeploy) DeleteGitHubAccountToken(input *DeleteGitHubAccountTokenInput) (*DeleteGitHubAccountTokenOutput, error) {
	req, out := c.DeleteGitHubAccountTokenRequest(input)
	return out, req.Send()
}

// DeleteGitHubAccountTokenWithContext is the same as DeleteGitHubAccountToken with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGitHubAccountToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) DeleteGitHubAccountTokenWithContext(ctx aws.Context, input *DeleteGitHubAccountTokenInput, opts ...request.Option) (*DeleteGitHubAccountTokenOutput, error) {
	req, out := c.DeleteGitHubAccountTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterOnPremisesInstance = "DeregisterOnPremisesInstance"

// DeregisterOnPremisesInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterOnPremisesInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterOnPremisesInstance for more information on using the DeregisterOnPremisesInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterOnPremisesInstanceRequest method.
//    req, resp := client.DeregisterOnPremisesInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance
func (c *CodeDeploy) DeregisterOnPremisesInstanceRequest(input *DeregisterOnPremisesInstanceInput) (req *request.Request, output *DeregisterOnPremisesInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterOnPremisesInstanceInput{}
	}

	output = &DeregisterOnPremisesInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterOnPremisesInstance API operation for AWS CodeDeploy.
//
// Deregisters an on-premises instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation DeregisterOnPremisesInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstanceNameRequiredException "InstanceNameRequiredException"
//   An on-premises instance name was not specified.
//
//   * ErrCodeInvalidInstanceNameException "InvalidInstanceNameException"
//   The specified on-premises instance name was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/DeregisterOnPremisesInstance
func (c *CodeDeploy) DeregisterOnPremisesInstance(input *DeregisterOnPremisesInstanceInput) (*DeregisterOnPremisesInstanceOutput, error) {
	req, out := c.DeregisterOnPremisesInstanceRequest(input)
	return out, req.Send()
}

// DeregisterOnPremisesInstanceWithContext is the same as DeregisterOnPremisesInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterOnPremisesInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) DeregisterOnPremisesInstanceWithContext(ctx aws.Context, input *DeregisterOnPremisesInstanceInput, opts ...request.Option) (*DeregisterOnPremisesInstanceOutput, error) {
	req, out := c.DeregisterOnPremisesInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationRequest method.
//    req, resp := client.GetApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication
func (c *CodeDeploy) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for AWS CodeDeploy.
//
// Gets information about an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplication
func (c *CodeDeploy) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationRevision = "GetApplicationRevision"

// GetApplicationRevisionRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationRevision for more information on using the GetApplicationRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationRevisionRequest method.
//    req, resp := client.GetApplicationRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision
func (c *CodeDeploy) GetApplicationRevisionRequest(input *GetApplicationRevisionInput) (req *request.Request, output *GetApplicationRevisionOutput) {
	op := &request.Operation{
		Name:       opGetApplicationRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationRevisionInput{}
	}

	output = &GetApplicationRevisionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationRevision API operation for AWS CodeDeploy.
//
// Gets information about an application revision.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetApplicationRevision for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeRevisionDoesNotExistException "RevisionDoesNotExistException"
//   The named revision does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeRevisionRequiredException "RevisionRequiredException"
//   The revision ID was not specified.
//
//   * ErrCodeInvalidRevisionException "InvalidRevisionException"
//   The revision was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetApplicationRevision
func (c *CodeDeploy) GetApplicationRevision(input *GetApplicationRevisionInput) (*GetApplicationRevisionOutput, error) {
	req, out := c.GetApplicationRevisionRequest(input)
	return out, req.Send()
}

// GetApplicationRevisionWithContext is the same as GetApplicationRevision with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) GetApplicationRevisionWithContext(ctx aws.Context, input *GetApplicationRevisionInput, opts ...request.Option) (*GetApplicationRevisionOutput, error) {
	req, out := c.GetApplicationRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployment for more information on using the GetDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentRequest method.
//    req, resp := client.GetDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment
func (c *CodeDeploy) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	output = &GetDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployment API operation for AWS CodeDeploy.
//
// Gets information about a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetDeployment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeploymentIdRequiredException "DeploymentIdRequiredException"
//   At least one deployment ID must be specified.
//
//   * ErrCodeInvalidDeploymentIdException "InvalidDeploymentIdException"
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * ErrCodeDeploymentDoesNotExistException "DeploymentDoesNotExistException"
//   The deployment does not exist with the applicable IAM user or AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeployment
func (c *CodeDeploy) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	return out, req.Send()
}

// GetDeploymentWithContext is the same as GetDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) GetDeploymentWithContext(ctx aws.Context, input *GetDeploymentInput, opts ...request.Option) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeploymentConfig = "GetDeploymentConfig"

// GetDeploymentConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetDeploymentConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeploymentConfig for more information on using the GetDeploymentConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentConfigRequest method.
//    req, resp := client.GetDeploymentConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig
func (c *CodeDeploy) GetDeploymentConfigRequest(input *GetDeploymentConfigInput) (req *request.Request, output *GetDeploymentConfigOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentConfigInput{}
	}

	output = &GetDeploymentConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeploymentConfig API operation for AWS CodeDeploy.
//
// Gets information about a deployment configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetDeploymentConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidDeploymentConfigNameException "InvalidDeploymentConfigNameException"
//   The deployment configuration name was specified in an invalid format.
//
//   * ErrCodeDeploymentConfigNameRequiredException "DeploymentConfigNameRequiredException"
//   The deployment configuration name was not specified.
//
//   * ErrCodeDeploymentConfigDoesNotExistException "DeploymentConfigDoesNotExistException"
//   The deployment configuration does not exist with the applicable IAM user
//   or AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentConfig
func (c *CodeDeploy) GetDeploymentConfig(input *GetDeploymentConfigInput) (*GetDeploymentConfigOutput, error) {
	req, out := c.GetDeploymentConfigRequest(input)
	return out, req.Send()
}

// GetDeploymentConfigWithContext is the same as GetDeploymentConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeploymentConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) GetDeploymentConfigWithContext(ctx aws.Context, input *GetDeploymentConfigInput, opts ...request.Option) (*GetDeploymentConfigOutput, error) {
	req, out := c.GetDeploymentConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeploymentGroup = "GetDeploymentGroup"

// GetDeploymentGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetDeploymentGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeploymentGroup for more information on using the GetDeploymentGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentGroupRequest method.
//    req, resp := client.GetDeploymentGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup
func (c *CodeDeploy) GetDeploymentGroupRequest(input *GetDeploymentGroupInput) (req *request.Request, output *GetDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentGroupInput{}
	}

	output = &GetDeploymentGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeploymentGroup API operation for AWS CodeDeploy.
//
// Gets information about a deployment group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetDeploymentGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeDeploymentGroupNameRequiredException "DeploymentGroupNameRequiredException"
//   The deployment group name was not specified.
//
//   * ErrCodeInvalidDeploymentGroupNameException "InvalidDeploymentGroupNameException"
//   The deployment group name was specified in an invalid format.
//
//   * ErrCodeDeploymentGroupDoesNotExistException "DeploymentGroupDoesNotExistException"
//   The named deployment group does not exist with the applicable IAM user or
//   AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentGroup
func (c *CodeDeploy) GetDeploymentGroup(input *GetDeploymentGroupInput) (*GetDeploymentGroupOutput, error) {
	req, out := c.GetDeploymentGroupRequest(input)
	return out, req.Send()
}

// GetDeploymentGroupWithContext is the same as GetDeploymentGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeploymentGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) GetDeploymentGroupWithContext(ctx aws.Context, input *GetDeploymentGroupInput, opts ...request.Option) (*GetDeploymentGroupOutput, error) {
	req, out := c.GetDeploymentGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeploymentInstance = "GetDeploymentInstance"

// GetDeploymentInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetDeploymentInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeploymentInstance for more information on using the GetDeploymentInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentInstanceRequest method.
//    req, resp := client.GetDeploymentInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentInstance
func (c *CodeDeploy) GetDeploymentInstanceRequest(input *GetDeploymentInstanceInput) (req *request.Request, output *GetDeploymentInstanceOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentInstanceInput{}
	}

	output = &GetDeploymentInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeploymentInstance API operation for AWS CodeDeploy.
//
// Gets information about an instance as part of a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetDeploymentInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeploymentIdRequiredException "DeploymentIdRequiredException"
//   At least one deployment ID must be specified.
//
//   * ErrCodeDeploymentDoesNotExistException "DeploymentDoesNotExistException"
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeInstanceIdRequiredException "InstanceIdRequiredException"
//   The instance ID was not specified.
//
//   * ErrCodeInvalidDeploymentIdException "InvalidDeploymentIdException"
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * ErrCodeInstanceDoesNotExistException "InstanceDoesNotExistException"
//   The specified instance does not exist in the deployment group.
//
//   * ErrCodeInvalidInstanceNameException "InvalidInstanceNameException"
//   The specified on-premises instance name was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentInstance
func (c *CodeDeploy) GetDeploymentInstance(input *GetDeploymentInstanceInput) (*GetDeploymentInstanceOutput, error) {
	req, out := c.GetDeploymentInstanceRequest(input)
	return out, req.Send()
}

// GetDeploymentInstanceWithContext is the same as GetDeploymentInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeploymentInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) GetDeploymentInstanceWithContext(ctx aws.Context, input *GetDeploymentInstanceInput, opts ...request.Option) (*GetDeploymentInstanceOutput, error) {
	req, out := c.GetDeploymentInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOnPremisesInstance = "GetOnPremisesInstance"

// GetOnPremisesInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetOnPremisesInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOnPremisesInstance for more information on using the GetOnPremisesInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOnPremisesInstanceRequest method.
//    req, resp := client.GetOnPremisesInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance
func (c *CodeDeploy) GetOnPremisesInstanceRequest(input *GetOnPremisesInstanceInput) (req *request.Request, output *GetOnPremisesInstanceOutput) {
	op := &request.Operation{
		Name:       opGetOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOnPremisesInstanceInput{}
	}

	output = &GetOnPremisesInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOnPremisesInstance API operation for AWS CodeDeploy.
//
// Gets information about an on-premises instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation GetOnPremisesInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstanceNameRequiredException "InstanceNameRequiredException"
//   An on-premises instance name was not specified.
//
//   * ErrCodeInstanceNotRegisteredException "InstanceNotRegisteredException"
//   The specified on-premises instance is not registered.
//
//   * ErrCodeInvalidInstanceNameException "InvalidInstanceNameException"
//   The specified on-premises instance name was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetOnPremisesInstance
func (c *CodeDeploy) GetOnPremisesInstance(input *GetOnPremisesInstanceInput) (*GetOnPremisesInstanceOutput, error) {
	req, out := c.GetOnPremisesInstanceRequest(input)
	return out, req.Send()
}

// GetOnPremisesInstanceWithContext is the same as GetOnPremisesInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetOnPremisesInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) GetOnPremisesInstanceWithContext(ctx aws.Context, input *GetOnPremisesInstanceInput, opts ...request.Option) (*GetOnPremisesInstanceOutput, error) {
	req, out := c.GetOnPremisesInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplicationRevisions = "ListApplicationRevisions"

// ListApplicationRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationRevisions for more information on using the ListApplicationRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationRevisionsRequest method.
//    req, resp := client.ListApplicationRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions
func (c *CodeDeploy) ListApplicationRevisionsRequest(input *ListApplicationRevisionsInput) (req *request.Request, output *ListApplicationRevisionsOutput) {
	op := &request.Operation{
		Name:       opListApplicationRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationRevisionsInput{}
	}

	output = &ListApplicationRevisionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationRevisions API operation for AWS CodeDeploy.
//
// Lists information about revisions for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListApplicationRevisions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeInvalidSortByException "InvalidSortByException"
//   The column name to sort by is either not present or was specified in an invalid
//   format.
//
//   * ErrCodeInvalidSortOrderException "InvalidSortOrderException"
//   The sort order was specified in an invalid format.
//
//   * ErrCodeInvalidBucketNameFilterException "InvalidBucketNameFilterException"
//   The bucket name either doesn't exist or was specified in an invalid format.
//
//   * ErrCodeInvalidKeyPrefixFilterException "InvalidKeyPrefixFilterException"
//   The specified key prefix filter was specified in an invalid format.
//
//   * ErrCodeBucketNameFilterRequiredException "BucketNameFilterRequiredException"
//   A bucket name is required, but was not provided.
//
//   * ErrCodeInvalidDeployedStateFilterException "InvalidDeployedStateFilterException"
//   The deployed state filter was specified in an invalid format.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplicationRevisions
func (c *CodeDeploy) ListApplicationRevisions(input *ListApplicationRevisionsInput) (*ListApplicationRevisionsOutput, error) {
	req, out := c.ListApplicationRevisionsRequest(input)
	return out, req.Send()
}

// ListApplicationRevisionsWithContext is the same as ListApplicationRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListApplicationRevisionsWithContext(ctx aws.Context, input *ListApplicationRevisionsInput, opts ...request.Option) (*ListApplicationRevisionsOutput, error) {
	req, out := c.ListApplicationRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationRevisionsPages iterates over the pages of a ListApplicationRevisions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationRevisions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplicationRevisions operation.
//    pageNum := 0
//    err := client.ListApplicationRevisionsPages(params,
//        func(page *ListApplicationRevisionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListApplicationRevisionsPages(input *ListApplicationRevisionsInput, fn func(*ListApplicationRevisionsOutput, bool) bool) error {
	return c.ListApplicationRevisionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationRevisionsPagesWithContext same as ListApplicationRevisionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListApplicationRevisionsPagesWithContext(ctx aws.Context, input *ListApplicationRevisionsInput, fn func(*ListApplicationRevisionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationRevisionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationRevisionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListApplicationRevisionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications
func (c *CodeDeploy) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for AWS CodeDeploy.
//
// Lists the applications registered with the applicable IAM user or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListApplications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListApplications
func (c *CodeDeploy) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplications operation.
//    pageNum := 0
//    err := client.ListApplicationsPages(params,
//        func(page *ListApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDeploymentConfigs = "ListDeploymentConfigs"

// ListDeploymentConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeploymentConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeploymentConfigs for more information on using the ListDeploymentConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeploymentConfigsRequest method.
//    req, resp := client.ListDeploymentConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs
func (c *CodeDeploy) ListDeploymentConfigsRequest(input *ListDeploymentConfigsInput) (req *request.Request, output *ListDeploymentConfigsOutput) {
	op := &request.Operation{
		Name:       opListDeploymentConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentConfigsInput{}
	}

	output = &ListDeploymentConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeploymentConfigs API operation for AWS CodeDeploy.
//
// Lists the deployment configurations with the applicable IAM user or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListDeploymentConfigs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentConfigs
func (c *CodeDeploy) ListDeploymentConfigs(input *ListDeploymentConfigsInput) (*ListDeploymentConfigsOutput, error) {
	req, out := c.ListDeploymentConfigsRequest(input)
	return out, req.Send()
}

// ListDeploymentConfigsWithContext is the same as ListDeploymentConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeploymentConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListDeploymentConfigsWithContext(ctx aws.Context, input *ListDeploymentConfigsInput, opts ...request.Option) (*ListDeploymentConfigsOutput, error) {
	req, out := c.ListDeploymentConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentConfigsPages iterates over the pages of a ListDeploymentConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeploymentConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeploymentConfigs operation.
//    pageNum := 0
//    err := client.ListDeploymentConfigsPages(params,
//        func(page *ListDeploymentConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListDeploymentConfigsPages(input *ListDeploymentConfigsInput, fn func(*ListDeploymentConfigsOutput, bool) bool) error {
	return c.ListDeploymentConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentConfigsPagesWithContext same as ListDeploymentConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListDeploymentConfigsPagesWithContext(ctx aws.Context, input *ListDeploymentConfigsInput, fn func(*ListDeploymentConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDeploymentConfigsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDeploymentGroups = "ListDeploymentGroups"

// ListDeploymentGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeploymentGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeploymentGroups for more information on using the ListDeploymentGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeploymentGroupsRequest method.
//    req, resp := client.ListDeploymentGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups
func (c *CodeDeploy) ListDeploymentGroupsRequest(input *ListDeploymentGroupsInput) (req *request.Request, output *ListDeploymentGroupsOutput) {
	op := &request.Operation{
		Name:       opListDeploymentGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentGroupsInput{}
	}

	output = &ListDeploymentGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeploymentGroups API operation for AWS CodeDeploy.
//
// Lists the deployment groups for an application registered with the applicable
// IAM user or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListDeploymentGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentGroups
func (c *CodeDeploy) ListDeploymentGroups(input *ListDeploymentGroupsInput) (*ListDeploymentGroupsOutput, error) {
	req, out := c.ListDeploymentGroupsRequest(input)
	return out, req.Send()
}

// ListDeploymentGroupsWithContext is the same as ListDeploymentGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeploymentGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListDeploymentGroupsWithContext(ctx aws.Context, input *ListDeploymentGroupsInput, opts ...request.Option) (*ListDeploymentGroupsOutput, error) {
	req, out := c.ListDeploymentGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentGroupsPages iterates over the pages of a ListDeploymentGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeploymentGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeploymentGroups operation.
//    pageNum := 0
//    err := client.ListDeploymentGroupsPages(params,
//        func(page *ListDeploymentGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListDeploymentGroupsPages(input *ListDeploymentGroupsInput, fn func(*ListDeploymentGroupsOutput, bool) bool) error {
	return c.ListDeploymentGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentGroupsPagesWithContext same as ListDeploymentGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListDeploymentGroupsPagesWithContext(ctx aws.Context, input *ListDeploymentGroupsInput, fn func(*ListDeploymentGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDeploymentGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDeploymentInstances = "ListDeploymentInstances"

// ListDeploymentInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListDeploymentInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeploymentInstances for more information on using the ListDeploymentInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeploymentInstancesRequest method.
//    req, resp := client.ListDeploymentInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentInstances
func (c *CodeDeploy) ListDeploymentInstancesRequest(input *ListDeploymentInstancesInput) (req *request.Request, output *ListDeploymentInstancesOutput) {
	op := &request.Operation{
		Name:       opListDeploymentInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentInstancesInput{}
	}

	output = &ListDeploymentInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeploymentInstances API operation for AWS CodeDeploy.
//
// Lists the instance for a deployment associated with the applicable IAM user
// or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListDeploymentInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeploymentIdRequiredException "DeploymentIdRequiredException"
//   At least one deployment ID must be specified.
//
//   * ErrCodeDeploymentDoesNotExistException "DeploymentDoesNotExistException"
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeDeploymentNotStartedException "DeploymentNotStartedException"
//   The specified deployment has not started.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format.
//
//   * ErrCodeInvalidDeploymentIdException "InvalidDeploymentIdException"
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * ErrCodeInvalidInstanceStatusException "InvalidInstanceStatusException"
//   The specified instance status does not exist.
//
//   * ErrCodeInvalidInstanceTypeException "InvalidInstanceTypeException"
//   An invalid instance type was specified for instances in a blue/green deployment.
//   Valid values include "Blue" for an original environment and "Green" for a
//   replacement environment.
//
//   * ErrCodeInvalidDeploymentInstanceTypeException "InvalidDeploymentInstanceTypeException"
//   An instance type was specified for an in-place deployment. Instance types
//   are supported for blue/green deployments only.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeploymentInstances
func (c *CodeDeploy) ListDeploymentInstances(input *ListDeploymentInstancesInput) (*ListDeploymentInstancesOutput, error) {
	req, out := c.ListDeploymentInstancesRequest(input)
	return out, req.Send()
}

// ListDeploymentInstancesWithContext is the same as ListDeploymentInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeploymentInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListDeploymentInstancesWithContext(ctx aws.Context, input *ListDeploymentInstancesInput, opts ...request.Option) (*ListDeploymentInstancesOutput, error) {
	req, out := c.ListDeploymentInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentInstancesPages iterates over the pages of a ListDeploymentInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeploymentInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeploymentInstances operation.
//    pageNum := 0
//    err := client.ListDeploymentInstancesPages(params,
//        func(page *ListDeploymentInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListDeploymentInstancesPages(input *ListDeploymentInstancesInput, fn func(*ListDeploymentInstancesOutput, bool) bool) error {
	return c.ListDeploymentInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentInstancesPagesWithContext same as ListDeploymentInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListDeploymentInstancesPagesWithContext(ctx aws.Context, input *ListDeploymentInstancesInput, fn func(*ListDeploymentInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDeploymentInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeployments for more information on using the ListDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeploymentsRequest method.
//    req, resp := client.ListDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments
func (c *CodeDeploy) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	output = &ListDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeployments API operation for AWS CodeDeploy.
//
// Lists the deployments in a deployment group for an application registered
// with the applicable IAM user or AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListDeployments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeInvalidDeploymentGroupNameException "InvalidDeploymentGroupNameException"
//   The deployment group name was specified in an invalid format.
//
//   * ErrCodeDeploymentGroupDoesNotExistException "DeploymentGroupDoesNotExistException"
//   The named deployment group does not exist with the applicable IAM user or
//   AWS account.
//
//   * ErrCodeDeploymentGroupNameRequiredException "DeploymentGroupNameRequiredException"
//   The deployment group name was not specified.
//
//   * ErrCodeInvalidTimeRangeException "InvalidTimeRangeException"
//   The specified time range was specified in an invalid format.
//
//   * ErrCodeInvalidDeploymentStatusException "InvalidDeploymentStatusException"
//   The specified deployment status doesn't exist or cannot be determined.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListDeployments
func (c *CodeDeploy) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	return out, req.Send()
}

// ListDeploymentsWithContext is the same as ListDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListDeploymentsWithContext(ctx aws.Context, input *ListDeploymentsInput, opts ...request.Option) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentsPages iterates over the pages of a ListDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeployments operation.
//    pageNum := 0
//    err := client.ListDeploymentsPages(params,
//        func(page *ListDeploymentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeDeploy) ListDeploymentsPages(input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool) error {
	return c.ListDeploymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentsPagesWithContext same as ListDeploymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListDeploymentsPagesWithContext(ctx aws.Context, input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDeploymentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListGitHubAccountTokenNames = "ListGitHubAccountTokenNames"

// ListGitHubAccountTokenNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListGitHubAccountTokenNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGitHubAccountTokenNames for more information on using the ListGitHubAccountTokenNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGitHubAccountTokenNamesRequest method.
//    req, resp := client.ListGitHubAccountTokenNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames
func (c *CodeDeploy) ListGitHubAccountTokenNamesRequest(input *ListGitHubAccountTokenNamesInput) (req *request.Request, output *ListGitHubAccountTokenNamesOutput) {
	op := &request.Operation{
		Name:       opListGitHubAccountTokenNames,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGitHubAccountTokenNamesInput{}
	}

	output = &ListGitHubAccountTokenNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGitHubAccountTokenNames API operation for AWS CodeDeploy.
//
// Lists the names of stored connections to GitHub accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListGitHubAccountTokenNames for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format.
//
//   * ErrCodeResourceValidationException "ResourceValidationException"
//   The specified resource could not be validated.
//
//   * ErrCodeOperationNotSupportedException "OperationNotSupportedException"
//   The API used does not support the deployment.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListGitHubAccountTokenNames
func (c *CodeDeploy) ListGitHubAccountTokenNames(input *ListGitHubAccountTokenNamesInput) (*ListGitHubAccountTokenNamesOutput, error) {
	req, out := c.ListGitHubAccountTokenNamesRequest(input)
	return out, req.Send()
}

// ListGitHubAccountTokenNamesWithContext is the same as ListGitHubAccountTokenNames with the addition of
// the ability to pass a context and additional request options.
//
// See ListGitHubAccountTokenNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListGitHubAccountTokenNamesWithContext(ctx aws.Context, input *ListGitHubAccountTokenNamesInput, opts ...request.Option) (*ListGitHubAccountTokenNamesOutput, error) {
	req, out := c.ListGitHubAccountTokenNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOnPremisesInstances = "ListOnPremisesInstances"

// ListOnPremisesInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListOnPremisesInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOnPremisesInstances for more information on using the ListOnPremisesInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOnPremisesInstancesRequest method.
//    req, resp := client.ListOnPremisesInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances
func (c *CodeDeploy) ListOnPremisesInstancesRequest(input *ListOnPremisesInstancesInput) (req *request.Request, output *ListOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opListOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListOnPremisesInstancesInput{}
	}

	output = &ListOnPremisesInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOnPremisesInstances API operation for AWS CodeDeploy.
//
// Gets a list of names for one or more on-premises instances.
//
// Unless otherwise specified, both registered and deregistered on-premises
// instance names will be listed. To list only registered or deregistered on-premises
// instance names, use the registration status parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation ListOnPremisesInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRegistrationStatusException "InvalidRegistrationStatusException"
//   The registration status was specified in an invalid format.
//
//   * ErrCodeInvalidTagFilterException "InvalidTagFilterException"
//   The specified tag filter was specified in an invalid format.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/ListOnPremisesInstances
func (c *CodeDeploy) ListOnPremisesInstances(input *ListOnPremisesInstancesInput) (*ListOnPremisesInstancesOutput, error) {
	req, out := c.ListOnPremisesInstancesRequest(input)
	return out, req.Send()
}

// ListOnPremisesInstancesWithContext is the same as ListOnPremisesInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListOnPremisesInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) ListOnPremisesInstancesWithContext(ctx aws.Context, input *ListOnPremisesInstancesInput, opts ...request.Option) (*ListOnPremisesInstancesOutput, error) {
	req, out := c.ListOnPremisesInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLifecycleEventHookExecutionStatus = "PutLifecycleEventHookExecutionStatus"

// PutLifecycleEventHookExecutionStatusRequest generates a "aws/request.Request" representing the
// client's request for the PutLifecycleEventHookExecutionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLifecycleEventHookExecutionStatus for more information on using the PutLifecycleEventHookExecutionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLifecycleEventHookExecutionStatusRequest method.
//    req, resp := client.PutLifecycleEventHookExecutionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/PutLifecycleEventHookExecutionStatus
func (c *CodeDeploy) PutLifecycleEventHookExecutionStatusRequest(input *PutLifecycleEventHookExecutionStatusInput) (req *request.Request, output *PutLifecycleEventHookExecutionStatusOutput) {
	op := &request.Operation{
		Name:       opPutLifecycleEventHookExecutionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLifecycleEventHookExecutionStatusInput{}
	}

	output = &PutLifecycleEventHookExecutionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutLifecycleEventHookExecutionStatus API operation for AWS CodeDeploy.
//
// Sets the result of a Lambda validation function. The function validates one
// or both lifecycle events (BeforeAllowTraffic and AfterAllowTraffic) and returns
// Succeeded or Failed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation PutLifecycleEventHookExecutionStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidLifecycleEventHookExecutionStatusException "InvalidLifecycleEventHookExecutionStatusException"
//   The result of a Lambda validation function that verifies a lifecycle event
//   is invalid. It should return Succeeded or Failed.
//
//   * ErrCodeInvalidLifecycleEventHookExecutionIdException "InvalidLifecycleEventHookExecutionIdException"
//   A lifecycle event hook is invalid. Review the hooks section in your AppSpec
//   file to ensure the lifecycle events and hooks functions are valid.
//
//   * ErrCodeLifecycleEventAlreadyCompletedException "LifecycleEventAlreadyCompletedException"
//   An attempt to return the status of an already completed lifecycle event occurred.
//
//   * ErrCodeDeploymentIdRequiredException "DeploymentIdRequiredException"
//   At least one deployment ID must be specified.
//
//   * ErrCodeDeploymentDoesNotExistException "DeploymentDoesNotExistException"
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeInvalidDeploymentIdException "InvalidDeploymentIdException"
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * ErrCodeUnsupportedActionForDeploymentTypeException "UnsupportedActionForDeploymentTypeException"
//   A call was submitted that is not supported for the specified deployment type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/PutLifecycleEventHookExecutionStatus
func (c *CodeDeploy) PutLifecycleEventHookExecutionStatus(input *PutLifecycleEventHookExecutionStatusInput) (*PutLifecycleEventHookExecutionStatusOutput, error) {
	req, out := c.PutLifecycleEventHookExecutionStatusRequest(input)
	return out, req.Send()
}

// PutLifecycleEventHookExecutionStatusWithContext is the same as PutLifecycleEventHookExecutionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See PutLifecycleEventHookExecutionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) PutLifecycleEventHookExecutionStatusWithContext(ctx aws.Context, input *PutLifecycleEventHookExecutionStatusInput, opts ...request.Option) (*PutLifecycleEventHookExecutionStatusOutput, error) {
	req, out := c.PutLifecycleEventHookExecutionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterApplicationRevision = "RegisterApplicationRevision"

// RegisterApplicationRevisionRequest generates a "aws/request.Request" representing the
// client's request for the RegisterApplicationRevision operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterApplicationRevision for more information on using the RegisterApplicationRevision
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterApplicationRevisionRequest method.
//    req, resp := client.RegisterApplicationRevisionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision
func (c *CodeDeploy) RegisterApplicationRevisionRequest(input *RegisterApplicationRevisionInput) (req *request.Request, output *RegisterApplicationRevisionOutput) {
	op := &request.Operation{
		Name:       opRegisterApplicationRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterApplicationRevisionInput{}
	}

	output = &RegisterApplicationRevisionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterApplicationRevision API operation for AWS CodeDeploy.
//
// Registers with AWS CodeDeploy a revision for the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation RegisterApplicationRevision for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeDescriptionTooLongException "DescriptionTooLongException"
//   The description is too long.
//
//   * ErrCodeRevisionRequiredException "RevisionRequiredException"
//   The revision ID was not specified.
//
//   * ErrCodeInvalidRevisionException "InvalidRevisionException"
//   The revision was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterApplicationRevision
func (c *CodeDeploy) RegisterApplicationRevision(input *RegisterApplicationRevisionInput) (*RegisterApplicationRevisionOutput, error) {
	req, out := c.RegisterApplicationRevisionRequest(input)
	return out, req.Send()
}

// RegisterApplicationRevisionWithContext is the same as RegisterApplicationRevision with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterApplicationRevision for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) RegisterApplicationRevisionWithContext(ctx aws.Context, input *RegisterApplicationRevisionInput, opts ...request.Option) (*RegisterApplicationRevisionOutput, error) {
	req, out := c.RegisterApplicationRevisionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterOnPremisesInstance = "RegisterOnPremisesInstance"

// RegisterOnPremisesInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterOnPremisesInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterOnPremisesInstance for more information on using the RegisterOnPremisesInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterOnPremisesInstanceRequest method.
//    req, resp := client.RegisterOnPremisesInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance
func (c *CodeDeploy) RegisterOnPremisesInstanceRequest(input *RegisterOnPremisesInstanceInput) (req *request.Request, output *RegisterOnPremisesInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterOnPremisesInstanceInput{}
	}

	output = &RegisterOnPremisesInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterOnPremisesInstance API operation for AWS CodeDeploy.
//
// Registers an on-premises instance.
//
// Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the
// request. You cannot use both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation RegisterOnPremisesInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstanceNameAlreadyRegisteredException "InstanceNameAlreadyRegisteredException"
//   The specified on-premises instance name is already registered.
//
//   * ErrCodeIamArnRequiredException "IamArnRequiredException"
//   No IAM ARN was included in the request. You must use an IAM session ARN or
//   IAM user ARN in the request.
//
//   * ErrCodeIamSessionArnAlreadyRegisteredException "IamSessionArnAlreadyRegisteredException"
//   The request included an IAM session ARN that has already been used to register
//   a different instance.
//
//   * ErrCodeIamUserArnAlreadyRegisteredException "IamUserArnAlreadyRegisteredException"
//   The specified IAM user ARN is already registered with an on-premises instance.
//
//   * ErrCodeInstanceNameRequiredException "InstanceNameRequiredException"
//   An on-premises instance name was not specified.
//
//   * ErrCodeIamUserArnRequiredException "IamUserArnRequiredException"
//   An IAM user ARN was not specified.
//
//   * ErrCodeInvalidInstanceNameException "InvalidInstanceNameException"
//   The specified on-premises instance name was specified in an invalid format.
//
//   * ErrCodeInvalidIamSessionArnException "InvalidIamSessionArnException"
//   The IAM session ARN was specified in an invalid format.
//
//   * ErrCodeInvalidIamUserArnException "InvalidIamUserArnException"
//   The IAM user ARN was specified in an invalid format.
//
//   * ErrCodeMultipleIamArnsProvidedException "MultipleIamArnsProvidedException"
//   Both an IAM user ARN and an IAM session ARN were included in the request.
//   Use only one ARN type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RegisterOnPremisesInstance
func (c *CodeDeploy) RegisterOnPremisesInstance(input *RegisterOnPremisesInstanceInput) (*RegisterOnPremisesInstanceOutput, error) {
	req, out := c.RegisterOnPremisesInstanceRequest(input)
	return out, req.Send()
}

// RegisterOnPremisesInstanceWithContext is the same as RegisterOnPremisesInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterOnPremisesInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) RegisterOnPremisesInstanceWithContext(ctx aws.Context, input *RegisterOnPremisesInstanceInput, opts ...request.Option) (*RegisterOnPremisesInstanceOutput, error) {
	req, out := c.RegisterOnPremisesInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromOnPremisesInstances = "RemoveTagsFromOnPremisesInstances"

// RemoveTagsFromOnPremisesInstancesRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromOnPremisesInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromOnPremisesInstances for more information on using the RemoveTagsFromOnPremisesInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromOnPremisesInstancesRequest method.
//    req, resp := client.RemoveTagsFromOnPremisesInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances
func (c *CodeDeploy) RemoveTagsFromOnPremisesInstancesRequest(input *RemoveTagsFromOnPremisesInstancesInput) (req *request.Request, output *RemoveTagsFromOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromOnPremisesInstancesInput{}
	}

	output = &RemoveTagsFromOnPremisesInstancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromOnPremisesInstances API operation for AWS CodeDeploy.
//
// Removes one or more tags from one or more on-premises instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation RemoveTagsFromOnPremisesInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInstanceNameRequiredException "InstanceNameRequiredException"
//   An on-premises instance name was not specified.
//
//   * ErrCodeInvalidInstanceNameException "InvalidInstanceNameException"
//   The specified on-premises instance name was specified in an invalid format.
//
//   * ErrCodeTagRequiredException "TagRequiredException"
//   A tag was not specified.
//
//   * ErrCodeInvalidTagException "InvalidTagException"
//   The specified tag was specified in an invalid format.
//
//   * ErrCodeTagLimitExceededException "TagLimitExceededException"
//   The maximum allowed number of tags was exceeded.
//
//   * ErrCodeInstanceLimitExceededException "InstanceLimitExceededException"
//   The maximum number of allowed on-premises instances in a single call was
//   exceeded.
//
//   * ErrCodeInstanceNotRegisteredException "InstanceNotRegisteredException"
//   The specified on-premises instance is not registered.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/RemoveTagsFromOnPremisesInstances
func (c *CodeDeploy) RemoveTagsFromOnPremisesInstances(input *RemoveTagsFromOnPremisesInstancesInput) (*RemoveTagsFromOnPremisesInstancesOutput, error) {
	req, out := c.RemoveTagsFromOnPremisesInstancesRequest(input)
	return out, req.Send()
}

// RemoveTagsFromOnPremisesInstancesWithContext is the same as RemoveTagsFromOnPremisesInstances with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromOnPremisesInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) RemoveTagsFromOnPremisesInstancesWithContext(ctx aws.Context, input *RemoveTagsFromOnPremisesInstancesInput, opts ...request.Option) (*RemoveTagsFromOnPremisesInstancesOutput, error) {
	req, out := c.RemoveTagsFromOnPremisesInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSkipWaitTimeForInstanceTermination = "SkipWaitTimeForInstanceTermination"

// SkipWaitTimeForInstanceTerminationRequest generates a "aws/request.Request" representing the
// client's request for the SkipWaitTimeForInstanceTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SkipWaitTimeForInstanceTermination for more information on using the SkipWaitTimeForInstanceTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SkipWaitTimeForInstanceTerminationRequest method.
//    req, resp := client.SkipWaitTimeForInstanceTerminationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/SkipWaitTimeForInstanceTermination
func (c *CodeDeploy) SkipWaitTimeForInstanceTerminationRequest(input *SkipWaitTimeForInstanceTerminationInput) (req *request.Request, output *SkipWaitTimeForInstanceTerminationOutput) {
	op := &request.Operation{
		Name:       opSkipWaitTimeForInstanceTermination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SkipWaitTimeForInstanceTerminationInput{}
	}

	output = &SkipWaitTimeForInstanceTerminationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SkipWaitTimeForInstanceTermination API operation for AWS CodeDeploy.
//
// In a blue/green deployment, overrides any specified wait time and starts
// terminating instances immediately after the traffic routing is completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation SkipWaitTimeForInstanceTermination for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeploymentIdRequiredException "DeploymentIdRequiredException"
//   At least one deployment ID must be specified.
//
//   * ErrCodeDeploymentDoesNotExistException "DeploymentDoesNotExistException"
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeDeploymentAlreadyCompletedException "DeploymentAlreadyCompletedException"
//   The deployment is already complete.
//
//   * ErrCodeInvalidDeploymentIdException "InvalidDeploymentIdException"
//   At least one of the deployment IDs was specified in an invalid format.
//
//   * ErrCodeDeploymentNotStartedException "DeploymentNotStartedException"
//   The specified deployment has not started.
//
//   * ErrCodeUnsupportedActionForDeploymentTypeException "UnsupportedActionForDeploymentTypeException"
//   A call was submitted that is not supported for the specified deployment type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/SkipWaitTimeForInstanceTermination
func (c *CodeDeploy) SkipWaitTimeForInstanceTermination(input *SkipWaitTimeForInstanceTerminationInput) (*SkipWaitTimeForInstanceTerminationOutput, error) {
	req, out := c.SkipWaitTimeForInstanceTerminationRequest(input)
	return out, req.Send()
}

// SkipWaitTimeForInstanceTerminationWithContext is the same as SkipWaitTimeForInstanceTermination with the addition of
// the ability to pass a context and additional request options.
//
// See SkipWaitTimeForInstanceTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) SkipWaitTimeForInstanceTerminationWithContext(ctx aws.Context, input *SkipWaitTimeForInstanceTerminationInput, opts ...request.Option) (*SkipWaitTimeForInstanceTerminationOutput, error) {
	req, out := c.SkipWaitTimeForInstanceTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDeployment = "StopDeployment"

// StopDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the StopDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDeployment for more information on using the StopDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDeploymentRequest method.
//    req, resp := client.StopDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment
func (c *CodeDeploy) StopDeploymentRequest(input *StopDeploymentInput) (req *request.Request, output *StopDeploymentOutput) {
	op := &request.Operation{
		Name:       opStopDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDeploymentInput{}
	}

	output = &StopDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDeployment API operation for AWS CodeDeploy.
//
// Attempts to stop an ongoing deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation StopDeployment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDeploymentIdRequiredException "DeploymentIdRequiredException"
//   At least one deployment ID must be specified.
//
//   * ErrCodeDeploymentDoesNotExistException "DeploymentDoesNotExistException"
//   The deployment does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeDeploymentAlreadyCompletedException "DeploymentAlreadyCompletedException"
//   The deployment is already complete.
//
//   * ErrCodeInvalidDeploymentIdException "InvalidDeploymentIdException"
//   At least one of the deployment IDs was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/StopDeployment
func (c *CodeDeploy) StopDeployment(input *StopDeploymentInput) (*StopDeploymentOutput, error) {
	req, out := c.StopDeploymentRequest(input)
	return out, req.Send()
}

// StopDeploymentWithContext is the same as StopDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See StopDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) StopDeploymentWithContext(ctx aws.Context, input *StopDeploymentInput, opts ...request.Option) (*StopDeploymentOutput, error) {
	req, out := c.StopDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication
func (c *CodeDeploy) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateApplication API operation for AWS CodeDeploy.
//
// Changes the name of an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationAlreadyExistsException "ApplicationAlreadyExistsException"
//   An application with the specified name already exists with the applicable
//   IAM user or AWS account.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateApplication
func (c *CodeDeploy) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeploymentGroup = "UpdateDeploymentGroup"

// UpdateDeploymentGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeploymentGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeploymentGroup for more information on using the UpdateDeploymentGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeploymentGroupRequest method.
//    req, resp := client.UpdateDeploymentGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup
func (c *CodeDeploy) UpdateDeploymentGroupRequest(input *UpdateDeploymentGroupInput) (req *request.Request, output *UpdateDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeploymentGroupInput{}
	}

	output = &UpdateDeploymentGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDeploymentGroup API operation for AWS CodeDeploy.
//
// Changes information about a deployment group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeDeploy's
// API operation UpdateDeploymentGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeApplicationNameRequiredException "ApplicationNameRequiredException"
//   The minimum number of required application names was not specified.
//
//   * ErrCodeInvalidApplicationNameException "InvalidApplicationNameException"
//   The application name was specified in an invalid format.
//
//   * ErrCodeApplicationDoesNotExistException "ApplicationDoesNotExistException"
//   The application does not exist with the applicable IAM user or AWS account.
//
//   * ErrCodeInvalidDeploymentGroupNameException "InvalidDeploymentGroupNameException"
//   The deployment group name was specified in an invalid format.
//
//   * ErrCodeDeploymentGroupAlreadyExistsException "DeploymentGroupAlreadyExistsException"
//   A deployment group with the specified name already exists with the applicable
//   IAM user or AWS account.
//
//   * ErrCodeDeploymentGroupNameRequiredException "DeploymentGroupNameRequiredException"
//   The deployment group name was not specified.
//
//   * ErrCodeDeploymentGroupDoesNotExistException "DeploymentGroupDoesNotExistException"
//   The named deployment group does not exist with the applicable IAM user or
//   AWS account.
//
//   * ErrCodeInvalidEC2TagException "InvalidEC2TagException"
//   The tag was specified in an invalid format.
//
//   * ErrCodeInvalidTagException "InvalidTagException"
//   The specified tag was specified in an invalid format.
//
//   * ErrCodeInvalidAutoScalingGroupException "InvalidAutoScalingGroupException"
//   The Auto Scaling group was specified in an invalid format or does not exist.
//
//   * ErrCodeInvalidDeploymentConfigNameException "InvalidDeploymentConfigNameException"
//   The deployment configuration name was specified in an invalid format.
//
//   * ErrCodeDeploymentConfigDoesNotExistException "DeploymentConfigDoesNotExistException"
//   The deployment configuration does not exist with the applicable IAM user
//   or AWS account.
//
//   * ErrCodeInvalidRoleException "InvalidRoleException"
//   The service role ARN was specified in an invalid format. Or, if an Auto Scaling
//   group was specified, the specified service role does not grant the appropriate
//   permissions to Auto Scaling.
//
//   * ErrCodeLifecycleHookLimitExceededException "LifecycleHookLimitExceededException"
//   The limit for lifecycle hooks was exceeded.
//
//   * ErrCodeInvalidTriggerConfigException "InvalidTriggerConfigException"
//   The trigger was specified in an invalid format.
//
//   * ErrCodeTriggerTargetsLimitExceededException "TriggerTargetsLimitExceededException"
//   The maximum allowed number of triggers was exceeded.
//
//   * ErrCodeInvalidAlarmConfigException "InvalidAlarmConfigException"
//   The format of the alarm configuration is invalid. Possible causes include:
//
//      * The alarm list is null.
//
//      * The alarm object is null.
//
//      * The alarm name is empty or null or exceeds the 255 character limit.
//
//      * Two alarms with the same name have been specified.
//
//      * The alarm configuration is enabled but the alarm list is empty.
//
//   * ErrCodeAlarmsLimitExceededException "AlarmsLimitExceededException"
//   The maximum number of alarms for a deployment group (10) was exceeded.
//
//   * ErrCodeInvalidAutoRollbackConfigException "InvalidAutoRollbackConfigException"
//   The automatic rollback configuration was specified in an invalid format.
//   For example, automatic rollback is enabled but an invalid triggering event
//   type or no event types were listed.
//
//   * ErrCodeInvalidLoadBalancerInfoException "InvalidLoadBalancerInfoException"
//   An invalid load balancer name, or no load balancer name, was specified.
//
//   * ErrCodeInvalidDeploymentStyleException "InvalidDeploymentStyleException"
//   An invalid deployment style was specified. Valid deployment types include
//   "IN_PLACE" and "BLUE_GREEN". Valid deployment options include "WITH_TRAFFIC_CONTROL"
//   and "WITHOUT_TRAFFIC_CONTROL".
//
//   * ErrCodeInvalidBlueGreenDeploymentConfigurationException "InvalidBlueGreenDeploymentConfigurationException"
//   The configuration for the blue/green deployment group was provided in an
//   invalid format. For information about deployment configuration format, see
//   CreateDeploymentConfig.
//
//   * ErrCodeInvalidEC2TagCombinationException "InvalidEC2TagCombinationException"
//   A call was submitted that specified both Ec2TagFilters and Ec2TagSet, but
//   only one of these data types can be used in a single call.
//
//   * ErrCodeInvalidOnPremisesTagCombinationException "InvalidOnPremisesTagCombinationException"
//   A call was submitted that specified both OnPremisesTagFilters and OnPremisesTagSet,
//   but only one of these data types can be used in a single call.
//
//   * ErrCodeTagSetListLimitExceededException "TagSetListLimitExceededException"
//   The number of tag groups included in the tag set list exceeded the maximum
//   allowed limit of 3.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The specified input was specified in an invalid format.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup
func (c *CodeDeploy) UpdateDeploymentGroup(input *UpdateDeploymentGroupInput) (*UpdateDeploymentGroupOutput, error) {
	req, out := c.UpdateDeploymentGroupRequest(input)
	return out, req.Send()
}

// UpdateDeploymentGroupWithContext is the same as UpdateDeploymentGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeploymentGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeDeploy) UpdateDeploymentGroupWithContext(ctx aws.Context, input *UpdateDeploymentGroupInput, opts ...request.Option) (*UpdateDeploymentGroupOutput, error) {
	req, out := c.UpdateDeploymentGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the input of, and adds tags to, an on-premises instance operation.
type AddTagsToOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the on-premises instances to which to add tags.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The tag key-value pairs to add to the on-premises instances.
	//
	// Keys and values are both required. Keys cannot be null or empty strings.
	// Value-only tags are not allowed.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToOnPremisesInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToOnPremisesInstancesInput"}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *AddTagsToOnPremisesInstancesInput) SetInstanceNames(v []*string) *AddTagsToOnPremisesInstancesInput {
	s.InstanceNames = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToOnPremisesInstancesInput) SetTags(v []*Tag) *AddTagsToOnPremisesInstancesInput {
	s.Tags = v
	return s
}

type AddTagsToOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Information about an alarm.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The name of the alarm. Maximum length is 255 characters. Each alarm name
	// can be used only once in a list of alarms.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alarm) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Alarm) SetName(v string) *Alarm {
	s.Name = &v
	return s
}

// Information about alarms associated with the deployment group.
type AlarmConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of alarms configured for the deployment group. A maximum of 10 alarms
	// can be added to a deployment group.
	Alarms []*Alarm `locationName:"alarms" type:"list"`

	// Indicates whether the alarm configuration is enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// Indicates whether a deployment should continue if information about the current
	// state of alarms cannot be retrieved from Amazon CloudWatch. The default value
	// is false.
	//
	//    * true: The deployment will proceed even if alarm status information can't
	//    be retrieved from Amazon CloudWatch.
	//
	//    * false: The deployment will stop if alarm status information can't be
	//    retrieved from Amazon CloudWatch.
	IgnorePollAlarmFailure *bool `locationName:"ignorePollAlarmFailure" type:"boolean"`
}

// String returns the string representation
func (s AlarmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlarmConfiguration) GoString() string {
	return s.String()
}

// SetAlarms sets the Alarms field's value.
func (s *AlarmConfiguration) SetAlarms(v []*Alarm) *AlarmConfiguration {
	s.Alarms = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AlarmConfiguration) SetEnabled(v bool) *AlarmConfiguration {
	s.Enabled = &v
	return s
}

// SetIgnorePollAlarmFailure sets the IgnorePollAlarmFailure field's value.
func (s *AlarmConfiguration) SetIgnorePollAlarmFailure(v bool) *AlarmConfiguration {
	s.IgnorePollAlarmFailure = &v
	return s
}

// Information about an application.
type ApplicationInfo struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `locationName:"applicationId" type:"string"`

	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// The destination platform type for deployment of the application (Lambda or
	// Server).
	ComputePlatform *string `locationName:"computePlatform" type:"string" enum:"ComputePlatform"`

	// The time at which the application was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// The name for a connection to a GitHub account.
	GitHubAccountName *string `locationName:"gitHubAccountName" type:"string"`

	// True if the user has authenticated with GitHub for the specified application;
	// otherwise, false.
	LinkedToGitHub *bool `locationName:"linkedToGitHub" type:"boolean"`
}

// String returns the string representation
func (s ApplicationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationInfo) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationInfo) SetApplicationId(v string) *ApplicationInfo {
	s.ApplicationId = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationInfo) SetApplicationName(v string) *ApplicationInfo {
	s.ApplicationName = &v
	return s
}

// SetComputePlatform sets the ComputePlatform field's value.
func (s *ApplicationInfo) SetComputePlatform(v string) *ApplicationInfo {
	s.ComputePlatform = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ApplicationInfo) SetCreateTime(v time.Time) *ApplicationInfo {
	s.CreateTime = &v
	return s
}

// SetGitHubAccountName sets the GitHubAccountName field's value.
func (s *ApplicationInfo) SetGitHubAccountName(v string) *ApplicationInfo {
	s.GitHubAccountName = &v
	return s
}

// SetLinkedToGitHub sets the LinkedToGitHub field's value.
func (s *ApplicationInfo) SetLinkedToGitHub(v bool) *ApplicationInfo {
	s.LinkedToGitHub = &v
	return s
}

// Information about a configuration for automatically rolling back to a previous
// version of an application revision when a deployment doesn't complete successfully.
type AutoRollbackConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether a defined automatic rollback configuration is currently
	// enabled.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The event type or types that trigger a rollback.
	Events []*string `locationName:"events" type:"list"`
}

// String returns the string representation
func (s AutoRollbackConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoRollbackConfiguration) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *AutoRollbackConfiguration) SetEnabled(v bool) *AutoRollbackConfiguration {
	s.Enabled = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *AutoRollbackConfiguration) SetEvents(v []*string) *AutoRollbackConfiguration {
	s.Events = v
	return s
}

// Information about an Auto Scaling group.
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// An Auto Scaling lifecycle event hook name.
	Hook *string `locationName:"hook" type:"string"`

	// The Auto Scaling group name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingGroup) GoString() string {
	return s.String()
}

// SetHook sets the Hook field's value.
func (s *AutoScalingGroup) SetHook(v string) *AutoScalingGroup {
	s.Hook = &v
	return s
}

// SetName sets the Name field's value.
func (s *AutoScalingGroup) SetName(v string) *AutoScalingGroup {
	s.Name = &v
	return s
}

// Represents the input of a BatchGetApplicationRevisions operation.
type BatchGetApplicationRevisionsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application about which to get revision information.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Information to get about the application revisions, including type and location.
	//
	// Revisions is a required field
	Revisions []*RevisionLocation `locationName:"revisions" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetApplicationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetApplicationRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetApplicationRevisionsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.Revisions == nil {
		invalidParams.Add(request.NewErrParamRequired("Revisions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *BatchGetApplicationRevisionsInput) SetApplicationName(v string) *BatchGetApplicationRevisionsInput {
	s.ApplicationName = &v
	return s
}

// SetRevisions sets the Revisions field's value.
func (s *BatchGetApplicationRevisionsInput) SetRevisions(v []*RevisionLocation) *BatchGetApplicationRevisionsInput {
	s.Revisions = v
	return s
}

// Represents the output of a BatchGetApplicationRevisions operation.
type BatchGetApplicationRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// The name of the application that corresponds to the revisions.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Information about errors that may have occurred during the API call.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Additional information about the revisions, including the type and location.
	Revisions []*RevisionInfo `locationName:"revisions" type:"list"`
}

// String returns the string representation
func (s BatchGetApplicationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationRevisionsOutput) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *BatchGetApplicationRevisionsOutput) SetApplicationName(v string) *BatchGetApplicationRevisionsOutput {
	s.ApplicationName = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetApplicationRevisionsOutput) SetErrorMessage(v string) *BatchGetApplicationRevisionsOutput {
	s.ErrorMessage = &v
	return s
}

// SetRevisions sets the Revisions field's value.
func (s *BatchGetApplicationRevisionsOutput) SetRevisions(v []*RevisionInfo) *BatchGetApplicationRevisionsOutput {
	s.Revisions = v
	return s
}

// Represents the input of a BatchGetApplications operation.
type BatchGetApplicationsInput struct {
	_ struct{} `type:"structure"`

	// A list of application names separated by spaces.
	//
	// ApplicationNames is a required field
	ApplicationNames []*string `locationName:"applicationNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetApplicationsInput"}
	if s.ApplicationNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationNames sets the ApplicationNames field's value.
func (s *BatchGetApplicationsInput) SetApplicationNames(v []*string) *BatchGetApplicationsInput {
	s.ApplicationNames = v
	return s
}

// Represents the output of a BatchGetApplications operation.
type BatchGetApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the applications.
	ApplicationsInfo []*ApplicationInfo `locationName:"applicationsInfo" type:"list"`
}

// String returns the string representation
func (s BatchGetApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplicationsInfo sets the ApplicationsInfo field's value.
func (s *BatchGetApplicationsOutput) SetApplicationsInfo(v []*ApplicationInfo) *BatchGetApplicationsOutput {
	s.ApplicationsInfo = v
	return s
}

// Represents the input of a BatchGetDeploymentGroups operation.
type BatchGetDeploymentGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The deployment groups' names.
	//
	// DeploymentGroupNames is a required field
	DeploymentGroupNames []*string `locationName:"deploymentGroupNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetDeploymentGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetDeploymentGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetDeploymentGroupsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentGroupNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentGroupNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *BatchGetDeploymentGroupsInput) SetApplicationName(v string) *BatchGetDeploymentGroupsInput {
	s.ApplicationName = &v
	return s
}

// SetDeploymentGroupNames sets the DeploymentGroupNames field's value.
func (s *BatchGetDeploymentGroupsInput) SetDeploymentGroupNames(v []*string) *BatchGetDeploymentGroupsInput {
	s.DeploymentGroupNames = v
	return s
}

// Represents the output of a BatchGetDeploymentGroups operation.
type BatchGetDeploymentGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployment groups.
	DeploymentGroupsInfo []*DeploymentGroupInfo `locationName:"deploymentGroupsInfo" type:"list"`

	// Information about errors that may have occurred during the API call.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`
}

// String returns the string representation
func (s BatchGetDeploymentGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentGroupsOutput) GoString() string {
	return s.String()
}

// SetDeploymentGroupsInfo sets the DeploymentGroupsInfo field's value.
func (s *BatchGetDeploymentGroupsOutput) SetDeploymentGroupsInfo(v []*DeploymentGroupInfo) *BatchGetDeploymentGroupsOutput {
	s.DeploymentGroupsInfo = v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetDeploymentGroupsOutput) SetErrorMessage(v string) *BatchGetDeploymentGroupsOutput {
	s.ErrorMessage = &v
	return s
}

// Represents the input of a BatchGetDeploymentInstances operation.
type BatchGetDeploymentInstancesInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The unique IDs of instances in the deployment group.
	//
	// InstanceIds is a required field
	InstanceIds []*string `locationName:"instanceIds" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetDeploymentInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetDeploymentInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetDeploymentInstancesInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *BatchGetDeploymentInstancesInput) SetDeploymentId(v string) *BatchGetDeploymentInstancesInput {
	s.DeploymentId = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *BatchGetDeploymentInstancesInput) SetInstanceIds(v []*string) *BatchGetDeploymentInstancesInput {
	s.InstanceIds = v
	return s
}

// Represents the output of a BatchGetDeploymentInstances operation.
type BatchGetDeploymentInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about errors that may have occurred during the API call.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Information about the instance.
	InstancesSummary []*InstanceSummary `locationName:"instancesSummary" type:"list"`
}

// String returns the string representation
func (s BatchGetDeploymentInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentInstancesOutput) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetDeploymentInstancesOutput) SetErrorMessage(v string) *BatchGetDeploymentInstancesOutput {
	s.ErrorMessage = &v
	return s
}

// SetInstancesSummary sets the InstancesSummary field's value.
func (s *BatchGetDeploymentInstancesOutput) SetInstancesSummary(v []*InstanceSummary) *BatchGetDeploymentInstancesOutput {
	s.InstancesSummary = v
	return s
}

// Represents the input of a BatchGetDeployments operation.
type BatchGetDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// A list of deployment IDs, separated by spaces.
	//
	// DeploymentIds is a required field
	DeploymentIds []*string `locationName:"deploymentIds" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetDeploymentsInput"}
	if s.DeploymentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentIds sets the DeploymentIds field's value.
func (s *BatchGetDeploymentsInput) SetDeploymentIds(v []*string) *BatchGetDeploymentsInput {
	s.DeploymentIds = v
	return s
}

// Represents the output of a BatchGetDeployments operation.
type BatchGetDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployments.
	DeploymentsInfo []*DeploymentInfo `locationName:"deploymentsInfo" type:"list"`
}

// String returns the string representation
func (s BatchGetDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeploymentsInfo sets the DeploymentsInfo field's value.
func (s *BatchGetDeploymentsOutput) SetDeploymentsInfo(v []*DeploymentInfo) *BatchGetDeploymentsOutput {
	s.DeploymentsInfo = v
	return s
}

// Represents the input of a BatchGetOnPremisesInstances operation.
type BatchGetOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the on-premises instances about which to get information.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetOnPremisesInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetOnPremisesInstancesInput"}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *BatchGetOnPremisesInstancesInput) SetInstanceNames(v []*string) *BatchGetOnPremisesInstancesInput {
	s.InstanceNames = v
	return s
}

// Represents the output of a BatchGetOnPremisesInstances operation.
type BatchGetOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the on-premises instances.
	InstanceInfos []*InstanceInfo `locationName:"instanceInfos" type:"list"`
}

// String returns the string representation
func (s BatchGetOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// SetInstanceInfos sets the InstanceInfos field's value.
func (s *BatchGetOnPremisesInstancesOutput) SetInstanceInfos(v []*InstanceInfo) *BatchGetOnPremisesInstancesOutput {
	s.InstanceInfos = v
	return s
}

// Information about blue/green deployment options for a deployment group.
type BlueGreenDeploymentConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about the action to take when newly provisioned instances are
	// ready to receive traffic in a blue/green deployment.
	DeploymentReadyOption *DeploymentReadyOption `locationName:"deploymentReadyOption" type:"structure"`

	// Information about how instances are provisioned for a replacement environment
	// in a blue/green deployment.
	GreenFleetProvisioningOption *GreenFleetProvisioningOption `locationName:"greenFleetProvisioningOption" type:"structure"`

	// Information about whether to terminate instances in the original fleet during
	// a blue/green deployment.
	TerminateBlueInstancesOnDeploymentSuccess *BlueInstanceTerminationOption `locationName:"terminateBlueInstancesOnDeploymentSuccess" type:"structure"`
}

// String returns the string representation
func (s BlueGreenDeploymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlueGreenDeploymentConfiguration) GoString() string {
	return s.String()
}

// SetDeploymentReadyOption sets the DeploymentReadyOption field's value.
func (s *BlueGreenDeploymentConfiguration) SetDeploymentReadyOption(v *DeploymentReadyOption) *BlueGreenDeploymentConfiguration {
	s.DeploymentReadyOption = v
	return s
}

// SetGreenFleetProvisioningOption sets the GreenFleetProvisioningOption field's value.
func (s *BlueGreenDeploymentConfiguration) SetGreenFleetProvisioningOption(v *GreenFleetProvisioningOption) *BlueGreenDeploymentConfiguration {
	s.GreenFleetProvisioningOption = v
	return s
}

// SetTerminateBlueInstancesOnDeploymentSuccess sets the TerminateBlueInstancesOnDeploymentSuccess field's value.
func (s *BlueGreenDeploymentConfiguration) SetTerminateBlueInstancesOnDeploymentSuccess(v *BlueInstanceTerminationOption) *BlueGreenDeploymentConfiguration {
	s.TerminateBlueInstancesOnDeploymentSuccess = v
	return s
}

// Information about whether instances in the original environment are terminated
// when a blue/green deployment is successful.
type BlueInstanceTerminationOption struct {
	_ struct{} `type:"structure"`

	// The action to take on instances in the original environment after a successful
	// blue/green deployment.
	//
	//    * TERMINATE: Instances are terminated after a specified wait time.
	//
	//    * KEEP_ALIVE: Instances are left running after they are deregistered from
	//    the load balancer and removed from the deployment group.
	Action *string `locationName:"action" type:"string" enum:"InstanceAction"`

	// The number of minutes to wait after a successful blue/green deployment before
	// terminating instances from the original environment.
	TerminationWaitTimeInMinutes *int64 `locationName:"terminationWaitTimeInMinutes" type:"integer"`
}

// String returns the string representation
func (s BlueInstanceTerminationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlueInstanceTerminationOption) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *BlueInstanceTerminationOption) SetAction(v string) *BlueInstanceTerminationOption {
	s.Action = &v
	return s
}

// SetTerminationWaitTimeInMinutes sets the TerminationWaitTimeInMinutes field's value.
func (s *BlueInstanceTerminationOption) SetTerminationWaitTimeInMinutes(v int64) *BlueInstanceTerminationOption {
	s.TerminationWaitTimeInMinutes = &v
	return s
}

type ContinueDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The deployment ID of the blue/green deployment for which you want to start
	// rerouting traffic to the replacement environment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`
}

// String returns the string representation
func (s ContinueDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueDeploymentInput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ContinueDeploymentInput) SetDeploymentId(v string) *ContinueDeploymentInput {
	s.DeploymentId = &v
	return s
}

type ContinueDeploymentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ContinueDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueDeploymentOutput) GoString() string {
	return s.String()
}

// Represents the input of a CreateApplication operation.
type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application. This name must be unique with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The destination platform type for the deployment (Lambda or Server).
	ComputePlatform *string `locationName:"computePlatform" type:"string" enum:"ComputePlatform"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateApplicationInput) SetApplicationName(v string) *CreateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetComputePlatform sets the ComputePlatform field's value.
func (s *CreateApplicationInput) SetComputePlatform(v string) *CreateApplicationInput {
	s.ComputePlatform = &v
	return s
}

// Represents the output of a CreateApplication operation.
type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// A unique application ID.
	ApplicationId *string `locationName:"applicationId" type:"string"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateApplicationOutput) SetApplicationId(v string) *CreateApplicationOutput {
	s.ApplicationId = &v
	return s
}

// Represents the input of a CreateDeploymentConfig operation.
type CreateDeploymentConfigInput struct {
	_ struct{} `type:"structure"`

	// The destination platform type for the deployment (Lambda or Server>).
	ComputePlatform *string `locationName:"computePlatform" type:"string" enum:"ComputePlatform"`

	// The name of the deployment configuration to create.
	//
	// DeploymentConfigName is a required field
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string" required:"true"`

	// The minimum number of healthy instances that should be available at any time
	// during the deployment. There are two parameters expected in the input: type
	// and value.
	//
	// The type parameter takes either of the following values:
	//
	//    * HOST_COUNT: The value parameter represents the minimum number of healthy
	//    instances as an absolute value.
	//
	//    * FLEET_PERCENT: The value parameter represents the minimum number of
	//    healthy instances as a percentage of the total number of instances in
	//    the deployment. If you specify FLEET_PERCENT, at the start of the deployment,
	//    AWS CodeDeploy converts the percentage to the equivalent number of instance
	//    and rounds up fractional instances.
	//
	// The value parameter takes an integer.
	//
	// For example, to set a minimum of 95% healthy instance, specify a type of
	// FLEET_PERCENT and a value of 95.
	MinimumHealthyHosts *MinimumHealthyHosts `locationName:"minimumHealthyHosts" type:"structure"`

	// The configuration that specifies how the deployment traffic will be routed.
	TrafficRoutingConfig *TrafficRoutingConfig `locationName:"trafficRoutingConfig" type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentConfigInput"}
	if s.DeploymentConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentConfigName"))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputePlatform sets the ComputePlatform field's value.
func (s *CreateDeploymentConfigInput) SetComputePlatform(v string) *CreateDeploymentConfigInput {
	s.ComputePlatform = &v
	return s
}

// SetDeploymentConfigName sets the DeploymentConfigName field's value.
func (s *CreateDeploymentConfigInput) SetDeploymentConfigName(v string) *CreateDeploymentConfigInput {
	s.DeploymentConfigName = &v
	return s
}

// SetMinimumHealthyHosts sets the MinimumHealthyHosts field's value.
func (s *CreateDeploymentConfigInput) SetMinimumHealthyHosts(v *MinimumHealthyHosts) *CreateDeploymentConfigInput {
	s.MinimumHealthyHosts = v
	return s
}

// SetTrafficRoutingConfig sets the TrafficRoutingConfig field's value.
func (s *CreateDeploymentConfigInput) SetTrafficRoutingConfig(v *TrafficRoutingConfig) *CreateDeploymentConfigInput {
	s.TrafficRoutingConfig = v
	return s
}

// Represents the output of a CreateDeploymentConfig operation.
type CreateDeploymentConfigOutput struct {
	_ struct{} `type:"structure"`

	// A unique deployment configuration ID.
	DeploymentConfigId *string `locationName:"deploymentConfigId" type:"string"`
}

// String returns the string representation
func (s CreateDeploymentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentConfigOutput) GoString() string {
	return s.String()
}

// SetDeploymentConfigId sets the DeploymentConfigId field's value.
func (s *CreateDeploymentConfigOutput) SetDeploymentConfigId(v string) *CreateDeploymentConfigOutput {
	s.DeploymentConfigId = &v
	return s
}

// Represents the input of a CreateDeploymentGroup operation.
type CreateDeploymentGroupInput struct {
	_ struct{} `type:"structure"`

	// Information to add about Amazon CloudWatch alarms when the deployment group
	// is created.
	AlarmConfiguration *AlarmConfiguration `locationName:"alarmConfiguration" type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Configuration information for an automatic rollback that is added when a
	// deployment group is created.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// A list of associated Auto Scaling groups.
	AutoScalingGroups []*string `locationName:"autoScalingGroups" type:"list"`

	// Information about blue/green deployment options for a deployment group.
	BlueGreenDeploymentConfiguration *BlueGreenDeploymentConfiguration `locationName:"blueGreenDeploymentConfiguration" type:"structure"`

	// If specified, the deployment configuration name can be either one of the
	// predefined configurations provided with AWS CodeDeploy or a custom deployment
	// configuration that you create by calling the create deployment configuration
	// operation.
	//
	// CodeDeployDefault.OneAtATime is the default deployment configuration. It
	// is used if a configuration isn't specified for the deployment or the deployment
	// group.
	//
	// For more information about the predefined deployment configurations in AWS
	// CodeDeploy, see Working with Deployment Groups in AWS CodeDeploy (http://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html)
	// in the AWS CodeDeploy User Guide.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The name of a new deployment group for the specified application.
	//
	// DeploymentGroupName is a required field
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string" required:"true"`

	// Information about the type of deployment, in-place or blue/green, that you
	// want to run and whether to route deployment traffic behind a load balancer.
	DeploymentStyle *DeploymentStyle `locationName:"deploymentStyle" type:"structure"`

	// The Amazon EC2 tags on which to filter. The deployment group will include
	// EC2 instances with any of the specified tags. Cannot be used in the same
	// call as ec2TagSet.
	Ec2TagFilters []*EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// Information about groups of tags applied to EC2 instances. The deployment
	// group will include only EC2 instances identified by all the tag groups. Cannot
	// be used in the same call as ec2TagFilters.
	Ec2TagSet *EC2TagSet `locationName:"ec2TagSet" type:"structure"`

	// Information about the load balancer used in a deployment.
	LoadBalancerInfo *LoadBalancerInfo `locationName:"loadBalancerInfo" type:"structure"`

	// The on-premises instance tags on which to filter. The deployment group will
	// include on-premises instances with any of the specified tags. Cannot be used
	// in the same call as OnPremisesTagSet.
	OnPremisesInstanceTagFilters []*TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// Information about groups of tags applied to on-premises instances. The deployment
	// group will include only on-premises instances identified by all the tag groups.
	// Cannot be used in the same call as onPremisesInstanceTagFilters.
	OnPremisesTagSet *OnPremisesTagSet `locationName:"onPremisesTagSet" type:"structure"`

	// A service role ARN that allows AWS CodeDeploy to act on the user's behalf
	// when interacting with AWS services.
	//
	// ServiceRoleArn is a required field
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string" required:"true"`

	// Information about triggers to create when the deployment group is created.
	// For examples, see Create a Trigger for an AWS CodeDeploy Event (http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-sns.html)
	// in the AWS CodeDeploy User Guide.
	TriggerConfigurations []*TriggerConfig `locationName:"triggerConfigurations" type:"list"`
}

// String returns the string representation
func (s CreateDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentGroupInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}
	if s.DeploymentGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentGroupName"))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}
	if s.ServiceRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmConfiguration sets the AlarmConfiguration field's value.
func (s *CreateDeploymentGroupInput) SetAlarmConfiguration(v *AlarmConfiguration) *CreateDeploymentGroupInput {
	s.AlarmConfiguration = v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateDeploymentGroupInput) SetApplicationName(v string) *CreateDeploymentGroupInput {
	s.ApplicationName = &v
	return s
}

// SetAutoRollbackConfiguration sets the AutoRollbackConfiguration field's value.
func (s *CreateDeploymentGroupInput) SetAutoRollbackConfiguration(v *AutoRollbackConfiguration) *CreateDeploymentGroupInput {
	s.AutoRollbackConfiguration = v
	return s
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *CreateDeploymentGroupInput) SetAutoScalingGroups(v []*string) *CreateDeploymentGroupInput {
	s.AutoScalingGroups = v
	return s
}

// SetBlueGreenDeploymentConfiguration sets the BlueGreenDeploymentConfiguration field's value.
func (s *CreateDeploymentGroupInput) SetBlueGreenDeploymentConfiguration(v *BlueGreenDeploymentConfiguration) *CreateDeploymentGroupInput {
	s.BlueGreenDeploymentConfiguration = v
	return s
}

// SetDeploymentConfigName sets the DeploymentConfigName field's value.
func (s *CreateDeploymentGroupInput) SetDeploymentConfigName(v string) *CreateDeploymentGroupInput {
	s.DeploymentConfigName = &v
	return s
}

// SetDeploymentGroupName sets the DeploymentGroupName field's value.
func (s *CreateDeploymentGroupInput) SetDeploymentGroupName(v string) *CreateDeploymentGroupInput {
	s.DeploymentGroupName = &v
	return s
}

// SetDeploymentStyle sets the DeploymentStyle field's value.
func (s *CreateDeploymentGroupInput) SetDeploymentStyle(v *DeploymentStyle) *CreateDeploymentGroupInput {
	s.DeploymentStyle = v
	return s
}

// SetEc2TagFilters sets the Ec2TagFilters field's value.
func (s *CreateDeploymentGroupInput) SetEc2TagFilters(v []*EC2TagFilter) *CreateDeploymentGroupInput {
	s.Ec2TagFilters = v
	return s
}

// SetEc2TagSet sets the Ec2TagSet field's value.
func (s *CreateDeploymentGroupInput) SetEc2TagSet(v *EC2TagSet) *CreateDeploymentGroupInput {
	s.Ec2TagSet = v
	return s
}

// SetLoadBalancerInfo sets the LoadBalancerInfo field's value.
func (s *CreateDeploymentGroupInput) SetLoadBalancerInfo(v *LoadBalancerInfo) *CreateDeploymentGroupInput {
	s.LoadBalancerInfo = v
	return s
}

// SetOnPremisesInstanceTagFilters sets the OnPremisesInstanceTagFilters field's value.
func (s *CreateDeploymentGroupInput) SetOnPremisesInstanceTagFilters(v []*TagFilter) *CreateDeploymentGroupInput {
	s.OnPremisesInstanceTagFilters = v
	return s
}

// SetOnPremisesTagSet sets the OnPremisesTagSet field's value.
func (s *CreateDeploymentGroupInput) SetOnPremisesTagSet(v *OnPremisesTagSet) *CreateDeploymentGroupInput {
	s.OnPremisesTagSet = v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *CreateDeploymentGroupInput) SetServiceRoleArn(v string) *CreateDeploymentGroupInput {
	s.ServiceRoleArn = &v
	return s
}

// SetTriggerConfigurations sets the TriggerConfigurations field's value.
func (s *CreateDeploymentGroupInput) SetTriggerConfigurations(v []*TriggerConfig) *CreateDeploymentGroupInput {
	s.TriggerConfigurations = v
	return s
}

// Represents the output of a CreateDeploymentGroup operation.
type CreateDeploymentGroupOutput struct {
	_ struct{} `type:"structure"`

	// A unique deployment group ID.
	DeploymentGroupId *string `locationName:"deploymentGroupId" type:"string"`
}

// String returns the string representation
func (s CreateDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentGroupOutput) GoString() string {
	return s.String()
}

// SetDeploymentGroupId sets the DeploymentGroupId field's value.
func (s *CreateDeploymentGroupOutput) SetDeploymentGroupId(v string) *CreateDeploymentGroupOutput {
	s.DeploymentGroupId = &v
	return s
}

// Represents the input of a CreateDeployment operation.
type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Configuration information for an automatic rollback that is added when a
	// deployment is created.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// The name of a deployment configuration associated with the applicable IAM
	// user or AWS account.
	//
	// If not specified, the value configured in the deployment group will be used
	// as the default. If the deployment group does not have a deployment configuration
	// associated with it, then CodeDeployDefault.OneAtATime will be used by default.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The name of the deployment group.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// A comment about the deployment.
	Description *string `locationName:"description" type:"string"`

	// Information about how AWS CodeDeploy handles files that already exist in
	// a deployment target location but weren't part of the previous successful
	// deployment.
	//
	// The fileExistsBehavior parameter takes any of the following values:
	//
	//    * DISALLOW: The deployment fails. This is also the default behavior if
	//    no option is specified.
	//
	//    * OVERWRITE: The version of the file from the application revision currently
	//    being deployed replaces the version already on the instance.
	//
	//    * RETAIN: The version of the file already on the instance is kept and
	//    used as part of the new deployment.
	FileExistsBehavior *string `locationName:"fileExistsBehavior" type:"string" enum:"FileExistsBehavior"`

	// If set to true, then if the deployment causes the ApplicationStop deployment
	// lifecycle event to an instance to fail, the deployment to that instance will
	// not be considered to have failed at that point and will continue on to the
	// BeforeInstall deployment lifecycle event.
	//
	// If set to false or not specified, then if the deployment causes the ApplicationStop
	// deployment lifecycle event to fail to an instance, the deployment to that
	// instance will stop, and the deployment to that instance will be considered
	// to have failed.
	IgnoreApplicationStopFailures *bool `locationName:"ignoreApplicationStopFailures" type:"boolean"`

	// The type and location of the revision to deploy.
	Revision *RevisionLocation `locationName:"revision" type:"structure"`

	// Information about the instances that will belong to the replacement environment
	// in a blue/green deployment.
	TargetInstances *TargetInstances `locationName:"targetInstances" type:"structure"`

	// Indicates whether to deploy to all instances or only to instances that are
	// not running the latest application revision.
	UpdateOutdatedInstancesOnly *bool `locationName:"updateOutdatedInstancesOnly" type:"boolean"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateDeploymentInput) SetApplicationName(v string) *CreateDeploymentInput {
	s.ApplicationName = &v
	return s
}

// SetAutoRollbackConfiguration sets the AutoRollbackConfiguration field's value.
func (s *CreateDeploymentInput) SetAutoRollbackConfiguration(v *AutoRollbackConfiguration) *CreateDeploymentInput {
	s.AutoRollbackConfiguration = v
	return s
}

// SetDeploymentConfigName sets the DeploymentConfigName field's value.
func (s *CreateDeploymentInput) SetDeploymentConfigName(v string) *CreateDeploymentInput {
	s.DeploymentConfigName = &v
	return s
}

// SetDeploymentGroupName sets the DeploymentGroupName field's value.
func (s *CreateDeploymentInput) SetDeploymentGroupName(v string) *CreateDeploymentInput {
	s.DeploymentGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDeploymentInput) SetDescription(v string) *CreateDeploymentInput {
	s.Description = &v
	return s
}

// SetFileExistsBehavior sets the FileExistsBehavior field's value.
func (s *CreateDeploymentInput) SetFileExistsBehavior(v string) *CreateDeploymentInput {
	s.FileExistsBehavior = &v
	return s
}

// SetIgnoreApplicationStopFailures sets the IgnoreApplicationStopFailures field's value.
func (s *CreateDeploymentInput) SetIgnoreApplicationStopFailures(v bool) *CreateDeploymentInput {
	s.IgnoreApplicationStopFailures = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *CreateDeploymentInput) SetRevision(v *RevisionLocation) *CreateDeploymentInput {
	s.Revision = v
	return s
}

// SetTargetInstances sets the TargetInstances field's value.
func (s *CreateDeploymentInput) SetTargetInstances(v *TargetInstances) *CreateDeploymentInput {
	s.TargetInstances = v
	return s
}

// SetUpdateOutdatedInstancesOnly sets the UpdateOutdatedInstancesOnly field's value.
func (s *CreateDeploymentInput) SetUpdateOutdatedInstancesOnly(v bool) *CreateDeploymentInput {
	s.UpdateOutdatedInstancesOnly = &v
	return s
}

// Represents the output of a CreateDeployment operation.
type CreateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// A unique deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`
}

// String returns the string representation
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentOutput) SetDeploymentId(v string) *CreateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// Represents the input of a DeleteApplication operation.
type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationInput) SetApplicationName(v string) *DeleteApplicationInput {
	s.ApplicationName = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteDeploymentConfig operation.
type DeleteDeploymentConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of a deployment configuration associated with the applicable IAM
	// user or AWS account.
	//
	// DeploymentConfigName is a required field
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeploymentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeploymentConfigInput"}
	if s.DeploymentConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentConfigName"))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentConfigName sets the DeploymentConfigName field's value.
func (s *DeleteDeploymentConfigInput) SetDeploymentConfigName(v string) *DeleteDeploymentConfigInput {
	s.DeploymentConfigName = &v
	return s
}

type DeleteDeploymentConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentConfigOutput) GoString() string {
	return s.String()
}

// Represents the input of a DeleteDeploymentGroup operation.
type DeleteDeploymentGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The name of an existing deployment group for the specified application.
	//
	// DeploymentGroupName is a required field
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeploymentGroupInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentGroupName"))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteDeploymentGroupInput) SetApplicationName(v string) *DeleteDeploymentGroupInput {
	s.ApplicationName = &v
	return s
}

// SetDeploymentGroupName sets the DeploymentGroupName field's value.
func (s *DeleteDeploymentGroupInput) SetDeploymentGroupName(v string) *DeleteDeploymentGroupInput {
	s.DeploymentGroupName = &v
	return s
}

// Represents the output of a DeleteDeploymentGroup operation.
type DeleteDeploymentGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the output contains no data, and the corresponding deployment group contained
	// at least one Auto Scaling group, AWS CodeDeploy successfully removed all
	// corresponding Auto Scaling lifecycle event hooks from the Amazon EC2 instances
	// in the Auto Scaling group. If the output contains data, AWS CodeDeploy could
	// not remove some Auto Scaling lifecycle event hooks from the Amazon EC2 instances
	// in the Auto Scaling group.
	HooksNotCleanedUp []*AutoScalingGroup `locationName:"hooksNotCleanedUp" type:"list"`
}

// String returns the string representation
func (s DeleteDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentGroupOutput) GoString() string {
	return s.String()
}

// SetHooksNotCleanedUp sets the HooksNotCleanedUp field's value.
func (s *DeleteDeploymentGroupOutput) SetHooksNotCleanedUp(v []*AutoScalingGroup) *DeleteDeploymentGroupOutput {
	s.HooksNotCleanedUp = v
	return s
}

// Represents the input of a DeleteGitHubAccount operation.
type DeleteGitHubAccountTokenInput struct {
	_ struct{} `type:"structure"`

	// The name of the GitHub account connection to delete.
	TokenName *string `locationName:"tokenName" type:"string"`
}

// String returns the string representation
func (s DeleteGitHubAccountTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGitHubAccountTokenInput) GoString() string {
	return s.String()
}

// SetTokenName sets the TokenName field's value.
func (s *DeleteGitHubAccountTokenInput) SetTokenName(v string) *DeleteGitHubAccountTokenInput {
	s.TokenName = &v
	return s
}

// Represents the output of a DeleteGitHubAccountToken operation.
type DeleteGitHubAccountTokenOutput struct {
	_ struct{} `type:"structure"`

	// The name of the GitHub account connection that was deleted.
	TokenName *string `locationName:"tokenName" type:"string"`
}

// String returns the string representation
func (s DeleteGitHubAccountTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGitHubAccountTokenOutput) GoString() string {
	return s.String()
}

// SetTokenName sets the TokenName field's value.
func (s *DeleteGitHubAccountTokenOutput) SetTokenName(v string) *DeleteGitHubAccountTokenOutput {
	s.TokenName = &v
	return s
}

// Information about a deployment configuration.
type DeploymentConfigInfo struct {
	_ struct{} `type:"structure"`

	// The destination platform type for the deployment (Lambda or Server).
	ComputePlatform *string `locationName:"computePlatform" type:"string" enum:"ComputePlatform"`

	// The time at which the deployment configuration was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment configuration ID.
	DeploymentConfigId *string `locationName:"deploymentConfigId" type:"string"`

	// The deployment configuration name.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// Information about the number or percentage of minimum healthy instance.
	MinimumHealthyHosts *MinimumHealthyHosts `locationName:"minimumHealthyHosts" type:"structure"`

	// The configuration specifying how the deployment traffic will be routed. Only
	// deployments with a Lambda compute platform can specify this.
	TrafficRoutingConfig *TrafficRoutingConfig `locationName:"trafficRoutingConfig" type:"structure"`
}

// String returns the string representation
func (s DeploymentConfigInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentConfigInfo) GoString() string {
	return s.String()
}

// SetComputePlatform sets the ComputePlatform field's value.
func (s *DeploymentConfigInfo) SetComputePlatform(v string) *DeploymentConfigInfo {
	s.ComputePlatform = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DeploymentConfigInfo) SetCreateTime(v time.Time) *DeploymentConfigInfo {
	s.CreateTime = &v
	return s
}

// SetDeploymentConfigId sets the DeploymentConfigId field's value.
func (s *DeploymentConfigInfo) SetDeploymentConfigId(v string) *DeploymentConfigInfo {
	s.DeploymentConfigId = &v
	return s
}

// SetDeploymentConfigName sets the DeploymentConfigName field's value.
func (s *DeploymentConfigInfo) SetDeploymentConfigName(v string) *DeploymentConfigInfo {
	s.DeploymentConfigName = &v
	return s
}

// SetMinimumHealthyHosts sets the MinimumHealthyHosts field's value.
func (s *DeploymentConfigInfo) SetMinimumHealthyHosts(v *MinimumHealthyHosts) *DeploymentConfigInfo {
	s.MinimumHealthyHosts = v
	return s
}

// SetTrafficRoutingConfig sets the TrafficRoutingConfig field's value.
func (s *DeploymentConfigInfo) SetTrafficRoutingConfig(v *TrafficRoutingConfig) *DeploymentConfigInfo {
	s.TrafficRoutingConfig = v
	return s
}

// Information about a deployment group.
type DeploymentGroupInfo struct {
	_ struct{} `type:"structure"`

	// A list of alarms associated with the deployment group.
	AlarmConfiguration *AlarmConfiguration `locationName:"alarmConfiguration" type:"structure"`

	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Information about the automatic rollback configuration associated with the
	// deployment group.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// A list of associated Auto Scaling groups.
	AutoScalingGroups []*AutoScalingGroup `locationName:"autoScalingGroups" type:"list"`

	// Information about blue/green deployment options for a deployment group.
	BlueGreenDeploymentConfiguration *BlueGreenDeploymentConfiguration `locationName:"blueGreenDeploymentConfiguration" type:"structure"`

	// The destination platform type for the deployment group (Lambda or Server).
	ComputePlatform *string `locationName:"computePlatform" type:"string" enum:"ComputePlatform"`

	// The deployment configuration name.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The deployment group ID.
	DeploymentGroupId *string `locationName:"deploymentGroupId" type:"string"`

	// The deployment group name.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// Information about the type of deployment, either in-place or blue/green,
	// you want to run and whether to route deployment traffic behind a load balancer.
	DeploymentStyle *DeploymentStyle `locationName:"deploymentStyle" type:"structure"`

	// The Amazon EC2 tags on which to filter. The deployment group includes EC2
	// instances with any of the specified tags.
	Ec2TagFilters []*EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// Information about groups of tags applied to an EC2 instance. The deployment
	// group includes only EC2 instances identified by all the tag groups. Cannot
	// be used in the same call as ec2TagFilters.
	Ec2TagSet *EC2TagSet `locationName:"ec2TagSet" type:"structure"`

	// Information about the most recent attempted deployment to the deployment
	// group.
	LastAttemptedDeployment *LastDeploymentInfo `locationName:"lastAttemptedDeployment" type:"structure"`

	// Information about the most recent successful deployment to the deployment
	// group.
	LastSuccessfulDeployment *LastDeploymentInfo `locationName:"lastSuccessfulDeployment" type:"structure"`

	// Information about the load balancer to use in a deployment.
	LoadBalancerInfo *LoadBalancerInfo `locationName:"loadBalancerInfo" type:"structure"`

	// The on-premises instance tags on which to filter. The deployment group includes
	// on-premises instances with any of the specified tags.
	OnPremisesInstanceTagFilters []*TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// Information about groups of tags applied to an on-premises instance. The
	// deployment group includes only on-premises instances identified by all the
	// tag groups. Cannot be used in the same call as onPremisesInstanceTagFilters.
	OnPremisesTagSet *OnPremisesTagSet `locationName:"onPremisesTagSet" type:"structure"`

	// A service role ARN.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// Information about the deployment group's target revision, including type
	// and location.
	TargetRevision *RevisionLocation `locationName:"targetRevision" type:"structure"`

	// Information about triggers associated with the deployment group.
	TriggerConfigurations []*TriggerConfig `locationName:"triggerConfigurations" type:"list"`
}

// String returns the string representation
func (s DeploymentGroupInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentGroupInfo) GoString() string {
	return s.String()
}

// SetAlarmConfiguration sets the AlarmConfiguration field's value.
func (s *DeploymentGroupInfo) SetAlarmConfiguration(v *AlarmConfiguration) *DeploymentGroupInfo {
	s.AlarmConfiguration = v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeploymentGroupInfo) SetApplicationName(v string) *DeploymentGroupInfo {
	s.ApplicationName = &v
	return s
}

// SetAutoRollbackConfiguration sets the AutoRollbackConfiguration field's value.
func (s *DeploymentGroupInfo) SetAutoRollbackConfiguration(v *AutoRollbackConfiguration) *DeploymentGroupInfo {
	s.AutoRollbackConfiguration = v
	return s
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *DeploymentGroupInfo) SetAutoScalingGroups(v []*AutoScalingGroup) *DeploymentGroupInfo {
	s.AutoScalingGroups = v
	return s
}

// SetBlueGreenDeploymentConfiguration sets the BlueGreenDeploymentConfiguration field's value.
func (s *DeploymentGroupInfo) SetBlueGreenDeploymentConfiguration(v *BlueGreenDeploymentConfiguration) *DeploymentGroupInfo {
	s.BlueGreenDeploymentConfiguration = v
	return s
}

// SetComputePlatform sets the ComputePlatform field's value.
func (s *DeploymentGroupInfo) SetComputePlatform(v string) *DeploymentGroupInfo {
	s.ComputePlatform = &v
	return s
}

// SetDeploymentConfigName sets the DeploymentConfigName field's value.
func (s *DeploymentGroupInfo) SetDeploymentConfigName(v string) *DeploymentGroupInfo {
	s.DeploymentConfigName = &v
	return s
}

// SetDeploymentGroupId sets the DeploymentGroupId field's value.
func (s *DeploymentGroupInfo) SetDeploymentGroupId(v string) *DeploymentGroupInfo {
	s.DeploymentGroupId = &v
	return s
}

// SetDeploymentGroupName sets the DeploymentGroupName field's value.
func (s *DeploymentGroupInfo) SetDeploymentGroupName(v string) *DeploymentGroupInfo {
	s.DeploymentGroupName = &v
	return s
}

// SetDeploymentStyle sets the DeploymentStyle field's value.
func (s *DeploymentGroupInfo) SetDeploymentStyle(v *DeploymentStyle) *DeploymentGroupInfo {
	s.DeploymentStyle = v
	return s
}

// SetEc2TagFilters sets the Ec2TagFilters field's value.
func (s *DeploymentGroupInfo) SetEc2TagFilters(v []*EC2TagFilter) *DeploymentGroupInfo {
	s.Ec2TagFilters = v
	return s
}

// SetEc2TagSet sets the Ec2TagSet field's value.
func (s *DeploymentGroupInfo) SetEc2TagSet(v *EC2TagSet) *DeploymentGroupInfo {
	s.Ec2TagSet = v
	return s
}

// SetLastAttemptedDeployment sets the LastAttemptedDeployment field's value.
func (s *DeploymentGroupInfo) SetLastAttemptedDeployment(v *LastDeploymentInfo) *DeploymentGroupInfo {
	s.LastAttemptedDeployment = v
	return s
}

// SetLastSuccessfulDeployment sets the LastSuccessfulDeployment field's value.
func (s *DeploymentGroupInfo) SetLastSuccessfulDeployment(v *LastDeploymentInfo) *DeploymentGroupInfo {
	s.LastSuccessfulDeployment = v
	return s
}

// SetLoadBalancerInfo sets the LoadBalancerInfo field's value.
func (s *DeploymentGroupInfo) SetLoadBalancerInfo(v *LoadBalancerInfo) *DeploymentGroupInfo {
	s.LoadBalancerInfo = v
	return s
}

// SetOnPremisesInstanceTagFilters sets the OnPremisesInstanceTagFilters field's value.
func (s *DeploymentGroupInfo) SetOnPremisesInstanceTagFilters(v []*TagFilter) *DeploymentGroupInfo {
	s.OnPremisesInstanceTagFilters = v
	return s
}

// SetOnPremisesTagSet sets the OnPremisesTagSet field's value.
func (s *DeploymentGroupInfo) SetOnPremisesTagSet(v *OnPremisesTagSet) *DeploymentGroupInfo {
	s.OnPremisesTagSet = v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *DeploymentGroupInfo) SetServiceRoleArn(v string) *DeploymentGroupInfo {
	s.ServiceRoleArn = &v
	return s
}

// SetTargetRevision sets the TargetRevision field's value.
func (s *DeploymentGroupInfo) SetTargetRevision(v *RevisionLocation) *DeploymentGroupInfo {
	s.TargetRevision = v
	return s
}

// SetTriggerConfigurations sets the TriggerConfigurations field's value.
func (s *DeploymentGroupInfo) SetTriggerConfigurations(v []*TriggerConfig) *DeploymentGroupInfo {
	s.TriggerConfigurations = v
	return s
}

// Information about a deployment.
type DeploymentInfo struct {
	_ struct{} `type:"structure"`

	// Provides information about the results of a deployment, such as whether instances
	// in the original environment in a blue/green deployment were not terminated.
	AdditionalDeploymentStatusInfo *string `locationName:"additionalDeploymentStatusInfo" deprecated:"true" type:"string"`

	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Information about the automatic rollback configuration associated with the
	// deployment.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// Information about blue/green deployment options for this deployment.
	BlueGreenDeploymentConfiguration *BlueGreenDeploymentConfiguration `locationName:"blueGreenDeploymentConfiguration" type:"structure"`

	// A timestamp indicating when the deployment was complete.
	CompleteTime *time.Time `locationName:"completeTime" type:"timestamp" timestampFormat:"unix"`

	// The destination platform type for the deployment (Lambda or Server).
	ComputePlatform *string `locationName:"computePlatform" type:"string" enum:"ComputePlatform"`

	// A timestamp indicating when the deployment was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// The means by which the deployment was created:
	//
	//    * user: A user created the deployment.
	//
	//    * autoscaling: Auto Scaling created the deployment.
	//
	//    * codeDeployRollback: A rollback process created the deployment.
	Creator *string `locationName:"creator" type:"string" enum:"DeploymentCreator"`

	// The deployment configuration name.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The deployment group name.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// The deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A summary of the deployment status of the instances in the deployment.
	DeploymentOverview *DeploymentOverview `locationName:"deploymentOverview" type:"structure"`

	// Messages that contain information about the status of a deployment.
	DeploymentStatusMessages []*string `locationName:"deploymentStatusMessages" type:"list"`

	// Information about the type of deployment, either in-place or blue/green,
	// you want to run and whether to route deployment traffic behind a load balancer.
	DeploymentStyle *DeploymentStyle `locationName:"deploymentStyle" type:"structure"`

	// A comment about the deployment.
	Description *string `locationName:"description" type:"string"`

	// Information about any error associated with this deployment.
	ErrorInformation *ErrorInformation `locationName:"errorInformation" type:"structure"`

	// Information about how AWS CodeDeploy handles files that already exist in
	// a deployment target location but weren't part of the previous successful
	// deployment.
	//
	//    * DISALLOW: The deployment fails. This is also the default behavior if
	//    no option is specified.
	//
	//    * OVERWRITE: The version of the file from the application revision currently
	//    being deployed replaces the version already on the instance.
	//
	//    * RETAIN: The version of the file already on the instance is kept and
	//    used as part of the new deployment.
	FileExistsBehavior *string `locationName:"fileExistsBehavior" type:"string" enum:"FileExistsBehavior"`

	// If true, then if the deployment causes the ApplicationStop deployment lifecycle
	// event to an instance to fail, the deployment to that instance will not be
	// considered to have failed at that point and will continue on to the BeforeInstall
	// deployment lifecycle event.
	//
	// If false or not specified, then if the deployment causes the ApplicationStop
	// deployment lifecycle event to an instance to fail, the deployment to that
	// instance will stop, and the deployment to that instance will be considered
	// to have failed.
	IgnoreApplicationStopFailures *bool `locationName:"ignoreApplicationStopFailures" type:"boolean"`

	// Indicates whether the wait period set for the termination of instances in
	// the original environment has started. Status is 'false' if the KEEP_ALIVE
	// option is specified; otherwise, 'true' as soon as the termination wait period
	// starts.
	InstanceTerminationWaitTimeStarted *bool `locationName:"instanceTerminationWaitTimeStarted" type:"boolean"`

	// Information about the load balancer used in the deployment.
	LoadBalancerInfo *LoadBalancerInfo `locationName:"loadBalancerInfo" type:"structure"`

	// Information about the application revision that was deployed to the deployment
	// group before the most recent successful deployment.
	PreviousRevision *RevisionLocation `locationName:"previousRevision" type:"structure"`

	// Information about the location of stored application artifacts and the service
	// from which to retrieve them.
	Revision *RevisionLocation `locationName:"revision" type:"structure"`

	// Information about a deployment rollback.
	RollbackInfo *RollbackInfo `locationName:"rollbackInfo" type:"structure"`

	// A timestamp indicating when the deployment was deployed to the deployment
	// group.
	//
	// In some cases, the reported value of the start time may be later than the
	// complete time. This is due to differences in the clock settings of back-end
	// servers that participate in the deployment process.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// The current state of the deployment as a whole.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`

	// Information about the instances that belong to the replacement environment
	// in a blue/green deployment.
	TargetInstances *TargetInstances `locationName:"targetInstances" type:"structure"`

	// Indicates whether only instances that are not running the latest application
	// revision are to be deployed to.
	UpdateOutdatedInstancesOnly *bool `locationName:"updateOutdatedInstancesOnly" type:"boolean"`
}

// String returns the string representation
func (s DeploymentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentInfo) GoString() string {
	return s.String()
}

// SetAdditionalDeploymentStatusInfo sets the AdditionalDeploymentStatusInfo field's value.
func (s *DeploymentInfo) SetAdditionalDeploymentStatusInfo(v string) *DeploymentInfo {
	s.AdditionalDeploymentStatusInfo = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeploymentInfo) SetApplicationName(v string) *DeploymentInfo {
	s.ApplicationName = &v
	return s
}

// SetAutoRollbackConfiguration sets the AutoRollbackConfiguration field's value.
func (s *DeploymentInfo) SetAutoRollbackConfiguration(v *AutoRollbackConfiguration) *DeploymentInfo {
	s.AutoRollbackConfiguration = v
	return s
}

// SetBlueGreenDeploymentConfiguration sets the BlueGreenDeploymentConfiguration field's value.
func (s *DeploymentInfo) SetBlueGreenDeploymentConfiguration(v *BlueGreenDeploymentConfiguration) *DeploymentInfo {
	s.BlueGreenDeploymentConfiguration = v
	return s
}

// SetCompleteTime sets the CompleteTime field's value.
func (s *DeploymentInfo) SetCompleteTime(v time.Time) *DeploymentInfo {
	s.CompleteTime = &v
	return s
}

// SetComputePlatform sets the ComputePlatform field's value.
func (s *DeploymentInfo) SetComputePlatform(v string) *DeploymentInfo {
	s.ComputePlatform = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DeploymentInfo) SetCreateTime(v time.Time) *DeploymentInfo {
	s.CreateTime = &v
	return s
}

// SetCreator sets the Creator field's value.
func (s *DeploymentInfo) SetCreator(v string) *DeploymentInfo {
	s.Creator = &v
	return s
}

// SetDeploymentConfigName sets the DeploymentConfigName field's value.
func (s *DeploymentInfo) SetDeploymentConfigName(v string) *DeploymentInfo {
	s.DeploymentConfigName = &v
	return s
}

// SetDeploymentGroupName sets the DeploymentGroupName field's value.
func (s *DeploymentInfo) SetDeploymentGroupName(v string) *DeploymentInfo {
	s.DeploymentGroupName = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *DeploymentInfo) SetDeploymentId(v string) *DeploymentInfo {
	s.DeploymentId = &v
	return s
}

// SetDeploymentOverview sets the DeploymentOverview field's value.
func (s *DeploymentInfo) SetDeploymentOverview(v *DeploymentOverview) *DeploymentInfo {
	s.DeploymentOverview = v
	return s
}

// SetDeploymentStatusMessages sets the DeploymentStatusMessages field's value.
func (s *DeploymentInfo) SetDeploymentStatusMessages(v []*string) *DeploymentInfo {
	s.DeploymentStatusMessages = v
	return s
}

// SetDeploymentStyle sets the DeploymentStyle field's value.
func (s *DeploymentInfo) SetDeploymentStyle(v *DeploymentStyle) *DeploymentInfo {
	s.DeploymentStyle = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DeploymentInfo) SetDescription(v string) *DeploymentInfo {
	s.Description = &v
	return s
}

// SetErrorInformation sets the ErrorInformation field's value.
func (s *DeploymentInfo) SetErrorInformation(v *ErrorInformation) *DeploymentInfo {
	s.ErrorInformation = v
	return s
}

// SetFileExistsBehavior sets the FileExistsBehavior field's value.
func (s *DeploymentInfo) SetFileExistsBehavior(v string) *DeploymentInfo {
	s.FileExistsBehavior = &v
	return s
}

// SetIgnoreApplicationStopFailures sets the IgnoreApplicationStopFailures field's value.
func (s *DeploymentInfo) SetIgnoreApplicationStopFailures(v bool) *DeploymentInfo {
	s.IgnoreApplicationStopFailures = &v
	return s
}

// SetInstanceTerminationWaitTimeStarted sets the InstanceTerminationWaitTimeStarted field's value.
func (s *DeploymentInfo) SetInstanceTerminationWaitTimeStarted(v bool) *DeploymentInfo {
	s.InstanceTerminationWaitTimeStarted = &v
	return s
}

// SetLoadBalancerInfo sets the LoadBalancerInfo field's value.
func (s *DeploymentInfo) SetLoadBalancerInfo(v *LoadBalancerInfo) *DeploymentInfo {
	s.LoadBalancerInfo = v
	return s
}

// SetPreviousRevision sets the PreviousRevision field's value.
func (s *DeploymentInfo) SetPreviousRevision(v *RevisionLocation) *DeploymentInfo {
	s.PreviousRevision = v
	return s
}

// SetRevision sets the Revision field's value.
func (s *DeploymentInfo) SetRevision(v *RevisionLocation) *DeploymentInfo {
	s.Revision = v
	return s
}

// SetRollbackInfo sets the RollbackInfo field's value.
func (s *DeploymentInfo) SetRollbackInfo(v *RollbackInfo) *DeploymentInfo {
	s.RollbackInfo = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DeploymentInfo) SetStartTime(v time.Time) *DeploymentInfo {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeploymentInfo) SetStatus(v string) *DeploymentInfo {
	s.Status = &v
	return s
}

// SetTargetInstances sets the TargetInstances field's value.
func (s *DeploymentInfo) SetTargetInstances(v *TargetInstances) *DeploymentInfo {
	s.TargetInstances = v
	return s
}

// SetUpdateOutdatedInstancesOnly sets the UpdateOutdatedInstancesOnly field's value.
func (s *DeploymentInfo) SetUpdateOutdatedInstancesOnly(v bool) *DeploymentInfo {
	s.UpdateOutdatedInstancesOnly = &v
	return s
}

// Information about the deployment status of the instances in the deployment.
type DeploymentOverview struct {
	_ struct{} `type:"structure"`

	// The number of instances in the deployment in a failed state.
	Failed *int64 `type:"long"`

	// The number of instances in which the deployment is in progress.
	InProgress *int64 `type:"long"`

	// The number of instances in the deployment in a pending state.
	Pending *int64 `type:"long"`

	// The number of instances in a replacement environment ready to receive traffic
	// in a blue/green deployment.
	Ready *int64 `type:"long"`

	// The number of instances in the deployment in a skipped state.
	Skipped *int64 `type:"long"`

	// The number of instances in the deployment to which revisions have been successfully
	// deployed.
	Succeeded *int64 `type:"long"`
}

// String returns the string representation
func (s DeploymentOverview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentOverview) GoString() string {
	return s.String()
}

// SetFailed sets the Failed field's value.
func (s *DeploymentOverview) SetFailed(v int64) *DeploymentOverview {
	s.Failed = &v
	return s
}

// SetInProgress sets the InProgress field's value.
func (s *DeploymentOverview) SetInProgress(v int64) *DeploymentOverview {
	s.InProgress = &v
	return s
}

// SetPending sets the Pending field's value.
func (s *DeploymentOverview) SetPending(v int64) *DeploymentOverview {
	s.Pending = &v
	return s
}

// SetReady sets the Ready field's value.
func (s *DeploymentOverview) SetReady(v int64) *DeploymentOverview {
	s.Ready = &v
	return s
}

// SetSkipped sets the Skipped field's value.
func (s *DeploymentOverview) SetSkipped(v int64) *DeploymentOverview {
	s.Skipped = &v
	return s
}

// SetSucceeded sets the Succeeded field's value.
func (s *DeploymentOverview) SetSucceeded(v int64) *DeploymentOverview {
	s.Succeeded = &v
	return s
}

// Information about how traffic is rerouted to instances in a replacement environment
// in a blue/green deployment.
type DeploymentReadyOption struct {
	_ struct{} `type:"structure"`

	// Information about when to reroute traffic from an original environment to
	// a replacement environment in a blue/green deployment.
	//
	//    * CONTINUE_DEPLOYMENT: Register new instances with the load balancer immediately
	//    after the new application revision is installed on the instances in the
	//    replacement environment.
	//
	//    * STOP_DEPLOYMENT: Do not register new instances with load balancer unless
	//    traffic is rerouted manually. If traffic is not rerouted manually before
	//    the end of the specified wait period, the deployment status is changed
	//    to Stopped.
	ActionOnTimeout *string `locationName:"actionOnTimeout" type:"string" enum:"DeploymentReadyAction"`

	// The number of minutes to wait before the status of a blue/green deployment
	// changed to Stopped if rerouting is not started manually. Applies only to
	// the STOP_DEPLOYMENT option for actionOnTimeout
	WaitTimeInMinutes *int64 `locationName:"waitTimeInMinutes" type:"integer"`
}

// String returns the string representation
func (s DeploymentReadyOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentReadyOption) GoString() string {
	return s.String()
}

// SetActionOnTimeout sets the ActionOnTimeout field's value.
func (s *DeploymentReadyOption) SetActionOnTimeout(v string) *DeploymentReadyOption {
	s.ActionOnTimeout = &v
	return s
}

// SetWaitTimeInMinutes sets the WaitTimeInMinutes field's value.
func (s *DeploymentReadyOption) SetWaitTimeInMinutes(v int64) *DeploymentReadyOption {
	s.WaitTimeInMinutes = &v
	return s
}

// Information about the type of deployment, either in-place or blue/green,
// you want to run and whether to route deployment traffic behind a load balancer.
type DeploymentStyle struct {
	_ struct{} `type:"structure"`

	// Indicates whether to route deployment traffic behind a load balancer.
	DeploymentOption *string `locationName:"deploymentOption" type:"string" enum:"DeploymentOption"`

	// Indicates whether to run an in-place deployment or a blue/green deployment.
	DeploymentType *string `locationName:"deploymentType" type:"string" enum:"DeploymentType"`
}

// String returns the string representation
func (s DeploymentStyle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentStyle) GoString() string {
	return s.String()
}

// SetDeploymentOption sets the DeploymentOption field's value.
func (s *DeploymentStyle) SetDeploymentOption(v string) *DeploymentStyle {
	s.DeploymentOption = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *DeploymentStyle) SetDeploymentType(v string) *DeploymentStyle {
	s.DeploymentType = &v
	return s
}

// Represents the input of a DeregisterOnPremisesInstance operation.
type DeregisterOnPremisesInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the on-premises instance to deregister.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterOnPremisesInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterOnPremisesInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterOnPremisesInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *DeregisterOnPremisesInstanceInput) SetInstanceName(v string) *DeregisterOnPremisesInstanceInput {
	s.InstanceName = &v
	return s
}

type DeregisterOnPremisesInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterOnPremisesInstanceOutput) GoString() string {
	return s.String()
}

// Diagnostic information about executable scripts that are part of a deployment.
type Diagnostics struct {
	_ struct{} `type:"structure"`

	// The associated error code:
	//
	//    * Success: The specified script ran.
	//
	//    * ScriptMissing: The specified script was not found in the specified location.
	//
	//    * ScriptNotExecutable: The specified script is not a recognized executable
	//    file type.
	//
	//    * ScriptTimedOut: The specified script did not finish running in the specified
	//    time period.
	//
	//    * ScriptFailed: The specified script failed to run as expected.
	//
	//    * UnknownError: The specified script did not run for an unknown reason.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"LifecycleErrorCode"`

	// The last portion of the diagnostic log.
	//
	// If available, AWS CodeDeploy returns up to the last 4 KB of the diagnostic
	// log.
	LogTail *string `locationName:"logTail" type:"string"`

	// The message associated with the error.
	Message *string `locationName:"message" type:"string"`

	// The name of the script.
	ScriptName *string `locationName:"scriptName" type:"string"`
}

// String returns the string representation
func (s Diagnostics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Diagnostics) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Diagnostics) SetErrorCode(v string) *Diagnostics {
	s.ErrorCode = &v
	return s
}

// SetLogTail sets the LogTail field's value.
func (s *Diagnostics) SetLogTail(v string) *Diagnostics {
	s.LogTail = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Diagnostics) SetMessage(v string) *Diagnostics {
	s.Message = &v
	return s
}

// SetScriptName sets the ScriptName field's value.
func (s *Diagnostics) SetScriptName(v string) *Diagnostics {
	s.ScriptName = &v
	return s
}

// Information about an EC2 tag filter.
type EC2TagFilter struct {
	_ struct{} `type:"structure"`

	// The tag filter key.
	Key *string `type:"string"`

	// The tag filter type:
	//
	//    * KEY_ONLY: Key only.
	//
	//    * VALUE_ONLY: Value only.
	//
	//    * KEY_AND_VALUE: Key and value.
	Type *string `type:"string" enum:"EC2TagFilterType"`

	// The tag filter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s EC2TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2TagFilter) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *EC2TagFilter) SetKey(v string) *EC2TagFilter {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *EC2TagFilter) SetType(v string) *EC2TagFilter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EC2TagFilter) SetValue(v string) *EC2TagFilter {
	s.Value = &v
	return s
}

// Information about groups of EC2 instance tags.
type EC2TagSet struct {
	_ struct{} `type:"structure"`

	// A list containing other lists of EC2 instance tag groups. In order for an
	// instance to be included in the deployment group, it must be identified by
	// all the tag groups in the list.
	Ec2TagSetList [][]*EC2TagFilter `locationName:"ec2TagSetList" type:"list"`
}

// String returns the string representation
func (s EC2TagSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2TagSet) GoString() string {
	return s.String()
}

// SetEc2TagSetList sets the Ec2TagSetList field's value.
func (s *EC2TagSet) SetEc2TagSetList(v [][]*EC2TagFilter) *EC2TagSet {
	s.Ec2TagSetList = v
	return s
}

// Information about a load balancer in Elastic Load Balancing to use in a deployment.
// Instances are registered directly with a load balancer, and traffic is routed
// to the load balancer.
type ELBInfo struct {
	_ struct{} `type:"structure"`

	// For blue/green deployments, the name of the load balancer that will be used
	// to route traffic from original instances to replacement instances in a blue/green
	// deployment. For in-place deployments, the name of the load balancer that
	// instances are deregistered from so they are not serving traffic during a
	// deployment, and then re-registered with after the deployment completes.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s ELBInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ELBInfo) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ELBInfo) SetName(v string) *ELBInfo {
	s.Name = &v
	return s
}

// Information about a deployment error.
type ErrorInformation struct {
	_ struct{} `type:"structure"`

	// For information about additional error codes, see Error Codes for AWS CodeDeploy
	// (http://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html)
	// in the AWS CodeDeploy User Guide (http://docs.aws.amazon.com/codedeploy/latest/userguide).
	//
	// The error code:
	//
	//    * APPLICATION_MISSING: The application was missing. This error code will
	//    most likely be raised if the application is deleted after the deployment
	//    is created but before it is started.
	//
	//    * DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error
	//    code will most likely be raised if the deployment group is deleted after
	//    the deployment is created but before it is started.
	//
	//    * HEALTH_CONSTRAINTS: The deployment failed on too many instances to be
	//    successfully deployed within the instance health constraints specified.
	//
	//    * HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed
	//    within the instance health constraints specified.
	//
	//    * IAM_ROLE_MISSING: The service role cannot be accessed.
	//
	//    * IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
	//
	//    * INTERNAL_ERROR: There was an internal error.
	//
	//    * NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon
	//    EC2 service.
	//
	//    * NO_INSTANCES: No instance were specified, or no instance can be found.
	//
	//    * OVER_MAX_INSTANCES: The maximum number of instance was exceeded.
	//
	//    * THROTTLED: The operation was throttled because the calling account exceeded
	//    the throttling limits of one or more AWS services.
	//
	//    * TIMEOUT: The deployment has timed out.
	//
	//    * REVISION_MISSING: The revision ID was missing. This error code will
	//    most likely be raised if the revision is deleted after the deployment
	//    is created but before it is started.
	Code *string `locationName:"code" type:"string" enum:"ErrorCode"`

	// An accompanying error message.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ErrorInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorInformation) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ErrorInformation) SetCode(v string) *ErrorInformation {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ErrorInformation) SetMessage(v string) *ErrorInformation {
	s.Message = &v
	return s
}

// Information about an application revision.
type GenericRevisionInfo struct {
	_ struct{} `type:"structure"`

	// The deployment groups for which this is the current target revision.
	DeploymentGroups []*string `locationName:"deploymentGroups" type:"list"`

	// A comment about the revision.
	Description *string `locationName:"description" type:"string"`

	// When the revision was first used by AWS CodeDeploy.
	FirstUsedTime *time.Time `locationName:"firstUsedTime" type:"timestamp" timestampFormat:"unix"`

	// When the revision was last used by AWS CodeDeploy.
	LastUsedTime *time.Time `locationName:"lastUsedTime" type:"timestamp" timestampFormat:"unix"`

	// When the revision was registered with AWS CodeDeploy.
	RegisterTime *time.Time `locationName:"registerTime" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s GenericRevisionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenericRevisionInfo) GoString() string {
	return s.String()
}

// SetDeploymentGroups sets the DeploymentGroups field's value.
func (s *GenericRevisionInfo) SetDeploymentGroups(v []*string) *GenericRevisionInfo {
	s.DeploymentGroups = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GenericRevisionInfo) SetDescription(v string) *GenericRevisionInfo {
	s.Description = &v
	return s
}

// SetFirstUsedTime sets the FirstUsedTime field's value.
func (s *GenericRevisionInfo) SetFirstUsedTime(v time.Time) *GenericRevisionInfo {
	s.FirstUsedTime = &v
	return s
}

// SetLastUsedTime sets the LastUsedTime field's value.
func (s *GenericRevisionInfo) SetLastUsedTime(v time.Time) *GenericRevisionInfo {
	s.LastUsedTime = &v
	return s
}

// SetRegisterTime sets the RegisterTime field's value.
func (s *GenericRevisionInfo) SetRegisterTime(v time.Time) *GenericRevisionInfo {
	s.RegisterTime = &v
	return s
}

// Represents the input of a GetApplication operation.
type GetApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *GetApplicationInput) SetApplicationName(v string) *GetApplicationInput {
	s.ApplicationName = &v
	return s
}

// Represents the output of a GetApplication operation.
type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the application.
	Application *ApplicationInfo `locationName:"application" type:"structure"`
}

// String returns the string representation
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetApplication sets the Application field's value.
func (s *GetApplicationOutput) SetApplication(v *ApplicationInfo) *GetApplicationOutput {
	s.Application = v
	return s
}

// Represents the input of a GetApplicationRevision operation.
type GetApplicationRevisionInput struct {
	_ struct{} `type:"structure"`

	// The name of the application that corresponds to the revision.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Information about the application revision to get, including type and location.
	//
	// Revision is a required field
	Revision *RevisionLocation `locationName:"revision" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApplicationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationRevisionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *GetApplicationRevisionInput) SetApplicationName(v string) *GetApplicationRevisionInput {
	s.ApplicationName = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *GetApplicationRevisionInput) SetRevision(v *RevisionLocation) *GetApplicationRevisionInput {
	s.Revision = v
	return s
}

// Represents the output of a GetApplicationRevision operation.
type GetApplicationRevisionOutput struct {
	_ struct{} `type:"structure"`

	// The name of the application that corresponds to the revision.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Additional information about the revision, including type and location.
	Revision *RevisionLocation `locationName:"revision" type:"structure"`

	// General information about the revision.
	RevisionInfo *GenericRevisionInfo `locationName:"revisionInfo" type:"structure"`
}

// String returns the string representation
func (s GetApplicationRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationRevisionOutput) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *GetApplicationRevisionOutput) SetApplicationName(v string) *GetApplicationRevisionOutput {
	s.ApplicationName = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *GetApplicationRevisionOutput) SetRevision(v *RevisionLocation) *GetApplicationRevisionOutput {
	s.Revision = v
	return s
}

// SetRevisionInfo sets the RevisionInfo field's value.
func (s *GetApplicationRevisionOutput) SetRevisionInfo(v *GenericRevisionInfo) *GetApplicationRevisionOutput {
	s.RevisionInfo = v
	return s
}

// Represents the input of a GetDeploymentConfig operation.
type GetDeploymentConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of a deployment configuration associated with the applicable IAM
	// user or AWS account.
	//
	// DeploymentConfigName is a required field
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentConfigInput"}
	if s.DeploymentConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentConfigName"))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentConfigName sets the DeploymentConfigName field's value.
func (s *GetDeploymentConfigInput) SetDeploymentConfigName(v string) *GetDeploymentConfigInput {
	s.DeploymentConfigName = &v
	return s
}

// Represents the output of a GetDeploymentConfig operation.
type GetDeploymentConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployment configuration.
	DeploymentConfigInfo *DeploymentConfigInfo `locationName:"deploymentConfigInfo" type:"structure"`
}

// String returns the string representation
func (s GetDeploymentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentConfigOutput) GoString() string {
	return s.String()
}

// SetDeploymentConfigInfo sets the DeploymentConfigInfo field's value.
func (s *GetDeploymentConfigOutput) SetDeploymentConfigInfo(v *DeploymentConfigInfo) *GetDeploymentConfigOutput {
	s.DeploymentConfigInfo = v
	return s
}

// Represents the input of a GetDeploymentGroup operation.
type GetDeploymentGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The name of an existing deployment group for the specified application.
	//
	// DeploymentGroupName is a required field
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentGroupInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentGroupName"))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *GetDeploymentGroupInput) SetApplicationName(v string) *GetDeploymentGroupInput {
	s.ApplicationName = &v
	return s
}

// SetDeploymentGroupName sets the DeploymentGroupName field's value.
func (s *GetDeploymentGroupInput) SetDeploymentGroupName(v string) *GetDeploymentGroupInput {
	s.DeploymentGroupName = &v
	return s
}

// Represents the output of a GetDeploymentGroup operation.
type GetDeploymentGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployment group.
	DeploymentGroupInfo *DeploymentGroupInfo `locationName:"deploymentGroupInfo" type:"structure"`
}

// String returns the string representation
func (s GetDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentGroupOutput) GoString() string {
	return s.String()
}

// SetDeploymentGroupInfo sets the DeploymentGroupInfo field's value.
func (s *GetDeploymentGroupOutput) SetDeploymentGroupInfo(v *DeploymentGroupInfo) *GetDeploymentGroupOutput {
	s.DeploymentGroupInfo = v
	return s
}

// Represents the input of a GetDeployment operation.
type GetDeploymentInput struct {
	_ struct{} `type:"structure"`

	// A deployment ID associated with the applicable IAM user or AWS account.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentInput) SetDeploymentId(v string) *GetDeploymentInput {
	s.DeploymentId = &v
	return s
}

// Represents the input of a GetDeploymentInstance operation.
type GetDeploymentInstanceInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The unique ID of an instance in the deployment group.
	//
	// InstanceId is a required field
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInstanceInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentInstanceInput) SetDeploymentId(v string) *GetDeploymentInstanceInput {
	s.DeploymentId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetDeploymentInstanceInput) SetInstanceId(v string) *GetDeploymentInstanceInput {
	s.InstanceId = &v
	return s
}

// Represents the output of a GetDeploymentInstance operation.
type GetDeploymentInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the instance.
	InstanceSummary *InstanceSummary `locationName:"instanceSummary" type:"structure"`
}

// String returns the string representation
func (s GetDeploymentInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceSummary sets the InstanceSummary field's value.
func (s *GetDeploymentInstanceOutput) SetInstanceSummary(v *InstanceSummary) *GetDeploymentInstanceOutput {
	s.InstanceSummary = v
	return s
}

// Represents the output of a GetDeployment operation.
type GetDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deployment.
	DeploymentInfo *DeploymentInfo `locationName:"deploymentInfo" type:"structure"`
}

// String returns the string representation
func (s GetDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentInfo sets the DeploymentInfo field's value.
func (s *GetDeploymentOutput) SetDeploymentInfo(v *DeploymentInfo) *GetDeploymentOutput {
	s.DeploymentInfo = v
	return s
}

// Represents the input of a GetOnPremisesInstance operation.
type GetOnPremisesInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the on-premises instance about which to get information.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOnPremisesInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOnPremisesInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOnPremisesInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetOnPremisesInstanceInput) SetInstanceName(v string) *GetOnPremisesInstanceInput {
	s.InstanceName = &v
	return s
}

// Represents the output of a GetOnPremisesInstance operation.
type GetOnPremisesInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the on-premises instance.
	InstanceInfo *InstanceInfo `locationName:"instanceInfo" type:"structure"`
}

// String returns the string representation
func (s GetOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOnPremisesInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceInfo sets the InstanceInfo field's value.
func (s *GetOnPremisesInstanceOutput) SetInstanceInfo(v *InstanceInfo) *GetOnPremisesInstanceOutput {
	s.InstanceInfo = v
	return s
}

// Information about the location of application artifacts stored in GitHub.
type GitHubLocation struct {
	_ struct{} `type:"structure"`

	// The SHA1 commit ID of the GitHub commit that represents the bundled artifacts
	// for the application revision.
	CommitId *string `locationName:"commitId" type:"string"`

	// The GitHub account and repository pair that stores a reference to the commit
	// that represents the bundled artifacts for the application revision.
	//
	// Specified as account/repository.
	Repository *string `locationName:"repository" type:"string"`
}

// String returns the string representation
func (s GitHubLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GitHubLocation) GoString() string {
	return s.String()
}

// SetCommitId sets the CommitId field's value.
func (s *GitHubLocation) SetCommitId(v string) *GitHubLocation {
	s.CommitId = &v
	return s
}

// SetRepository sets the Repository field's value.
func (s *GitHubLocation) SetRepository(v string) *GitHubLocation {
	s.Repository = &v
	return s
}

// Information about the instances that belong to the replacement environment
// in a blue/green deployment.
type GreenFleetProvisioningOption struct {
	_ struct{} `type:"structure"`

	// The method used to add instances to a replacement environment.
	//
	//    * DISCOVER_EXISTING: Use instances that already exist or will be created
	//    manually.
	//
	//    * COPY_AUTO_SCALING_GROUP: Use settings from a specified Auto Scaling
	//    group to define and create instances in a new Auto Scaling group.
	Action *string `locationName:"action" type:"string" enum:"GreenFleetProvisioningAction"`
}

// String returns the string representation
func (s GreenFleetProvisioningOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GreenFleetProvisioningOption) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GreenFleetProvisioningOption) SetAction(v string) *GreenFleetProvisioningOption {
	s.Action = &v
	return s
}

// Information about an on-premises instance.
type InstanceInfo struct {
	_ struct{} `type:"structure"`

	// If the on-premises instance was deregistered, the time at which the on-premises
	// instance was deregistered.
	DeregisterTime *time.Time `locationName:"deregisterTime" type:"timestamp" timestampFormat:"unix"`

	// The ARN of the IAM session associated with the on-premises instance.
	IamSessionArn *string `locationName:"iamSessionArn" type:"string"`

	// The IAM user ARN associated with the on-premises instance.
	IamUserArn *string `locationName:"iamUserArn" type:"string"`

	// The ARN of the on-premises instance.
	InstanceArn *string `locationName:"instanceArn" type:"string"`

	// The name of the on-premises instance.
	InstanceName *string `locationName:"instanceName" type:"string"`

	// The time at which the on-premises instance was registered.
	RegisterTime *time.Time `locationName:"registerTime" type:"timestamp" timestampFormat:"unix"`

	// The tags currently associated with the on-premises instance.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s InstanceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInfo) GoString() string {
	return s.String()
}

// SetDeregisterTime sets the DeregisterTime field's value.
func (s *InstanceInfo) SetDeregisterTime(v time.Time) *InstanceInfo {
	s.DeregisterTime = &v
	return s
}

// SetIamSessionArn sets the IamSessionArn field's value.
func (s *InstanceInfo) SetIamSessionArn(v string) *InstanceInfo {
	s.IamSessionArn = &v
	return s
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *InstanceInfo) SetIamUserArn(v string) *InstanceInfo {
	s.IamUserArn = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *InstanceInfo) SetInstanceArn(v string) *InstanceInfo {
	s.InstanceArn = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceInfo) SetInstanceName(v string) *InstanceInfo {
	s.InstanceName = &v
	return s
}

// SetRegisterTime sets the RegisterTime field's value.
func (s *InstanceInfo) SetRegisterTime(v time.Time) *InstanceInfo {
	s.RegisterTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InstanceInfo) SetTags(v []*Tag) *InstanceInfo {
	s.Tags = v
	return s
}

// Information about an instance in a deployment.
type InstanceSummary struct {
	_ struct{} `type:"structure"`

	// The deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The instance ID.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// Information about which environment an instance belongs to in a blue/green
	// deployment.
	//
	//    * BLUE: The instance is part of the original environment.
	//
	//    * GREEN: The instance is part of the replacement environment.
	InstanceType *string `locationName:"instanceType" type:"string" enum:"InstanceType"`

	// A timestamp indicating when the instance information was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// A list of lifecycle events for this instance.
	LifecycleEvents []*LifecycleEvent `locationName:"lifecycleEvents" type:"list"`

	// The deployment status for this instance:
	//
	//    * Pending: The deployment is pending for this instance.
	//
	//    * In Progress: The deployment is in progress for this instance.
	//
	//    * Succeeded: The deployment has succeeded for this instance.
	//
	//    * Failed: The deployment has failed for this instance.
	//
	//    * Skipped: The deployment has been skipped for this instance.
	//
	//    * Unknown: The deployment status is unknown for this instance.
	Status *string `locationName:"status" type:"string" enum:"InstanceStatus"`
}

// String returns the string representation
func (s InstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceSummary) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *InstanceSummary) SetDeploymentId(v string) *InstanceSummary {
	s.DeploymentId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceSummary) SetInstanceId(v string) *InstanceSummary {
	s.InstanceId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceSummary) SetInstanceType(v string) *InstanceSummary {
	s.InstanceType = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *InstanceSummary) SetLastUpdatedAt(v time.Time) *InstanceSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetLifecycleEvents sets the LifecycleEvents field's value.
func (s *InstanceSummary) SetLifecycleEvents(v []*LifecycleEvent) *InstanceSummary {
	s.LifecycleEvents = v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceSummary) SetStatus(v string) *InstanceSummary {
	s.Status = &v
	return s
}

// Information about the most recent attempted or successful deployment to a
// deployment group.
type LastDeploymentInfo struct {
	_ struct{} `type:"structure"`

	// A timestamp indicating when the most recent deployment to the deployment
	// group started.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A timestamp indicating when the most recent deployment to the deployment
	// group completed.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// The status of the most recent deployment.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`
}

// String returns the string representation
func (s LastDeploymentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LastDeploymentInfo) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *LastDeploymentInfo) SetCreateTime(v time.Time) *LastDeploymentInfo {
	s.CreateTime = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *LastDeploymentInfo) SetDeploymentId(v string) *LastDeploymentInfo {
	s.DeploymentId = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *LastDeploymentInfo) SetEndTime(v time.Time) *LastDeploymentInfo {
	s.EndTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LastDeploymentInfo) SetStatus(v string) *LastDeploymentInfo {
	s.Status = &v
	return s
}

// Information about a deployment lifecycle event.
type LifecycleEvent struct {
	_ struct{} `type:"structure"`

	// Diagnostic information about the deployment lifecycle event.
	Diagnostics *Diagnostics `locationName:"diagnostics" type:"structure"`

	// A timestamp indicating when the deployment lifecycle event ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment lifecycle event name, such as ApplicationStop, BeforeInstall,
	// AfterInstall, ApplicationStart, or ValidateService.
	LifecycleEventName *string `locationName:"lifecycleEventName" type:"string"`

	// A timestamp indicating when the deployment lifecycle event started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment lifecycle event status:
	//
	//    * Pending: The deployment lifecycle event is pending.
	//
	//    * InProgress: The deployment lifecycle event is in progress.
	//
	//    * Succeeded: The deployment lifecycle event ran successfully.
	//
	//    * Failed: The deployment lifecycle event has failed.
	//
	//    * Skipped: The deployment lifecycle event has been skipped.
	//
	//    * Unknown: The deployment lifecycle event is unknown.
	Status *string `locationName:"status" type:"string" enum:"LifecycleEventStatus"`
}

// String returns the string representation
func (s LifecycleEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleEvent) GoString() string {
	return s.String()
}

// SetDiagnostics sets the Diagnostics field's value.
func (s *LifecycleEvent) SetDiagnostics(v *Diagnostics) *LifecycleEvent {
	s.Diagnostics = v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *LifecycleEvent) SetEndTime(v time.Time) *LifecycleEvent {
	s.EndTime = &v
	return s
}

// SetLifecycleEventName sets the LifecycleEventName field's value.
func (s *LifecycleEvent) SetLifecycleEventName(v string) *LifecycleEvent {
	s.LifecycleEventName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *LifecycleEvent) SetStartTime(v time.Time) *LifecycleEvent {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LifecycleEvent) SetStatus(v string) *LifecycleEvent {
	s.Status = &v
	return s
}

// Represents the input of a ListApplicationRevisions operation.
type ListApplicationRevisionsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Whether to list revisions based on whether the revision is the target revision
	// of an deployment group:
	//
	//    * include: List revisions that are target revisions of a deployment group.
	//
	//    * exclude: Do not list revisions that are target revisions of a deployment
	//    group.
	//
	//    * ignore: List all revisions.
	Deployed *string `locationName:"deployed" type:"string" enum:"ListStateFilterAction"`

	// An identifier returned from the previous list application revisions call.
	// It can be used to return the next set of applications in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An Amazon S3 bucket name to limit the search for revisions.
	//
	// If set to null, all of the user's buckets will be searched.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// A key prefix for the set of Amazon S3 objects to limit the search for revisions.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" type:"string"`

	// The column name to use to sort the list results:
	//
	//    * registerTime: Sort by the time the revisions were registered with AWS
	//    CodeDeploy.
	//
	//    * firstUsedTime: Sort by the time the revisions were first used in a deployment.
	//
	//    * lastUsedTime: Sort by the time the revisions were last used in a deployment.
	//
	// If not specified or set to null, the results will be returned in an arbitrary
	// order.
	SortBy *string `locationName:"sortBy" type:"string" enum:"ApplicationRevisionSortBy"`

	// The order in which to sort the list results:
	//
	//    * ascending: ascending order.
	//
	//    * descending: descending order.
	//
	// If not specified, the results will be sorted in ascending order.
	//
	// If set to null, the results will be sorted in an arbitrary order.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation
func (s ListApplicationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationRevisionsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ListApplicationRevisionsInput) SetApplicationName(v string) *ListApplicationRevisionsInput {
	s.ApplicationName = &v
	return s
}

// SetDeployed sets the Deployed field's value.
func (s *ListApplicationRevisionsInput) SetDeployed(v string) *ListApplicationRevisionsInput {
	s.Deployed = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationRevisionsInput) SetNextToken(v string) *ListApplicationRevisionsInput {
	s.NextToken = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *ListApplicationRevisionsInput) SetS3Bucket(v string) *ListApplicationRevisionsInput {
	s.S3Bucket = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *ListApplicationRevisionsInput) SetS3KeyPrefix(v string) *ListApplicationRevisionsInput {
	s.S3KeyPrefix = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListApplicationRevisionsInput) SetSortBy(v string) *ListApplicationRevisionsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListApplicationRevisionsInput) SetSortOrder(v string) *ListApplicationRevisionsInput {
	s.SortOrder = &v
	return s
}

// Represents the output of a ListApplicationRevisions operation.
type ListApplicationRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// If a large amount of information is returned, an identifier will also be
	// returned. It can be used in a subsequent list application revisions call
	// to return the next set of application revisions in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of locations that contain the matching revisions.
	Revisions []*RevisionLocation `locationName:"revisions" type:"list"`
}

// String returns the string representation
func (s ListApplicationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationRevisionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationRevisionsOutput) SetNextToken(v string) *ListApplicationRevisionsOutput {
	s.NextToken = &v
	return s
}

// SetRevisions sets the Revisions field's value.
func (s *ListApplicationRevisionsOutput) SetRevisions(v []*RevisionLocation) *ListApplicationRevisionsOutput {
	s.Revisions = v
	return s
}

// Represents the input of a ListApplications operation.
type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// An identifier returned from the previous list applications call. It can be
	// used to return the next set of applications in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListApplications operation.
type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of application names.
	Applications []*string `locationName:"applications" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list applications call to return the next
	// set of applications, will also be returned. in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *ListApplicationsOutput) SetApplications(v []*string) *ListApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a ListDeploymentConfigs operation.
type ListDeploymentConfigsInput struct {
	_ struct{} `type:"structure"`

	// An identifier returned from the previous list deployment configurations call.
	// It can be used to return the next set of deployment configurations in the
	// list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentConfigsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentConfigsInput) SetNextToken(v string) *ListDeploymentConfigsInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListDeploymentConfigs operation.
type ListDeploymentConfigsOutput struct {
	_ struct{} `type:"structure"`

	// A list of deployment configurations, including built-in configurations such
	// as CodeDeployDefault.OneAtATime.
	DeploymentConfigsList []*string `locationName:"deploymentConfigsList" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployment configurations call to return
	// the next set of deployment configurations in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentConfigsOutput) GoString() string {
	return s.String()
}

// SetDeploymentConfigsList sets the DeploymentConfigsList field's value.
func (s *ListDeploymentConfigsOutput) SetDeploymentConfigsList(v []*string) *ListDeploymentConfigsOutput {
	s.DeploymentConfigsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentConfigsOutput) SetNextToken(v string) *ListDeploymentConfigsOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a ListDeploymentGroups operation.
type ListDeploymentGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// An identifier returned from the previous list deployment groups call. It
	// can be used to return the next set of deployment groups in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentGroupsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ListDeploymentGroupsInput) SetApplicationName(v string) *ListDeploymentGroupsInput {
	s.ApplicationName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentGroupsInput) SetNextToken(v string) *ListDeploymentGroupsInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListDeploymentGroups operation.
type ListDeploymentGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A list of corresponding deployment group names.
	DeploymentGroups []*string `locationName:"deploymentGroups" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployment groups call to return the
	// next set of deployment groups in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentGroupsOutput) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ListDeploymentGroupsOutput) SetApplicationName(v string) *ListDeploymentGroupsOutput {
	s.ApplicationName = &v
	return s
}

// SetDeploymentGroups sets the DeploymentGroups field's value.
func (s *ListDeploymentGroupsOutput) SetDeploymentGroups(v []*string) *ListDeploymentGroupsOutput {
	s.DeploymentGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentGroupsOutput) SetNextToken(v string) *ListDeploymentGroupsOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a ListDeploymentInstances operation.
type ListDeploymentInstancesInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of a deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// A subset of instances to list by status:
	//
	//    * Pending: Include those instance with pending deployments.
	//
	//    * InProgress: Include those instance where deployments are still in progress.
	//
	//    * Succeeded: Include those instances with successful deployments.
	//
	//    * Failed: Include those instance with failed deployments.
	//
	//    * Skipped: Include those instance with skipped deployments.
	//
	//    * Unknown: Include those instance with deployments in an unknown state.
	InstanceStatusFilter []*string `locationName:"instanceStatusFilter" type:"list"`

	// The set of instances in a blue/green deployment, either those in the original
	// environment ("BLUE") or those in the replacement environment ("GREEN"), for
	// which you want to view instance information.
	InstanceTypeFilter []*string `locationName:"instanceTypeFilter" type:"list"`

	// An identifier returned from the previous list deployment instances call.
	// It can be used to return the next set of deployment instances in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentInstancesInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ListDeploymentInstancesInput) SetDeploymentId(v string) *ListDeploymentInstancesInput {
	s.DeploymentId = &v
	return s
}

// SetInstanceStatusFilter sets the InstanceStatusFilter field's value.
func (s *ListDeploymentInstancesInput) SetInstanceStatusFilter(v []*string) *ListDeploymentInstancesInput {
	s.InstanceStatusFilter = v
	return s
}

// SetInstanceTypeFilter sets the InstanceTypeFilter field's value.
func (s *ListDeploymentInstancesInput) SetInstanceTypeFilter(v []*string) *ListDeploymentInstancesInput {
	s.InstanceTypeFilter = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentInstancesInput) SetNextToken(v string) *ListDeploymentInstancesInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListDeploymentInstances operation.
type ListDeploymentInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A list of instance IDs.
	InstancesList []*string `locationName:"instancesList" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployment instances call to return the
	// next set of deployment instances in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentInstancesOutput) GoString() string {
	return s.String()
}

// SetInstancesList sets the InstancesList field's value.
func (s *ListDeploymentInstancesOutput) SetInstancesList(v []*string) *ListDeploymentInstancesOutput {
	s.InstancesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentInstancesOutput) SetNextToken(v string) *ListDeploymentInstancesOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a ListDeployments operation.
type ListDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A time range (start and end) for returning a subset of the list of deployments.
	CreateTimeRange *TimeRange `locationName:"createTimeRange" type:"structure"`

	// The name of an existing deployment group for the specified application.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// A subset of deployments to list by status:
	//
	//    * Created: Include created deployments in the resulting list.
	//
	//    * Queued: Include queued deployments in the resulting list.
	//
	//    * In Progress: Include in-progress deployments in the resulting list.
	//
	//    * Succeeded: Include successful deployments in the resulting list.
	//
	//    * Failed: Include failed deployments in the resulting list.
	//
	//    * Stopped: Include stopped deployments in the resulting list.
	IncludeOnlyStatuses []*string `locationName:"includeOnlyStatuses" type:"list"`

	// An identifier returned from the previous list deployments call. It can be
	// used to return the next set of deployments in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.DeploymentGroupName != nil && len(*s.DeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ListDeploymentsInput) SetApplicationName(v string) *ListDeploymentsInput {
	s.ApplicationName = &v
	return s
}

// SetCreateTimeRange sets the CreateTimeRange field's value.
func (s *ListDeploymentsInput) SetCreateTimeRange(v *TimeRange) *ListDeploymentsInput {
	s.CreateTimeRange = v
	return s
}

// SetDeploymentGroupName sets the DeploymentGroupName field's value.
func (s *ListDeploymentsInput) SetDeploymentGroupName(v string) *ListDeploymentsInput {
	s.DeploymentGroupName = &v
	return s
}

// SetIncludeOnlyStatuses sets the IncludeOnlyStatuses field's value.
func (s *ListDeploymentsInput) SetIncludeOnlyStatuses(v []*string) *ListDeploymentsInput {
	s.IncludeOnlyStatuses = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsInput) SetNextToken(v string) *ListDeploymentsInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListDeployments operation.
type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of deployment IDs.
	Deployments []*string `locationName:"deployments" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list deployments call to return the next set
	// of deployments in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *ListDeploymentsOutput) SetDeployments(v []*string) *ListDeploymentsOutput {
	s.Deployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsOutput) SetNextToken(v string) *ListDeploymentsOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a ListGitHubAccountTokenNames operation.
type ListGitHubAccountTokenNamesInput struct {
	_ struct{} `type:"structure"`

	// An identifier returned from the previous ListGitHubAccountTokenNames call.
	// It can be used to return the next set of names in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListGitHubAccountTokenNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGitHubAccountTokenNamesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListGitHubAccountTokenNamesInput) SetNextToken(v string) *ListGitHubAccountTokenNamesInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListGitHubAccountTokenNames operation.
type ListGitHubAccountTokenNamesOutput struct {
	_ struct{} `type:"structure"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent ListGitHubAccountTokenNames call to return
	// the next set of names in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of names of connections to GitHub accounts.
	TokenNameList []*string `locationName:"tokenNameList" type:"list"`
}

// String returns the string representation
func (s ListGitHubAccountTokenNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGitHubAccountTokenNamesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListGitHubAccountTokenNamesOutput) SetNextToken(v string) *ListGitHubAccountTokenNamesOutput {
	s.NextToken = &v
	return s
}

// SetTokenNameList sets the TokenNameList field's value.
func (s *ListGitHubAccountTokenNamesOutput) SetTokenNameList(v []*string) *ListGitHubAccountTokenNamesOutput {
	s.TokenNameList = v
	return s
}

// Represents the input of a ListOnPremisesInstances operation.
type ListOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// An identifier returned from the previous list on-premises instances call.
	// It can be used to return the next set of on-premises instances in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The registration status of the on-premises instances:
	//
	//    * Deregistered: Include deregistered on-premises instances in the resulting
	//    list.
	//
	//    * Registered: Include registered on-premises instances in the resulting
	//    list.
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" enum:"RegistrationStatus"`

	// The on-premises instance tags that will be used to restrict the corresponding
	// on-premises instance names returned.
	TagFilters []*TagFilter `locationName:"tagFilters" type:"list"`
}

// String returns the string representation
func (s ListOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOnPremisesInstancesInput) SetNextToken(v string) *ListOnPremisesInstancesInput {
	s.NextToken = &v
	return s
}

// SetRegistrationStatus sets the RegistrationStatus field's value.
func (s *ListOnPremisesInstancesInput) SetRegistrationStatus(v string) *ListOnPremisesInstancesInput {
	s.RegistrationStatus = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *ListOnPremisesInstancesInput) SetTagFilters(v []*TagFilter) *ListOnPremisesInstancesInput {
	s.TagFilters = v
	return s
}

// Represents the output of list on-premises instances operation.
type ListOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The list of matching on-premises instance names.
	InstanceNames []*string `locationName:"instanceNames" type:"list"`

	// If a large amount of information is returned, an identifier is also returned.
	// It can be used in a subsequent list on-premises instances call to return
	// the next set of on-premises instances in the list.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *ListOnPremisesInstancesOutput) SetInstanceNames(v []*string) *ListOnPremisesInstancesOutput {
	s.InstanceNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOnPremisesInstancesOutput) SetNextToken(v string) *ListOnPremisesInstancesOutput {
	s.NextToken = &v
	return s
}

// Information about the Elastic Load Balancing load balancer or target group
// used in a deployment.
type LoadBalancerInfo struct {
	_ struct{} `type:"structure"`

	// An array containing information about the load balancer to use for load balancing
	// in a deployment. In Elastic Load Balancing, load balancers are used with
	// Classic Load Balancers.
	ElbInfoList []*ELBInfo `locationName:"elbInfoList" type:"list"`

	// An array containing information about the target group to use for load balancing
	// in a deployment. In Elastic Load Balancing, target groups are used with Application
	// Load Balancers.
	TargetGroupInfoList []*TargetGroupInfo `locationName:"targetGroupInfoList" type:"list"`
}

// String returns the string representation
func (s LoadBalancerInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerInfo) GoString() string {
	return s.String()
}

// SetElbInfoList sets the ElbInfoList field's value.
func (s *LoadBalancerInfo) SetElbInfoList(v []*ELBInfo) *LoadBalancerInfo {
	s.ElbInfoList = v
	return s
}

// SetTargetGroupInfoList sets the TargetGroupInfoList field's value.
func (s *LoadBalancerInfo) SetTargetGroupInfoList(v []*TargetGroupInfo) *LoadBalancerInfo {
	s.TargetGroupInfoList = v
	return s
}

// Information about minimum healthy instance.
type MinimumHealthyHosts struct {
	_ struct{} `type:"structure"`

	// The minimum healthy instance type:
	//
	//    * HOST_COUNT: The minimum number of healthy instance as an absolute value.
	//
	//    * FLEET_PERCENT: The minimum number of healthy instance as a percentage
	//    of the total number of instance in the deployment.
	//
	// In an example of nine instance, if a HOST_COUNT of six is specified, deploy
	// to up to three instances at a time. The deployment will be successful if
	// six or more instances are deployed to successfully; otherwise, the deployment
	// fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance
	// at a time. The deployment will be successful if four or more instance are
	// deployed to successfully; otherwise, the deployment fails.
	//
	// In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime
	// will return a minimum healthy instance type of MOST_CONCURRENCY and a value
	// of 1. This means a deployment to only one instance at a time. (You cannot
	// set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In
	// addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy will try to ensure
	// that all instances but one are kept in a healthy state during the deployment.
	// Although this allows one instance at a time to be taken offline for a new
	// deployment, it also means that if the deployment to the last instance fails,
	// the overall deployment still succeeds.
	//
	// For more information, see AWS CodeDeploy Instance Health (http://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html)
	// in the AWS CodeDeploy User Guide.
	Type *string `locationName:"type" type:"string" enum:"MinimumHealthyHostsType"`

	// The minimum healthy instance value.
	Value *int64 `locationName:"value" type:"integer"`
}

// String returns the string representation
func (s MinimumHealthyHosts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MinimumHealthyHosts) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *MinimumHealthyHosts) SetType(v string) *MinimumHealthyHosts {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MinimumHealthyHosts) SetValue(v int64) *MinimumHealthyHosts {
	s.Value = &v
	return s
}

// Information about groups of on-premises instance tags.
type OnPremisesTagSet struct {
	_ struct{} `type:"structure"`

	// A list containing other lists of on-premises instance tag groups. In order
	// for an instance to be included in the deployment group, it must be identified
	// by all the tag groups in the list.
	OnPremisesTagSetList [][]*TagFilter `locationName:"onPremisesTagSetList" type:"list"`
}

// String returns the string representation
func (s OnPremisesTagSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OnPremisesTagSet) GoString() string {
	return s.String()
}

// SetOnPremisesTagSetList sets the OnPremisesTagSetList field's value.
func (s *OnPremisesTagSet) SetOnPremisesTagSetList(v [][]*TagFilter) *OnPremisesTagSet {
	s.OnPremisesTagSetList = v
	return s
}

type PutLifecycleEventHookExecutionStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment. Pass this ID to a Lambda function that validates
	// a deployment lifecycle event.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The execution ID of a deployment's lifecycle hook. A deployment lifecycle
	// hook is specified in the hooks section of the AppSpec file.
	LifecycleEventHookExecutionId *string `locationName:"lifecycleEventHookExecutionId" type:"string"`

	// The result of a Lambda function that validates a deployment lifecycle event
	// (Succeeded or Failed).
	Status *string `locationName:"status" type:"string" enum:"LifecycleEventStatus"`
}

// String returns the string representation
func (s PutLifecycleEventHookExecutionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLifecycleEventHookExecutionStatusInput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *PutLifecycleEventHookExecutionStatusInput) SetDeploymentId(v string) *PutLifecycleEventHookExecutionStatusInput {
	s.DeploymentId = &v
	return s
}

// SetLifecycleEventHookExecutionId sets the LifecycleEventHookExecutionId field's value.
func (s *PutLifecycleEventHookExecutionStatusInput) SetLifecycleEventHookExecutionId(v string) *PutLifecycleEventHookExecutionStatusInput {
	s.LifecycleEventHookExecutionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PutLifecycleEventHookExecutionStatusInput) SetStatus(v string) *PutLifecycleEventHookExecutionStatusInput {
	s.Status = &v
	return s
}

type PutLifecycleEventHookExecutionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The execution ID of the lifecycle event hook. A hook is specified in the
	// hooks section of the deployment's AppSpec file.
	LifecycleEventHookExecutionId *string `locationName:"lifecycleEventHookExecutionId" type:"string"`
}

// String returns the string representation
func (s PutLifecycleEventHookExecutionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLifecycleEventHookExecutionStatusOutput) GoString() string {
	return s.String()
}

// SetLifecycleEventHookExecutionId sets the LifecycleEventHookExecutionId field's value.
func (s *PutLifecycleEventHookExecutionStatusOutput) SetLifecycleEventHookExecutionId(v string) *PutLifecycleEventHookExecutionStatusOutput {
	s.LifecycleEventHookExecutionId = &v
	return s
}

// A revision for an AWS Lambda deployment that is a YAML-formatted or JSON-formatted
// string. For AWS Lambda deployments, the revision is the same as the AppSpec
// file.
type RawString struct {
	_ struct{} `type:"structure"`

	// The YAML-formatted or JSON-formatted revision string. It includes information
	// about which Lambda function to update and optional Lambda functions that
	// validate deployment lifecycle events.
	Content *string `locationName:"content" type:"string"`

	// The SHA256 hash value of the revision that is specified as a RawString.
	Sha256 *string `locationName:"sha256" type:"string"`
}

// String returns the string representation
func (s RawString) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RawString) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *RawString) SetContent(v string) *RawString {
	s.Content = &v
	return s
}

// SetSha256 sets the Sha256 field's value.
func (s *RawString) SetSha256(v string) *RawString {
	s.Sha256 = &v
	return s
}

// Represents the input of a RegisterApplicationRevision operation.
type RegisterApplicationRevisionInput struct {
	_ struct{} `type:"structure"`

	// The name of an AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// A comment about the revision.
	Description *string `locationName:"description" type:"string"`

	// Information about the application revision to register, including type and
	// location.
	//
	// Revision is a required field
	Revision *RevisionLocation `locationName:"revision" type:"structure" required:"true"`
}

// String returns the string representation
func (s RegisterApplicationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterApplicationRevisionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterApplicationRevisionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterApplicationRevisionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.Revision == nil {
		invalidParams.Add(request.NewErrParamRequired("Revision"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *RegisterApplicationRevisionInput) SetApplicationName(v string) *RegisterApplicationRevisionInput {
	s.ApplicationName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RegisterApplicationRevisionInput) SetDescription(v string) *RegisterApplicationRevisionInput {
	s.Description = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *RegisterApplicationRevisionInput) SetRevision(v *RevisionLocation) *RegisterApplicationRevisionInput {
	s.Revision = v
	return s
}

type RegisterApplicationRevisionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterApplicationRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterApplicationRevisionOutput) GoString() string {
	return s.String()
}

// Represents the input of the register on-premises instance operation.
type RegisterOnPremisesInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM session to associate with the on-premises instance.
	IamSessionArn *string `locationName:"iamSessionArn" type:"string"`

	// The ARN of the IAM user to associate with the on-premises instance.
	IamUserArn *string `locationName:"iamUserArn" type:"string"`

	// The name of the on-premises instance to register.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterOnPremisesInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterOnPremisesInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterOnPremisesInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIamSessionArn sets the IamSessionArn field's value.
func (s *RegisterOnPremisesInstanceInput) SetIamSessionArn(v string) *RegisterOnPremisesInstanceInput {
	s.IamSessionArn = &v
	return s
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *RegisterOnPremisesInstanceInput) SetIamUserArn(v string) *RegisterOnPremisesInstanceInput {
	s.IamUserArn = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *RegisterOnPremisesInstanceInput) SetInstanceName(v string) *RegisterOnPremisesInstanceInput {
	s.InstanceName = &v
	return s
}

type RegisterOnPremisesInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterOnPremisesInstanceOutput) GoString() string {
	return s.String()
}

// Represents the input of a RemoveTagsFromOnPremisesInstances operation.
type RemoveTagsFromOnPremisesInstancesInput struct {
	_ struct{} `type:"structure"`

	// The names of the on-premises instances from which to remove tags.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The tag key-value pairs to remove from the on-premises instances.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromOnPremisesInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromOnPremisesInstancesInput"}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *RemoveTagsFromOnPremisesInstancesInput) SetInstanceNames(v []*string) *RemoveTagsFromOnPremisesInstancesInput {
	s.InstanceNames = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RemoveTagsFromOnPremisesInstancesInput) SetTags(v []*Tag) *RemoveTagsFromOnPremisesInstancesInput {
	s.Tags = v
	return s
}

type RemoveTagsFromOnPremisesInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Information about an application revision.
type RevisionInfo struct {
	_ struct{} `type:"structure"`

	// Information about an application revision, including usage details and associated
	// deployment groups.
	GenericRevisionInfo *GenericRevisionInfo `locationName:"genericRevisionInfo" type:"structure"`

	// Information about the location and type of an application revision.
	RevisionLocation *RevisionLocation `locationName:"revisionLocation" type:"structure"`
}

// String returns the string representation
func (s RevisionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevisionInfo) GoString() string {
	return s.String()
}

// SetGenericRevisionInfo sets the GenericRevisionInfo field's value.
func (s *RevisionInfo) SetGenericRevisionInfo(v *GenericRevisionInfo) *RevisionInfo {
	s.GenericRevisionInfo = v
	return s
}

// SetRevisionLocation sets the RevisionLocation field's value.
func (s *RevisionInfo) SetRevisionLocation(v *RevisionLocation) *RevisionInfo {
	s.RevisionLocation = v
	return s
}

// Information about the location of an application revision.
type RevisionLocation struct {
	_ struct{} `type:"structure"`

	// Information about the location of application artifacts stored in GitHub.
	GitHubLocation *GitHubLocation `locationName:"gitHubLocation" type:"structure"`

	// The type of application revision:
	//
	//    * S3: An application revision stored in Amazon S3.
	//
	//    * GitHub: An application revision stored in GitHub (EC2/On-premises deployments
	//    only)
	//
	//    * String: A YAML-formatted or JSON-formatted string (AWS Lambda deployments
	//    only)
	RevisionType *string `locationName:"revisionType" type:"string" enum:"RevisionLocationType"`

	// Information about the location of a revision stored in Amazon S3.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`

	// Information about the location of an AWS Lambda deployment revision stored
	// as a RawString.
	String_ *RawString `locationName:"string" type:"structure"`
}

// String returns the string representation
func (s RevisionLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevisionLocation) GoString() string {
	return s.String()
}

// SetGitHubLocation sets the GitHubLocation field's value.
func (s *RevisionLocation) SetGitHubLocation(v *GitHubLocation) *RevisionLocation {
	s.GitHubLocation = v
	return s
}

// SetRevisionType sets the RevisionType field's value.
func (s *RevisionLocation) SetRevisionType(v string) *RevisionLocation {
	s.RevisionType = &v
	return s
}

// SetS3Location sets the S3Location field's value.
func (s *RevisionLocation) SetS3Location(v *S3Location) *RevisionLocation {
	s.S3Location = v
	return s
}

// SetString_ sets the String_ field's value.
func (s *RevisionLocation) SetString_(v *RawString) *RevisionLocation {
	s.String_ = v
	return s
}

// Information about a deployment rollback.
type RollbackInfo struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment rollback.
	RollbackDeploymentId *string `locationName:"rollbackDeploymentId" type:"string"`

	// Information describing the status of a deployment rollback; for example,
	// whether the deployment can't be rolled back, is in progress, failed, or succeeded.
	RollbackMessage *string `locationName:"rollbackMessage" type:"string"`

	// The deployment ID of the deployment that was underway and triggered a rollback
	// deployment because it failed or was stopped.
	RollbackTriggeringDeploymentId *string `locationName:"rollbackTriggeringDeploymentId" type:"string"`
}

// String returns the string representation
func (s RollbackInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RollbackInfo) GoString() string {
	return s.String()
}

// SetRollbackDeploymentId sets the RollbackDeploymentId field's value.
func (s *RollbackInfo) SetRollbackDeploymentId(v string) *RollbackInfo {
	s.RollbackDeploymentId = &v
	return s
}

// SetRollbackMessage sets the RollbackMessage field's value.
func (s *RollbackInfo) SetRollbackMessage(v string) *RollbackInfo {
	s.RollbackMessage = &v
	return s
}

// SetRollbackTriggeringDeploymentId sets the RollbackTriggeringDeploymentId field's value.
func (s *RollbackInfo) SetRollbackTriggeringDeploymentId(v string) *RollbackInfo {
	s.RollbackTriggeringDeploymentId = &v
	return s
}

// Information about the location of application artifacts stored in Amazon
// S3.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket where the application revision is stored.
	Bucket *string `locationName:"bucket" type:"string"`

	// The file type of the application revision. Must be one of the following:
	//
	//    * tar: A tar archive file.
	//
	//    * tgz: A compressed tar archive file.
	//
	//    * zip: A zip archive file.
	BundleType *string `locationName:"bundleType" type:"string" enum:"BundleType"`

	// The ETag of the Amazon S3 object that represents the bundled artifacts for
	// the application revision.
	//
	// If the ETag is not specified as an input parameter, ETag validation of the
	// object will be skipped.
	ETag *string `locationName:"eTag" type:"string"`

	// The name of the Amazon S3 object that represents the bundled artifacts for
	// the application revision.
	Key *string `locationName:"key" type:"string"`

	// A specific version of the Amazon S3 object that represents the bundled artifacts
	// for the application revision.
	//
	// If the version is not specified, the system will use the most recent version
	// by default.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *S3Location) SetBucket(v string) *S3Location {
	s.Bucket = &v
	return s
}

// SetBundleType sets the BundleType field's value.
func (s *S3Location) SetBundleType(v string) *S3Location {
	s.BundleType = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *S3Location) SetETag(v string) *S3Location {
	s.ETag = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Location) SetKey(v string) *S3Location {
	s.Key = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *S3Location) SetVersion(v string) *S3Location {
	s.Version = &v
	return s
}

type SkipWaitTimeForInstanceTerminationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the blue/green deployment for which you want to skip the instance
	// termination wait time.
	DeploymentId *string `locationName:"deploymentId" type:"string"`
}

// String returns the string representation
func (s SkipWaitTimeForInstanceTerminationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SkipWaitTimeForInstanceTerminationInput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *SkipWaitTimeForInstanceTerminationInput) SetDeploymentId(v string) *SkipWaitTimeForInstanceTerminationInput {
	s.DeploymentId = &v
	return s
}

type SkipWaitTimeForInstanceTerminationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SkipWaitTimeForInstanceTerminationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SkipWaitTimeForInstanceTerminationOutput) GoString() string {
	return s.String()
}

// Represents the input of a StopDeployment operation.
type StopDeploymentInput struct {
	_ struct{} `type:"structure"`

	// Indicates, when a deployment is stopped, whether instances that have been
	// updated should be rolled back to the previous version of the application
	// revision.
	AutoRollbackEnabled *bool `locationName:"autoRollbackEnabled" type:"boolean"`

	// The unique ID of a deployment.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`
}

// String returns the string representation
func (s StopDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoRollbackEnabled sets the AutoRollbackEnabled field's value.
func (s *StopDeploymentInput) SetAutoRollbackEnabled(v bool) *StopDeploymentInput {
	s.AutoRollbackEnabled = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *StopDeploymentInput) SetDeploymentId(v string) *StopDeploymentInput {
	s.DeploymentId = &v
	return s
}

// Represents the output of a StopDeployment operation.
type StopDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The status of the stop deployment operation:
	//
	//    * Pending: The stop operation is pending.
	//
	//    * Succeeded: The stop operation was successful.
	Status *string `locationName:"status" type:"string" enum:"StopStatus"`

	// An accompanying status message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation
func (s StopDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDeploymentOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *StopDeploymentOutput) SetStatus(v string) *StopDeploymentOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *StopDeploymentOutput) SetStatusMessage(v string) *StopDeploymentOutput {
	s.StatusMessage = &v
	return s
}

// Information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	Key *string `type:"string"`

	// The tag's value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Information about an on-premises instance tag filter.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// The on-premises instance tag filter key.
	Key *string `type:"string"`

	// The on-premises instance tag filter type:
	//
	//    * KEY_ONLY: Key only.
	//
	//    * VALUE_ONLY: Value only.
	//
	//    * KEY_AND_VALUE: Key and value.
	Type *string `type:"string" enum:"TagFilterType"`

	// The on-premises instance tag filter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagFilter) SetKey(v string) *TagFilter {
	s.Key = &v
	return s
}

// SetType sets the Type field's value.
func (s *TagFilter) SetType(v string) *TagFilter {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagFilter) SetValue(v string) *TagFilter {
	s.Value = &v
	return s
}

// Information about a target group in Elastic Load Balancing to use in a deployment.
// Instances are registered as targets in a target group, and traffic is routed
// to the target group.
type TargetGroupInfo struct {
	_ struct{} `type:"structure"`

	// For blue/green deployments, the name of the target group that instances in
	// the original environment are deregistered from, and instances in the replacement
	// environment registered with. For in-place deployments, the name of the target
	// group that instances are deregistered from, so they are not serving traffic
	// during a deployment, and then re-registered with after the deployment completes.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s TargetGroupInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetGroupInfo) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *TargetGroupInfo) SetName(v string) *TargetGroupInfo {
	s.Name = &v
	return s
}

// Information about the instances to be used in the replacement environment
// in a blue/green deployment.
type TargetInstances struct {
	_ struct{} `type:"structure"`

	// The names of one or more Auto Scaling groups to identify a replacement environment
	// for a blue/green deployment.
	AutoScalingGroups []*string `locationName:"autoScalingGroups" type:"list"`

	// Information about the groups of EC2 instance tags that an instance must be
	// identified by in order for it to be included in the replacement environment
	// for a blue/green deployment. Cannot be used in the same call as tagFilters.
	Ec2TagSet *EC2TagSet `locationName:"ec2TagSet" type:"structure"`

	// The tag filter key, type, and value used to identify Amazon EC2 instances
	// in a replacement environment for a blue/green deployment. Cannot be used
	// in the same call as ec2TagSet.
	TagFilters []*EC2TagFilter `locationName:"tagFilters" type:"list"`
}

// String returns the string representation
func (s TargetInstances) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetInstances) GoString() string {
	return s.String()
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *TargetInstances) SetAutoScalingGroups(v []*string) *TargetInstances {
	s.AutoScalingGroups = v
	return s
}

// SetEc2TagSet sets the Ec2TagSet field's value.
func (s *TargetInstances) SetEc2TagSet(v *EC2TagSet) *TargetInstances {
	s.Ec2TagSet = v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *TargetInstances) SetTagFilters(v []*EC2TagFilter) *TargetInstances {
	s.TagFilters = v
	return s
}

// A configuration that shifts traffic from one version of a Lambda function
// to another in two increments. The original and target Lambda function versions
// are specified in the deployment's AppSpec file.
type TimeBasedCanary struct {
	_ struct{} `type:"structure"`

	// The number of minutes between the first and second traffic shifts of a TimeBasedCanary
	// deployment.
	CanaryInterval *int64 `locationName:"canaryInterval" type:"integer"`

	// The percentage of traffic to shift in the first increment of a TimeBasedCanary
	// deployment.
	CanaryPercentage *int64 `locationName:"canaryPercentage" type:"integer"`
}

// String returns the string representation
func (s TimeBasedCanary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeBasedCanary) GoString() string {
	return s.String()
}

// SetCanaryInterval sets the CanaryInterval field's value.
func (s *TimeBasedCanary) SetCanaryInterval(v int64) *TimeBasedCanary {
	s.CanaryInterval = &v
	return s
}

// SetCanaryPercentage sets the CanaryPercentage field's value.
func (s *TimeBasedCanary) SetCanaryPercentage(v int64) *TimeBasedCanary {
	s.CanaryPercentage = &v
	return s
}

// A configuration that shifts traffic from one version of a Lambda function
// to another in equal increments, with an equal number of minutes between each
// increment. The original and target Lambda function versions are specified
// in the deployment's AppSpec file.
type TimeBasedLinear struct {
	_ struct{} `type:"structure"`

	// The number of minutes between each incremental traffic shift of a TimeBasedLinear
	// deployment.
	LinearInterval *int64 `locationName:"linearInterval" type:"integer"`

	// The percentage of traffic that is shifted at the start of each increment
	// of a TimeBasedLinear deployment.
	LinearPercentage *int64 `locationName:"linearPercentage" type:"integer"`
}

// String returns the string representation
func (s TimeBasedLinear) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeBasedLinear) GoString() string {
	return s.String()
}

// SetLinearInterval sets the LinearInterval field's value.
func (s *TimeBasedLinear) SetLinearInterval(v int64) *TimeBasedLinear {
	s.LinearInterval = &v
	return s
}

// SetLinearPercentage sets the LinearPercentage field's value.
func (s *TimeBasedLinear) SetLinearPercentage(v int64) *TimeBasedLinear {
	s.LinearPercentage = &v
	return s
}

// Information about a time range.
type TimeRange struct {
	_ struct{} `type:"structure"`

	// The end time of the time range.
	//
	// Specify null to leave the end time open-ended.
	End *time.Time `locationName:"end" type:"timestamp" timestampFormat:"unix"`

	// The start time of the time range.
	//
	// Specify null to leave the start time open-ended.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeRange) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *TimeRange) SetEnd(v time.Time) *TimeRange {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *TimeRange) SetStart(v time.Time) *TimeRange {
	s.Start = &v
	return s
}

// The configuration that specifies how traffic is shifted from one version
// of a Lambda function to another version during an AWS Lambda deployment.
type TrafficRoutingConfig struct {
	_ struct{} `type:"structure"`

	// A configuration that shifts traffic from one version of a Lambda function
	// to another in two increments. The original and target Lambda function versions
	// are specified in the deployment's AppSpec file.
	TimeBasedCanary *TimeBasedCanary `locationName:"timeBasedCanary" type:"structure"`

	// A configuration that shifts traffic from one version of a Lambda function
	// to another in equal increments, with an equal number of minutes between each
	// increment. The original and target Lambda function versions are specified
	// in the deployment's AppSpec file.
	TimeBasedLinear *TimeBasedLinear `locationName:"timeBasedLinear" type:"structure"`

	// The type of traffic shifting (TimeBasedCanary or TimeBasedLinear) used by
	// a deployment configuration .
	Type *string `locationName:"type" type:"string" enum:"TrafficRoutingType"`
}

// String returns the string representation
func (s TrafficRoutingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficRoutingConfig) GoString() string {
	return s.String()
}

// SetTimeBasedCanary sets the TimeBasedCanary field's value.
func (s *TrafficRoutingConfig) SetTimeBasedCanary(v *TimeBasedCanary) *TrafficRoutingConfig {
	s.TimeBasedCanary = v
	return s
}

// SetTimeBasedLinear sets the TimeBasedLinear field's value.
func (s *TrafficRoutingConfig) SetTimeBasedLinear(v *TimeBasedLinear) *TrafficRoutingConfig {
	s.TimeBasedLinear = v
	return s
}

// SetType sets the Type field's value.
func (s *TrafficRoutingConfig) SetType(v string) *TrafficRoutingConfig {
	s.Type = &v
	return s
}

// Information about notification triggers for the deployment group.
type TriggerConfig struct {
	_ struct{} `type:"structure"`

	// The event type or types for which notifications are triggered.
	TriggerEvents []*string `locationName:"triggerEvents" type:"list"`

	// The name of the notification trigger.
	TriggerName *string `locationName:"triggerName" type:"string"`

	// The ARN of the Amazon Simple Notification Service topic through which notifications
	// about deployment or instance events are sent.
	TriggerTargetArn *string `locationName:"triggerTargetArn" type:"string"`
}

// String returns the string representation
func (s TriggerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TriggerConfig) GoString() string {
	return s.String()
}

// SetTriggerEvents sets the TriggerEvents field's value.
func (s *TriggerConfig) SetTriggerEvents(v []*string) *TriggerConfig {
	s.TriggerEvents = v
	return s
}

// SetTriggerName sets the TriggerName field's value.
func (s *TriggerConfig) SetTriggerName(v string) *TriggerConfig {
	s.TriggerName = &v
	return s
}

// SetTriggerTargetArn sets the TriggerTargetArn field's value.
func (s *TriggerConfig) SetTriggerTargetArn(v string) *TriggerConfig {
	s.TriggerTargetArn = &v
	return s
}

// Represents the input of an UpdateApplication operation.
type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The current name of the application you want to change.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// The new name to give the application.
	NewApplicationName *string `locationName:"newApplicationName" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.NewApplicationName != nil && len(*s.NewApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationInput) SetApplicationName(v string) *UpdateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetNewApplicationName sets the NewApplicationName field's value.
func (s *UpdateApplicationInput) SetNewApplicationName(v string) *UpdateApplicationInput {
	s.NewApplicationName = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of an UpdateDeploymentGroup operation.
type UpdateDeploymentGroupInput struct {
	_ struct{} `type:"structure"`

	// Information to add or change about Amazon CloudWatch alarms when the deployment
	// group is updated.
	AlarmConfiguration *AlarmConfiguration `locationName:"alarmConfiguration" type:"structure"`

	// The application name corresponding to the deployment group to update.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Information for an automatic rollback configuration that is added or changed
	// when a deployment group is updated.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// The replacement list of Auto Scaling groups to be included in the deployment
	// group, if you want to change them. To keep the Auto Scaling groups, enter
	// their names. To remove Auto Scaling groups, do not enter any Auto Scaling
	// group names.
	AutoScalingGroups []*string `locationName:"autoScalingGroups" type:"list"`

	// Information about blue/green deployment options for a deployment group.
	BlueGreenDeploymentConfiguration *BlueGreenDeploymentConfiguration `locationName:"blueGreenDeploymentConfiguration" type:"structure"`

	// The current name of the deployment group.
	//
	// CurrentDeploymentGroupName is a required field
	CurrentDeploymentGroupName *string `locationName:"currentDeploymentGroupName" min:"1" type:"string" required:"true"`

	// The replacement deployment configuration name to use, if you want to change
	// it.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// Information about the type of deployment, either in-place or blue/green,
	// you want to run and whether to route deployment traffic behind a load balancer.
	DeploymentStyle *DeploymentStyle `locationName:"deploymentStyle" type:"structure"`

	// The replacement set of Amazon EC2 tags on which to filter, if you want to
	// change them. To keep the existing tags, enter their names. To remove tags,
	// do not enter any tag names.
	Ec2TagFilters []*EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// Information about groups of tags applied to on-premises instances. The deployment
	// group will include only EC2 instances identified by all the tag groups.
	Ec2TagSet *EC2TagSet `locationName:"ec2TagSet" type:"structure"`

	// Information about the load balancer used in a deployment.
	LoadBalancerInfo *LoadBalancerInfo `locationName:"loadBalancerInfo" type:"structure"`

	// The new name of the deployment group, if you want to change it.
	NewDeploymentGroupName *string `locationName:"newDeploymentGroupName" min:"1" type:"string"`

	// The replacement set of on-premises instance tags on which to filter, if you
	// want to change them. To keep the existing tags, enter their names. To remove
	// tags, do not enter any tag names.
	OnPremisesInstanceTagFilters []*TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// Information about an on-premises instance tag set. The deployment group will
	// include only on-premises instances identified by all the tag groups.
	OnPremisesTagSet *OnPremisesTagSet `locationName:"onPremisesTagSet" type:"structure"`

	// A replacement ARN for the service role, if you want to change it.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// Information about triggers to change when the deployment group is updated.
	// For examples, see Modify Triggers in an AWS CodeDeploy Deployment Group (http://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html)
	// in the AWS CodeDeploy User Guide.
	TriggerConfigurations []*TriggerConfig `locationName:"triggerConfigurations" type:"list"`
}

// String returns the string representation
func (s UpdateDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeploymentGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeploymentGroupInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentDeploymentGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentDeploymentGroupName"))
	}
	if s.CurrentDeploymentGroupName != nil && len(*s.CurrentDeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentDeploymentGroupName", 1))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentConfigName", 1))
	}
	if s.NewDeploymentGroupName != nil && len(*s.NewDeploymentGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewDeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarmConfiguration sets the AlarmConfiguration field's value.
func (s *UpdateDeploymentGroupInput) SetAlarmConfiguration(v *AlarmConfiguration) *UpdateDeploymentGroupInput {
	s.AlarmConfiguration = v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateDeploymentGroupInput) SetApplicationName(v string) *UpdateDeploymentGroupInput {
	s.ApplicationName = &v
	return s
}

// SetAutoRollbackConfiguration sets the AutoRollbackConfiguration field's value.
func (s *UpdateDeploymentGroupInput) SetAutoRollbackConfiguration(v *AutoRollbackConfiguration) *UpdateDeploymentGroupInput {
	s.AutoRollbackConfiguration = v
	return s
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *UpdateDeploymentGroupInput) SetAutoScalingGroups(v []*string) *UpdateDeploymentGroupInput {
	s.AutoScalingGroups = v
	return s
}

// SetBlueGreenDeploymentConfiguration sets the BlueGreenDeploymentConfiguration field's value.
func (s *UpdateDeploymentGroupInput) SetBlueGreenDeploymentConfiguration(v *BlueGreenDeploymentConfiguration) *UpdateDeploymentGroupInput {
	s.BlueGreenDeploymentConfiguration = v
	return s
}

// SetCurrentDeploymentGroupName sets the CurrentDeploymentGroupName field's value.
func (s *UpdateDeploymentGroupInput) SetCurrentDeploymentGroupName(v string) *UpdateDeploymentGroupInput {
	s.CurrentDeploymentGroupName = &v
	return s
}

// SetDeploymentConfigName sets the DeploymentConfigName field's value.
func (s *UpdateDeploymentGroupInput) SetDeploymentConfigName(v string) *UpdateDeploymentGroupInput {
	s.DeploymentConfigName = &v
	return s
}

// SetDeploymentStyle sets the DeploymentStyle field's value.
func (s *UpdateDeploymentGroupInput) SetDeploymentStyle(v *DeploymentStyle) *UpdateDeploymentGroupInput {
	s.DeploymentStyle = v
	return s
}

// SetEc2TagFilters sets the Ec2TagFilters field's value.
func (s *UpdateDeploymentGroupInput) SetEc2TagFilters(v []*EC2TagFilter) *UpdateDeploymentGroupInput {
	s.Ec2TagFilters = v
	return s
}

// SetEc2TagSet sets the Ec2TagSet field's value.
func (s *UpdateDeploymentGroupInput) SetEc2TagSet(v *EC2TagSet) *UpdateDeploymentGroupInput {
	s.Ec2TagSet = v
	return s
}

// SetLoadBalancerInfo sets the LoadBalancerInfo field's value.
func (s *UpdateDeploymentGroupInput) SetLoadBalancerInfo(v *LoadBalancerInfo) *UpdateDeploymentGroupInput {
	s.LoadBalancerInfo = v
	return s
}

// SetNewDeploymentGroupName sets the NewDeploymentGroupName field's value.
func (s *UpdateDeploymentGroupInput) SetNewDeploymentGroupName(v string) *UpdateDeploymentGroupInput {
	s.NewDeploymentGroupName = &v
	return s
}

// SetOnPremisesInstanceTagFilters sets the OnPremisesInstanceTagFilters field's value.
func (s *UpdateDeploymentGroupInput) SetOnPremisesInstanceTagFilters(v []*TagFilter) *UpdateDeploymentGroupInput {
	s.OnPremisesInstanceTagFilters = v
	return s
}

// SetOnPremisesTagSet sets the OnPremisesTagSet field's value.
func (s *UpdateDeploymentGroupInput) SetOnPremisesTagSet(v *OnPremisesTagSet) *UpdateDeploymentGroupInput {
	s.OnPremisesTagSet = v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *UpdateDeploymentGroupInput) SetServiceRoleArn(v string) *UpdateDeploymentGroupInput {
	s.ServiceRoleArn = &v
	return s
}

// SetTriggerConfigurations sets the TriggerConfigurations field's value.
func (s *UpdateDeploymentGroupInput) SetTriggerConfigurations(v []*TriggerConfig) *UpdateDeploymentGroupInput {
	s.TriggerConfigurations = v
	return s
}

// Represents the output of an UpdateDeploymentGroup operation.
type UpdateDeploymentGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the output contains no data, and the corresponding deployment group contained
	// at least one Auto Scaling group, AWS CodeDeploy successfully removed all
	// corresponding Auto Scaling lifecycle event hooks from the AWS account. If
	// the output contains data, AWS CodeDeploy could not remove some Auto Scaling
	// lifecycle event hooks from the AWS account.
	HooksNotCleanedUp []*AutoScalingGroup `locationName:"hooksNotCleanedUp" type:"list"`
}

// String returns the string representation
func (s UpdateDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentGroupOutput) GoString() string {
	return s.String()
}

// SetHooksNotCleanedUp sets the HooksNotCleanedUp field's value.
func (s *UpdateDeploymentGroupOutput) SetHooksNotCleanedUp(v []*AutoScalingGroup) *UpdateDeploymentGroupOutput {
	s.HooksNotCleanedUp = v
	return s
}

const (
	// ApplicationRevisionSortByRegisterTime is a ApplicationRevisionSortBy enum value
	ApplicationRevisionSortByRegisterTime = "registerTime"

	// ApplicationRevisionSortByFirstUsedTime is a ApplicationRevisionSortBy enum value
	ApplicationRevisionSortByFirstUsedTime = "firstUsedTime"

	// ApplicationRevisionSortByLastUsedTime is a ApplicationRevisionSortBy enum value
	ApplicationRevisionSortByLastUsedTime = "lastUsedTime"
)

const (
	// AutoRollbackEventDeploymentFailure is a AutoRollbackEvent enum value
	AutoRollbackEventDeploymentFailure = "DEPLOYMENT_FAILURE"

	// AutoRollbackEventDeploymentStopOnAlarm is a AutoRollbackEvent enum value
	AutoRollbackEventDeploymentStopOnAlarm = "DEPLOYMENT_STOP_ON_ALARM"

	// AutoRollbackEventDeploymentStopOnRequest is a AutoRollbackEvent enum value
	AutoRollbackEventDeploymentStopOnRequest = "DEPLOYMENT_STOP_ON_REQUEST"
)

const (
	// BundleTypeTar is a BundleType enum value
	BundleTypeTar = "tar"

	// BundleTypeTgz is a BundleType enum value
	BundleTypeTgz = "tgz"

	// BundleTypeZip is a BundleType enum value
	BundleTypeZip = "zip"

	// BundleTypeYaml is a BundleType enum value
	BundleTypeYaml = "YAML"

	// BundleTypeJson is a BundleType enum value
	BundleTypeJson = "JSON"
)

const (
	// ComputePlatformServer is a ComputePlatform enum value
	ComputePlatformServer = "Server"

	// ComputePlatformLambda is a ComputePlatform enum value
	ComputePlatformLambda = "Lambda"
)

const (
	// DeploymentCreatorUser is a DeploymentCreator enum value
	DeploymentCreatorUser = "user"

	// DeploymentCreatorAutoscaling is a DeploymentCreator enum value
	DeploymentCreatorAutoscaling = "autoscaling"

	// DeploymentCreatorCodeDeployRollback is a DeploymentCreator enum value
	DeploymentCreatorCodeDeployRollback = "codeDeployRollback"
)

const (
	// DeploymentOptionWithTrafficControl is a DeploymentOption enum value
	DeploymentOptionWithTrafficControl = "WITH_TRAFFIC_CONTROL"

	// DeploymentOptionWithoutTrafficControl is a DeploymentOption enum value
	DeploymentOptionWithoutTrafficControl = "WITHOUT_TRAFFIC_CONTROL"
)

const (
	// DeploymentReadyActionContinueDeployment is a DeploymentReadyAction enum value
	DeploymentReadyActionContinueDeployment = "CONTINUE_DEPLOYMENT"

	// DeploymentReadyActionStopDeployment is a DeploymentReadyAction enum value
	DeploymentReadyActionStopDeployment = "STOP_DEPLOYMENT"
)

const (
	// DeploymentStatusCreated is a DeploymentStatus enum value
	DeploymentStatusCreated = "Created"

	// DeploymentStatusQueued is a DeploymentStatus enum value
	DeploymentStatusQueued = "Queued"

	// DeploymentStatusInProgress is a DeploymentStatus enum value
	DeploymentStatusInProgress = "InProgress"

	// DeploymentStatusSucceeded is a DeploymentStatus enum value
	DeploymentStatusSucceeded = "Succeeded"

	// DeploymentStatusFailed is a DeploymentStatus enum value
	DeploymentStatusFailed = "Failed"

	// DeploymentStatusStopped is a DeploymentStatus enum value
	DeploymentStatusStopped = "Stopped"

	// DeploymentStatusReady is a DeploymentStatus enum value
	DeploymentStatusReady = "Ready"
)

const (
	// DeploymentTypeInPlace is a DeploymentType enum value
	DeploymentTypeInPlace = "IN_PLACE"

	// DeploymentTypeBlueGreen is a DeploymentType enum value
	DeploymentTypeBlueGreen = "BLUE_GREEN"
)

const (
	// EC2TagFilterTypeKeyOnly is a EC2TagFilterType enum value
	EC2TagFilterTypeKeyOnly = "KEY_ONLY"

	// EC2TagFilterTypeValueOnly is a EC2TagFilterType enum value
	EC2TagFilterTypeValueOnly = "VALUE_ONLY"

	// EC2TagFilterTypeKeyAndValue is a EC2TagFilterType enum value
	EC2TagFilterTypeKeyAndValue = "KEY_AND_VALUE"
)

const (
	// ErrorCodeDeploymentGroupMissing is a ErrorCode enum value
	ErrorCodeDeploymentGroupMissing = "DEPLOYMENT_GROUP_MISSING"

	// ErrorCodeApplicationMissing is a ErrorCode enum value
	ErrorCodeApplicationMissing = "APPLICATION_MISSING"

	// ErrorCodeRevisionMissing is a ErrorCode enum value
	ErrorCodeRevisionMissing = "REVISION_MISSING"

	// ErrorCodeIamRoleMissing is a ErrorCode enum value
	ErrorCodeIamRoleMissing = "IAM_ROLE_MISSING"

	// ErrorCodeIamRolePermissions is a ErrorCode enum value
	ErrorCodeIamRolePermissions = "IAM_ROLE_PERMISSIONS"

	// ErrorCodeNoEc2Subscription is a ErrorCode enum value
	ErrorCodeNoEc2Subscription = "NO_EC2_SUBSCRIPTION"

	// ErrorCodeOverMaxInstances is a ErrorCode enum value
	ErrorCodeOverMaxInstances = "OVER_MAX_INSTANCES"

	// ErrorCodeNoInstances is a ErrorCode enum value
	ErrorCodeNoInstances = "NO_INSTANCES"

	// ErrorCodeTimeout is a ErrorCode enum value
	ErrorCodeTimeout = "TIMEOUT"

	// ErrorCodeHealthConstraintsInvalid is a ErrorCode enum value
	ErrorCodeHealthConstraintsInvalid = "HEALTH_CONSTRAINTS_INVALID"

	// ErrorCodeHealthConstraints is a ErrorCode enum value
	ErrorCodeHealthConstraints = "HEALTH_CONSTRAINTS"

	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "INTERNAL_ERROR"

	// ErrorCodeThrottled is a ErrorCode enum value
	ErrorCodeThrottled = "THROTTLED"

	// ErrorCodeAlarmActive is a ErrorCode enum value
	ErrorCodeAlarmActive = "ALARM_ACTIVE"

	// ErrorCodeAgentIssue is a ErrorCode enum value
	ErrorCodeAgentIssue = "AGENT_ISSUE"

	// ErrorCodeAutoScalingIamRolePermissions is a ErrorCode enum value
	ErrorCodeAutoScalingIamRolePermissions = "AUTO_SCALING_IAM_ROLE_PERMISSIONS"

	// ErrorCodeAutoScalingConfiguration is a ErrorCode enum value
	ErrorCodeAutoScalingConfiguration = "AUTO_SCALING_CONFIGURATION"

	// ErrorCodeManualStop is a ErrorCode enum value
	ErrorCodeManualStop = "MANUAL_STOP"

	// ErrorCodeMissingBlueGreenDeploymentConfiguration is a ErrorCode enum value
	ErrorCodeMissingBlueGreenDeploymentConfiguration = "MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION"

	// ErrorCodeMissingElbInformation is a ErrorCode enum value
	ErrorCodeMissingElbInformation = "MISSING_ELB_INFORMATION"

	// ErrorCodeMissingGithubToken is a ErrorCode enum value
	ErrorCodeMissingGithubToken = "MISSING_GITHUB_TOKEN"

	// ErrorCodeElasticLoadBalancingInvalid is a ErrorCode enum value
	ErrorCodeElasticLoadBalancingInvalid = "ELASTIC_LOAD_BALANCING_INVALID"

	// ErrorCodeElbInvalidInstance is a ErrorCode enum value
	ErrorCodeElbInvalidInstance = "ELB_INVALID_INSTANCE"

	// ErrorCodeInvalidLambdaConfiguration is a ErrorCode enum value
	ErrorCodeInvalidLambdaConfiguration = "INVALID_LAMBDA_CONFIGURATION"

	// ErrorCodeInvalidLambdaFunction is a ErrorCode enum value
	ErrorCodeInvalidLambdaFunction = "INVALID_LAMBDA_FUNCTION"

	// ErrorCodeHookExecutionFailure is a ErrorCode enum value
	ErrorCodeHookExecutionFailure = "HOOK_EXECUTION_FAILURE"
)

const (
	// FileExistsBehaviorDisallow is a FileExistsBehavior enum value
	FileExistsBehaviorDisallow = "DISALLOW"

	// FileExistsBehaviorOverwrite is a FileExistsBehavior enum value
	FileExistsBehaviorOverwrite = "OVERWRITE"

	// FileExistsBehaviorRetain is a FileExistsBehavior enum value
	FileExistsBehaviorRetain = "RETAIN"
)

const (
	// GreenFleetProvisioningActionDiscoverExisting is a GreenFleetProvisioningAction enum value
	GreenFleetProvisioningActionDiscoverExisting = "DISCOVER_EXISTING"

	// GreenFleetProvisioningActionCopyAutoScalingGroup is a GreenFleetProvisioningAction enum value
	GreenFleetProvisioningActionCopyAutoScalingGroup = "COPY_AUTO_SCALING_GROUP"
)

const (
	// InstanceActionTerminate is a InstanceAction enum value
	InstanceActionTerminate = "TERMINATE"

	// InstanceActionKeepAlive is a InstanceAction enum value
	InstanceActionKeepAlive = "KEEP_ALIVE"
)

const (
	// InstanceStatusPending is a InstanceStatus enum value
	InstanceStatusPending = "Pending"

	// InstanceStatusInProgress is a InstanceStatus enum value
	InstanceStatusInProgress = "InProgress"

	// InstanceStatusSucceeded is a InstanceStatus enum value
	InstanceStatusSucceeded = "Succeeded"

	// InstanceStatusFailed is a InstanceStatus enum value
	InstanceStatusFailed = "Failed"

	// InstanceStatusSkipped is a InstanceStatus enum value
	InstanceStatusSkipped = "Skipped"

	// InstanceStatusUnknown is a InstanceStatus enum value
	InstanceStatusUnknown = "Unknown"

	// InstanceStatusReady is a InstanceStatus enum value
	InstanceStatusReady = "Ready"
)

const (
	// InstanceTypeBlue is a InstanceType enum value
	InstanceTypeBlue = "Blue"

	// InstanceTypeGreen is a InstanceType enum value
	InstanceTypeGreen = "Green"
)

const (
	// LifecycleErrorCodeSuccess is a LifecycleErrorCode enum value
	LifecycleErrorCodeSuccess = "Success"

	// LifecycleErrorCodeScriptMissing is a LifecycleErrorCode enum value
	LifecycleErrorCodeScriptMissing = "ScriptMissing"

	// LifecycleErrorCodeScriptNotExecutable is a LifecycleErrorCode enum value
	LifecycleErrorCodeScriptNotExecutable = "ScriptNotExecutable"

	// LifecycleErrorCodeScriptTimedOut is a LifecycleErrorCode enum value
	LifecycleErrorCodeScriptTimedOut = "ScriptTimedOut"

	// LifecycleErrorCodeScriptFailed is a LifecycleErrorCode enum value
	LifecycleErrorCodeScriptFailed = "ScriptFailed"

	// LifecycleErrorCodeUnknownError is a LifecycleErrorCode enum value
	LifecycleErrorCodeUnknownError = "UnknownError"
)

const (
	// LifecycleEventStatusPending is a LifecycleEventStatus enum value
	LifecycleEventStatusPending = "Pending"

	// LifecycleEventStatusInProgress is a LifecycleEventStatus enum value
	LifecycleEventStatusInProgress = "InProgress"

	// LifecycleEventStatusSucceeded is a LifecycleEventStatus enum value
	LifecycleEventStatusSucceeded = "Succeeded"

	// LifecycleEventStatusFailed is a LifecycleEventStatus enum value
	LifecycleEventStatusFailed = "Failed"

	// LifecycleEventStatusSkipped is a LifecycleEventStatus enum value
	LifecycleEventStatusSkipped = "Skipped"

	// LifecycleEventStatusUnknown is a LifecycleEventStatus enum value
	LifecycleEventStatusUnknown = "Unknown"
)

const (
	// ListStateFilterActionInclude is a ListStateFilterAction enum value
	ListStateFilterActionInclude = "include"

	// ListStateFilterActionExclude is a ListStateFilterAction enum value
	ListStateFilterActionExclude = "exclude"

	// ListStateFilterActionIgnore is a ListStateFilterAction enum value
	ListStateFilterActionIgnore = "ignore"
)

const (
	// MinimumHealthyHostsTypeHostCount is a MinimumHealthyHostsType enum value
	MinimumHealthyHostsTypeHostCount = "HOST_COUNT"

	// MinimumHealthyHostsTypeFleetPercent is a MinimumHealthyHostsType enum value
	MinimumHealthyHostsTypeFleetPercent = "FLEET_PERCENT"
)

const (
	// RegistrationStatusRegistered is a RegistrationStatus enum value
	RegistrationStatusRegistered = "Registered"

	// RegistrationStatusDeregistered is a RegistrationStatus enum value
	RegistrationStatusDeregistered = "Deregistered"
)

const (
	// RevisionLocationTypeS3 is a RevisionLocationType enum value
	RevisionLocationTypeS3 = "S3"

	// RevisionLocationTypeGitHub is a RevisionLocationType enum value
	RevisionLocationTypeGitHub = "GitHub"

	// RevisionLocationTypeString is a RevisionLocationType enum value
	RevisionLocationTypeString = "String"
)

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ascending"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "descending"
)

const (
	// StopStatusPending is a StopStatus enum value
	StopStatusPending = "Pending"

	// StopStatusSucceeded is a StopStatus enum value
	StopStatusSucceeded = "Succeeded"
)

const (
	// TagFilterTypeKeyOnly is a TagFilterType enum value
	TagFilterTypeKeyOnly = "KEY_ONLY"

	// TagFilterTypeValueOnly is a TagFilterType enum value
	TagFilterTypeValueOnly = "VALUE_ONLY"

	// TagFilterTypeKeyAndValue is a TagFilterType enum value
	TagFilterTypeKeyAndValue = "KEY_AND_VALUE"
)

const (
	// TrafficRoutingTypeTimeBasedCanary is a TrafficRoutingType enum value
	TrafficRoutingTypeTimeBasedCanary = "TimeBasedCanary"

	// TrafficRoutingTypeTimeBasedLinear is a TrafficRoutingType enum value
	TrafficRoutingTypeTimeBasedLinear = "TimeBasedLinear"

	// TrafficRoutingTypeAllAtOnce is a TrafficRoutingType enum value
	TrafficRoutingTypeAllAtOnce = "AllAtOnce"
)

const (
	// TriggerEventTypeDeploymentStart is a TriggerEventType enum value
	TriggerEventTypeDeploymentStart = "DeploymentStart"

	// TriggerEventTypeDeploymentSuccess is a TriggerEventType enum value
	TriggerEventTypeDeploymentSuccess = "DeploymentSuccess"

	// TriggerEventTypeDeploymentFailure is a TriggerEventType enum value
	TriggerEventTypeDeploymentFailure = "DeploymentFailure"

	// TriggerEventTypeDeploymentStop is a TriggerEventType enum value
	TriggerEventTypeDeploymentStop = "DeploymentStop"

	// TriggerEventTypeDeploymentRollback is a TriggerEventType enum value
	TriggerEventTypeDeploymentRollback = "DeploymentRollback"

	// TriggerEventTypeDeploymentReady is a TriggerEventType enum value
	TriggerEventTypeDeploymentReady = "DeploymentReady"

	// TriggerEventTypeInstanceStart is a TriggerEventType enum value
	TriggerEventTypeInstanceStart = "InstanceStart"

	// TriggerEventTypeInstanceSuccess is a TriggerEventType enum value
	TriggerEventTypeInstanceSuccess = "InstanceSuccess"

	// TriggerEventTypeInstanceFailure is a TriggerEventType enum value
	TriggerEventTypeInstanceFailure = "InstanceFailure"

	// TriggerEventTypeInstanceReady is a TriggerEventType enum value
	TriggerEventTypeInstanceReady = "InstanceReady"
)
