# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################

import os
import locale
import gettext
import gtk.glade
import utils
import version
from APTonCD.core import enum

def get_path(default,  destination):

    if not utils.pathExists(destination):
        return utils.normalizePath(default)
    else:
        return utils.normalizePath(destination)

APP_ICON_NAME = 'aptoncd'
APP_VERSION = version.APP_VERSION

# Internationalization variables
I18N_APP = 'aptoncd'
I18N_DIR = "/usr/share/locale/"

# ---- i18n ----
locale.setlocale(locale.LC_ALL, '')
gettext.bindtextdomain(I18N_APP, I18N_DIR)
gettext.textdomain(I18N_APP)

_ = gettext.gettext

gtk.glade.bindtextdomain(I18N_APP, I18N_DIR)
gtk.glade.textdomain(I18N_APP)
gettext.install(I18N_APP, I18N_DIR, unicode=1)

language = locale.setlocale(locale.LC_ALL, '')
end = language.find('.')
language = language[:end]

#Folder for configurarion file
CONFIG_DIR  = utils.mkdir(os.path.expanduser('~/.aptoncd/'))

#configuration file name
CONFIG_FILE  = os.path.join(CONFIG_DIR, 'config')

#Local base path, where aptoncd is located (runtime)
BASE_PATH = utils.normalizePath(os.curdir)

MAIN_GUI = get_path('/usr/share/aptoncd/glade/main_window.glade',  os.path.join(BASE_PATH ,'data/glade/main_window.glade'))
CREATE_GUI = get_path('/usr/share/aptoncd/glade/create_window.glade', os.path.join(BASE_PATH ,'data/glade/create_window.glade'))    
RESTORE_GUI = get_path('/usr/share/aptoncd/glade/restore_window.glade', os.path.join(BASE_PATH ,'data/glade/restore_window.glade'))
PROPERTY_GUI = get_path('/usr/share/aptoncd/glade/utils.glade', os.path.join(BASE_PATH ,'data/glade/utils.glade'))
BURNS_DATA = get_path('/usr/share/aptoncd/burners',  os.path.join(BASE_PATH ,'data/burners'))
COPY_SCRIPT = get_path('/usr/share/aptoncd/restorefiles.py',  os.path.join(BASE_PATH ,'restorefiles.py'))
MAIN_ANIMATION = get_path('/usr/share/aptoncd/loading.gif', os.path.join(BASE_PATH,'data/loading.gif'))	
DESKTOP_FILE = get_path('/usr/share/applications/aptoncd.desktop',  os.path.join(BASE_PATH,'data/aptoncd.desktop.in'))
# documentation directory
DOCDIR = get_path('doc/'+ language+ '/index.xml' , 'doc/'+ 'C/index.xml')

#Configuration constants
XML_FILE = os.path.join(CONFIG_DIR, 'conf.xml')
XML_CONTENTS_FILE = 'content.xml'

#Source folder for downloaded apt packages files
LOCAL_APT_FOLDER = "/var/cache/apt/archives/"
TEMP_FOLDER = "/tmp/"

#media size constants
CD = 695 * 1024 * 1024
DVD = 4500 * 1024 * 1024

RESTORE_TYPE = enum.EnumClass('RESTORE_TYPE',('RESTORE_FROM_ISO','RESTORE_FROM_MEDIA','RESTORE_FROM_NONE'))

MESSAGE_0001 =    _('Reading information of packages...')
MESSAGE_0002 =    _('Building list of packages')
MESSAGE_0003 =    _('Reading all packages from your cache, this could take\na long time, depending on number and size of packages.')
MESSAGE_0004 =    _('Package')
MESSAGE_0005 =    _('<b>Warning.</b>\n\nThe following package(s) is already in the list.')
MESSAGE_0006 =    _('Error')
#TRANSLATOR: the statusbar message while listing packages
MESSAGE_0007 =    _('<small>Total: %s/%s  .  Selected: %s/%s  .  Custom: %s/%s</small>')
MESSAGE_0008 =    _('Are you sure you want to remove the package below from the list?\n\n<b>%s</b>')
#TRANSLATOR: mark all checkboxes in the list
MESSAGE_0009 =    _('Check All')
#TRANSLATOR: unmark all checkboxes in the list
MESSAGE_0010 =    _('Uncheck All')
MESSAGE_0011 =    _('Invert selections')
MESSAGE_0012 =    _('Show Properties')
MESSAGE_0013 =    _('Select Package')
MESSAGE_0014 =    _('Select Folder')
MESSAGE_0015 =    _('Debian Packages')
MESSAGE_0016 =    _("APTonCD couldn't read the following package(s).\n"
                    '%s\n'
                    'The file is probably corrupted.\n'
                    'These packages will be listed but not marked to copy.\n'
                    'You can try to copy packages manually later.')
#TRANSLATOR: the packages was ignored and not listed                    
MESSAGE_0017 =    _('<b>Some packages are already in the list</b>\nThe following packages were skipped:\n')
MESSAGE_0018 =    _('The destination directory is not writable.\nPlease, select another destination directory and try again.')
#TRANSLATOR: creating the headers (Packages.gz) based on the packages information
MESSAGE_0019 =    _('Scanning and cataloguing packages...')
MESSAGE_0020 =    _('Copying packages')
MESSAGE_0021 =    _('Scanning packages')
MESSAGE_0022 =    _('Making the .iso image')
#TRANSLATOR: removing temporary packages and files
MESSAGE_0023 =    _('Cleaning session')
MESSAGE_0024 =    _("Creating APTonCD")
MESSAGE_0025 =    _('The installation disc is being created.\nYou can cancel this operation at any time.')
MESSAGE_0026 =    _('Version')
#TRANSLATOR: the user has cancelled the operation
MESSAGE_0027 =    _('Process canceled.')

MESSAGE_0029 =    _('Processing file %s')
MESSAGE_0030 =    _('<b><i>The metapackage could not be created.</i></b>\nThe reported error is shown below:\n%s')
MESSAGE_0031 =    _('<b><i>Error compressing Packages..</i></b>\nThe reported error is shown below:\n%s')
MESSAGE_0032 =    _('Making .iso for')
MESSAGE_0033 =    _('The image was successfully created, and it can be found in \n%s \n\nDo you want burn it now?')
MESSAGE_0034 =    _('The APTonCD .iso image was successfully created, and it can be found in\n%s')

#TRANSLATOR: write the files created into a CD or DVD
MESSAGE_0035 =    _('<b>Do you want to burn it now?</b>')

MESSAGE_0044 =    _('Processing installed packages, please wait.')
MESSAGE_0045 =    _("Checking package's versions")
MESSAGE_0046 =    _('Version: %s')
MESSAGE_0047 =    _('File Size: %s')

MESSAGE_0048 =    MESSAGE_0004 + ':   '
MESSAGE_0049 =    _('Summary: ')

MESSAGE_0050 =    _('Error loading package data.')
MESSAGE_0051 =    _('READ ERROR')
MESSAGE_0052 =    _("Processing...")
MESSAGE_0053 =    _('This process could take a long time.')
MESSAGE_0054 =    _('Please wait...')
MESSAGE_0055 =    _('remaining %i of %i packages')
MESSAGE_0056 =    _('Packages')
MESSAGE_0057 =    _('Folder')
MESSAGE_0058 =    _('Installed')
MESSAGE_0059 =    _('Not Installed')
MESSAGE_0060 =    _('Yes')
MESSAGE_0061 =    _('No')
MESSAGE_0062 =    _('Install')
MESSAGE_0063 =    _('Warning')
MESSAGE_0064 =    _("No help viewer is installed.\n"
        			"Install the GNOME help viewer (yelp) to view the APTonCD manual.")

MESSAGE_0065 =    _('You must specify the full path.')
MESSAGE_0066 =    _('Ready')
MESSAGE_0067 =    _("The CD/DVD is empty or it isn't a valid APTonCD medium. \nInsert an APTonCD medium into the drive.")
MESSAGE_0068 =    _('CD image file')
MESSAGE_0069 =    _("You need to select one source to restore files from.")
MESSAGE_0070 =    _("This media was created in an %s %s system, and is not suitable for your running system (%s %s).\nUsually might be a problem trying to install software that was not made for your distribution version.")
MESSAGE_0071 =    _("Are you sure want to continue?")
#TRANSLATOR: refers to properties of package X, as in "foo Properties"
MESSAGE_0072 =    _("Properties")
MESSAGE_0073 =    _("Restoring files")
MESSAGE_0074 =    _("The packages are being copied back to your cache.\nIt will not install any packages on your system.")
