/***************************************************************************
 $RCSfile: aqmxactionstore.h,v $
 -------------------
 cvs         : $Id: aqmxactionstore.h,v 1.1 2003/05/29 16:20:36 aquamaniac Exp $
 begin       : Thu May 29 2003
 copyright   : (C) 2003 by Martin Preuss
 email       : martin@aquamaniac.de
 */

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AQMXACTIONSTORE_H
#define AQMXACTIONSTORE_H

#include <openhbci.h>
using namespace HBCI;
#include <string>
#include <list>
using namespace std;
#include "aqmtypes.h"


/**
 *
 */
class TransactionStore {
private:
  unsigned int _lastTransactionId;

protected:
  unsigned int nextTransactionId();
  unsigned int lastTransactionId();
  void setLastTransactionId(unsigned int i);

public:
  TransactionStore();
  virtual ~TransactionStore();

  virtual list<AQMTransaction> findTransactions(const AQMTransaction &t,
						Date fromDate,
						Date toDate)=0;

  virtual Error removeTransactions(const AQMTransaction &t,
				   Date fromDate,
				   Date toDate)=0;
  virtual Error addTransaction(const AQMTransaction &t)=0;
  virtual AQMTransaction getTransaction(unsigned int id)=0;

};


#endif



