/***************************************************************************
 $RCSfile: disablekeys.cpp,v $
                             -------------------
    cvs         : $Id: disablekeys.cpp,v 1.4 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Wed Feb 19 2003
    copyright   : (C) 2003 by Fabian Kaiser
    email       : openhbci@derzach.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif




/*
 */

#include "disablekeys.h"


HBCI::Error disableKeys(HBCI::Pointer<AQMAPI> hbciif,
			HBCI::SimpleConfig &opt){
  HBCI::Pointer<HBCI::OutboxJob> job;
  HBCI::Tree<HBCI::ConfigNode>::iterator var;
  int country;
  string instid;
  string userid;
  int keyNumber;
  int keyVersion;
  HBCI::Error err;
  HBCI::Pointer<HBCI::User> user;
  HBCI::Pointer<HBCI::Customer> cust;

  job.setDescription("disableKeys:job (HBCI::OutboxJob)");
  country=opt.getIntVariable("country",280,opt.root());
  instid=opt.getVariable("instid","*",opt.root());
  userid=opt.getVariable("user","",opt.root());
  keyNumber=opt.getIntVariable("keynumber",0,opt.root());
  keyVersion=opt.getIntVariable("keyversion",0,opt.root());

  // get the user
  user = hbciif.ref().findUser(country, instid, userid);
  if (!user.isValid())
    return HBCI::Error("disableKeys()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "user not found");

  // we need the customer for creating the job
  cust = user.ref().customers().back();
  if (!cust.isValid())
    return HBCI::Error("disableKeys()",
		       ERROR_LEVEL_NORMAL,
		       0,
		       ERROR_ADVISE_DONTKNOW,
		       "customer not found");

  // create job
  if ( (0 == keyNumber) && (0 == keyVersion) ) {
    job=new HBCI::OutboxJobDisableKeys(hbciif.ptr(), cust);
  } else {
    job=new HBCI::OutboxJobDisableLostKeys(hbciif.ptr(), cust,
					   keyNumber, keyVersion);
  }

  // enqueue job
  hbciif.ref().addJob(job);


  try {
    // execute queue
    err=hbciif.ref().executeQueue(true);
  }
  catch (HBCI::Error lerr) {
    err=lerr;
  }

  return err;
}


