/***************************************************************************
 $RCSfile: resetseq.cpp,v $
                             -------------------
    cvs         : $Id: resetseq.cpp,v 1.5 2003/05/18 03:02:12 aquamaniac Exp $
    begin       : Sat Jan 26 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "resetseq.h"


HBCI::Error resetSeq(HBCI::Pointer<AQMAPI> hbciif,
		     HBCI::SimpleConfig &opt){
    HBCI::Pointer<HBCI::User> user;
    int country;
    string instid;
    string userid;
    HBCI::Error err;
    HBCI::Pointer<HBCI::Medium> medium;
    HBCI::Pointer<HBCI::MediumRDHBase> mediumRDH;
    HBCI::Pointer<HBCI::OutboxJob> job;

    try {
	country=opt.getIntVariable("country",280,opt.root());
	instid=opt.getVariable("instid","",opt.root());
	userid=opt.getVariable("user","",opt.root());


	if (country==0 ||
	    instid.empty() ||
	    userid.empty())
	    return HBCI::Error("resetSeq()",
			       ERROR_LEVEL_NORMAL,
			       0,
			       ERROR_ADVISE_DONTKNOW,
			       "I need at least country,institute, and user.");

	user=hbciif.ref().findUser(country,
				   instid,
			       userid);
	if (!user.isValid())
	    return HBCI::Error("resetSeq()",
			       ERROR_LEVEL_NORMAL,
			       0,
			       ERROR_ADVISE_DONTKNOW,
			       "user not found.");
	medium=user.ref().medium();
	if (!medium.isValid())
	    return HBCI::Error("resetSeq()",
			       ERROR_LEVEL_NORMAL,
			       0,
			       ERROR_ADVISE_DONTKNOW,
			       "user has no medium.");
        if (medium.ref().securityMode()!=HBCI_SECURITY_RDH)
	    return HBCI::Error("resetSeq()",
			       ERROR_LEVEL_NORMAL,
			       0,
			       ERROR_ADVISE_DONTKNOW,
			       "not a RDH medium");

	mediumRDH=medium.cast<HBCI::MediumRDHBase>();

	err=mediumRDH.ref().mountMedium(0);
	if (!err.isOk())
	    return HBCI::Error("resetSeq()",err);
	err=mediumRDH.ref().selectContext(country,instid,userid);
        if (!err.isOk())
	  return HBCI::Error("resetSeq()", err);

	mediumRDH.ref().resetSEQ();
	mediumRDH.ref().unmountMedium();
    } // try
    catch (HBCI::Error xerr) {
	return HBCI::Error("resetSeq()",xerr);
    }

    return err;

}

