{
(* Lexic *)
(* $Id: lexic.mll,v 1.3 2003/06/10 21:26:08 berke Exp $ *)

open Syntax

exception Parse_error of int * int * string

let lexical_error l s = raise (Parse_error(Lexing.lexeme_start l, Lexing.lexeme_end l,s))
}
let blancs = [' ' '\n' '\t' '\r']+
let alpha = ['a'-'z''A'-'Z']
let alphanum = alpha | ['0'-'9']
let decimaldigit = ['0'-'9']
let sign = '+'|'-'
let space = [' ''\t''\r''\n']
rule token = parse
(* Operators *)
(* Various non-alphabetic symbols *)
| "(" { LPAREN }
| ")" { RPAREN }
| "<>" { NEQ } 
| "!=" { NEQ }
| "=" { EQ }
| "<=" { LEQ }
| ">=" { GEQ }
| "<" { LT }
| ">" { GT }
| "=~" { MATCHES }
| "!~" { DOESNT_MATCH }
| "and" { AND }
| "or" { OR }
| "not" { NOT }
| "&" { AND }
| "|" { OR }
| "!" { NOT }
| "\"" { STRING(readstr lexbuf) }
| "/" { REGEXP(readregexp lexbuf) }
| "E" { EXISTS }
| "exists" { EXISTS }
| "A" { FORALL }
| "forall" { FORALL }
| "true" { TRUE }
| "false" { FALSE }
| (alphanum|'_'|'*')+ { STRING(Lexing.lexeme lexbuf) }
| decimaldigit+ { STRING(Lexing.lexeme lexbuf) }
(* Comments, space, strings and end of file *)
| "(*" { eat_comment lexbuf; token lexbuf }
| space+ { token lexbuf }
| eof { EOF }
| _ { lexical_error lexbuf
	(Printf.sprintf "Unexpected %S" (Lexing.lexeme lexbuf)) }
and eat_comment = parse
  "(*" { eat_comment lexbuf; eat_comment lexbuf }
| "*)" { }
| [^'(' '*']+ { eat_comment lexbuf }
| _ { eat_comment lexbuf }
and readstr = parse
  "\"" { "" }
| "\\\"" { "\""^(readstr lexbuf) }
| [^'"' '\\']+ { let s = Lexing.lexeme lexbuf in s^(readstr lexbuf) }
and readregexp = parse
  "/" { ("",readregexpoptions lexbuf) }
| "\\/" { let (s,o) = readregexp lexbuf in ("/"^s,o) }
| ([^'/' '\\']+ | '\\'[^'/'][^'/' '\\']*) { let s = Lexing.lexeme lexbuf in let (s',o) = readregexp lexbuf in (s^s',o) }
and readregexpoptions = parse
 (['w' 'i']*) {
    let w = Lexing.lexeme lexbuf in
    let rec loop r i =
      if i = String.length w then
        r
      else
        loop
          ((match w.[i] with
             'w' -> Ast.Word_boundary
           | 'i' -> Ast.Case_insensitive
           | _ -> assert false)::r)
          (i + 1)
    in
    loop [] 0 }
and readident = parse
  alpha (alphanum|'_')* { Lexing.lexeme lexbuf }
{
(* Epilogue. *)
}
