%{
(* Syntax *)
(* $Id: syntax.mly,v 1.2 2003/06/10 21:24:38 berke Exp $ *)
(* Prolog *)

open Ast

%}
%token EQ
%token NEQ
%token LEQ
%token GEQ
%token LT
%token GT
%token MATCHES
%token DOESNT_MATCH
%token LPAREN
%token RPAREN
%token EOF
%token AND
%token TRUE
%token FALSE
%token NOT
%token OR
%token EXISTS
%token FORALL
%token <string> STRING
%token <string * Ast.regexp_option list> REGEXP
%type <Ast.quantified Ast.boolean> quantified
%start quantified

%left OR
%left AND
%nonassoc NOT
%nonassoc EQ
%nonassoc NEQ
%nonassoc MATCHES
%nonassoc DOESNT_MATCH
%left LT
%left LEQ
%left GT
%left GEQ

%%
quantified :
| LPAREN quantified RPAREN { $2 }
| quantified AND quantified { And($1,$3) }
| quantified OR quantified { Or($1,$3) }
| NOT quantified { Not($2) }
| TRUE { True }
| FALSE { False }
| field MATCHES REGEXP { let (x,y) = $3 in Atom(Matches($1,Regular(x,y))) }
| field DOESNT_MATCH REGEXP { let (x,y) = $3 in Not(Atom(Matches($1,Regular(x,y)))) }
| field EQ STRING { Atom(Matches($1,Exact($3))) }
| field NEQ STRING { Not(Atom(Matches($1,Exact($3)))) }
| field LEQ STRING { Atom(Matches($1,Lexicographic_le($3))) }
| field GEQ STRING { Atom(Matches($1,Lexicographic_ge($3))) }
| field LT STRING {
  And(Not(Atom(Matches($1,Exact($3)))),Atom(Matches($1,Lexicographic_le($3)))) }
| field GT STRING {
  And(Not(Atom(Matches($1,Exact($3)))),Atom(Matches($1,Lexicographic_ge($3)))) }

field :
| STRING { 
  let w = $1 in
  try
    let m = String.length w in
    let b = Buffer.create m in
    Buffer.add_char b '^';
    for i = 0 to m - 1 do
      match w.[i] with
      | ('.'|'+'|'?'|'['|']'|'^'|'$'|'\\') as c -> Buffer.add_char b '\\'; Buffer.add_char b c
      | '*' -> Buffer.add_string b ".*"
      | c -> Buffer.add_char b c
    done;
    Buffer.add_char b '$';
    Some_field(Regular(Buffer.contents b,[Case_insensitive]))
  with
  | Not_found -> This_field($1) }
