.\" manual page [] for m4_ara()
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label
.TH m4_translit(m4_ara(),'a-z','A-Z') 1 "November 1, 2004"
.SH NAME
m4_ifelse(m4_ara, `ara',
`ara \- a utility for doing boolean regexp queries on the the Debian
package database',
`xara \- GTK2 interface for the above')

.SH SYNOPSIS

m4_ifelse(m4_ara, `ara',
`.SS
Batch mode:
.B ara
[options] query
.LP
In batch mode, \fBara\fP takes one or more queries as arguments, read the
database files according to its configuration, and outputs the results
to \fBstdout\fP.

.SS
Interactive mode:
.B ara [options]
\-i
.LP
With the \fB\-i\fP or \fB\-interactive\fP options, \fBara\fP reads the
database files and then prompts the user for queries or commands.
The results are displayed (with the help of a pager such as
\fBmore\fP or \fBless\fP if necessary), and \fBara\fP prompts the
user again.  Interactive mode is strongly recommended, since loading
the package databases can be long, but once loaded, queries run
quite fast.  This is a major advantage of \fBara\fP over tools
such as \fBdpkg\-iasearch\fP or \fBdpkg\-dctrl\fP.

For key bindings see \fBKEY BINDINGS\fP.
.SS
Graphical interface (GTK2):
A graphical interface, \fBxara(1)\fP, is provided by the Debian
package \fBxara-gtk\fP.',
`.SS
Graphical interface (GTK2):
.B xara
.LP
The graphical interface allows the user to input queries and browse
the results.  Menu options are provided for installing and removing
the selected packages using \fBapt\-get\fP.  The packages the user is
interested in may be bookmarked.

Command-line interface (GTK2):
A command-line interface, \fBara(1)\fP, is provided by the
Debian package \fBara\fP.')

.SS
Query syntax

See the \fBEXAMPLES\fP section for a quick introduction ; \fBxara\fP
has some built\-in help.  The syntax is described in detail below.

.SH DESCRIPTION
.LP
.B ara
and
.B xara
allow the user to search the Debian software package database
(which includes installed and uninstalled packages)
using powerful queries made of boolean combinations of
regular expressions acting on fields given by patterns.

For example, the query
\fB
section=utils & depends:(gtk or tk8 or xlibs or kde or gnome or qt) & debian & package
\fP
will display packages in the section \fButils\fP that have graphical
interfaces (because they depend on graphical toolkits or X11 libraries),
and whose description contains the words \fBdebian\fP and \fBpackage\fP.

.SH RATIONALE
.LP
Debian users can easily install software with the commands
\fBdselect\fP or \fBapt\-get install\fP.  They can choose
(on Debian 3.1 unstable) from over 30,000 packages.  Finding
the right package can be quite difficult.  Although packages
are categorized in crude sections, there are still too many
packages and reading all descriptions is out of the question.

The database files are huge and their mail\-like syntax makes them hard to
search with line\-oriented tools like grep.  There exist commands such as
\fBdpkg\-iasearch\fP(1) or \fBdpkg\-dctrl\fP(1) but their capabilities are
limited.  Graphical package management tools such as \fBaptitude\fP or
\fBsynaptic\fP have search capabilities.  Although \fBara\fP can call \fBapt\fP
to install or remove packages, its orientation is that of a powerful search
tool.  Indeed, the name \fBara\fP comes from the imperative form of the Turkish
verb \fBaramak\fP which means "to search".

.SH THE DEBIAN PACKAGE DATABASE
.LP
The database of Debian packages is a huge text file
at \fB/var/lib/dpkg/available\fP (or a collection of text
files under \fB/var/lib/apt/lists/\fP).  These files are
in a mailbox\-like format, and a typical entry looks like this:

.nf
Priority: required
Section: base
Installed\-Size: 460
Origin: debian
Maintainer: Dpkg Development <debian\-dpkg@lists.debian.org>
Bugs: debbugs://bugs.debian.org
Architecture: i386
Source: dpkg
Version: 1.10.24
Replaces: dpkg (<< 1.10.3)
Depends: libc6 (>= 2.3.2.ds1\-4), ....
Filename: pool/main/d/dpkg/dselect_1.10.24_i386.deb
Size: 119586
MD5sum: c740f7f68dab08badf4f60b51a33500a
Description: a user tool to manage Debian packages
 dselect is the primary user interface for installing, removing and
 managing Debian packages. It is a front\-end to dpkg.

.LP
Each package is thus described by a set of fields (like Package, Description, Version...).

.SH QUERY SYNTAX AND SEMANTICS
.LP
Here we describe the query syntax in some detail.  As of version 1.0,
\fBara\fP introduces new, simplified syntax which is quite traditional
and should be familiar to anyone having used search engines.  Search
terms are simply combined with \fBAND\fP, \fBOR\fP and \fBNOT\fP
boolean operators.  Having a look at the \fBEXAMPLES\fP section
at the end of this manual should provide you a starting point.

Consider the set \fBD\fP of Debian package descriptions contained in the file
\fB/var/lib/dpkg/available\fP (or in files under \fB/var/lib/apt/lists/\fP).
Each description is a set of couples of the form \fB(f,v)\fP where \fBf\fP and \fBv\fP
are strings: \fBf\fP is the name of the field (namely, \fBPackage\fP,
\fBDescription\fP, \fBFilename\fP, \fBDepends\fP, etc.); \fBv\fP is
its value.  Thus \fBD\fP is a set of set of couples, forming the universe.
Queries select subsets of the universe \fBD\fP.
Output options select which fields of the selected part of the universe
to display, and how to display them.

.SS
Queries
A \fBquery\fP is a boolean combination of atomic expressions.
An \fBatomic expression\fP selects a subset of the set \fBD\fP of descriptions.
I call this set the \fBmeaning\fP of the expression; if \fBe\fP
denotes an atomic expression, its meaning is denoted by \fB[e]\fP.
The meaning of a boolean combination of atomic expressions is just
the boolean combination of the meaning of its constituents.  In other
words, if \fBe1\fP and \fBe2\fP are atomic expressions, then
\fBe1 & e2\fP is a query, whose meaning is the intersection of the
meanings of \fBe1\fP and \fBe2\fP; and the meaning of \fBe1 | e2\fP
is the union of the meanings of \fBe1\fP and \fBe2\fP.

.SS
Atomic expressions
Atomic expressions can be of the forms
\fBpattern\fP, \fB/regexp/\fP, \fBquoted_string\fP,
\fBfieldspec operator1 string\fP,
or \fBfieldspec operator2 regexp\fP.

.SS
Boolean operators and constants

.TP
\fBe1 & e2\fP (also \fBe1 AND e2\fP, \fBe1 and e2\fP)
This is logical conjunction (set intersection).
Returns the intersection of [e1] and [e2], i.e. packages satisfying both e1 and e2.

.TP
\fBe1 | e2\fP (also \fBe1 OR e2\fP, \fBe1 or e2\fP)
This is logical disjunction (set union).
Union of [e1] and [e2], i.e. packages satisfying e1, e2 or both.

.TP
\fB!e1\fP (also \fBNOT e1\fP, \fBnot e1\fP)
This is logical negation (set complementation).
Complement of [e1], i.e. packages not satisfying e1.

Please note that \fB~\fP stands for the current default field specifier
and is not an alias for the complementation operator.

.TP
\fBtrue\fP (also \fBall\fP)
The set of all descriptions, i.e. all packages.

.TP
.B
\fBfalse\fP (also \fBnone\fP)
The empty set, i.e. no packages.

.SS
Field specifiers
A field specifier \fBfieldspec\fP is a comma\-separated list of field patterns.

Field patterns are like simple shell patterns and they may contain star
characters (which stand for anything) or question marks (which stand for
any single character).  They are case\-insensitive.  They specify a set
of fields.

For example \fBdescription\fP and \fBDescription\fP specify
the set of fields \fB{ Description }\fP, whereas
\fBde*\fP specifies \fB{ Description, Depends }\fP.

The special specifier \fB~\fP denotes the current default specifier
(see below).

.SS
Current fields specifiers and simplified atomic expressions
The need to repeat the field specifier can make the above syntax cumbersome.
That is why there is a \fBcurrent field specifier\fP.  The current field
specified is, by default, \fBDescription,Package\fP.  Simplified atomic
expressions are simply words or simplified shell expressions (which do
not need to be enclosed in double quotes) and they are searched in
fields in the current field specifier.  They can be made of letters,
digits, underscores, dashes and periods.  They may contain stars of
question marks which are interpreted as for field patterns (i.e., as
simplified shell expressions).  If double quotes are used, other
characters and spaces can be used.

The default field specifier in a query \fBquery\fP can be changed to
\fBfieldspec\fP by simply prefixing the query with \fBfieldspec:\fP.
This gives \fBfieldspec:query\fP.  However if \fBquery\fP is complex
(i.e., contains binary boolean operators) you need to enclose \fBquery\fP
in parentheses, as in \fBfieldspec:(query1 or query2)\fP.

.SS
String literals
\fBString literals\fP can be given with or without double quotes; without
double quotes, the syntax is as for C identifiers, except that you can use
dashes, you must start with a latin letter (\fB[a\-zA\-Z]\fP) and you can
continue with Latin letters, decimal digits or underscore
(\fB[a\-zA\-Z0\-9_]\fP).  Inside double quotes, all characters are allowed,
except double quotes, which must be preceded by a backslash.

.SS
Variables
Results of queries can be stored in variables, which may be recalled later.
This isn't very useful in batch mode but is useful in interactive and graphical
modes.

Variable names start with a dollar and follow usual conventions for variables,
i.e., they can be any mix of alphanumeric characters and symbols such as
underscore, dash, etc.

Variable names are case\-sensitive so that \fB$Installed\fP and \fB$installed\fP
are different.

To assign the result of a query (which is a set of packages) a variable named
\fB$variable\fP just execute the query \fB$variable := query\fP.  You may
then recall this particular set by simply writing \fB$variable\fP.

Example:
\fB$installed := status:(installed & !not\-installed)\fP

.SS
Operators
Hierarchical comparison operators can be negated by changing
the direction of the angle brackets and adding or removing
an equality sign at end (\fB<=\fP becomes \fB>\fP).
Other operators are negated as follows:
\fB=\fP becomes \fB!=\fP and
\fB=~\fB becomes \fB!~\fP.

.TP
.B
fieldspec=string
Atomic expression selecting packages having a field in \fBfieldspec\fP having a
value a value exactly equal to \fBstring\fP.

.TP
.B
fieldspec<string (fieldspec<=string, fieldspec>string, fieldspec>=string)
Atomic expression selecting packages having a field in \fBfieldspec\fP
whose value is strictly less than \fBstring\fP.  The order used is the
Debian versioning order.  This order is compatible with the natural order
on integers and with Debian version numbers.  When comparing strings
not containing special characters, letters sort before numbers, as opposed
to lexicographic ASCII order we are used to.  This means that
hexadecimal numbers (such as MD5 sums) will not have their usual order.

Note that \fBstring\fP must be on the right side of the operator (i.e.,
you cannot write \fB1000 < Size\fP).

.TP
\fBfieldspec=~/expression/\fP (also \fBfieldspec:/expression/\fP)
Selects descriptions whose field named \fBfieldspec\fP exists and whose value
matches, case\-sensitively, the regular expression \fBexpression\fP.

.TP
.B
\fBfieldspec=~/expression/i\fP (also \fBfieldspec:/expression/i\fP)
Same as above, but the regular expression is case\-insensitive.

.TP
.B
\fBfieldspec=~/expression/w\fP (also \fBfieldspec:/expression/w\fP)
Same as above, but the regular expression is case\-sensitive and matches only at
word boundaries.  Note that letters\-to\-digit or digit\-to\-letter transitions are
considered to be word boundaries.

.TP
.B
\fBfieldspec=~/expression/iw\fP (also \fBfieldspec:/expression/iw\fP)
The regular expression here is case\-insensitive and matched
at word boundaries.

.SS
Regular expressions
Regular expressions are given between a pair of slashes; the
last slash can be followed by a commutative sequence of letters
denoting flags.  Regular expression syntax is sed\-like:
grouping parentheses and alternation must be backslashed.  For
more details, see the Objective Caml manual chapter on the
Str module.  In short (\fBx\fP,\fBx1\fP,\fBx2\fP are meta\-symbols denoting
regular expressions):

.TP
.B
/./
Any character.

.TP
.B
/toto/
Literal string toto.

.TP
.B
/x1x2/
Concatenation.

.TP
.B
/x1\\|x2/
Alternation.

.TP
.B
\\(x1\\)*
Star closure.

.TP
.B
[c\-d]
Character range.

.TP
.B
\\b
Word boundaries.

.TP
.B
/x/i
Case insensitive.

.TP
.B
/x/w
At word boundaries.

.SS Remark
Most queries will contain an appreciable amount of shell metacharacters.  For example,
logical disjunction is denoted by the pipe character, which is used by all known shells.
The problem is aggravated by the fact that names of real commands are likely to appear
in the used expressions; successfully setting up a UNIX pipeline by error is therefore
plausible.

When calling \fBara\fP from the command line in batch mode, You are strongly
urged to protect your queries by surrounding them with simple quotes; never
write something like \fBara Pack*=~/halt|reboot|shutdown/\fP as this will very
likely reboot your system (and is incorrect regular expression syntax, if
\fBhalt\fP or \fBreboot\fP or \fBshutdown\fP is meant: pipes must be
backslashed).  Instead, one should write
.B
ara 'Pack*=~/halt\\|reboot\\|shutdown /'

.SH OPTIONS
m4_ifelse(m4_ara,`ara',
`.SS Operation
.TP
\fB\-interactive\fP, \fB\-i\fP
Interactive mode ; prompt for a query, display it.

.TP
\fB\-config <path>\fP (also for \fBxara\fP)
Set configuration file name (default \fB$HOME/.ara/ara.config\fP).

.TP
\fB\-noconfig\fP
Don`'t attempt to create a configuration file.

.TP
\fB\-nohistory\fP
Don`'t save command history

.SS Help options
.TP
\fB\-help\fP (also for \fBxara\fP)
Display some help

\fB\-about\fP
Display copyright, thanks and dedication.

.TP
\fB\-version\fP, \fB\-about\fP (also for \fBxara\fP)
Print author, license, version and dedication (and exit if called from CLI).

.TP
\fB\-examples\fP
Display some documentation including examples exit.

.TP
\fB\-q <query>\fP
Query (e.g., depends:xlibs & !package:xcalc).

.TP
\fB\-query <query>\fP
Ditto.

.SS Options pertaining to the terminal
.TP
\fB\-progress\fP (\fB\-noprogress\fP)
Show or don`'t show progress indicator when loading database.

.TP
\fB\-lines <height>\fP
Set height of terminal for interactive display.  By default
this is taken from the environment variable \fBLINES\fP
or as 25 if it is undefined.

.TP
\fB\-columns <width>\fP
Set width of terminal for interactive display.  By default
this is taken from the environment variable \fBCOLUMNS\fP
or as 25 if it is undefined.

.TP
\fB\-pager\fP (\fB\-nopager\fP)
Use (or don`'t use) a pager displaying long output in interactive mode.  The
pager command is defined in the configuration file \fB$HOME/.ara/ara.config\fP.
By default this is \fB/etc/alternatives/pager\fP.  The pager is only used when
the output size exceeds the terminal height.

.TP
\fB\-debug\fP (also for \fBxara\fP)
Enable debugging information

.TP
\fB\-debug\-level\fP (also for \fBxara\fP)
Set debugging level (higher is more verbose, max is 100, default is 10)

.SS Display styles
\fB\-new\fP
Show only newest version of each package.

.TP
\fB\-old\fP
List all versions of packages.

.TP
\fB\-short <query>\fP
Display names of packages satisfying query (and their version if \fB\-old\fP
is set), with multiple packages per line.

.TP
\fB\-list <query>\fP
Same, but display one package name per line, and no curly braces (default).

.TP
\fB\-raw <query>\fP
For each package satisfying the query, display all selected fields.

.TP
\fB\-table <query>\fP
Display results as a table.

.TP
\fB\-noborders\fP
Don`'t draw ASCII borders for tabular output.

.TP
\fB\-borders\fP
Draw ASCII borders for tabular output.

.TP
\fB\-count <query>\fP
Display number of matching packages.


.TP
\fB\-fields\fP <field_1[:width_1],...>
Limit output to specified fields.
The optional width specifiers are used with the \fB\-table\fP option and ignored otherwise.
Use * to display all fields (but remember to escape the star character from your shell).

.TP
\fB\-ast\fP
Dump the abstract syntax tree of parsed queries to stderr.',
`None.')

m4_ifelse(`m4_ara', `ara',
`.SH INTERACTIVE MODE
.SS General operation
Type your query and press enter.  \fBAra\fP will display packages matching your
query using the current display mode.  If the results are longer than what
your screen can handle, ara will pipe the output to a pager, which is
\fB/etc/alternatives/pager\fP by default.  Depending on your system, this will be
probably a link to \fB/usr/bin/less\fP or \fB/bin/more\fP : to quit the pager and
return to \fBara\fP, press `'q'`.

.SS Miscellaneous commands
.TP
\fB#syntax\fP
Displays help on syntax.

.TP
\fB#examples\fP
Displays some examples.

.TP
\fB#quit\fP, \fB#bye\fP, \fB#q\fP or \fBCTRL\-D\fP (EOF)
Quits \fBara\fP.

.TP
\fB#version\fP
To see version information.

.TP
\fB#about\fP
To see copyright, thanks and dedication.

.TP
\fB#reload\fP
To reload the database.

.TP
\fB#update\fP
To launch \fBapt\-get update\fP (type \fB#reload\fP afterwards).

.TP
\fB#shell\fP or \fB!\fP
To launch a shell.

.LP
.SS Display modes

In the following, if [query] is omitted, the default action mode is
changed instead :
.TP
\fB#short [query]\fP
to display results in short form

.TP
\fB#bourbaki [query]\fP
same

.TP
\fB#list [query]\fP
To display results as a list of package
(and version) names.

.TP
\fB#table [query]\fP
To display results as a table.

.TP
\fB#show [query]\fP
To show results in unformatted form.

.TP
\fB#raw [query]\fP
Same.

.TP
\fB#all [query]\fP
Same as above, but will always show all fields.

.TP
\fB#ast [query]\fP
To display the abstract syntax tree.

.TP
\fB#install [query]\fP
To install packages in query.  If a package is listed more than once, it
will only install the newest version.

.TP
\fB#remove [query]\fP
To remove packages in query.

.SS Redirection
Output from the commands \fB#short\fP, \fB#list\fP, \fB#table\fP, \fB#show\fP and \fB#ast\fP can
be redirected to a file as follows: (examples shown with \fB#short\fP)

.TP
\fB>/path/file #short [query]\fP
Will write output to file \fB/path/file\fP.

.TP
\fB>>/path/file #short [query]\fP
Will append output to file \fB/path/file\fP.

.TP
\fB>|/path/file #short [query]\fP
Will overwrite file \fB/path/file\fP with output.

.SS Key bindings
The line editor \fBledit(1)\fP has been incorporated into \fBara\fP.  Here
are its key bindings.

In the following lines, the caret sign "^" means "control" and the
sequence "M\-" means "meta" (either with the "meta" prefix, or by
pressing the "escape" key before). Examples:
.TP 1.0i
^a
press the "control" key, then press "a", then release "a", then
release "control".
.TP
M\-a
press the "meta" key, then press "a", then release "a", then release
"meta", or: press and release the "escape" key, then press and release
"a" (the manipulation with "meta" may not work in some systems: in
this case, use the manipulation with "escape").
.PP

The editing commands are:
.nf

      ^a   : beginning of line
      ^e   : end of line
      ^f   : forward char
      ^b   : backward char
      M\-f  : forward word
      M\-b  : backward word
      ^p   : previous line in history
      ^n   : next line in history
      M\-<  : first line in history
      M\->  : last line in history
      ^r   : reverse search in history (see below)
      ^d   : delete char (or EOF if the line is empty)
      ^h   : (or del or backspace) backward delete char
      ^t   : transpose chars
      M\-c  : capitalize word
      M\-u  : upcase word
      M\-l  : downcase word
      M\-d  : kill word
      M\-^h : (or M\-del or M\-backspace) backward kill word
      ^q   : insert next char
      M\-/  : expand abbreviation
      ^k   : cut until end of line
      ^y   : paste
      ^u   : line discard
      ^l   : clear screen
      ^g   : abort prefix
      ^c   : interrupt
      ^z   : suspend
      ^\\   : quit
      return : send line
      ^x     : send line and show next history line
      other  : insert char
.fi

The arrow keys can be used, providing your keyword returns standard key
sequences:
.nf

      up arrow    : previous line in history
      down arrow  : next line in history
      right arrow : forward char
      left arrow  : backward char

.SS Reverse search
The reverse search in incremental, i.e. \fIledit\fP backward searches in the
history a line holding the characters typed. If you type "a", it searches the
first line before the current line holding an "a" and displays it. If you then
type a "b", its search a line holding "ab", and so on. If you type ^h (or
backspace), it returns to the previous line found. To cancel the search,
type ^g. To find another line before holding the same string, type ^r.
To stop the editing and display the current line found, type "escape"
(other commands of the normal editing, different from ^h, ^g, and ^r stop
the editing too).

Summary of reverse search commands:
.nf

      ^g  : abort search
      ^r  : search previous same pattern
      ^h  : (or backspace) search without the last char
      del : search without the last char
      any other command : stop search and show the line found

.fi
',`')
m4_ifelse(m4_ara,`ara',
  `m4_define(`m4_example',`\fBara $1&apos;$2&apos;\fP')',
  `m4_define(`m4_example', `\fB$2\fP')')

.SH EXAMPLES
.TP
.B
m4_example(`',`Section=utils')
List the name of every package in section utils.

.TP
.B
m4_example(`',`Section=utils and !Depends:(gnome|kde|gtk)')
 ... except those whose dependency field matches the regexp gnome\\|kde\\|gtk

.TP
.B
m4_example(`\-list ', `Section=utils and Status:(installed & !not\-installed)')
List all installed packages in section \fButils\fP.

.TP
.B
m4_example(`\-short ', `section=utils and !depends:(gtk|gnome|kde) and priority=optional')
m4_ifelse(m4_ara,`ara',
` ... list multiple names per line, and show only optional packages.',
` ... show only optional packages.')

.TP
.B
m4_example(`\-short ',`section=utils & (!depends:(gtk|gnome|kde) | size<100000) & priority=optional')
Well, exclude gtk,gnome or kde stuff only if 100000 bytes or greater.

m4_ifelse(m4_ara, `ara',
`.TP
.nf
m4_example(`\-noborders \-fields Package,Size,Maintainer:20 \-table \\
\fB    \-short ',`section=utils & (!depends:(gtk|gnome|kde) | size<100000) & priority=optional')
\fP
.fi
.LP
 ... show Package, Size and Maintainer fields from the above results as a
nice ascii table, limiting the maintainer field to 20 characters, but without
crude ASCII borders.', `')

.TP
.nf
m4_example(`\-old \-fields Package:8,Size,Description:100 \\
\fB    \-table ',
`Section=games and not (Depends:(gtk|sdl|kde|opengl|gnome|qt)
\fB    or /shoot\\|kill\\|destroy\\|blast\\|race\\|bomb/iw
\fB    or /multi\\(\-\\|\\)player\\|strategy\\|conquest\\|3\\(\-\\|\\)d/iw)
\fB    and Depends:(xlibs or vga)
\fB    and Size <= 1000000')
\fP
.fi
.LP
m4_ifelse(m4_ara, `ara',
`Assuming a 125\-column display, display the first eight characters of the
package name, the size in bytes, and the first hundred characters of the
(first line) of the description of ',
`Display ')
all packages in the games section whose size does not exceeding one million
bytes, and which do not depend on fancy stuff like GTK, SDL, KDE, OpenGL,
Qt or Gnome, do not mention some form of violence (to shoot, to kill, etc.)
in their description, are not described as multi\-player, strategy,
conquest or three\-dimensional, and yet depend on either xlibs or svga to
exclude console\-based games.


.SH SPEED
.B
m4_ara
reads the whole database into memory and then processes queries. Since the
database is usually big, this takes some time. However, queries then run quite
fast. So specify multiple queries or use the \fB\-interactive\fP option to amortize
the cost of reading the database.

.SH LICENSE
.B m4_ara
is released under the GNU General Public License, version 2,
a copy of which is included in the source distribution.

.SH THANKS
Many thanks to George Danchev, Thomas Schoepf and Sven Luther for doing the
Debian packaging of ara and many helpful comments.

This program is dedicated to Lea Eleonor Amandine M.

.SH CONFIGURATION FILES
The system-wide configuration file for m4_ara is
\fB/etc/m4_ara.config\fP.  Its syntax is self-evident and
follows the Ocaml lexical conventions.

Values in the user-specific configuration file
\fB$HOME/.ara/m4_ara.config\fP
override those of \fB/etc/m4_ara.config\fP.

m4_ifelse(m4_ara,`ara',
`',
`The user configuration file can be edited from the \fBConfigure\fP
menu item in the \fBSettings\fP menu.  GUI parameters such as
window sizes and checkbox states are saved at exit in that file.')

.SH OTHER FILES

m4_ifelse(m4_ara,`ara',
`Command line history is saved in
\fB$HOME/.ara/ara.history\fP.',
`Bookmarks are saved into \fB$HOME/.ara/bookmarks\fP.
\fB$HOME/.ara/bookmarks\fP')

The following databases are loaded by default:

\fB/var/lib/dpkg/available\fP
.br
\fB/var/lib/dpkg/status\fP
.br
\fB/var/lib/apt/lists/*_Packages\fP

m4_ifelse(m4_ara,`ara',
`.SH ENVIRONMENT VARIABLES
In \fBara\fP the variables \fBLINES\fP and \fBCOLUMNS\fP are used to determine the
dimensions of the terminal.  Note that these variables are not exported by default
in your shell ; add \fBexport LINES COLUMNS\fP in your \fB.zshrc\fP or
\fB.bashrc\fP.', `')

.SH SEE ALSO
m4_ifelse(m4_ara,`ara', `\fBxara(1)\fP', `\fBara(1)\fP'),
\fBapt\fP(8),
\fBdpkg\fP(8),
\fBaptitude(8)\fP
\fBdselect\fP(8),
\fBgrep\-dctrl\fP(1),
\fBdpkg\-iasearch\fP(1),
\fBdpkg\-dctrl\fP(1),
\fBsynaptic(1)\fP.

.SH AUTHOR
Oguz Berke Durak <berke\-dev@ouvaton.org>
http://abaababa.ouvaton.org/ara/

m4_ifelse(m4_ara,`ara',
`.SH KNOWN BUGS
Due to lack of Unicode support, non\-ASCII characters lead to problems
under Unicode terminals.  Note that the database files are encoded
in Latin1.',`')

.br
