(in-package :araneida)

(define-condition http-error (condition)
  ((code :initarg :code :reader http-error-code)
   ;; message goes to error log, client-message goes to browser
   (message :initarg :message :initform nil :reader http-error-message)
   (client-message :initarg :client-message :initform nil 
		   :reader http-error-client-message)))

(macrolet ((def-http-err (number name)
	       `(define-condition ,name (http-error) 
		  ((code :initform ,number)))))
  (def-http-err 400 http-bad-request)
  (def-http-err 401 http-unauthorized)
  (def-http-err 402 http-payment-required)
  (def-http-err 403 http-forbidden)
  (def-http-err 404 http-not-found)
  (def-http-err 405 http-method-not-allowed)
  (def-http-err 406 http-not-acceptable)
  (def-http-err 407 http-proxy-authentication-required)
  (def-http-err 408 http-request-time-out)
  (def-http-err 409 http-conflict)
  (def-http-err 410 http-gone)
  (def-http-err 411 http-length-required)  
  (def-http-err 412 http-precondition-failed)
  (def-http-err 413 http-request-entity-too-large)
  (def-http-err 414 http-request-url-too-large)
  (def-http-err 415 http-unsupported-media-type)
  (def-http-err 500 http-internal-server-error)
  (def-http-err 501 http-not-implemented)
  (def-http-err 502 http-bad-gateway)
  (def-http-err 503 http-service-unavailable)
  (def-http-err 504 http-gateway-time-out)
  (def-http-err 505 http-version-not-supported))

