# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::Widget::FrameScroll;

use Glib qw(TRUE FALSE);
use Gtk2;

# actually, it would be just Gtk2::Bin, but that is abstract
use base qw(Gtk2::VBox);

sub new ($$;$$) {
	my $class = shift;
	my $widget = shift;
	my $frame_text = shift;
	my $use_scroll = shift;

	my $self = bless Gtk2::VBox->new, $class;
	$self->{the_widget} = $widget;

	if ($use_scroll) {
		my $scroll = Gtk2::ScrolledWindow->new;
      $scroll->set_policy('automatic', 'automatic');
      $scroll->add_with_viewport($widget);
		$widget = $scroll;
	}

	if (defined $frame_text) {
		my $frame = Gtk2::Frame->new(" $frame_text ");
		$frame->add($widget);
		$frame->set_border_width(3);
		$widget = $frame;
	}

#	$self->set_border_width(3);
	$self->add($widget);

	return $self;
}

our $AUTOLOAD;

sub AUTOLOAD ($@) {
	my $self = shift;
	my $method = $AUTOLOAD;

	# remove the package name
	$method =~ s/.*://;
	# DESTROY messages should never be propagated
	return if $method eq 'DESTROY';

	$method =~ s/^child_//;
	return $self->{the_widget}->$method(@_);
}

1;

__END__
