# -*- coding: iso-8859-15 -*-
# generated by wxGlade HG on Mon Jul  6 15:48:44 2009

#
# ClientSettingsDialog main window class
#

"""
Implements the client settings dialog.
"""

import wx

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode

# end wxGlade

import os, sys

from wx.lib.dialogs import *

class ClientSettingsDialog(wx.Dialog):
    """
    Client settings dialog class
    
    Displays settings for timeout, broker, automatic download and certificate information.
    """
    def __init__(self, *args, **kwds):
        """
        Class constructor
        """
        self.__applicationDir = os.path.dirname(sys.argv[0])

        if os.environ.has_key("ARCJOBTOOL_SHARE"):
            self.__imageDir = os.path.join(os.environ["ARCJOBTOOL_SHARE"], "images")
        else:
            self.__imageDir = os.path.join(self.__imageDir, "../share/arcjobtool/images")
        
        ARCGUI_SELECT_PATH = os.path.join(self.__imageDir, "folder-open.png")

        # begin wxGlade: ClientSettingsDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.settingsNotebook = wx.Notebook(self, -1, style=0)
        self.generalPane = wx.Panel(self.settingsNotebook, -1)
        self.timeoutLabel = wx.StaticText(self.generalPane, -1, "Timeout (s)")
        self.timeOutText = wx.TextCtrl(self.generalPane, -1, "40")
        self.brokerLabel = wx.StaticText(self.generalPane, -1, "Broker")
        self.brokerCombo = wx.ComboBox(self.generalPane, -1, choices=["Random"], style=wx.CB_DROPDOWN)
        self.processingPane = wx.Panel(self.settingsNotebook, -1)
        self.panel_3 = wx.Panel(self.processingPane, -1)
        self.automaticDownloadCheck = wx.CheckBox(self.panel_3, -1, "Automatic download to definition")
        self.downloadTimerIntervalLabel = wx.StaticText(self.panel_3, -1, "Download timer interval (s)")
        self.automaticDownloadIntervalSpin = wx.SpinCtrl(self.panel_3, -1, "120", min=10, max=3600)
        self.static_line_2 = wx.StaticLine(self.panel_3, -1)
        self.automaticUpdateCheck = wx.CheckBox(self.panel_3, -1, "Automatic update of job status")
        self.automaticUpdateIntervalLabel = wx.StaticText(self.panel_3, -1, "Update timer interval (s)")
        self.automaticUpdateIntervalSpin = wx.SpinCtrl(self.panel_3, -1, "60", min=10, max=3600)
        self.certificatesPane = wx.Panel(self.settingsNotebook, -1)
        self.userCertficiateLabel = wx.StaticText(self.certificatesPane, -1, "User certificate")
        self.userCertificateText = wx.TextCtrl(self.certificatesPane, -1, "")
        self.selectUserCertButton = wx.BitmapButton(self.certificatesPane, -1, wx.Bitmap(ARCGUI_SELECT_PATH,wx.BITMAP_TYPE_ANY))
        self.userKeyLabel = wx.StaticText(self.certificatesPane, -1, "User key")
        self.userKeyText = wx.TextCtrl(self.certificatesPane, -1, "")
        self.selectUserKeyButton = wx.BitmapButton(self.certificatesPane, -1, wx.Bitmap(ARCGUI_SELECT_PATH,wx.BITMAP_TYPE_ANY))
        self.CACertificateLabel = wx.StaticText(self.certificatesPane, -1, "CA Certificates")
        self.CACertificatesText = wx.TextCtrl(self.certificatesPane, -1, "")
        self.selectCACertDir = wx.BitmapButton(self.certificatesPane, -1, wx.Bitmap(ARCGUI_SELECT_PATH,wx.BITMAP_TYPE_ANY))
        self.proxyCertificateLabel = wx.StaticText(self.certificatesPane, -1, "Proxy certificate")
        self.proxyCertificateText = wx.TextCtrl(self.certificatesPane, -1, "")
        self.selectProxyCertButton = wx.BitmapButton(self.certificatesPane, -1, wx.Bitmap(ARCGUI_SELECT_PATH,wx.BITMAP_TYPE_ANY))
        self.okButton = wx.Button(self, -1, "OK")
        self.cancelButton = wx.Button(self, -1, "Cancel")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_CHECKBOX, self.onDownloadToDefinition, self.automaticDownloadCheck)
        self.Bind(wx.EVT_CHECKBOX, self.onUpdateStatus, self.automaticUpdateCheck)
        self.Bind(wx.EVT_BUTTON, self.onSelectUserCert, self.selectUserCertButton)
        self.Bind(wx.EVT_BUTTON, self.onSelectUserKey, self.selectUserKeyButton)
        self.Bind(wx.EVT_BUTTON, self.onSelectCaDir, self.selectCACertDir)
        self.Bind(wx.EVT_BUTTON, self.onSelectProxyCert, self.selectProxyCertButton)
        self.Bind(wx.EVT_BUTTON, self.onOK, self.okButton)
        self.Bind(wx.EVT_BUTTON, self.onCancel, self.cancelButton)
        # end wxGlade
        
        self.__initDialog()

    def __set_properties(self):
        # begin wxGlade: ClientSettingsDialog.__set_properties
        self.SetTitle("Client settings")
        self.SetSize((459, 316))
        self.timeoutLabel.SetMinSize((120, -1))
        self.brokerLabel.SetMinSize((120, -1))
        self.brokerCombo.SetSelection(-1)
        self.automaticUpdateCheck.SetValue(1)
        self.userCertficiateLabel.SetMinSize((120, -1))
        self.selectUserCertButton.SetSize(self.selectUserCertButton.GetBestSize())
        self.userKeyLabel.SetMinSize((120, -1))
        self.selectUserKeyButton.SetSize(self.selectUserKeyButton.GetBestSize())
        self.CACertificateLabel.SetMinSize((120, -1))
        self.selectCACertDir.SetSize(self.selectCACertDir.GetBestSize())
        self.proxyCertificateLabel.SetMinSize((120, -1))
        self.selectProxyCertButton.SetSize(self.selectProxyCertButton.GetBestSize())
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: ClientSettingsDialog.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_14 = wx.BoxSizer(wx.HORIZONTAL)
        certificatesVertSizer = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_copy_1_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_16_copy_copy_1 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_16_copy_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_16_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_18 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_19 = wx.BoxSizer(wx.VERTICAL)
        sizer_32 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_25 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_15 = wx.BoxSizer(wx.VERTICAL)
        sizer_17 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_16 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_16.Add(self.timeoutLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 10)
        sizer_16.Add(self.timeOutText, 0, 0, 0)
        sizer_15.Add(sizer_16, 0, wx.ALL|wx.EXPAND, 5)
        sizer_17.Add(self.brokerLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 10)
        sizer_17.Add(self.brokerCombo, 0, 0, 0)
        sizer_15.Add(sizer_17, 0, wx.ALL|wx.EXPAND, 5)
        self.generalPane.SetSizer(sizer_15)
        sizer_19.Add(self.automaticDownloadCheck, 0, 0, 0)
        sizer_25.Add((20, 20), 0, 0, 0)
        sizer_25.Add(self.downloadTimerIntervalLabel, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_25.Add(self.automaticDownloadIntervalSpin, 0, 0, 0)
        sizer_19.Add(sizer_25, 0, wx.EXPAND, 0)
        sizer_19.Add(self.static_line_2, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 4)
        sizer_19.Add(self.automaticUpdateCheck, 0, 0, 0)
        sizer_32.Add((20, 20), 0, 0, 0)
        sizer_32.Add(self.automaticUpdateIntervalLabel, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 4)
        sizer_32.Add(self.automaticUpdateIntervalSpin, 0, 0, 0)
        sizer_19.Add(sizer_32, 0, wx.EXPAND, 0)
        self.panel_3.SetSizer(sizer_19)
        sizer_18.Add(self.panel_3, 1, wx.ALL|wx.EXPAND, 4)
        self.processingPane.SetSizer(sizer_18)
        sizer_16_copy.Add(self.userCertficiateLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 10)
        sizer_16_copy.Add(self.userCertificateText, 1, wx.RIGHT|wx.EXPAND, 6)
        sizer_16_copy.Add(self.selectUserCertButton, 0, 0, 0)
        certificatesVertSizer.Add(sizer_16_copy, 0, wx.ALL|wx.EXPAND, 5)
        sizer_16_copy_copy.Add(self.userKeyLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 10)
        sizer_16_copy_copy.Add(self.userKeyText, 1, wx.RIGHT|wx.EXPAND, 6)
        sizer_16_copy_copy.Add(self.selectUserKeyButton, 0, 0, 0)
        certificatesVertSizer.Add(sizer_16_copy_copy, 0, wx.ALL|wx.EXPAND, 5)
        sizer_16_copy_copy_1.Add(self.CACertificateLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 10)
        sizer_16_copy_copy_1.Add(self.CACertificatesText, 1, wx.RIGHT|wx.EXPAND, 6)
        sizer_16_copy_copy_1.Add(self.selectCACertDir, 0, 0, 0)
        certificatesVertSizer.Add(sizer_16_copy_copy_1, 0, wx.ALL|wx.EXPAND, 5)
        sizer_16_copy_copy_1_copy.Add(self.proxyCertificateLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 10)
        sizer_16_copy_copy_1_copy.Add(self.proxyCertificateText, 1, wx.RIGHT|wx.EXPAND, 6)
        sizer_16_copy_copy_1_copy.Add(self.selectProxyCertButton, 0, 0, 0)
        certificatesVertSizer.Add(sizer_16_copy_copy_1_copy, 0, wx.ALL|wx.EXPAND, 5)
        self.certificatesPane.SetSizer(certificatesVertSizer)
        self.settingsNotebook.AddPage(self.generalPane, "General")
        self.settingsNotebook.AddPage(self.processingPane, "Processing")
        self.settingsNotebook.AddPage(self.certificatesPane, "Certificates")
        sizer_1.Add(self.settingsNotebook, 1, wx.ALL|wx.EXPAND, 5)
        sizer_14.Add(self.okButton, 0, wx.RIGHT, 5)
        sizer_14.Add(self.cancelButton, 0, 0, 0)
        sizer_1.Add(sizer_14, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 3)
        self.SetSizer(sizer_1)
        self.Layout()
        self.Centre()
        # end wxGlade
        
    def __initDialog(self):
        """
        Initialise dialig instance variables.
        """
        self.__arcGuiConfig = None
    
    def getArcGuiConfig(self):
        """
        Return ArcGuiConfig instance
        """
        return self.__arcGuiConfig
    
    def setArcGuiConfig(self, arcGuiConfig):
        """
        Assign the ArcGuiConfig instance.
        
        Assigns all controls values from the ArcGuiConfig instance.
        """
        self.__arcGuiConfig = arcGuiConfig
        
        self.automaticDownloadCheck.SetValue(self.__arcGuiConfig.automaticDownload)
        self.automaticDownloadIntervalSpin.SetValue(self.__arcGuiConfig.automaticDownloadInterval/1000)
        
        if self.__arcGuiConfig.automaticDownload:
            self.automaticDownloadIntervalSpin.Enable()
        else:
            self.automaticDownloadIntervalSpin.Disable()

        self.automaticUpdateCheck.SetValue(self.__arcGuiConfig.automaticUpdate)
        self.automaticUpdateIntervalSpin.SetValue(self.__arcGuiConfig.automaticUpdateInterval/1000)
        
        if self.__arcGuiConfig.automaticUpdate:
            self.automaticUpdateIntervalSpin.Enable()
        else:
            self.automaticUpdateIntervalSpin.Disable()
                       
        self.brokerCombo.SetValue(str(self.__arcGuiConfig.brokerName))
        self.timeOutText.SetValue(str(self.__arcGuiConfig.timeout))
        self.userCertificateText.SetValue(str(self.__arcGuiConfig.certificatePath))
        self.userKeyText.SetValue(str(self.__arcGuiConfig.keyPath))
        self.proxyCertificateText.SetValue(str(self.__arcGuiConfig.proxyPath))
        self.CACertificatesText.SetValue(str(self.__arcGuiConfig.cacertificatesDirectory))
    
    def onDownloadToDefinition(self, event): # wxGlade: ClientSettingsDialog.<event_handler>
        """
        Event method handling download to definition checkbox.
        """
        if self.automaticDownloadCheck.GetValue() == True:
            self.automaticDownloadIntervalSpin.Enable()
        else:
            self.automaticDownloadIntervalSpin.Disable()

    def onUpdateStatus(self, event): # wxGlade: ClientSettingsDialog.<event_handler>
        """
        Event method handling automatic update check box.
        """
        if self.automaticUpdateCheck.GetValue() == True:
            self.automaticUpdateIntervalSpin.Enable()
        else:
            self.automaticUpdateIntervalSpin.Disable()

    def onOK(self, event): # wxGlade: ClientSettingsDialog.<event_handler>
        """
        Event method handling a click on the OK button.
        
        Assigns the ArcGuiConfig instance the contents of the dialog controls.
        """
        
        self.__arcGuiConfig.timeout = int(self.timeOutText.GetValue())
        self.__arcGuiConfig.brokerName = str(self.brokerCombo.GetValue())
        self.__arcGuiConfig.certificatePath = self.userCertificateText.GetValue()
        self.__arcGuiConfig.keyPath = self.userKeyText.GetValue()
        self.__arcGuiConfig.proxyPath = self.proxyCertificateText.GetValue()
        self.__arcGuiConfig.cacertificatesDirectory = self.CACertificatesText.GetValue()
        self.__arcGuiConfig.automaticDownload = bool(self.automaticDownloadCheck.GetValue())
        self.__arcGuiConfig.automaticDownloadInterval = int(self.automaticDownloadIntervalSpin.GetValue()*1000)
        self.__arcGuiConfig.automaticUpdate = bool(self.automaticUpdateCheck.GetValue())
        self.__arcGuiConfig.automaticUpdateInterval = int(self.automaticUpdateIntervalSpin.GetValue()*1000)
        self.__arcGuiConfig.update()
        self.Close()

    def onCancel(self, event): # wxGlade: ClientSettingsDialog.<event_handler>
        """
        Event method handling a click on the Cancel button.
        
        Closes the dialog
        """
        self.Close()
        
    def onSelectUserCert(self, event): # wxGlade: ClientSettingsDialog.<event_handler>
        """
        Event method handling the button for selecting a user certificate.
        """
        inputFilename = wx.FileSelector("Select user certificate", default_path=os.getcwd())
        if inputFilename != "":
            self.userCertificateText.SetValue(inputFilename)

    def onSelectUserKey(self, event): # wxGlade: ClientSettingsDialog.<event_handler>
        """
        Event method handling the button for selecting a user key.
        """
        inputFilename = wx.FileSelector("Select user key", default_path=os.getcwd())
        if inputFilename != "":
            self.userKeyText.SetValue(inputFilename)

    def onSelectCaDir(self, event): # wxGlade: ClientSettingsDialog.<event_handler>
        """
        Event method handling the button for selecting a CA certificate directory.
        """
        dlg = wx.DirDialog(self, "Choose a CA directory", os.getcwd())
        if dlg.ShowModal() == wx.ID_OK:
            self.CACertificatesText.SetValue(dlg.GetPath())
        else:
            return

    def onSelectProxyCert(self, event): # wxGlade: ClientSettingsDialog.<event_handler>
        """
        Event method handling the button for selecting proxy certificate location.
        """
        inputFilename = wx.FileSelector("Select user proxy", default_path=os.getcwd())
        if inputFilename != "":
            self.proxyCertificateText.SetValue(inputFilename)

    arcGuiConfig = property(getArcGuiConfig, setArcGuiConfig)




# end of class ClientSettingsDialog


