# -*- coding: iso-8859-15 -*-
# generated by wxGlade HG on Sun Sep 27 22:30:52 2009

import wx

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode

# end wxGlade

from arcjobtool.ArcUtils import *

class ProxyDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: ProxyDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.proxyNotebook = wx.Notebook(self, -1, style=0)
        self.localProxyPane = wx.Panel(self.proxyNotebook, -1)
        self.label_1 = wx.StaticText(self.localProxyPane, -1, "Private key passphrase")
        self.passphraseText = wx.TextCtrl(self.localProxyPane, -1, "", style=wx.TE_PASSWORD)
        self.static_line_1 = wx.StaticLine(self.localProxyPane, -1)
        self.proxyTypeRadio = wx.RadioBox(self.localProxyPane, -1, "Proxy Type", choices=["GSI proxy", "RFC 3820 proxy"], majorDimension=0, style=wx.RA_SPECIFY_ROWS)
        self.proxyLifetimeRadio = wx.RadioBox(self.localProxyPane, -1, "Proxy Lifetime", choices=["12 h", "24 h", "48 h"], majorDimension=0, style=wx.RA_SPECIFY_ROWS)
        self.myProxyPane = wx.Panel(self.proxyNotebook, -1)
        self.okButton = wx.Button(self, -1, "OK")
        self.exitButton = wx.Button(self, -1, "Exit")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.onOK, self.okButton)
        self.Bind(wx.EVT_BUTTON, self.onExit, self.exitButton)
        # end wxGlade
        
        self.__initDialog()

    def __set_properties(self):
        # begin wxGlade: ProxyDialog.__set_properties
        self.SetTitle("Proxy creation")
        self.SetSize((400, 300))
        self.passphraseText.SetMinSize((250, 27))
        self.passphraseText.SetFocus()
        self.proxyTypeRadio.SetSelection(0)
        self.proxyLifetimeRadio.SetSelection(0)
        self.okButton.SetDefault()
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: ProxyDialog.__do_layout
        sizer_3 = wx.BoxSizer(wx.VERTICAL)
        sizer_4 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_5 = wx.BoxSizer(wx.VERTICAL)
        sizer_7 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_6 = wx.BoxSizer(wx.VERTICAL)
        sizer_6.Add(self.label_1, 0, 0, 0)
        sizer_6.Add(self.passphraseText, 0, 0, 0)
        sizer_8.Add(sizer_6, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_5.Add(sizer_8, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL, 8)
        sizer_5.Add(self.static_line_1, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 10)
        sizer_7.Add(self.proxyTypeRadio, 0, wx.RIGHT, 8)
        sizer_7.Add(self.proxyLifetimeRadio, 0, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_5.Add(sizer_7, 0, wx.ALIGN_CENTER_HORIZONTAL, 0)
        self.localProxyPane.SetSizer(sizer_5)
        self.proxyNotebook.AddPage(self.localProxyPane, "Local proxy")
        self.proxyNotebook.AddPage(self.myProxyPane, "MyProxy")
        sizer_3.Add(self.proxyNotebook, 1, wx.ALL|wx.EXPAND, 4)
        sizer_4.Add(self.okButton, 0, wx.RIGHT, 4)
        sizer_4.Add(self.exitButton, 0, 0, 0)
        sizer_3.Add(sizer_4, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 4)
        self.SetSizer(sizer_3)
        self.Layout()
        # end wxGlade
        
    def __initDialog(self):
        self.dialogResult = False
        
    def onOK(self, event): # wxGlade: ProxyDialog.<event_handler>
        self.dialogResult = True
        self.Close()

    def onExit(self, event): # wxGlade: ProxyDialog.<event_handler>
        self.dialogResult = False
        self.Close()
        
    def getPassphrase(self):
        passphrase = self.passphraseText.GetValue()
        self.passphraseText.SetValue("                                            ")
        self.passphraseText.SetValue("")
        return passphrase
        
    def getProxyType(self):
        if self.proxyTypeRadio.GetSelection()==0:
            return "gsi2"
        else:
            return "rfc"
    
    def getProxyLifetime(self):
        if self.proxyLifetimeRadio.GetSelection() == 0:
            return str(12)
        elif self.proxyLifetimeRadio.GetSelection() == 1:
            return str(24)
        elif self.proxyLifetimeRadio.GetSelection() == 2:
            return str(48)
        
    passphrase = property(getPassphrase)
    proxyType = property(getProxyType)
    proxyLifetime = property(getProxyLifetime)
    

# end of class ProxyDialog


