/*
    Copyright (C) 2003 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: add_route_dialog.cc,v 1.8 2003/12/29 20:06:40 trutkin Exp $
*/

#include <cstdio>
#include <cmath>

#include <sigc++/bind.h>

#include <gtkmmext/utils.h>

#include "add_route_dialog.h"
#include "i18n.h"

using namespace Gtk;
using namespace SigC;

void
channel_choice_printer (char buf[32], Gtk::Adjustment& adj, void *ignored)
{
	float val = adj.get_value();
	if (val <= 0) {
		snprintf (buf, 32, "custom");
	} else {
		if (val == 1.0f) {
			snprintf (buf, 32, _("mono"));
		} else if (val == 2.0f) {
			snprintf (buf, 32, _("stereo"));
		} else {
			snprintf (buf, 32, "%d channels", (int) floor (val));
		}
	}
}

AddRouteDialog::AddRouteDialog ()
	: ok_button (_("OK")),
	  cancel_button (_("Cancel")),
	  track_button (_("Tracks")),
	  bus_button (_("Busses")),
	  routes_adjustment (1, 1, 32, 1, 4),
	  routes_spinner (routes_adjustment),
	  channels_adjustment (1, 0, 16, 1, 4),
	  channels_choice (&channels_adjustment, "AddRouteDialogChannelChoice")
{
	channels_choice.set_print_func (channel_choice_printer, 0);
	channels_choice.set_wrap (true);

	set_usize_to_display_given_text (channels_choice, _("16 channels"), 2, 2);

	set_name ("AddRouteDialog");
	set_title (_("ardour: add track/bus"));
	set_wmclass (_("ardour_add_track_bus"), "Ardour");
	set_position (GTK_WIN_POS_MOUSE);
	set_keyboard_input (true);

	name_template_entry.set_name ("AddRouteDialogNameTemplateEntry");
	track_button.set_name ("AddRouteDialogRadioButton");
	bus_button.set_name ("AddRouteDialogRadioButton");
	ok_button.set_name ("AddRouteDialogButton");
	cancel_button.set_name ("AddRouteDialogButton");
	routes_spinner.set_name ("AddRouteDialogSpinner");
	
	bus_button.set_group (track_button.group());
	track_button.set_active (true);

	HBox *hbrb = manage (new HBox);

	hbrb->set_spacing (6);
	hbrb->pack_start (*(manage (new Label (_("Add")))), false, false);
	hbrb->pack_start (routes_spinner, false, false);
	hbrb->pack_start (track_button, false, false);
	hbrb->pack_start (bus_button, false, false);

	Frame* ccframe = manage (new Frame);

	ccframe->add (channels_choice);
	ccframe->set_shadow_type (GTK_SHADOW_IN);
	
	HBox *hbcc = manage (new HBox);

	hbcc->set_spacing (6);
	hbcc->pack_start (*(manage (new Label ("Channel configuration"))), false, false);
	hbcc->pack_start (*ccframe, false, false);

#if NOT_USEFUL_YET
	HBox *hbnt = manage (new HBox);

	hbnt->pack_start (*(manage (new Label (_("Name (template)")))), false, false);
	hbnt->pack_start (name_template_entry, true, true);
#endif

	HBox* hbbut = manage (new HBox);

	hbbut->set_homogeneous (true);
	hbbut->set_spacing (6);
	hbbut->pack_end (cancel_button, false, false);	
 	hbbut->pack_end (ok_button, false, false);

	HBox* hbbutouter = manage (new HBox);
	hbbutouter->set_border_width (12);
	hbbutouter->pack_end (*hbbut, false, false);

	VBox* vb2 = manage (new VBox);

	vb2->set_border_width (12);
	vb2->set_spacing (6);
	vb2->pack_start (*hbrb, false, false);
	vb2->pack_start (*hbcc, false, false);
#if NOT_USEFUL_YET
	vb2->pack_start (*hbnt, false, false);
#endif
	vb2->pack_start (*hbbutouter, false, false);

	add (*vb2);

	delete_event.connect (slot (*this, &ArdourDialog::wm_close_event));
	ok_button.clicked.connect (bind (slot (*this,  &ArdourDialog::stop), 0));
	cancel_button.clicked.connect (bind (slot (*this, &ArdourDialog::stop), 1));
}

AddRouteDialog::~AddRouteDialog ()
{
}

bool
AddRouteDialog::track ()
{
	return track_button.get_active ();
}

string
AddRouteDialog::name_template ()
{
	return name_template_entry.get_text ();
}

int
AddRouteDialog::channels ()
{
	return (int) floor (channels_adjustment.get_value ());
}

int
AddRouteDialog::howmany ()
{
	return (int) floor (routes_adjustment.get_value ());
}

