/* gtkwavebufferutil.h: handy utilities for data types
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_WAVE_BUFFER_UTIL_H__
#define __GTK_WAVE_BUFFER_UTIL_H__

#include "gtkwavebuffer.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Utility functions. */
static inline gint16
double_to_s16 (gdouble d)
{
  if (d >= 1.0)
    return 32767;
  else if (d <= -1.0)
    return -32768;

  return (gint16) ((d + 1.0) * 32767.5 - 32768.0);
}

static inline gint32
double_to_s32 (gdouble d)
{
  if (d >= 1.0)
    return 0x7fffffff /* 2147483647 */;
  else if (d <= -1.0)
    return 0x80000000 /* -2147483648 */;

  return (gint32) ((d + 1.0) * 2147483647.5 - 2147483648.0);
}

static inline gdouble
s32_to_double (gint32 i)
{
  return (((double) i) + 2147483648.0) / 2147483647.5 - 1.0;
}

static inline gdouble
s16_to_double (gint16 i)
{
  return (((double) i) + 32768.0) / 32767.5 - 1.0;
}


guint32        gtk_wave_buffer_type_width   (GtkWaveBufferType dtype);
void           gtk_wave_buffer_type_convert (guint32 n_channels,
                                             guint32 length,
                                             GtkWaveBufferType out_type,
                                             gpointer out,
                                             GtkWaveBufferType in_type,
                                             gpointer in);
void           gtk_wave_buffer_type_clear   (guint32 n_channels,
                                             guint32 length,
                                             GtkWaveBufferType type,
                                             gpointer out);

#ifdef __cplusplus
}
#endif

#endif /* __GTK_WAVE_BUFFER_UTIL_H__ */
