/*
    Copyright (C) 2002 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: mixer_selection.cc,v 1.2 2004/02/11 04:50:28 pauld Exp $
*/

#include <algorithm>
#include <sigc++/bind.h>
#include <pbd/error.h>

#include <ardour/playlist.h>

#include "mixer_selection.h"

#include "i18n.h"

using namespace ARDOUR;
using namespace SigC;

MixerSelection&
MixerSelection::operator= (const MixerSelection& other)
{
	if (&other != this) {
		redirects = other.redirects;
		strips = other.strips;
	}
	return *this;
}

bool
operator== (const MixerSelection& a, const MixerSelection& b)
{
	return a.redirects == b.redirects &&
		a.strips == b.strips;
}

void
MixerSelection::clear ()
{
	clear_redirects ();
	clear_strips ();
}

void
MixerSelection::clear_redirects ()
{
	/* NEED TO DELETE REDIRECTS */
	redirects.clear ();
	RedirectsChanged ();
}

void
MixerSelection::clear_strips ()
{
	strips.clear ();
	MixerStripsChanged ();
}

void
MixerSelection::add (Redirect* r)
{
	if (find (redirects.begin(), redirects.end(), r) == redirects.end()) {
		redirects.push_back (r);
		RedirectsChanged();
	}
}

void
MixerSelection::remove (Redirect* r)
{
	list<Redirect*>::iterator i;
	if ((i = find (redirects.begin(), redirects.end(), r)) != redirects.end()) {
		redirects.erase (i);
		RedirectsChanged ();
	}
}

void
MixerSelection::set (Redirect *r)
{
	clear_redirects ();
	add (r);
}

void
MixerSelection::add (MixerStrip* r)
{
	if (find (strips.begin(), strips.end(), r) == strips.end()) {
		strips.push_back (r);
		MixerStripsChanged();
	}
}

void
MixerSelection::remove (MixerStrip* r)
{
	list<MixerStrip*>::iterator i;
	if ((i = find (strips.begin(), strips.end(), r)) != strips.end()) {
		strips.erase (i);
		MixerStripsChanged ();
	}
}

void
MixerSelection::set (MixerStrip *r)
{
	clear_strips ();
	add (r);
}

bool
MixerSelection::selected (MixerStrip* ms)
{
	return find (strips.begin(), strips.end(), ms) != strips.end();
}

bool
MixerSelection::empty ()
{
	return redirects.empty () &&
		strips.empty ();
}
		
