/*
    Copyright (C) 2000 Paul Davis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: mixer_strip.h,v 1.74 2004/02/16 04:26:18 pauld Exp $
*/

#ifndef __ardour_mixer_strip__
#define __ardour_mixer_strip__

#include <vector>

#include <cmath>
#include <gtk--.h>
#include <gtkmmext/auto_spin.h>
#include <gtkmmext/slider_controller.h>
#include <gtkmmext/click_box.h>

#include <ardour/ardour.h>
#include <ardour/io.h>
#include <ardour/stateful.h>
#include <ardour/redirect.h>

#include <pbd/fastlog.h>

#include "route_ui.h"
#include "io_selector.h"
#include "gain_pan_meter.h"
#include "enums.h"

class MotionController;
class Panner;

namespace LADSPA {
	class Plugin;
}

namespace Gtkmmext {
	class SliderController;
}

namespace ARDOUR {
	class Route;
	class Send;
	class Insert;
	class Session;
	class PortInsert;
	class Connection;
}

class Mixer_UI;

class MixerStrip : public RouteUI, public Gtk::EventBox
{
  public:
	MixerStrip (Mixer_UI&, ARDOUR::Session&, ARDOUR::Route &);
	~MixerStrip ();

	void set_width (Width);
	Width get_width() const { return _width; }
	void update ();
	void set_embedded (bool);

  protected:
	friend class Mixer_UI;
	void set_packed (bool yn);
	bool packed () { return _packed; }

	void set_selected(bool yn);
	void set_stuff_from_route ();

  private:
	Mixer_UI& _mixer;

	bool  _embedded;
	bool  _packed;
	Width _width;

	Gtk::Button         hide_button;
	Gtk::Button         width_button;
	Gtk::HBox           width_hide_box;

	void hide_clicked();
	void width_clicked ();

	Gtk::Frame          global_frame;
	Gtk::VBox           global_vpacker;

	Gtk::EventBox		pre_redirect_eventbox;
	Gtk::HBox           pre_redirect_hpacker;
	Gtk::CList          pre_redirect_display;
	Gtk::ScrolledWindow pre_redirect_scroller;

	Gtk::EventBox		post_redirect_eventbox;
	Gtk::HBox           post_redirect_hpacker;
	Gtk::CList          post_redirect_display;
	Gtk::ScrolledWindow post_redirect_scroller;

	GainPanMeter gpm;

	Gtk::Table button_table;

	Gtk::Button diskstream_button;
	Gtk::Label  diskstream_label;

	Gtk::Button input_button;
	Gtk::Label  input_label;
	Gtk::Button output_button;
	Gtk::Label  output_label;

	Gtk::Button automation_recording_button;
	Gtk::Button automation_mode_button;
	Gtk::Menu arec_menu;
	Gtk::Menu amode_menu;
	Gtk::ToggleButton automation_playback_button;
	Gtk::ToggleButton polarity_button;

	SigC::Connection newplug_connection;
    
	gint    mark_update_safe ();
	guint32 mode_switch_in_progress;
	
	Gtk::Button   name_button;
	Gtk::Text     comment_area;

	Gtk::Button   group_button;
	Gtk::Label    group_label;
	Gtk::Menu    *group_menu;

	gint input_press (GdkEventButton *);
	gint output_press (GdkEventButton *);

	Gtk::Menu  input_menu;
	void add_connection_to_input_menu (ARDOUR::Connection *);

	Gtk::Menu output_menu;
	void add_connection_to_output_menu (ARDOUR::Connection *);
	
	void stream_input_chosen (ARDOUR::DiskStream*);
	void select_stream_input ();
	void connection_input_chosen (ARDOUR::Connection *);
	void connection_output_chosen (ARDOUR::Connection *);

	void edit_input_configuration ();
	void edit_output_configuration ();

	void diskstream_changed (void *src);

	Gtk::Menu *send_action_menu;
	void build_send_action_menu ();

	void new_send ();
	void show_send_controls ();

	Gtk::Menu *pre_redirect_menu;
	Gtk::Menu *post_redirect_menu;
	vector<Gtk::MenuItem*> selection_dependent_items;
	Gtk::MenuItem* redirect_paste_item;
	gint redirect_menu_map_handler (GdkEventAny *ev);
	Gtk::Menu * build_redirect_menu (Gtk::CList&);
	void build_redirect_tooltip (Gtk::CList&, Gtk::EventBox&, string);

	void select_all_redirects (Gtk::CList*);
	void select_all_plugins (Gtk::CList*);
	void select_all_inserts (Gtk::CList*);
	void select_all_sends (Gtk::CList*);
	
	void choose_send ();
	void send_io_finished (IOSelector::Result, ARDOUR::Redirect*, IOSelectorWindow*);
	void choose_insert ();
	void choose_plugin ();
	void insert_plugin_chosen (LADSPA::Plugin *);

	ARDOUR::Redirect::Placement selected_redirect_placement;
	gint redirect_button (GdkEventButton *, ARDOUR::Redirect::Placement);
	void redirects_changed (void *);
	void show_redirect_active (ARDOUR::Redirect *, void *);
	void add_redirect_to_display (ARDOUR::Redirect *);

	void show_plugin_selector ();

	gint automation_recording_press (GdkEventButton *);
	gint automation_mode_press (GdkEventButton *);
	gint automation_playback_press (GdkEventButton *);

	void input_changed (void *);
	void output_changed (void *);
	void automation_recording_changed(void *);
	void automation_mode_changed(void *);
	void automation_playback_changed(void *);

	std::string arec_string ();
	std::string amode_string ();

	std::string short_arec_string ();
	std::string short_amode_string ();

	void update_diskstream_display ();
	void update_input_display ();
	void update_output_display ();

	void set_automated_controls_sensitivity (bool yn);

	Gtk::Menu *route_ops_menu;
	void build_route_ops_menu ();
	gint name_button_button_release (GdkEventButton*);
	void list_route_operations ();

	gint comment_key_release_handler (GdkEventKey*);
	void comment_changed (void *src);
	void comment_edited ();
	bool ignore_comment_edit;

	void set_mix_group (ARDOUR::RouteGroup *);
	void add_mix_group_to_menu (ARDOUR::RouteGroup *);
	gint select_mix_group (GdkEventButton *);
	void mix_group_changed (void *);

	void polarity_toggled ();

	string redirect_name (ARDOUR::Redirect&);

	IOSelectorWindow *input_selector;
	IOSelectorWindow *output_selector;

	Gtk::Style *passthru_style;

	void route_gui_changed (string, void*);
	void show_route_color ();
	void show_passthru_color ();

	void route_active_changed ();

	void remove_redirect_gui (ARDOUR::Redirect *);

	void disconnect_newplug();

	void redirects_reordered (gint, gint);
	gint compute_redirect_sort_keys ();
	vector<SigC::Connection> redirect_active_connections;
	
	bool redirect_drag_in_progress;
	void redirect_drag_begin (GdkDragContext*);
	void redirect_drag_end (GdkDragContext*);
	void all_redirects_active(bool state);

	void cut_redirects (Gtk::CList*);
	void copy_redirects (Gtk::CList*);
	void paste_redirects ();
	void clear_redirects ();
	void clone_redirects ();

	void for_selected_redirects (Gtk::CList*, void (MixerStrip::*pmf)(ARDOUR::Redirect*));
	void get_selected_redirects (Gtk::CList*, vector<ARDOUR::Redirect*>&);

	void activate_redirect (ARDOUR::Redirect*);
	void deactivate_redirect (ARDOUR::Redirect*);
	void cut_redirect (ARDOUR::Redirect*);
	void copy_redirect (ARDOUR::Redirect*);
	void edit_redirect (ARDOUR::Redirect*);

	gint idle_delete_redirect (ARDOUR::Redirect *);

	/* speed control (for tracks only) */

	Gtk::Adjustment    speed_adjustment;
	Gtkmmext::ClickBox speed_spinner;
	Gtk::Label         speed_label;
	Gtk::Frame         speed_frame;

	void speed_adjustment_changed ();
	void speed_changed ();
	void name_changed (void *src);
	void update_speed_display ();

	SigC::Connection auto_watching;
	bool ignore_speed_adjustment;
};

#endif /* __ardour_mixer_strip__ */
