#ifndef __ardour_gtk_redirect_automation_time_axis_h__
#define __ardour_gtk_redirect_automation_time_axis_h__

#include <pbd/xml++.h>
#include "automation_time_axis.h"

namespace ARDOUR {
	class Redirect;
}

class RedirectAutomationTimeAxisView : public AutomationTimeAxisView
{
  public:
	RedirectAutomationTimeAxisView (ARDOUR::Session&,
					ARDOUR::Route&,
					PublicEditor&,
					Gtk::Widget* parent,
					std::string name,
					unsigned long port,
					ARDOUR::Redirect& rd);

	~RedirectAutomationTimeAxisView();

	void add_automation_event (GtkCanvasItem *item, GdkEvent *event, jack_nframes_t, double);

	guint32 show_at (double y, int& nth, Gtk::VBox *parent);
	void hide ();

	
   private:
	ARDOUR::Redirect& redirect;
        unsigned long port;

	XMLNode *xml_node;
	void ensure_xml_node();
	void update_extra_xml_shown (bool editor_shown);
	
};

#endif /* __ardour_gtk_redirect_automation_time_axis_h__ */
