/*
    Copyright (C) 2000 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: playlistsource.h,v 1.2 2002/05/13 03:23:21 trutkin Exp $
*/

#ifndef __ardour_playlist_source_h__ 
#define __ardour_playlist_source_h__

#include <string>

#include "source.h"
#include "playlist.h"

namespace ARDOUR {

class PlaylistSource : public Source {
  public:
	PlaylistSource (ARDOUR::Playlist&);
	~PlaylistSource ();

	jack_nframes_t length() { return playlist.length(); }
	jack_nframes_t read (Source::Data *dst, jack_nframes_t start, jack_nframes_t cnt) {
		return playlist.read (dst, start, cnt);
	}

//	int read_peaks (PeakData *, jack_nframes_t npeaks, jack_nframes_t start, jack_nframes_t cnt);
//	int build_peak (jack_nframes_t first_frame, jack_nframes_t cnt);

	static bool is_playlist_source (const string& name) {
		return ((name.length() > 1) && (name.substr (0,2) == "P"));
	}

  protected:

  private:
	ARDOUR::Playlist& playlist;
};

}; /* namespace ARDOUR */

#endif /* __ardour_playlist_source_h__ */
