#ifndef __gtkmmext_newsavedialog_h__
#define __gtkmmext_newsavedialog_h__

#include <string>
#include <vector>

#include <gtk--/entry.h>
#include <gtk--/box.h>
#include <gtk--/label.h>
#include <gtk--/combo.h>
#include <gtk--/arrow.h>
#include <gtk--/clist.h>
#include <gtk--/scrolledwindow.h>
#include <gtk--/eventbox.h>
#include <gtk--/table.h>
#include <gtk--/misc.h>
#include <gtk--/checkbutton.h>

namespace Gtkmmext {

class NewSaveDialog : public Gtk::Misc
{
  public:
	NewSaveDialog (std::string label, std::string action);
	~NewSaveDialog ();

	std::string get_path ();
        void set_path (std::string path, bool force=false);

	void set_favorites (std::vector<std::string>);
	void get_favorites (std::vector<std::string> &);
	
	void hidden_dirs_shown(bool val);
	bool hidden_dirs_shown() { return show_hidden_dirs; }
	
	SigC::Signal1<void,bool> Expanded;

	Gtk::Table table;
	Gtk::Entry entry;
	Gtk::Label entry_label;
	Gtk::HBox  entry_hbox;

	Gtk::Combo where_combo;
	Gtk::Label where_label;
	Gtk::Button where_browse;
	Gtk::HBox  where_hbox;

	Gtk::Button cancel_button;
	Gtk::Button op_button;
	Gtk::HBox   button_box;

	Gtk::VBox expansion_vbox;
	Gtk::ScrolledWindow dir_scroller;
	std::vector<Gtk::CList*> dir_lists;
	Gtk::HBox   dir_lists_box;
	Gtk::Button new_dir_button;
	Gtk::Button add_to_favorites_button;
	Gtk::Button remove_from_favorites_button;
	Gtk::HBox   expansion_button_box;
	Gtk::HBox   show_hidden_box;
	Gtk::CheckButton show_hidden_check;
	Gtk::HBox   path_label_box;
	Gtk::Entry  path_entry;
	Gtk::Entry  new_dir_entry;
	
	bool ignore_selection;
	bool ignore_path_entry;
	bool ignore_where_combo;
	bool show_hidden_dirs;
	std::string _fullpath;

	typedef std::vector<std::string> FavoriteDirs;
	FavoriteDirs favorite_dirs;

	
	void toggle_expansion ();
	void toggle_hidden ();

	void new_dir_clicked ();
	void add_favorites_clicked ();
	void remove_favorites_clicked ();
	void update_fav_combo ();
	void path_entry_changed ();
	gint where_combo_chosen (GdkEventAny *ev);
	
	void refill_dir_lists ();
	void refill_dir_list (Gtk::CList&, Gtk::Widget& parent);
	void row_selected (int row, int col, GdkEvent*, int list);
};

} // namespace Gtkmmext

#endif // __gtkmmext_newsavedialog_h__
