/*
    Copyright (C) 1998-99 Paul Barton-Davis
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: popup.cc,v 1.4 2004/02/13 13:12:47 pauld Exp $
*/

#include <gtkmmext/popup.h>
#include <gtkmmext/utils.h>

using namespace std;
using namespace Gtk;
using namespace Gtkmmext;

PopUp::PopUp (GtkWindowPosition pos, unsigned int showfor_msecs, bool doh)
	: Window (GTK_WINDOW_DIALOG)
{

	realize ();
	get_window().set_decorations (GdkWMDecoration (GDK_DECOR_BORDER|GDK_DECOR_RESIZEH));
	add_events (GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK);
	button_release_event.connect(SigC::slot(this,&PopUp::button_click));
	set_border_width (12);
	add (label);
	set_position (pos);

	delete_on_hide = doh;
	popdown_time = showfor_msecs;
}


PopUp::~PopUp ()
{
}

gint
PopUp::remove_prompt_timeout (void *arg)
{
	PopUp *pup = (PopUp *) arg;

	pup->remove ();
	return FALSE;
}

static gint idle_delete (void *arg)
{
	delete static_cast<PopUp*> (arg);
	return FALSE;
}

void
PopUp::remove ()
{
	if (delete_on_hide) {
		gtk_idle_add (idle_delete, this);
	} else {
		hide ();
	}
}

void
PopUp::touch ()
{
	if (is_visible ()) {
		remove ();
	} else {
		set_usize_to_display_given_text (label, my_text.c_str(), 25, 10);
		label.set_text (my_text);
		show_all ();
		
		if (popdown_time != 0) {
			timeout = gtk_timeout_add (popdown_time, 
						   remove_prompt_timeout, 
						   this);
		}
	}
}

gint
PopUp::button_click (GdkEventButton *ev)
{
	remove ();
	return TRUE;
}

void
PopUp::set_text (string txt)
{
	my_text = txt;
}

void
PopUp::set_name (string name)
{
	Window::set_name (name);
	label.set_name (name);
}



