/*
    Copyright (C) 2001 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: audioengine_control.h,v 1.2 2002/11/11 00:02:35 trutkin Exp $
*/

#ifndef __gtk_ardour_audioengine_control_h__
#define __gtk_ardour_audioengine_control_h__

#include <vector>
#include <string>

#include <gtk--.h>
#include <gtkmmext/click_box.h>

namespace LinuxAudioSystems {
	class AudioEngine;
}

class AudioEngineControl : public ArdourDialog

{
  public:
	AudioEngineControl (LinuxAudioSystems::AudioEngine&);
	~AudioEngineControl () {}

  private:
	struct GlobalClickBox : public Gtk::VBox {
	    Gtkmmext::ClickBox  *box;
	    Gtk::Frame      frame;
	    Gtk::Label      label;
	    vector<string> &strings;
	    Gtk::Adjustment adjustment;

	    static void printer (char buf[32], Gtk::Adjustment &adj, void *arg);

	    GlobalClickBox (const string &str, vector<string> &vs)
		    : strings (vs),
		      adjustment (0, 0, vs.size() - 1, 1, 1, 0) {
		    box = new Gtkmmext::ClickBox (&adjustment, "ClickButton");
		    label.set_text (str);
		    label.set_name ("GlobalButtonLabel");
		    frame.add (*box);
		    frame.set_shadow_type (GTK_SHADOW_IN);
		    pack_start (label);
		    pack_start (frame);
		    box->set_print_func (printer, this);
		    box->set_wrap (true);
	    };
	};

	LinuxAudioSystems::AudioEngine      &engine;

	Gtk::VBox               vbox;
	Gtk::VBox               hbox;
	
	Gtk::CheckButton        bypass_button;
	Gtk::CheckButton        hw_monitor_button;
	Gtk::Label              pause_button_label;
	Gtk::ToggleButton       pause_button;

	Gtk::Frame              control_frame;
	Gtk::Frame              plugin_frame;
	Gtk::Frame              action_frame;

	Gtk::VBox               control_vbox;
	Gtk::VBox               action_vbox;

	GlobalClickBox    *sample_clock_mode_button;
	vector<string>     sample_clock_mode_strings;

	GlobalClickBox    *latency_button;
	vector<string>     latency_strings;

	void sample_clock_mode_adjusted ();
	void latency_adjusted ();
	void bypass_click ();
	void quit_click ();
	void pause_toggled ();
	void hw_monitor_click ();
};

#endif /* __gtk_ardour_audioengine_control_h__ */
