/*
    Copyright (C) 2004 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: editor_keyboard.cc,v 1.2 2004/06/28 17:31:43 pauld Exp $
*/

#include <ardour/audioregion.h>

#include "editor.h"
#include "regionview.h"
#include "selection.h"

void
Editor::kbd_driver (SigC::Slot1<void,GdkEvent*> theslot, bool use_track_canvas, bool use_time_canvas, bool can_select)
{
	gint x, y;
	double dx, dy;
	GdkEvent ev;
	GdkModifierType mask;
	Gdk_Window evw (track_canvas->get_window().get_pointer (x, y, mask));
	bool doit = false;

	if (use_track_canvas && gdk_window_get_pointer (track_canvas_event_box.get_window(),
							&x, &y, &mask)) {
		doit = true;

	} else if (use_time_canvas && gdk_window_get_pointer (time_canvas_event_box.get_window(),
							      &x, &y, &mask)) {
		doit = true;
	}

	if (doit) {

		if (within_regionview && selection->audio_regions.empty() && can_select) {
			selection->set (within_regionview);
		}

		gtk_canvas_window_to_world (GTK_CANVAS(track_gtk_canvas), x, y, &dx, &dy);

		ev.type = GDK_BUTTON_PRESS;
		ev.button.x = dx;
		ev.button.y = dy;

		theslot (&ev);
	}
}

void
Editor::kbd_set_playhead_cursor ()
{
	kbd_driver (slot (*this, &Editor::set_playhead_cursor));
}

void
Editor::kbd_set_edit_cursor ()
{
	kbd_driver (slot (*this, &Editor::set_edit_cursor));
}

void
Editor::kbd_do_split (GdkEvent* ev)
{
	split_region_at (event_frame (ev));
}

void
Editor::kbd_split ()
{
	kbd_driver (slot (*this, &Editor::kbd_do_split));
}

void
Editor::kbd_do_align (GdkEvent* ev, ARDOUR::RegionPoint what)
{
	align (what);
}

void
Editor::kbd_align (ARDOUR::RegionPoint what)
{
	kbd_driver (bind (slot (*this, &Editor::kbd_do_align), what));
}

void
Editor::kbd_do_align_relative (GdkEvent* ev, ARDOUR::RegionPoint what)
{
	align (what);
}

void
Editor::kbd_align_relative (ARDOUR::RegionPoint what)
{
	kbd_driver (bind (slot (*this, &Editor::kbd_do_align), what), true, true, false);
}
