/*
    Copyright (C) 2001 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: mark_editor.h,v 1.2 2002/11/04 17:43:04 pbd Exp $
*/

#ifndef __gtk_ardour_mark_editor_h__
#define __gtk_ardour_mark_editor_h__

#include <gtk--.h>
#include <sigc++/signal_system.h>

#include "audio_clock.h"
#include "ardour_dialog.h"

namespace ARDOUR {
	class TempoSection;
	class Session;
}

class MarkEditor : public ArdourDialog
{
  public:
	MarkEditor ();
	~MarkEditor ();

	bool edit (ARDOUR::TempoSection *);
	void apply (ARDOUR::TempoSection *);
	
	void set_session (ARDOUR::Session *);
	void session_gone ();
	
  private:
	AudioClock start_clock;
	Gtk::Entry bpb_entry;
	Gtk::Entry note_type_entry;
	Gtk::Entry qpm_entry;
	Gtk::Entry bars_entry;

	Gtk::Button ok_button;
	Gtk::Button cancel_button;
	
	Gtk::HBox action_button_hbox;
	Gtk::HBox lower_hbox;
	Gtk::HBox upper_hbox;
	Gtk::VBox vbox;
	
	bool edit_status;
	void edit_finished (bool);
};

#endif /* __gtk_ardour_mark_editor_h__ */

