/*
    Copyright (C) 2004 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id$
*/

#ifndef __ardour_vst_plugin_h__
#define __ardour_vst_plugin_h__

#include <list>
#include <map>
#include <set>
#include <vector>
#include <string>
#include <dlfcn.h>

#include <midi++/controllable.h>
#include <sigc++/signal_system.h>

#include <jack/types.h>
#include <ardour/vst.h>
#include <ardour/stateful.h>
#include <ardour/plugin_state.h>
#include <ardour/plugin.h>
#include <ardour/vst_plugin.h>

using std::string;
using std::vector;
using std::list;
using std::map;

namespace ARDOUR {
class AudioEngine;
class Session;

class VSTPlugin : public ARDOUR::Plugin
{
  public:
	VSTPlugin (ARDOUR::AudioEngine&, ARDOUR::Session&, void* handle);
	VSTPlugin (const VSTPlugin &);
	~VSTPlugin ();

	/* Plugin interface */
	
	const char * label() const;
	const char * name() const;
	const char * maker() const;
	uint32_t port_count() const;
	float default_value (uint32_t port);
	jack_nframes_t latency() const;
	void set_parameter (uint32_t port, float val);
	float get_parameter (uint32_t port) const;
	int get_parameter_descriptor (uint32_t which, float& lower, float& upper, bool& toggled, bool& logarithmic) const;
	std::set<uint32_t> automatable() const;
	uint32_t nth_parameter (uint32_t port, bool& ok) const;
	void activate ();
	void deactivate ();
	int connect_and_run (vector<Sample*>& bufs, int32_t maxbuf, jack_nframes_t nframes, jack_nframes_t offset);
	void store_state (ARDOUR::PluginState&);
	void restore_state (ARDOUR::PluginState&);
	string describe_parameter (uint32_t);
	string state_node_name() const { return "VST"; }

	XMLNode& get_state();
	int set_state(const XMLNode& node);
	bool load_preset (const string preset_label );
	bool save_preset(string name);
	list<string> get_presets();

  private:
	FST*                     fst;
};

}

#endif /* __ardour_vst_plugin_h__ */
