// -*- c++ -*-
//  Generated by gtkmmproc from ./../clist.gen_h -- DO NOT MODIFY!
#include <gtk--/clist.h>
#include <gtk--/private/clist_p.h>
#include <gtk--/style.h>
#include <gtk--/adjustment.h>

namespace Gtk
{

CList::CList(int columnsx, const gchar* titles[])
  : Container((GtkContainer*)(gtk_object_new(get_type(),0)))
{
  initialize_class();
  GTK_OBJECT_UNSET_FLAGS(gtkobj(), GTK_CONSTRUCTED);
  gtk_clist_construct(gtkobj(),columnsx,const_cast<gchar**>(titles));
}

CList::CList(const SArray &titles)
  : Container((GtkContainer*)(gtk_object_new(get_type(),0)))
{
  initialize_class();
  GTK_OBJECT_UNSET_FLAGS(gtkobj(), GTK_CONSTRUCTED);
  gtk_clist_construct(gtkobj(),titles.size(),const_cast<gchar**>((const char **)titles));
}

CList::CList(GtkCList *castitem)
  : Container(GTK_CONTAINER(castitem))
{
  initialize_class();
}

bool CList::check_seliterator_type() const { return true; }

bool
CList::get_text(gint row, gint column, nstring *text) const
{
  g_return_val_if_fail(text != 0, false);

  gchar *tmp;

  gint rc = gtk_clist_get_text(const_cast<GtkCList*>(gtkobj()),
			       row, column, &tmp);
  *text=tmp;

  return (rc)?true:false;
}

bool
CList::get_text(gint row, gint column, string &text) const
{
  gchar *tmp;

  gint rc = gtk_clist_get_text(const_cast<GtkCList*>(gtkobj()),
			       row, column, &tmp);
  text=tmp;

  return (rc)?true:false;
}

nstring
CList::get_text(gint row, gint column) const
{
  gchar *tmp;

  gint rc = gtk_clist_get_text(const_cast<GtkCList*>(gtkobj()),
			       row, column, &tmp);
  if ( rc )
    return tmp;
  else
    return 0;
}

gint
CList::get_pixmap(gint row, gint column,
		      Gdk_Pixmap &pixmap, Gdk_Bitmap &mask) const
{
  GdkPixmap *pm;
  GdkBitmap *bm;
  gint rc=gtk_clist_get_pixmap(const_cast<GtkCList*>(gtkobj()),
			       row, column, &pm, &bm);
  pixmap=Gdk_Pixmap(pm);
  mask=Gdk_Bitmap(bm);
  return rc;
}


bool
CList::get_pixtext(gint row, gint column, string &text,
		       guint8 &spacing,
		       Gdk_Pixmap &pixmap, Gdk_Bitmap &mask) const
{

  GdkBitmap *bm;
  GdkPixmap *pm;
  guint8    sp;
  gchar     *tmp;

  gint rc = gtk_clist_get_pixtext ( const_cast < GtkCList * > ( gtkobj () ),
				  row, column, &tmp, &sp, &pm, &bm );
  pixmap = Gdk_Pixmap ( pm );
  mask = Gdk_Bitmap ( bm );

  if ( tmp )
    text = tmp;
  else
    text.erase();

  spacing = sp;

  return (rc)?true:false;
}


gint
CList::get_column_width ( gint column ) const
{
  if ( column < ( gtkobj () -> columns ) )
      return gtkobj () -> column [ column ] .  width;
  return -1;
}

CList::Cell CList::cell(gint row, gint column)
  {
    return Cell(gtkobj(),row,column);
  }

const CList::Cell CList::cell(gint row, gint column) const
  {
    return Cell(const_cast<GtkCList*>(gtkobj()),row,column);
  }

void CList::Proxy_select_row::emit(int row, int column)
  {
    gtk_clist_select_row(obj->gtkobj(),row,column);
  }

void CList::Proxy_unselect_row::emit(int row, int column)
  {
    gtk_clist_unselect_row(obj->gtkobj(),row,column);
  }

namespace CList_Helpers {
/**************************************************************
*** Cell
**************************************************************/
Cell::Cell(GtkCList *parent, gint row, gint column)
  {
    parent_=parent;
    row__=0;
    number__=row;
    column_=column;
  }

Cell::Cell(GtkCList *parent, GtkCListRow *row, gint column)
  {
    parent_=parent;
    row__=row;
    number__=-1;
    column_=column;
  }

Cell::Cell()
  {
    parent_=0;
    row__=0;
    number__=-1;
    column_=0;
  }

GtkCell* Cell::get_cell()
  {
    if (column_>=parent_->columns)
      return 0;
    return &(get_row()->cell[column_]);
  }

GtkCell* Cell::get_cell() const
  {
    if (column_>=parent_->columns)
      return 0;
    return &(get_row()->cell[column_]);
  }

GtkCListRow* Cell::get_row() const
  {
    if (!row__)
      return (GtkCListRow*)(g_list_nth(parent_->row_list,number__)->data);
    return row__;
  }

GtkCListRow* Cell::get_row()
  {
    if (!row__)
      row__=(GtkCListRow*)(g_list_nth(parent_->row_list,number__)->data);
    return row__;
  }

gint Cell::get_row_num()
  {
    if (number__==-1)
      number__=g_list_index(parent_->row_list,row__);
    return number__;
  }

gint Cell::get_row_num() const
  {
    if (number__!=-1) return number__;
    return g_list_index(parent_->row_list,row__);
  }

GtkCellType Cell::get_type() const
  {
    GtkCell* cell=get_cell();
    if (!cell) return GTK_CELL_EMPTY;
    return cell->type;
  }

Gtk::Style* Cell::get_style() const
  {
    GtkCell *cell=get_cell();
    if (!cell) return 0;
    return wrap(cell->style);
  }

nstring Cell::get_text() const
  {
    GtkCell *cell=get_cell();
    if (!cell) return 0;
    switch (cell->type)
      {
        case GTK_CELL_TEXT:
          return ((GtkCellText*)cell)->text;
        case GTK_CELL_PIXTEXT:
          return ((GtkCellPixText*)cell)->text;
        default:
          return 0;
      }
  }

guint8 Cell::get_spacing() const
  {
    GtkCell *cell=get_cell();
    if (!cell) return 0;
    switch (cell->type)
      {
        case GTK_CELL_PIXTEXT:
          return ((GtkCellPixText*)cell)->spacing;
        default:
          return 0;
      }
  }

Gdk_Pixmap Cell::get_pixmap() const
  {
    GtkCell *cell=get_cell();
    if (!cell) return 0;
    switch (cell->type)
      {
        case GTK_CELL_PIXMAP:
          return ((GtkCellPixmap*)cell)->pixmap;
        case GTK_CELL_PIXTEXT:
          return ((GtkCellPixText*)cell)->pixmap;
        default:
          return 0;
      }
  }

Gdk_Bitmap Cell::get_mask() const
  {
    GtkCell *cell=get_cell();
    if (!cell) return 0;
    switch (cell->type)
      {
        case GTK_CELL_PIXMAP:
          return ((GtkCellPixmap*)cell)->mask;
        case GTK_CELL_PIXTEXT:
          return ((GtkCellPixText*)cell)->mask;
        default:
          return 0;
      }
  }

void Cell::redraw()
  {
    if (parent_->freeze_count==0
        && gtk_clist_row_is_visible (parent_, get_row_num())
              != GTK_VISIBILITY_NONE)
      (((GtkCListClass*)(((GtkObject*)parent_)->klass))->draw_row)
        (parent_,NULL,get_row_num(),get_row());
  }

void Cell::moveto(gfloat row_align,gfloat col_align)
  {
    gtk_clist_moveto(parent_, get_row_num(), column_, row_align, col_align);
  }

void Row::moveto(gfloat row_align,gfloat col_align)
  {
    gtk_clist_moveto(parent_, get_row_num(), -1, row_align, col_align);
  }

void Column::moveto(gfloat row_align,gfloat col_align)
  {
    gtk_clist_moveto(parent_, -1, column_, row_align, col_align);
  }

void Cell::set_style(Gtk::Style& style)
  {
    gtk_clist_set_cell_style(parent_, get_row_num(), column_,
       style.gtkobj());
  }

void Cell::set_spacing(guint8 spacing)
  {
    GtkCell *cell=get_cell();
    if (!cell) return;
    switch (cell->type)
      {
        case GTK_CELL_PIXTEXT:
          cell->u.pt.spacing=spacing;
          redraw();
        default:
          return;
      }
  }

void Cell::clear()
  {
    GtkCell *cell=get_cell();
    if (!cell) return;
    switch (cell->type)
      {
        case GTK_CELL_EMPTY:
          break;
        case GTK_CELL_TEXT:
          g_free(cell->u.text);
          break;
        case GTK_CELL_PIXMAP:
          gdk_pixmap_unref (cell->u.pm.pixmap);
          if (cell->u.pm.mask)
            gdk_bitmap_unref (cell->u.pm.mask);
          break;
        case GTK_CELL_PIXTEXT:
          g_free (cell->u.pt.text);
          gdk_pixmap_unref (cell->u.pt.pixmap);
          if (cell->u.pt.mask)
            gdk_bitmap_unref (cell->u.pt.mask);
          break;
        case GTK_CELL_WIDGET:
          /* unimplimented */
          break;
        default:
          break;
      }
    cell->type=GTK_CELL_EMPTY;
  }

void Cell::set_text(nstring str)
  {
    GtkCell *cell=get_cell();
    if (!cell) return;
    Gdk_Pixmap pm;
    Gdk_Bitmap bm;
    switch (cell->type)
      {
        case GTK_CELL_EMPTY:
        case GTK_CELL_TEXT:
          gtk_clist_set_text(parent_,get_row_num(),column_,str.c_str());
          break;
        case GTK_CELL_PIXTEXT:
          pm=cell->u.pt.pixmap;
          bm=cell->u.pt.mask;
          gtk_clist_set_pixtext(parent_,get_row_num(),column_,str.c_str(),
            cell->u.pt.spacing, pm, bm);
          break;
        case GTK_CELL_PIXMAP:
          pm=cell->u.pm.pixmap;
          bm=cell->u.pm.mask;
          gtk_clist_set_pixtext(parent_,get_row_num(),column_,str.c_str(),
            5, pm, bm);
        default:
          break;
      }
  }

void Cell::set_pixmap(const Gdk_Pixmap& pixmap,const Gdk_Bitmap& mask)
  {
    GtkCell *cell=get_cell();
    if (!cell) return;
    string s;
    switch (cell->type)
      {
        case GTK_CELL_EMPTY:
        case GTK_CELL_PIXMAP:
          gtk_clist_set_pixmap(parent_,get_row_num(),column_,
            pixmap.gdkobj(), mask.gdkobj());
          break;
        case GTK_CELL_TEXT:
          s=cell->u.text;
          if (s=="")  // junk text should be removed
            gtk_clist_set_pixmap(parent_,get_row_num(),column_,
              pixmap.gdkobj(), mask.gdkobj());
          else
            gtk_clist_set_pixtext(parent_,get_row_num(),column_,s.c_str(),
              5, pixmap.gdkobj(), mask.gdkobj());
          break;
        case GTK_CELL_PIXTEXT:
          s=cell->u.pt.text;
          gtk_clist_set_pixtext(parent_,get_row_num(),column_,s.c_str(),
            cell->u.pt.spacing, pixmap.gdkobj(), mask.gdkobj());
          break;
        default:
          break;
      }
  }

void Cell::set_shift(gint vertical,gint horizontal)
  {
    gtk_clist_set_shift(parent_,get_row_num(),column_, vertical, horizontal);
  }

void Cell::select()
  {
    gtk_clist_select_row(parent_,get_row_num(),column_);
  }

void Cell::unselect()
  {
    gtk_clist_unselect_row(parent_,get_row_num(),column_);
  }

/**************************************************************
*** Column
**************************************************************/
Column::Column(GtkCList* parent,gint number)
  {
    parent_=parent;
    column_=number;
  }

Column::Column()
  {
    parent_=0;
    column_=0;
  }

void Column::set_active()
  {
    gtk_clist_column_title_active(parent_,column_);
  }

void Column::set_passive()
  {
    gtk_clist_column_title_passive(parent_,column_);
  }

void Column::set_title(const string& title)
  {
    gtk_clist_set_column_title(parent_,column_,title.c_str());
  }

string Column::get_title()
  {
    return string(gtk_clist_get_column_title(parent_,column_));
  }

void Column::set_widget(Gtk::Widget* widget)
  {
    gtk_clist_set_column_widget(parent_,column_,
                                widget?widget->gtkobj():0);
  }

void Column::set_widget(Gtk::Widget& widget)
  {
    gtk_clist_set_column_widget(parent_,column_,widget.gtkobj());
  }

Gtk::Widget* Column::get_widget()
  {
    return wrap(gtk_clist_get_column_widget(parent_,column_));
  }

void Column::set_justification(GtkJustification justification)
  {
    gtk_clist_set_column_justification(parent_,column_,justification);
  }

void Column::set_visiblity(bool vis)
  {
    gtk_clist_set_column_visibility(parent_,column_,vis);
  }

void Column::set_resizable(bool resize)
  {
    gtk_clist_set_column_resizeable(parent_,column_,resize);
  }

void Column::set_auto_resize(bool resize)
  {
    gtk_clist_set_column_auto_resize(parent_,column_,resize);
  }

gint Column::get_optimal_width()
  {
    return gtk_clist_optimal_column_width(parent_,column_);
  }

void Column::set_width(gint width)
  {
    gtk_clist_set_column_width(parent_,column_,width);
  }

void Column::set_min_width(gint min)
  {
    gtk_clist_set_column_min_width(parent_,column_,min);
  }

void Column::set_max_width(gint max)
  {
    gtk_clist_set_column_max_width(parent_,column_,max);
  }

/**************************************************************
*** Row
**************************************************************/
Row::Row(GtkCList* parent,GtkCListRow* row)
  {
    parent_=parent;
    row__=row;
    number__=-1;
  }

Row::Row(GtkCList* parent,gint number)
  {
    parent_=parent;
    row__=0;
    number__=number;
  }

GtkCListRow* Row::get_row()
  {
    if (!row__&&number__==-1)
      return 0;
    if (!row__)
      row__=(GtkCListRow*)(g_list_nth(parent_->row_list,number__)->data);
    return row__;
  }

GtkCListRow* Row::get_row() const
  {
    if (!row__&&number__==-1)
      return 0;
    if (!row__)
      return (GtkCListRow*)(g_list_nth(parent_->row_list,number__)->data);
    return row__;
  }

gint Row::get_row_num()
  {
    if (number__==-1)
      number__=g_list_index(parent_->row_list,row__);
    return number__;
  }

gint Row::get_row_num() const
  {
    if (number__!=-1) return number__;
    return g_list_index(parent_->row_list,row__);
  }

GtkVisibility Row::is_visible()
  {
    return gtk_clist_row_is_visible(parent_,get_row_num());
  }

Gtk::Style* Row::get_style() const
  {
    return wrap(gtk_clist_get_row_style(parent_,get_row_num()));
  }

gpointer Row::get_data() const
  {
    return gtk_clist_get_row_data(parent_,get_row_num());
  }

bool Row::get_selectable() const
  {
    return gtk_clist_get_selectable(parent_, get_row_num())?true:false;
  }

void Row::set_style(Gtk::Style& style)
  {
    gtk_clist_set_row_style(parent_,get_row_num(),style.gtkobj());
  }

void Row::set_data(gpointer data)
  {
    gtk_clist_set_row_data(parent_, get_row_num(), data);
  }

void Row::set_data(gpointer data,GtkDestroyNotify destroy)
  {
    gtk_clist_set_row_data_full(parent_, get_row_num(), data, destroy);
  }

void Row::set_selectable(bool selectable)
  {
    gtk_clist_set_selectable(parent_, get_row_num(), selectable);
  }

void Row::set_foreground(const Gdk_Color& color)
  {
    gtk_clist_set_foreground(parent_, get_row_num(),
       const_cast<GdkColor*>(color.gdkobj()));
  }

void Row::set_background(const Gdk_Color& color)
  {
    gtk_clist_set_background(parent_, get_row_num(),
       const_cast<GdkColor*>(color.gdkobj()));
  }


void Row::focus()
  {
    parent_->focus_row=get_row_num();
    if (parent_->freeze_count==0)
      gtk_widget_draw(GTK_WIDGET(parent_),0);
  }

void Row::select(gint column)
  {
    gtk_clist_select_row(parent_, get_row_num(), column);
  }

void Row::unselect(gint column)
  {
    gtk_clist_unselect_row(parent_, get_row_num(), column);
  }

/**************************************************************
*** CellIterator
**************************************************************/
CellIterator&  CellIterator::operator++()
  {
    if (column_<parent_->columns) column_++;
    return *this;
  }

CellIterator&  CellIterator::operator--()
  {
    if (column_>0) column_--;
    return *this;
  }

Cell& CellIterator::operator*() const
  {
    return const_cast<CellIterator&>(*this);
  }

Cell* CellIterator::operator -> () const
  {
    return &operator*();
  };

/**************************************************************
*** ColumnIterator
**************************************************************/
ColumnIterator&  ColumnIterator::operator++()
  {
    if (column_<parent_->columns) column_++;
    return *this;
  }

ColumnIterator&  ColumnIterator::operator--()
  {
    if (column_>-1) column_--;
    return *this;
  }


Column& ColumnIterator::operator*() const
  {
    return const_cast<ColumnIterator&>(*this);
  }

Column* ColumnIterator::operator -> () const
  {
    return &operator*();
  }

/**************************************************************
*** RowIterator
**************************************************************/

/* RowIterator is fun.  We have 3 things to be
concerned about.  The row number, the row and
the GList node to that row.  The row__ and number__
should be blank because otherwise inserts will break
the cache and give incorrect results.  */

RowIterator::RowIterator(GtkCList* parent,GList* node)
  : Row(parent,-1), node_(node)
  {}

RowIterator::RowIterator(GtkCList* parent,gint number)
  : Row(parent,number), node_(0)
  {}

RowIterator::RowIterator()
  : Row(0,-1), node_(0)
  {}

RowIterator&  RowIterator::operator++()
  {
    if (!parent_) return *this;
    get_node();  // work over caches
    number__=-1; row__=0;
    if (!node_)
      node_=parent_->row_list;
    else
      node_ = g_list_next(node_);
    return *this;
  }

RowIterator&  RowIterator::operator--()
  {
    if (!parent_) return *this;
    get_node();  // work over caches
    number__=-1; row__=0;
    if (!node_)
      node_=parent_->row_list_end;
    else
      node_ = g_list_previous(node_);
    return *this;
  }

// get the node changing from row or number
GList* RowIterator::get_node() const
  {
    RowIterator& r=const_cast<RowIterator&>(*this);
    if (node_) return node_;
    if (row__)
      r.node_=g_list_find(parent_->row_list,row__);
    else if (number__!=-1)
      r.node_=g_list_nth(parent_->row_list,number__);
    return r.node_;
  }

// get the row changing from node or number
GtkCListRow* RowIterator::get_row() const
  {
    RowIterator& r=const_cast<RowIterator&>(*this);
    if (node_&&!row__)
      {
        r.row__=(GtkCListRow*)(node_->data);
        r.number__=-1;
      }
    return r.Row::get_row();
  }

gint RowIterator::get_row_num() const
  {
    RowIterator& r=const_cast<RowIterator&>(*this);
    if (node_&&number__==-1)
      {
        r.row__=(GtkCListRow*)(node_->data);
        r.number__=g_list_position(parent_->row_list,node_);
      }
    return r.Row::get_row_num();
  }

Row& RowIterator::operator*() const
  {
    RowIterator& r=const_cast<RowIterator&>(*this);
    r.get_row();
    return r;
  }

Row* RowIterator::operator -> () const
  {
    return &operator*();
  }

Row& SelectionIterator::operator*() const
  {
    SelectionIterator& r=const_cast<SelectionIterator&>(*this);
    r.row__=0;
    r.number__=GPOINTER_TO_INT(node_->data);
    return r;
  }

Row* SelectionIterator::operator -> () const
  {
    return &operator*();
  }

SelectionIterator&  SelectionIterator::operator++()
  {
    if (!node_)
      node_=parent_->selection;
    else
      node_ = g_list_next(node_);
    return *this;
  }

SelectionIterator&  SelectionIterator::operator--()
  {
    if (!node_)
      node_=parent_->selection_end;
    else
      node_ = g_list_previous(node_);
    return *this;
  }

/**************************************************************
*** ColumnVector
**************************************************************/
ColumnVector::size_type ColumnVector::size(void) const
  { return size_type(parent_->gtkobj()->columns); }
ColumnVector::size_type ColumnVector::max_size(void) const
  { return size_type(parent_->gtkobj()->columns); }

ColumnVector::value_type ColumnVector::operator[](size_type l) const
  {
    return Column(parent_->gtkobj(),l);
  }

/**************************************************************
*** SelectionList
**************************************************************/
SelectionList::iterator SelectionList::begin_() const
  { return iterator(parent_->gtkobj(),parent_->gtkobj()->selection); }
SelectionList::iterator SelectionList::end_() const
  { return iterator(parent_->gtkobj(),(GList*)0); }

GList*& SelectionList::glist() const
  { return parent_->gtkobj()->selection; }

SelectionList::value_type SelectionList::operator[](size_type l) const
  {
    return Row(parent_->gtkobj(),
       GPOINTER_TO_INT(g_list_nth(parent_->gtkobj()->selection,l)->data));
  }

void SelectionList::all()
  {
    gtk_clist_select_all(parent_->gtkobj());
  }

void SelectionList::clear()
  {
    gtk_clist_unselect_all(parent_->gtkobj());
  }

void SelectionList::undo()
  {
    gtk_clist_undo_selection(parent_->gtkobj());
  }

SelectionList::size_type SelectionList::size() const
  {
    return g_list_length(parent_->gtkobj()->selection);
  }

/**************************************************************
*** RowList
**************************************************************/
RowList::iterator RowList::begin_() const
  { return iterator(parent_->gtkobj(),parent_->gtkobj()->row_list); }
RowList::iterator RowList::end_() const
  { return iterator(parent_->gtkobj(),(GList*)0); }

GList*& RowList::glist() const
  { return parent_->gtkobj()->row_list; }

RowList::value_type RowList::operator[](size_type l) const
  {
    return Row(parent_->gtkobj(),l);
  }

RowList::iterator RowList::insert(iterator i,const Gtk::SArray& text)
  {
    // on autosort the row may be different.
    return iterator(parent_->gtkobj(),
      gtk_clist_insert(parent_->gtkobj(),i.get_row_num(),
      const_cast<gchar**>((const gchar**)text)));
  }

RowList::iterator RowList::insert(const_reference i,const Gtk::SArray& text)
  {
    // on autosort the row may be different.
    return iterator(parent_->gtkobj(),
      gtk_clist_insert(parent_->gtkobj(),i.get_row_num(),
      const_cast<gchar**>((const gchar**)text)));
  }

void RowList::push_front(const Gtk::SArray& text)
  {
    gtk_clist_prepend(parent_->gtkobj(),
      const_cast<gchar**>((const gchar**)text));
  }

void RowList::push_back(const Gtk::SArray& text)
  {
    gtk_clist_append(parent_->gtkobj(),
      const_cast<gchar**>((const gchar**)text));
  }


void RowList::clear()
  {
    gtk_clist_clear(parent_->gtkobj());
  }

RowList::iterator RowList::erase(iterator i)
  {
    iterator i2=i;
    ++i2;
    gtk_clist_remove(parent_->gtkobj(),i.get_row_num());
    return i2;
  }

void RowList::erase(iterator start, iterator stop)
  {
    for (start; start!=stop; start++)
      erase(start);
  }

void RowList::remove(const_reference r)
  {
    gtk_clist_remove(parent_->gtkobj(),r.get_row_num());
  }

void RowList::swap(iterator i1, iterator i2)
  {
    gtk_clist_swap_rows(parent_->gtkobj(),i1.get_row_num(),i2.get_row_num());
  }

void RowList::move(iterator i1, iterator i2)
  {
    gtk_clist_row_move(parent_->gtkobj(),i1.get_row_num(),i2.get_row_num());
  }

void RowList::swap(const_reference i1, const_reference i2)
  {
    gtk_clist_swap_rows(parent_->gtkobj(),i1.get_row_num(),i2.get_row_num());
  }

void RowList::move(const_reference i1, const_reference i2)
  {
    gtk_clist_row_move(parent_->gtkobj(),i1.get_row_num(),i2.get_row_num());
  }


RowList::iterator RowList::find_data(gpointer data)
  {
    gint i=gtk_clist_find_row_from_data(parent_->gtkobj(), data);
    if (i==-1) return end();
    return RowIterator(parent_->gtkobj(),
                       g_list_nth(parent_->gtkobj()->row_list,i));
  }

RowList::size_type RowList::size(void) const
  {
    return parent_->gtkobj()->rows;
  }

Freeze::Freeze(CList & clist)
  : clist_(&clist)
  {
    clist_->freeze();
  }

Freeze::~Freeze()
  {
    clist_->thaw();
  }



} /* namespace CList_Helpers */

} /* namespace Gtk */

namespace Gtk {
Gtk::CList *wrap (GtkCList *o)
  {
    return static_cast<Gtk::CList *> (Gtk::wrap_auto ((GtkObject *) (o)));
  }
}

namespace Gtk {
CList_Class CList::clist_class = {0};

Object* CList_Class::wrap_new(GtkObject* o)
  {
    Object* cpp=manage(new CList((GtkCList*)(o)));
    return cpp;
  }

bool CList::isA( Object *checkcast)
  {
    return GTK_IS_CLIST(checkcast->gtkobj());
  }

GtkType CList::get_type()
  {
    return clist_class.get_type();
  }

GtkType CList_Class::get_type()
  {
    if (!type)
      {
        CppClassParent::CppObjectType::get_type();
        GtkTypeInfo info =
          {
            "Gtk__CList",
            sizeof(BaseObjectType),
            sizeof(BaseClassType),
            (GtkClassInitFunc) class_init_function,
            (GtkObjectInitFunc) object_init_function,
            /* reserved_1 */ NULL,
            /* reserved_2 */ NULL,
            /*base_class_init_func */ (GtkClassInitFunc) NULL
          };
        type=gtk_type_unique(gtk_clist_get_type(), &info);
      }
    return type;
  }

const char* const CList::signal_names[]={
   "select_row",
   "unselect_row",
   "select_all",
   "unselect_all",
   "undo_selection",
   "click_column",
   "row_move",
   "resize_column",
   "toggle_focus_row",
   "toggle_add_mode",
   "start_selection",
   "end_selection",
   "extend_selection",
   "scroll_vertical",
   "scroll_horizontal",
   "abort_column_resize",
   "set_scroll_adjustments",
   "insert_row",
   "remove_row",
   "clear",
   "sort_list",
   0};

void CList::initialize_class()
  {

     clist_self=this;

  }

void CList_Class::class_init_function(GtkCListClass *klass)
  {
    CppClassParent::class_init_function((BaseClassParent*)klass);
    klass->select_row=select_row_callback;
    klass->unselect_row=unselect_row_callback;
    klass->select_all=select_all_callback;
    klass->unselect_all=unselect_all_callback;
    klass->undo_selection=undo_selection_callback;
    klass->click_column=click_column_callback;
    klass->row_move=row_move_callback;
    klass->resize_column=resize_column_callback;
    klass->toggle_focus_row=toggle_focus_row_callback;
    klass->toggle_add_mode=toggle_add_mode_callback;
    klass->start_selection=start_selection_callback;
    klass->end_selection=end_selection_callback;
    klass->extend_selection=extend_selection_callback;
    klass->scroll_vertical=scroll_vertical_callback;
    klass->scroll_horizontal=scroll_horizontal_callback;
    klass->abort_column_resize=abort_column_resize_callback;
    klass->set_scroll_adjustments=set_scroll_adjustments_callback;
    klass->insert_row=insert_row_callback;
    klass->remove_row=remove_row_callback;
    klass->clear=clear_callback;
    klass->sort_list=sort_list_callback;
  }

void CList_Class::object_init_function(GtkCList *)
  {}

}

Gtk::CList::~CList() { destroy_(); }

void Gtk::CList::set_hadjustment(Gtk::Adjustment* adjustment)
  {
    gtk_clist_set_hadjustment(gtkobj(),(GtkAdjustment*)Gtk::unwrap(adjustment));
  }

void Gtk::CList::set_vadjustment(Gtk::Adjustment* adjustment)
  {
    gtk_clist_set_vadjustment(gtkobj(),(GtkAdjustment*)Gtk::unwrap(adjustment));
  }

void Gtk::CList::set_hadjustment(Gtk::Adjustment& adjustment)
  {
    gtk_clist_set_hadjustment(gtkobj(),adjustment.gtkobj());
  }

void Gtk::CList::set_vadjustment(Gtk::Adjustment& adjustment)
  {
    gtk_clist_set_vadjustment(gtkobj(),adjustment.gtkobj());
  }

void Gtk::CList::set_shadow_type(GtkShadowType type)
  {
    gtk_clist_set_shadow_type(gtkobj(),type);
  }

void Gtk::CList::set_selection_mode(GtkSelectionMode mode)
  {
    gtk_clist_set_selection_mode(gtkobj(),mode);
  }

void Gtk::CList::set_reorderable(bool reorderable)
  {
    gtk_clist_set_reorderable(gtkobj(),(gboolean)reorderable);
  }

void Gtk::CList::set_use_drag_icons(bool use_icons)
  {
    gtk_clist_set_use_drag_icons(gtkobj(),(gboolean)use_icons);
  }

void Gtk::CList::set_button_actions(guint button,guint8 button_actions)
  {
    gtk_clist_set_button_actions(gtkobj(),button,button_actions);
  }

void Gtk::CList::freeze()
  {
    gtk_clist_freeze(gtkobj());
  }

void Gtk::CList::thaw()
  {
    gtk_clist_thaw(gtkobj());
  }

void Gtk::CList::column_titles_show()
  {
    gtk_clist_column_titles_show(gtkobj());
  }

void Gtk::CList::column_titles_hide()
  {
    gtk_clist_column_titles_hide(gtkobj());
  }

void Gtk::CList::column_titles_active()
  {
    gtk_clist_column_titles_active(gtkobj());
  }

void Gtk::CList::column_titles_passive()
  {
    gtk_clist_column_titles_passive(gtkobj());
  }

gint Gtk::CList::columns_autosize()
  {
    return gtk_clist_columns_autosize(gtkobj());
  }

void Gtk::CList::set_row_height(guint height)
  {
    gtk_clist_set_row_height(gtkobj(),height);
  }

void Gtk::CList::set_compare_func(GtkCListCompareFunc cmp_func)
  {
    gtk_clist_set_compare_func(gtkobj(),cmp_func);
  }

void Gtk::CList::set_sort_column(gint column)
  {
    gtk_clist_set_sort_column(gtkobj(),column);
  }

void Gtk::CList::set_sort_type(GtkSortType sort_type)
  {
    gtk_clist_set_sort_type(gtkobj(),sort_type);
  }

void Gtk::CList::sort()
  {
    gtk_clist_sort(gtkobj());
  }

void Gtk::CList::set_auto_sort(bool auto_sort)
  {
    gtk_clist_set_auto_sort(gtkobj(),(gboolean)auto_sort);
  }

gint Gtk::CList::get_selection_info(gint x,gint y,gint* row,gint* column) const
  {
    return gtk_clist_get_selection_info(const_cast<GtkCList*>(gtkobj()),x,y,row,column);
  }

void Gtk::CList::column_title_active(gint column)
  {
    gtk_clist_column_title_active(gtkobj(),column);
  }

void Gtk::CList::column_title_passive(gint column)
  {
    gtk_clist_column_title_passive(gtkobj(),column);
  }

void Gtk::CList::set_column_title(gint column,const string& title)
  {
    gtk_clist_set_column_title(gtkobj(),column,title.c_str());
  }

string Gtk::CList::get_column_title(gint column) const
  {
    return gtk_clist_get_column_title(const_cast<GtkCList*>(gtkobj()),column);
  }

void Gtk::CList::set_column_widget(gint column,Gtk::Widget& widget)
  {
    gtk_clist_set_column_widget(gtkobj(),column,widget.gtkobj());
  }

Gtk::Widget* Gtk::CList::get_column_widget(gint column) const
  {
    return Gtk::wrap(gtk_clist_get_column_widget(const_cast<GtkCList*>(gtkobj()),column));
  }

void Gtk::CList::set_column_justification(gint column,GtkJustification justification)
  {
    gtk_clist_set_column_justification(gtkobj(),column,justification);
  }

void Gtk::CList::set_column_visibility(gint column,bool visible)
  {
    gtk_clist_set_column_visibility(gtkobj(),column,(gboolean)visible);
  }

void Gtk::CList::set_column_resizeable(gint column,bool resizeable)
  {
    gtk_clist_set_column_resizeable(gtkobj(),column,(gboolean)resizeable);
  }

void Gtk::CList::set_column_auto_resize(gint column,bool auto_resize)
  {
    gtk_clist_set_column_auto_resize(gtkobj(),column,(gboolean)auto_resize);
  }

gint Gtk::CList::optimal_column_width(gint column) const
  {
    return gtk_clist_optimal_column_width(const_cast<GtkCList*>(gtkobj()),column);
  }

void Gtk::CList::set_column_width(gint column,gint width)
  {
    gtk_clist_set_column_width(gtkobj(),column,width);
  }

void Gtk::CList::set_column_min_width(gint column,gint min_width)
  {
    gtk_clist_set_column_min_width(gtkobj(),column,min_width);
  }

void Gtk::CList::set_column_max_width(gint column,gint max_width)
  {
    gtk_clist_set_column_max_width(gtkobj(),column,max_width);
  }

void gtkmm_clist_click_column(GtkCList* clist,gint p0)
  {
    static guint signum=gtk_signal_lookup("click_column",gtk_clist_get_type());
    g_return_if_fail (clist != NULL);
    g_return_if_fail (GTK_CLIST (clist));

    gtk_signal_emit(GTK_OBJECT(clist),signum,p0);
  }

gint Gtk::CList::prepend_row(const SArray& text)
  {
    return gtk_clist_prepend(gtkobj(),const_cast<gchar**>((const char**)text));
  }

gint Gtk::CList::prepend(const SArray& text)
  {
    return gtk_clist_prepend(gtkobj(),const_cast<gchar**>((const char**)text));
  }

gint Gtk::CList::append_row(const SArray& text)
  {
    return gtk_clist_append(gtkobj(),const_cast<gchar**>((const char**)text));
  }

gint Gtk::CList::append(const SArray& text)
  {
    return gtk_clist_append(gtkobj(),const_cast<gchar**>((const char**)text));
  }

gint Gtk::CList::insert_row(gint row,const SArray& text)
  {
    return gtk_clist_insert(gtkobj(),row,const_cast<gchar**>((const char**)text));
  }

gint Gtk::CList::insert(gint row,const SArray& text)
  {
    return gtk_clist_insert(gtkobj(),row,const_cast<gchar**>((const char**)text));
  }

void Gtk::CList::clear()
  {
    gtk_clist_clear(gtkobj());
  }

void Gtk::CList::swap_rows(gint row1,gint row2)
  {
    gtk_clist_swap_rows(gtkobj(),row1,row2);
  }

gint Gtk::CList::find_row_from_data(gpointer data) const
  {
    return gtk_clist_find_row_from_data(const_cast<GtkCList*>(gtkobj()),data);
  }

GtkVisibility Gtk::CList::row_is_visible(gint row) const
  {
    return gtk_clist_row_is_visible(const_cast<GtkCList*>(gtkobj()),row);
  }

void Gtk::CList::set_foreground(gint row,const Gdk_Color& color)
  {
    gtk_clist_set_foreground(gtkobj(),row,const_cast<GdkColor*>(color.gdkobj()));
  }

void Gtk::CList::set_background(gint row,const Gdk_Color& color)
  {
    gtk_clist_set_background(gtkobj(),row,const_cast<GdkColor*>(color.gdkobj()));
  }

void Gtk::CList::set_row_style(gint row,Gtk::Style& style)
  {
    gtk_clist_set_row_style(gtkobj(),row,style.gtkobj());
  }

Gtk::Style* Gtk::CList::get_row_style(gint row) const
  {
    return Gtk::wrap(gtk_clist_get_row_style(const_cast<GtkCList*>(gtkobj()),row));
  }

bool Gtk::CList::get_selectable(gint row) const
  {
    return ((gtk_clist_get_selectable(const_cast<GtkCList*>(gtkobj()),row))?true:false);
  }

void Gtk::CList::set_selectable(gint row,bool selectable)
  {
    gtk_clist_set_selectable(gtkobj(),row,(gboolean)selectable);
  }

void Gtk::CList::remove_row(gint row)
  {
    gtk_clist_remove(gtkobj(),row);
  }

void Gtk::CList::set_row_data(gint row,gpointer data)
  {
    gtk_clist_set_row_data(gtkobj(),row,data);
  }

gpointer Gtk::CList::get_row_data(gint row) const
  {
    return gtk_clist_get_row_data(const_cast<GtkCList*>(gtkobj()),row);
  }

void Gtk::CList::set_row_data_full(gint row,gpointer data,GtkDestroyNotify destroy)
  {
    gtk_clist_set_row_data_full(gtkobj(),row,data,destroy);
  }

void Gtk::CList::moveto(gint row,gint column,gfloat row_align,gfloat col_align)
  {
    gtk_clist_moveto(gtkobj(),row,column,row_align,col_align);
  }

GtkCellType Gtk::CList::get_cell_type(gint row,gint column) const
  {
    return gtk_clist_get_cell_type(const_cast<GtkCList*>(gtkobj()),row,column);
  }

void Gtk::CList::set_text(gint row,gint column,const string& text)
  {
    gtk_clist_set_text(gtkobj(),row,column,text.c_str());
  }

void Gtk::CList::set_pixmap(gint row,gint column,const Gdk_Pixmap& pixmap,const Gdk_Bitmap& mask)
  {
    gtk_clist_set_pixmap(gtkobj(),row,column,const_cast<GdkPixmap*>(pixmap.gdkobj()),const_cast<GdkBitmap*>(mask.gdkobj()));
  }

void Gtk::CList::set_pixtext(gint row,gint column,const string& text,guint8 spacing,const Gdk_Pixmap& pixmap,const Gdk_Bitmap& mask)
  {
    gtk_clist_set_pixtext(gtkobj(),row,column,text.c_str(),spacing,const_cast<GdkPixmap*>(pixmap.gdkobj()),const_cast<GdkBitmap*>(mask.gdkobj()));
  }

void Gtk::CList::set_cell_style(gint row,gint column,Gtk::Style& style)
  {
    gtk_clist_set_cell_style(gtkobj(),row,column,style.gtkobj());
  }

Gtk::Style* Gtk::CList::get_cell_style(gint row,gint column) const
  {
    return Gtk::wrap(gtk_clist_get_cell_style(const_cast<GtkCList*>(gtkobj()),row,column));
  }

void Gtk::CList::set_shift(gint row,gint column,gint vertical,gint horizontal)
  {
    gtk_clist_set_shift(gtkobj(),row,column,vertical,horizontal);
  }

void gtk_clist_set_scroll_adjustments(GtkCList* clist,GtkAdjustment* p1,GtkAdjustment* p2)
  {
    static guint signum=gtk_signal_lookup("set_scroll_adjustments",gtk_clist_get_type());
    g_return_if_fail (clist != NULL);
    g_return_if_fail (GTK_CLIST (clist));

    gtk_signal_emit(GTK_OBJECT(clist),signum,p1,p2);
  }

void Gtk::CList_Class::select_row_callback(GtkCList* o_,gint p0,gint p1,GdkEvent* p2)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->select_row_impl(p0,p1,p2);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->select_row)
          (base->select_row)(o_,p0,p1,p2);
      }

  }

void Gtk::CList::select_row_impl(gint p0,gint p1,GdkEvent* p2)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->select_row)
      (base->select_row)(gtkobj(),p0,p1,p2);

  }

namespace {
static void select_row_convert_func(SigC::Callback3<void,gint,gint,GdkEvent*> *s,gint p0,gint p1,GdkEvent* p2)
  {
     s->call(p0,p1,p2);
  }

}

SigC::Connection
Gtk::CList::Proxy_select_row::connect(const SigC::Slot3<void,gint,gint,GdkEvent*> &s)
   {
    return BaseType::connect(SigC::convert(s,&select_row_convert_func));
   }

void Gtk::CList_Class::unselect_row_callback(GtkCList* o_,gint p0,gint p1,GdkEvent* p2)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->unselect_row_impl(p0,p1,p2);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->unselect_row)
          (base->unselect_row)(o_,p0,p1,p2);
      }

  }

void Gtk::CList::unselect_row_impl(gint p0,gint p1,GdkEvent* p2)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->unselect_row)
      (base->unselect_row)(gtkobj(),p0,p1,p2);

  }

namespace {
static void unselect_row_convert_func(SigC::Callback3<void,gint,gint,GdkEvent*> *s,gint p0,gint p1,GdkEvent* p2)
  {
     s->call(p0,p1,p2);
  }

}

SigC::Connection
Gtk::CList::Proxy_unselect_row::connect(const SigC::Slot3<void,gint,gint,GdkEvent*> &s)
   {
    return BaseType::connect(SigC::convert(s,&unselect_row_convert_func));
   }

void Gtk::CList_Class::select_all_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->select_all_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->select_all)
          (base->select_all)(o_);
      }

  }

void Gtk::CList::select_all_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->select_all)
      (base->select_all)(gtkobj());

  }

void Gtk::CList_Class::unselect_all_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->unselect_all_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->unselect_all)
          (base->unselect_all)(o_);
      }

  }

void Gtk::CList::unselect_all_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->unselect_all)
      (base->unselect_all)(gtkobj());

  }

void Gtk::CList_Class::undo_selection_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->undo_selection_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->undo_selection)
          (base->undo_selection)(o_);
      }

  }

void Gtk::CList::undo_selection_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->undo_selection)
      (base->undo_selection)(gtkobj());

  }

void Gtk::CList_Class::click_column_callback(GtkCList* o_,gint p0)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->click_column_impl(p0);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->click_column)
          (base->click_column)(o_,p0);
      }

  }

void Gtk::CList::click_column_impl(gint p0)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->click_column)
      (base->click_column)(gtkobj(),p0);

  }

void Gtk::CList_Class::row_move_callback(GtkCList* o_,gint p0,gint p1)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->row_move_impl(p0,p1);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->row_move)
          (base->row_move)(o_,p0,p1);
      }

  }

void Gtk::CList::row_move_impl(gint p0,gint p1)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->row_move)
      (base->row_move)(gtkobj(),p0,p1);

  }

void Gtk::CList_Class::resize_column_callback(GtkCList* o_,gint p0,gint p1)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->resize_column_impl(p0,p1);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->resize_column)
          (base->resize_column)(o_,p0,p1);
      }

  }

void Gtk::CList::resize_column_impl(gint p0,gint p1)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->resize_column)
      (base->resize_column)(gtkobj(),p0,p1);

  }

void Gtk::CList_Class::toggle_focus_row_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->toggle_focus_row_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->toggle_focus_row)
          (base->toggle_focus_row)(o_);
      }

  }

void Gtk::CList::toggle_focus_row_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->toggle_focus_row)
      (base->toggle_focus_row)(gtkobj());

  }

void Gtk::CList_Class::toggle_add_mode_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->toggle_add_mode_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->toggle_add_mode)
          (base->toggle_add_mode)(o_);
      }

  }

void Gtk::CList::toggle_add_mode_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->toggle_add_mode)
      (base->toggle_add_mode)(gtkobj());

  }

void Gtk::CList_Class::start_selection_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->start_selection_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->start_selection)
          (base->start_selection)(o_);
      }

  }

void Gtk::CList::start_selection_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->start_selection)
      (base->start_selection)(gtkobj());

  }

void Gtk::CList_Class::end_selection_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->end_selection_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->end_selection)
          (base->end_selection)(o_);
      }

  }

void Gtk::CList::end_selection_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->end_selection)
      (base->end_selection)(gtkobj());

  }

void Gtk::CList_Class::extend_selection_callback(GtkCList* o_,GtkScrollType p0,gfloat p1,gboolean p2)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->extend_selection_impl(p0,p1,p2);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->extend_selection)
          (base->extend_selection)(o_,p0,p1,p2);
      }

  }

void Gtk::CList::extend_selection_impl(GtkScrollType p0,gfloat p1,gboolean p2)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->extend_selection)
      (base->extend_selection)(gtkobj(),p0,p1,p2);

  }

void Gtk::CList_Class::scroll_vertical_callback(GtkCList* o_,GtkScrollType p0,gfloat p1)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->scroll_vertical_impl(p0,p1);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->scroll_vertical)
          (base->scroll_vertical)(o_,p0,p1);
      }

  }

void Gtk::CList::scroll_vertical_impl(GtkScrollType p0,gfloat p1)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->scroll_vertical)
      (base->scroll_vertical)(gtkobj(),p0,p1);

  }

void Gtk::CList_Class::scroll_horizontal_callback(GtkCList* o_,GtkScrollType p0,gfloat p1)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->scroll_horizontal_impl(p0,p1);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->scroll_horizontal)
          (base->scroll_horizontal)(o_,p0,p1);
      }

  }

void Gtk::CList::scroll_horizontal_impl(GtkScrollType p0,gfloat p1)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->scroll_horizontal)
      (base->scroll_horizontal)(gtkobj(),p0,p1);

  }

void Gtk::CList_Class::abort_column_resize_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->abort_column_resize_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->abort_column_resize)
          (base->abort_column_resize)(o_);
      }

  }

void Gtk::CList::abort_column_resize_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->abort_column_resize)
      (base->abort_column_resize)(gtkobj());

  }

void Gtk::CList_Class::set_scroll_adjustments_callback(GtkCList* p0,GtkAdjustment* p1,GtkAdjustment* p2)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)p0,Gtk::quark_)));

    if (obj)
      obj->set_scroll_adjustments_impl(Gtk::wrap(p1),Gtk::wrap(p2));
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)p0)->klass->type));
        if (base->set_scroll_adjustments)
          (base->set_scroll_adjustments)(p0,p1,p2);
      }

  }

void Gtk::CList::set_scroll_adjustments_impl(Gtk::Adjustment* p0,Gtk::Adjustment* p1)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->set_scroll_adjustments)
      (base->set_scroll_adjustments)(gtkobj(),(GtkAdjustment*)Gtk::unwrap(p0),(GtkAdjustment*)Gtk::unwrap(p1));

  }

namespace {
static void set_scroll_adjustments_convert_func(SigC::Callback2<void,Gtk::Adjustment*,Gtk::Adjustment*> *s,GtkAdjustment* p1,GtkAdjustment* p2)
  {
     s->call(Gtk::wrap(p1),Gtk::wrap(p2));
  }

}

SigC::Connection
Gtk::CList::Proxy_set_scroll_adjustments::connect(const SigC::Slot2<void,Gtk::Adjustment*,Gtk::Adjustment*> &s)
   {
    return BaseType::connect(SigC::convert(s,&set_scroll_adjustments_convert_func));
   }

void Gtk::CList::Proxy_set_scroll_adjustments::operator()(Gtk::Adjustment* p0,Gtk::Adjustment* p1)
  {
     BaseType::emit((GtkAdjustment*)Gtk::unwrap(p0),(GtkAdjustment*)Gtk::unwrap(p1));
  }

void Gtk::CList::Proxy_set_scroll_adjustments::emit(Gtk::Adjustment* p0,Gtk::Adjustment* p1)
  {
     BaseType::emit((GtkAdjustment*)Gtk::unwrap(p0),(GtkAdjustment*)Gtk::unwrap(p1));
  }

int Gtk::CList_Class::insert_row_callback(GtkCList* o_,gint row,gchar** p1)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      return obj->insert_row_impl(row,p1);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->insert_row)
          return (base->insert_row)(o_,row,p1);
        gtkmm_set_ignore();
      }
    return 0;

  }

int Gtk::CList::insert_row_impl(gint row,gchar** p1)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->insert_row)
      return (base->insert_row)(gtkobj(),row,p1);
    gtkmm_set_ignore();
    return 0;

  }

void Gtk::CList_Class::remove_row_callback(GtkCList* o_,gint row)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->remove_row_impl(row);
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->remove_row)
          (base->remove_row)(o_,row);
      }

  }

void Gtk::CList::remove_row_impl(gint row)
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->remove_row)
      (base->remove_row)(gtkobj(),row);

  }

void Gtk::CList_Class::clear_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->clear_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->clear)
          (base->clear)(o_);
      }

  }

void Gtk::CList::clear_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->clear)
      (base->clear)(gtkobj());

  }

void Gtk::CList_Class::sort_list_callback(GtkCList* o_)
  {
    CppObjectType *obj=
      static_cast<CppObjectType *>(static_cast<Gtk::Object *>(
        gtk_object_get_data_by_id((GtkObject*)o_,Gtk::quark_)));

    if (obj)
      obj->sort_list_impl();
    else
      {
        BaseClassType* base=
          static_cast<BaseClassType*>(
            gtk_type_parent_class(((GtkObject*)o_)->klass->type));
        if (base->sort_list)
          (base->sort_list)(o_);
      }

  }

void Gtk::CList::sort_list_impl()
  {
    BaseClassType* base=
      static_cast<BaseClassType*>(
        gtk_type_parent_class(gtkobject->klass->type));
    if (base->sort_list)
      (base->sort_list)(gtkobj());

  }

Gtk::Adjustment* Gtk::CList::get_hadjustment() const
  { return Gtk::wrap(gtkobj()->hadjustment); }

Gtk::Adjustment* Gtk::CList::get_vadjustment() const
  { return Gtk::wrap(gtkobj()->vadjustment); }

GtkSelectionMode Gtk::CList::get_selection_mode() const
  { return gtkobj()->selection_mode; }

gint Gtk::CList::get_row_height() const
  { return gtkobj()->row_height; }

gint Gtk::CList::get_rows() const
  { return gtkobj()->rows; }
