#ifndef __gtkmmext_pixscroller_h__ 
#define __gtkmmext_pixscroller_h__

#include <gtk--/drawingarea.h>
#include <gtk--/adjustment.h>
#include <gdk/gdk.h>

#include <gtkmmext/pix.h>

namespace Gtkmmext {

class PixScroller : public Gtk::DrawingArea
{
  public:
	PixScroller(Gtk::Adjustment& adjustment, Pix&);

	
	gint expose_event_impl (GdkEventExpose*);
	gint motion_notify_event_impl (GdkEventMotion*);
	gint button_press_event_impl (GdkEventButton*);
	gint button_release_event_impl (GdkEventButton*);
	void size_request_impl (GtkRequisition*);

  protected:
	Gtk::Adjustment& adj;

  private:
	GdkPixmap* rail;
	GdkPixmap* slider;
	GdkBitmap* rail_mask;
	GdkBitmap* slider_mask;
	GdkRectangle sliderrect;
	GdkRectangle railrect;
	GdkWindow* grab_window;
	double grab_y;
	double grab_start;
	int overall_height;
	bool dragging;
	
	void adjustment_changed ();
};

} // namespace

#endif /* __gtkmmext_pixscroller_h__ */
