/*
 * Copyright (c) 2023, MediaTek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SLEEP_DEF_H
#define SLEEP_DEF_H

/*
 * Auto generated by DE, please DO NOT modify this file directly.
 */

/* --- SPM Flag Define --- */
#define SPM_FLAG_DISABLE_CPU_PDN              (1U << 0)
#define SPM_FLAG_DISABLE_INFRA_PDN            (1U << 1)
#define SPM_FLAG_DISABLE_DDRPHY_PDN           (1U << 2)
#define SPM_FLAG_DISABLE_VCORE_DVS            (1U << 3)
#define SPM_FLAG_DISABLE_VCORE_DFS            (1U << 4)
#define SPM_FLAG_DISABLE_COMMON_SCENARIO      (1U << 5)
#define SPM_FLAG_DISABLE_BUS_CLK_OFF          (1U << 6)
#define SPM_FLAG_DISABLE_ARMPLL_OFF           (1U << 7)
#define SPM_FLAG_KEEP_CSYSPWRACK_HIGH         (1U << 8)
#define SPM_FLAG_ENABLE_LVTS_WORKAROUND       (1U << 9)
#define SPM_FLAG_RUN_COMMON_SCENARIO          (1U << 10)
#define SPM_FLAG_PERI_ON_IN_SUSPEND           (1U << 11)
#define SPM_FLAG_ENABLE_SPM_DBG_WDT_DUMP      (1U << 12)
#define SPM_FLAG_USE_SRCCLKENO2               (1U << 13)
#define SPM_FLAG_ENABLE_6315_CTRL             (1U << 14)
#define SPM_FLAG_ENABLE_TIA_WORKAROUND        (1U << 15)
#define SPM_FLAG_DISABLE_SYSRAM_SLEEP         (1U << 16)
#define SPM_FLAG_DISABLE_SSPM_SRAM_SLEEP      (1U << 17)
#define SPM_FLAG_DISABLE_MCUPM_SRAM_SLEEP     (1U << 18)
#define SPM_FLAG_DISABLE_DRAMC_ISSUE_CMD      (1U << 19)
#define SPM_FLAG_ENABLE_VOLTAGE_BIN           (1U << 20)
#define SPM_FLAG_RESERVED_BIT21               (1U << 21)
#define SPM_FLAG_DISABLE_DRAMC_MCU_SRAM_SLEEP (1U << 22)
#define SPM_FLAG_DISABLE_DRAMC_MD32_BACKUP    (1U << 23)
#define SPM_FLAG_RESERVED_BIT24               (1U << 24)
#define SPM_FLAG_RESERVED_BIT25               (1U << 25)
#define SPM_FLAG_RESERVED_BIT26               (1U << 26)
#define SPM_FLAG_VTCXO_STATE                  (1U << 27)
#define SPM_FLAG_INFRA_STATE                  (1U << 28)
#define SPM_FLAG_APSRC_STATE                  (1U << 29)
#define SPM_FLAG_VRF18_STATE                  (1U << 30)
#define SPM_FLAG_DDREN_STATE                  (1U << 31)
/* --- SPM Flag1 Define --- */
#define SPM_FLAG1_DISABLE_AXI_BUS_TO_26M      (1U << 0)
#define SPM_FLAG1_DISABLE_SYSPLL_OFF          (1U << 1)
#define SPM_FLAG1_DISABLE_PWRAP_CLK_SWITCH    (1U << 2)
#define SPM_FLAG1_DISABLE_ULPOSC_OFF          (1U << 3)
#define SPM_FLAG1_FW_SET_ULPOSC_ON            (1U << 4)
#define SPM_FLAG1_RESERVED_BIT5               (1U << 5)
#define SPM_FLAG1_ENABLE_REKICK               (1U << 6)
#define SPM_FLAG1_RESERVED_BIT7               (1U << 7)
#define SPM_FLAG1_RESERVED_BIT8               (1U << 8)
#define SPM_FLAG1_RESERVED_BIT9               (1U << 9)
#define SPM_FLAG1_DISABLE_SRCLKEN_LOW         (1U << 10)
#define SPM_FLAG1_DISABLE_SCP_CLK_SWITCH      (1U << 11)
#define SPM_FLAG1_RESERVED_BIT12              (1U << 12)
#define SPM_FLAG1_RESERVED_BIT13              (1U << 13)
#define SPM_FLAG1_RESERVED_BIT14              (1U << 14)
#define SPM_FLAG1_RESERVED_BIT15              (1U << 15)
#define SPM_FLAG1_RESERVED_BIT16              (1U << 16)
#define SPM_FLAG1_RESERVED_BIT17              (1U << 17)
#define SPM_FLAG1_RESERVED_BIT18              (1U << 18)
#define SPM_FLAG1_RESERVED_BIT19              (1U << 19)
#define SPM_FLAG1_DISABLE_DEVAPC_SRAM_SLEEP   (1U << 20)
#define SPM_FLAG1_RESERVED_BIT21              (1U << 21)
#define SPM_FLAG1_ENABLE_VS1_VOTER            (1U << 22)
#define SPM_FLAG1_ENABLE_VS2_VOTER            (1U << 23)
#define SPM_FLAG1_DISABLE_SCP_VREQ_MASK_CONTROL   (1U << 24)
#define SPM_FLAG1_RESERVED_BIT25              (1U << 25)
#define SPM_FLAG1_RESERVED_BIT26              (1U << 26)
#define SPM_FLAG1_RESERVED_BIT27              (1U << 27)
#define SPM_FLAG1_RESERVED_BIT28              (1U << 28)
#define SPM_FLAG1_RESERVED_BIT29              (1U << 29)
#define SPM_FLAG1_RESERVED_BIT30              (1U << 30)
#define SPM_FLAG1_RESERVED_BIT31              (1U << 31)
/* --- SPM DEBUG Define --- */
#define SPM_DBG_DEBUG_IDX_26M_WAKE            (1U << 0)
#define SPM_DBG_DEBUG_IDX_26M_SLEEP           (1U << 1)
#define SPM_DBG_DEBUG_IDX_INFRA_WAKE          (1U << 2)
#define SPM_DBG_DEBUG_IDX_INFRA_SLEEP         (1U << 3)
#define SPM_DBG_DEBUG_IDX_APSRC_WAKE          (1U << 4)
#define SPM_DBG_DEBUG_IDX_APSRC_SLEEP         (1U << 5)
#define SPM_DBG_DEBUG_IDX_VRF18_WAKE          (1U << 6)
#define SPM_DBG_DEBUG_IDX_VRF18_SLEEP         (1U << 7)
#define SPM_DBG_DEBUG_IDX_DDREN_WAKE          (1U << 8)
#define SPM_DBG_DEBUG_IDX_DDREN_SLEEP         (1U << 9)
#define SPM_DBG_DEBUG_IDX_DRAM_SREF_ABORT_IN_APSRC    (1U << 10)
#define SPM_DBG_DEBUG_IDX_MCUPM_SRAM_STATE    (1U << 11)
#define SPM_DBG_DEBUG_IDX_SSPM_SRAM_STATE     (1U << 12)
#define SPM_DBG_DEBUG_IDX_DRAM_SREF_ABORT_IN_DDREN    (1U << 13)
#define SPM_DBG_DEBUG_IDX_DRAMC_MCU_SRAM_STATE   (1U << 14)
#define SPM_DBG_DEBUG_IDX_SYSRAM_SLP          (1U << 15)
#define SPM_DBG_DEBUG_IDX_SYSRAM_ON           (1U << 16)
#define SPM_DBG_DEBUG_IDX_MCUPM_SRAM_SLP      (1U << 17)
#define SPM_DBG_DEBUG_IDX_MCUPM_SRAM_ON       (1U << 18)
#define SPM_DBG_DEBUG_IDX_SSPM_SRAM_SLP       (1U << 19)
#define SPM_DBG_DEBUG_IDX_SSPM_SRAM_ON        (1U << 20)
#define SPM_DBG_DEBUG_IDX_DRAMC_MCU_SRAM_SLP    (1U << 21)
#define SPM_DBG_DEBUG_IDX_DRAMC_MCU_SRAM_ON    (1U << 22)
#define SPM_DBG_DEBUG_IDX_SCP_VCORE_0P575V    (1U << 23)
#define SPM_DBG_DEBUG_IDX_SCP_VCORE_0P600V    (1U << 24)
#define SPM_DBG_DEBUG_IDX_SCP_VCORE_0P650V    (1U << 25)
#define SPM_DBG_DEBUG_IDX_SCP_VCORE_0P725V    (1U << 26)
#define SPM_DBG_DEBUG_IDX_SPM_GO_WAKEUP_NOW   (1U << 27)
#define SPM_DBG_DEBUG_IDX_VTCXO_STATE         (1U << 28)
#define SPM_DBG_DEBUG_IDX_INFRA_STATE         (1U << 29)
#define SPM_DBG_DEBUG_IDX_VRR18_STATE         (1U << 30)
#define SPM_DBG_DEBUG_IDX_APSRC_STATE         (1U << 31)
/* --- SPM DEBUG1 Define --- */
#define SPM_DBG1_DEBUG_IDX_CURRENT_IS_LP      (1U << 0)
#define SPM_DBG1_DEBUG_IDX_VCORE_DVFS_START   (1U << 1)
#define SPM_DBG1_DEBUG_IDX_SYSPLL_OFF         (1U << 2)
#define SPM_DBG1_DEBUG_IDX_SYSPLL_ON          (1U << 3)
#define SPM_DBG1_DEBUG_IDX_CURRENT_IS_VCORE_DVFS   (1U << 4)
#define SPM_DBG1_DEBUG_IDX_INFRA_MTCMOS_OFF   (1U << 5)
#define SPM_DBG1_DEBUG_IDX_INFRA_MTCMOS_ON    (1U << 6)
#define SPM_DBG1_DEBUG_IDX_VRCXO_SLEEP_ABORT   (1U << 7)
#define SPM_DBG1_RESERVED_BIT8                (1U << 8)
#define SPM_DBG1_DEBUG_IDX_INFRA_SUB_MTCMOS_OFF   (1U << 9)
#define SPM_DBG1_DEBUG_IDX_INFRA_SUB_MTCMOS_ON   (1U << 10)
#define SPM_DBG1_DEBUG_IDX_PWRAP_CLK_TO_ULPOSC   (1U << 11)
#define SPM_DBG1_DEBUG_IDX_PWRAP_CLK_TO_26M   (1U << 12)
#define SPM_DBG1_DEBUG_IDX_SCP_CLK_TO_32K     (1U << 13)
#define SPM_DBG1_DEBUG_IDX_SCP_CLK_TO_26M     (1U << 14)
#define SPM_DBG1_DEBUG_IDX_BUS_CLK_OFF        (1U << 15)
#define SPM_DBG1_DEBUG_IDX_BUS_CLK_ON         (1U << 16)
#define SPM_DBG1_DEBUG_IDX_SRCLKEN2_LOW       (1U << 17)
#define SPM_DBG1_DEBUG_IDX_SRCLKEN2_HIGH      (1U << 18)
#define SPM_DBG1_RESERVED_BIT19               (1U << 19)
#define SPM_DBG1_DEBUG_IDX_ULPOSC_IS_OFF_BUT_SHOULD_ON   (1U << 20)
#define SPM_DBG1_DEBUG_IDX_6315_LOW		(1U << 21)
#define SPM_DBG1_DEBUG_IDX_6315_HIGH		(1U << 22)
#define SPM_DBG1_DEBUG_IDX_PWRAP_SLEEP_ACK_LOW_ABORT   (1U << 23)
#define SPM_DBG1_DEBUG_IDX_PWRAP_SLEEP_ACK_HIGH_ABORT   (1U << 24)
#define SPM_DBG1_DEBUG_IDX_EMI_SLP_IDLE_ABORT   (1U << 25)
#define SPM_DBG1_DEBUG_IDX_SCP_SLP_ACK_LOW_ABORT   (1U << 26)
#define SPM_DBG1_DEBUG_IDX_SCP_SLP_ACK_HIGH_ABORT   (1U << 27)
#define SPM_DBG1_DEBUG_IDX_SPM_DVFS_CMD_RDY_ABORT   (1U << 28)
#define SPM_DBG1_RESERVED_BIT29               (1U << 29)
#define SPM_DBG1_RESERVED_BIT30               (1U << 30)
#define SPM_DBG1_RESERVED_BIT31               (1U << 31)

/*
 * Macro and Inline
 */
#define is_cpu_pdn(flags)		((flags) & SPM_FLAG_DIS_CPU_PDN == 0)
#define is_infra_pdn(flags)		((flags) & SPM_FLAG_DIS_INFRA_PDN == 0)
#define is_ddrphy_pdn(flags)		((flags) & SPM_FLAG_DIS_DDRPHY_PDN == 0)

#endif /* SLEEP_DEF_H */
