//
// Copyright © 2019 Arm Ltd. All rights reserved.
// SPDX-License-Identifier: MIT
//

#pragma once

#include <cstdint>

namespace armnn
{

namespace profiling
{

class IReadCounterValues
{
public:
    virtual ~IReadCounterValues() {}

    virtual bool IsCounterRegistered(uint16_t counterUid) const = 0;
    virtual uint16_t GetCounterCount() const = 0;
    virtual uint32_t GetCounterValue(uint16_t counterUid) const = 0;
};

class IWriteCounterValues
{
public:
    virtual ~IWriteCounterValues() {}

    virtual void SetCounterValue(uint16_t counterUid, uint32_t value) = 0;
    virtual uint32_t AddCounterValue(uint16_t counterUid, uint32_t value) = 0;
    virtual uint32_t SubtractCounterValue(uint16_t counterUid, uint32_t value) = 0;
    virtual uint32_t IncrementCounterValue(uint16_t counterUid) = 0;
    virtual uint32_t DecrementCounterValue(uint16_t counterUid) = 0;
};

class IReadWriteCounterValues : public IReadCounterValues, public IWriteCounterValues
{
public:
    virtual ~IReadWriteCounterValues() {}
};

} // namespace profiling

} // namespace armnn
