INCLUDE(ExternalProject)

SET(prefix ${CMAKE_BINARY_DIR}/third_party/clBLAS)
SET(clBLAS_location ${prefix}/lib/import/${CMAKE_STATIC_LIBRARY_PREFIX}clBLAS${CMAKE_STATIC_LIBRARY_SUFFIX})
IF(CMAKE_VERSION VERSION_LESS 3.2)
    IF(CMAKE_GENERATOR MATCHES "Ninja")
        MESSAGE(WARNING "Building clBLAS with Ninja has known issues with CMake older than 3.2")
    endif()
    SET(byproducts)
ELSE()
    SET(byproducts BYPRODUCTS ${clBLAS_location})
ENDIF()

ExternalProject_Add(
    clBLAS-external
    GIT_REPOSITORY https://github.com/arrayfire/clBLAS.git
    GIT_TAG 47662a6ac1186c756508109d7fef8827efab4504
    PREFIX "${prefix}"
    INSTALL_DIR "${prefix}"
    UPDATE_COMMAND ""
    CONFIGURE_COMMAND ${CMAKE_COMMAND} -Wno-dev "-G${CMAKE_GENERATOR}" <SOURCE_DIR>/src
    -DCMAKE_CXX_COMPILER:FILEPATH=${CMAKE_CXX_COMPILER}
    "-DCMAKE_CXX_FLAGS:STRING=${CMAKE_CXX_FLAGS} -w -fPIC"
    -DCMAKE_C_COMPILER:FILEPATH=${CMAKE_C_COMPILER}
    "-DCMAKE_C_FLAGS:STRING=${CMAKE_C_FLAGS} -w -fPIC"
    -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
    -DCMAKE_INSTALL_PREFIX:PATH=<INSTALL_DIR>
    -DBUILD_SHARED_LIBS:BOOL=OFF
    -DBUILD_CLIENT:BOOL=OFF
    -DBUILD_TEST:BOOL=OFF
    -DBUILD_KTEST:BOOL=OFF
    -DSUFFIX_LIB:STRING=
    ${byproducts}
    )

ExternalProject_Get_Property(clBLAS-external install_dir)
ADD_LIBRARY(clBLAS IMPORTED STATIC)
SET_TARGET_PROPERTIES(clBLAS PROPERTIES IMPORTED_LOCATION ${clBLAS_location})
ADD_DEPENDENCIES(clBLAS clBLAS-external)
SET(CLBLAS_INCLUDE_DIRS ${install_dir}/include)
SET(CLBLAS_LIBRARIES clBLAS)
SET(CLBLAS_FOUND ON)
