/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __BURNERPAGE_H__
#define __BURNERPAGE_H__

#include "_burnerpage.h"
#include "configdlg.h"
#include "device.h"

/*========================================================*/

class ArsonBurnerPage : public ArsonBurnerPageBase, public ArsonConfigPage
{
	Q_OBJECT
	
public:
	ArsonBurnerPage (ArsonConfig &cfg, ArsonConfigDlg *pdlg, QWidget *parent);

private:
	void handleCheckboxes (bool save);
	void updateDevs (const char *dev, const ArsonDeviceList &dl);

	virtual void size_preset_down (void);
	virtual void size_preset_up (void);

	void setPresetText (void);
	
	int m_preset;

	ArsonDeviceUiList m_devs;

public slots:
	void on_dev_changed (const ArsonDeviceList &dl);
	void on_accept (void);
};
/*========================================================*/
#endif	/*	__BURNERPAGE_H__	*/
