/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	The general options apge class implementation
 *
 *	by Tony Sideris	(07:11PM May 14, 2002)
 *================================================*/
#include "arson.h"

#include <qcombobox.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include <kfiledialog.h>

#include "optionpage.h"
#include "mainwnd.h"
#include "konfig.h"

/*========================================================*/

ArsonOptionPage::ArsonOptionPage (ArsonConfig &config, ArsonConfigDlg *pd, QWidget *parent)
	: ArsonOptionPageBase(parent), ArsonConfigPage(config)
{
	//	Fill in the initial document list
	for (int index = 0; index < _DOCUMENT_MAX; ++index)
	{
		QString temp (ArsonFrame::documentTitle(index));
		const int cat = temp.find('&');

		if (cat != -1)
			temp.remove(cat, 1);

		init_doc->insertItem(temp);
	}

	tempdir->setText(cfg().temporaryDirectory());
	init_doc->setCurrentItem(cfg().startDoc());
	handleCheckboxes(false);
}

/*========================================================*/

void ArsonOptionPage::handleCheckboxes (bool save)
{
	struct {
		QCheckBox *pb;
		uint mask;
	}	checks[] = {
		{ md5_verify, ArsonConfig::flagMd5Verify },
		{ md5_reset, ArsonConfig::flagMd5Reset },
	};

	for (int index = 0; index < ARRSIZE(checks); ++index)
		if (save)
			cfg().fromBool(checks[index].mask, checks[index].pb->isChecked());
		else
			checks[index].pb->setChecked(cfg().is(checks[index].mask));
}

/*========================================================*/

void ArsonOptionPage::browse_clicked (void)
{
	const QString dir = KFileDialog::getExistingDirectory();

	if (dir != QString::null)
		tempdir->setText(dir);
}

/*========================================================*/

void ArsonOptionPage::on_accept (void)
{
	cfg().setTemporaryDirectory(tempdir->text());
	cfg().setStartDoc(init_doc->currentItem());
	handleCheckboxes(true);
}

/*========================================================*/
