/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	Program properties dialog class implementation
 *
 *	by Tony Sideris	(08:50AM Aug 09, 2001)
 *================================================*/
#include "arson.h"

#include <qlineedit.h>
#include <qlabel.h>

#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klocale.h>

#include "programdlg.h"
#include "konfig.h"

/*========================================================*/

ArsonProgramDlg::ArsonProgramDlg (QWidget *parent, int nprog, ArsonConfig::Program &prog)
	: ArsonProgramDlgBase(parent, NULL, TRUE),
	m_progNum(nprog),
	m_program(prog)
{
	m_progname = ArsonConfig::programName(nprog);
	
	setCaption(
		i18n("Program Configuration: %1")
		.arg(m_progname));

	desc->setText(ArsonConfig::programDesc(nprog));
	path->setText(prog.m_program);
	params->setText(prog.m_params);
}

/*========================================================*/

void ArsonProgramDlg::help_clicked (void)
{
	ArsonProgramHelp proc (m_progNum);

	if (proc.valid())
		proc.show(this);
}

/*========================================================*/

void ArsonProgramDlg::browse_clicked (void)
{
	const QString prog = KFileDialog::getOpenFileName(
		QString::null,
		i18n("%1|%2\n*|All Files").arg(m_progname).arg(m_progname),
		NULL, m_progname);

	if (prog != QString::null)
	{
		if (!arsonIsExecutable(prog))
		{
			arsonErrorMsg(
				i18n("The selected file is not executable..."));

			return;
		}

		path->setText(prog);
	}
}

/*========================================================*/

void ArsonProgramDlg::accept (void)
{
	m_program.m_program = path->text();
	m_program.m_params = params->text();

	ArsonProgramDlgBase::accept();
}

/*========================================================*/
