/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __INFPROGBAR_H__
#define __INFPROGBAR_H__

#include <qprogressbar.h>

#include <kpixmap.h>

/*==================================*/
/*	DEFINES
 *==================================*/

enum {
	arsonProgressNormal = 0,
	arsonProgressInfinite,
	arsonProgressBlank,
};

/*========================================================*/

class QPainter;
class QTimer;

class ArsonInfiniteProgressBar : public QProgressBar
{
	Q_OBJECT
	
public:
	ArsonInfiniteProgressBar (QWidget *parent, const char *name);

	bool infinite (void) const { return m_nMode == arsonProgressInfinite; }
	int mode (void) const { return m_nMode; }
	void setMode (int mode);

protected:
	virtual void drawContents (QPainter *ptr);
	virtual void resizeEvent (QResizeEvent *ptr);

	void createPixmaps (const QSize &size);
	QRect getRect (bool edge = false) const;

	int m_nAniPos;
	QTimer *m_pTimer;
	uint m_nMode : 4;
	uint m_bDirLeft : 1;
	KPixmap m_pml, m_pmr;

protected slots:
	void slotTimeout (void);
};

/*========================================================*/

class ArsonDiskUsageBar : public QFrame
{
	Q_OBJECT
	
public:
	ArsonDiskUsageBar (QWidget *parent, const char *name = NULL);
	ArsonDiskUsageBar (int max, int pos, QWidget *parent, const char *name = NULL);
	virtual ~ArsonDiskUsageBar (void);

	int full (void) const { return max() + (max() / 4); }
	int max (void) const { return m_max; }
	int pos (void) const { return m_pos; }
	int mod (void) const { return m_mod; }

	void setSuffix (const QString &str) { m_suffix = str; }
	QString suffix (void) const { return m_suffix; }

	void setMod (int mod) { m_mod = mod; }
	
	void setMax (int max);
	void setPos (int p);

	virtual QSize minimumSizeHint (void) const;
	virtual QSize sizeHint (void) const;

private:
	virtual void drawContents (QPainter *ptr);

	enum {
		subrectProgress,
		subrectMarks,
	};

	void drawProgress (QPainter *ptr, const QColorGroup &cg, const QRect &rc);
	void drawMarks (QPainter *ptr, const QColorGroup &cg, const QRect &rc);

	void drawMark (QPainter *ptr, const QRect &rc, int pos, bool right = false);
	int percentageOf (const QRect &rc, int pos) const;

	QRect subRect (int which) const;
	
	void startTimer (void);
	void endTimer (void);
	void checkTimer (void);

	void init (void);

	QString m_suffix;
	QTimer *m_pTimer;
	QColor m_color;
	int m_mod;
	int m_max;
	int m_pos;

private slots:
	void slotTimer (void);
};

/*========================================================*/
#endif	/*	__INFPROGBAR_H__	*/
