/* :: ascii-jump project
   :: $Id: cup.c,v 1.1.1.1 2003/02/28 10:05:04 loth Exp $
   
   :: copyright (c) 2003 :: grzegorz moskal, g.moskal@opengruop.org
   :: license gnu gpl v 2						*/

#define CUP_C
#include "cup.h"

struct object **jumpers_tab, *jumpers;
struct hill **hills_tab;

int nhills, njumpers = 8;

int cup_status;
static int set_hill = 1;
static int double_hill = 0;

static int current_jumper_no;
static int current_hill_no;

static struct widget *scr_result;
static struct widget *win_result;
static struct widget *menu_result;

static char *names[] = {
"player",
"next player",
"next ^2 player",
"next ^3 player",
"erykah badu",
"charlie parker",
"thom yorke",
"bjork",
NULL
};

static void jumpers_init()
{
	struct object *last = NULL, *jmp;
	int i = 0;
	
	for (; i < njumpers; i++) {
		jmp = jumper_init(hills, skin, (i < 8) ? names[i] : "foo");
		if (i < 4)
			jmp->level = 0;
		if (jumpers == NULL) 
			jumpers = last = jmp;
		else {
			last->next = jmp; 
			SWITCH(last);
		}
	}
	
	jumpers_tab = xmalloc(sizeof(struct object *)*njumpers);
	hills_tab = xmalloc(sizeof(struct hill *)*nhills);
}

void cup_init()
{
	scr_result = screen_add();
	jumpers_init();
	scrcup_init();
}

void cup_refresh(void)
{
	int i = njumpers-1;

	current_jumper_no = 0;
	current_hill_no = 0;
	
	for (; i >= 0; i--) 
		if (jumpers_tab[i]) {
			jumper_flush(jumpers_tab[i], hills);
			jumpers_tab[i]->points = 0;
		}

	cup_menurefresh();
}

static void cup_menurefresh_last()
{
	int uw = sl_screen_width/10, i, place = 1;
	char *text = NULL;
	int len = 0, tmplen = 0;
	
	win_result = window_add(scr_result, 
		" world cup _w_i_n_n_e_r_s ", 5, 3, uw*6, 11);
	menuobj_add(menu_add(win_result, 2, 8, uw*6-2, 1, 0),
		"<<<", 0,  scrmain_show, 0);

	for (i = njumpers-1; i >= 0; i--)  {
		if (jumpers_tab[i] == 0)
			continue;
			
		if (text)
			tmplen = strlen(text);
			
		len += strlen(jumpers_tab[i]->name) + 20;
		text = xrealloc(text, sizeof(char) * len);
		sprintf(text+tmplen, "  %d. %.1f  %s\n", place,
			jumpers_tab[i]->points, jumpers_tab[i]->name);
		if (place++ > 5)
			break;
	}
	
	textbox_add(win_result, text);
	xfree(text);	
	
	scr_result->kids = scr_result->current = win_result;
	
	cup_status = MENU;
	
	sl_cls();
}

static void cup_menurefresh()
{
	struct widget *mo;
	char *name;
	int i;

	win_result = window_add(scr_result, "results", 3, 1,
		WIDTH-6, HEIGHT-2);
	menuobj_add(menu_add(win_result,1, 
	HEIGHT-4, WIDTH-9, 1,0), ">>>", 0,  cup_gamerefresh, 0);
	menu_result = menu_add(win_result, 1, 2, WIDTH-9, HEIGHT-2, 0);
	menu_result->selectable = 0;
	
	jumper_tabsort(jumpers_tab, njumpers);
	
	for (i = njumpers-1; i >= 0; i--) {
		if (jumpers_tab[i] == 0)
			continue;
			
		name = xmalloc(sizeof(char) * (strlen(jumpers_tab[i]->name) + 30));
		sprintf(name, "%s  --  %.1f(%.1f)", 
			jumpers_tab[i]->name, jumpers_tab[i]->points, jumpers_tab[i]->last_points);
		mo = menuobj_add(menu_result, name, *name, NULL, 0);
		
		if (i == current_jumper_no)
			menu_result->current = mo;
		xfree(name);
			
	}
		
	scr_result->kids = scr_result->current = win_result;
	cup_status = MENU;
	status = CUP;
	sl_cls();
}

static void cup_gamerefresh(void)
{
	cup_status = GAME;
	sl_cls();
}

static void cup_service(void)
{
	if (current_hill_no < nhills && HILL) {
		int i = njumpers-1;
		for (; i >= 0; i--) 
			if (jumpers_tab[i])
				jumper_flush(jumpers_tab[i], HILL);
					
		jumper_tabsort(jumpers_tab, njumpers);
		set_hill = 0;			
		if (++double_hill >= 2) {
			current_hill_no++;
			double_hill = 0;
		} else 
			hill_intro(HILL);
	} else {
		cup_menurefresh_last();
		set_hill = 0;
	}
}

void cup(int key)
{
	
	switch (cup_status) {
	case MENU:
		if (current_jumper_no == 0 && set_hill) 
			cup_service();
			
		scr_result->draw(scr_result);
		scr_result->key(scr_result, key);
		break;
	
	case GAME:
		if (JUMPER->level)
			jumper_cpujump(JUMPER);
		else if (jumper_service(JUMPER, key)) {
			game_draw(JUMPER);	
			break;
			
		}
		
		if (++current_jumper_no >= njumpers || JUMPER == 0) {
			current_jumper_no = 0;
			set_hill = 1;
			cup_menurefresh();
		}
	}
}
