#include <unistd.h>

#include <asddef.h>

#include "protocol-http.h"
#include "protocol-http-inet.h"
#include "inet.h"

static int _fd;
static gboolean _enabled = FALSE;

gboolean protocol_http_inet_init(guint16 port)
{
  g_assert(!_enabled);
  return (_enabled = ((_fd = inet_server_socket(port ? port : ASD_PROTOCOL_HTTP_INET_PORT)) >= 0));
}

void protocol_http_inet_done()
{
  if (_enabled)
    close(_fd);

  _enabled = FALSE;
}

int protocol_http_inet_get_fd()
{
  return _fd;
}

gboolean protocol_http_inet_enabled()
{
  return _enabled;
}

void protocol_http_inet_accept()
{  
  int sock;
  
  g_assert(_enabled);
  
  if ((sock = inet_server_accept(_fd)) >= 0)
    protocol_http_new_socket(sock);
}
