------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                          A 4 G . N E N C L _ E L                         --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1995-2002, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
--
--
--
--
--
--
--
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

--  Now this package contains temporary patches for the current (ugly and
--  non-effective) implementation of Enclosing_Element, which definitely
--  should be revised.

with Asis;

with Types; use Types;

package A4G.Nencl_El is

   function An_Association_Enclosing
     (Element : Asis.Element)
      return Asis.Element;
   --  Computes the Enclosing Element for parameter associations. The main
   --  difference with An_Expression_Enclosing is that here we may have to deal
   --  with normalized associations

   function An_Expression_Enclosing
     (Element : Asis.Element)
      return Asis.Element;
   --  This function implements the part of the semantic of the
   --  Asis.Elements.Enclosing_Element function corresponding to the
   --  enclosing element retrieving for elements representing Ada explicit
   --  constructs. It deals only with expressions - the hardest part
   --  for Enclosing_Element.

   function Get_Rough_Enclosing_Node (Element : Asis.Element) return Node_Id;
   --  This function finds the node, which is the base for a "rough"
   --  enclosing element for the argument Element. Starting from the
   --  argument R_Node, we go up through the chain of Parent nodes
   --  till the first node, which is a member of some Node_List or to the node
   --  representing the unit declaration in a compilation unit

   function Get_Enclosing
     (Approximation : Asis.Element;
      Element       : Asis.Element)
      return Asis.Element;
   --  This function finds the Enclosing Element for Element by traversing
   --  Approximation which is  considered as a rough estimation for
   --  enclosing element.

   procedure Skip_Normalized_Declarations_Back (Node : in out Node_Id);
   --  this procedure is applied in case when the compiler may normalize a
   --  multi-identifier declaration (or multi-name with clause) in a set of
   --  equivalent one-identifier (one-name) declarations (clauses). It is
   --  intended to be called for Node representing any  declaration
   --  (clause) in this normalized sequence, and it resets its parameter
   --  to point to the first declaration (clause) in this sequence
   --
   --  There is no harm to call this procedure for Node which does not
   --  represent a normalized declaration (or even which does not represent
   --  any declaration at all), or for Node which represents the first
   --  declaration in a normalized chain - the procedure simply leaves
   --  its parameter intact.
   --
   --  (In some sense this procedure may be considered as an "inversion
   --  of the local procedure Skip_Normalized_Declarations defined in
   --  the body of the A4G.Mapping package)

end A4G.Nencl_El;
