------------------------------------------------------------------------------
--                                                                          --
--                      GNAT METRICS TOOLS COMPONENTS                       --
--                                                                          --
--                       M E T R I C S . C O M M O N                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2002-2005, AdaCore                     --
--                                                                          --
-- GNAT Metrics Toolset  is free software;  you can  redistribute it and/or --
-- modify it under terms of the  GNU General Public License as published by --
-- the Free Software Foundation;  either version 2, or (at your option) any --
-- later version.  GNAT Metrics Toolset is  distributed in the hope that it --
-- will be useful, but  WITHOUT ANY WARRANTY; without even the implied war- --
-- ranty of  MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the --
-- GNU General Public License for more details.  You should have received a --
-- copy of the  GNU General Public License distributed with  GNAT; see file --
-- COPYING.  If not,  write to the  Free  Software  Foundation,   59 Temple --
-- Place - Suite 330, Boston,                                               --
--                                                                          --
-- GNAT Metrics Toolset is maintained by Adacore (http://www.adacore.com).  --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains some general-purpose entities that are used by many
--  Metrics Toolset components

with Ada.Command_Line;
with Ada.Text_IO; use Ada.Text_IO;
with GNAT.OS_Lib; use GNAT.OS_Lib;
with Asis;

package METRICS.Common is

   Fatal_Error : exception;
   --  This exception should be raised when there is no sense any more to do
   --  any work in the tool. When raising this exception, one has to generate
   --  the "fatal" diagnostic message and set exit status to Failure

   The_Context : Asis.Context;
   --  The Context for all the processing made by the metrics tools. May be
   --  associated, opened, closed and dissociated several times during one
   --  tool run

   The_CU : Asis.Compilation_Unit;
   --  The ASIS Compilation Unit corresponding to the unit represented by the
   --  source being processed.

   CU_Kind :  Asis.Unit_Kinds;
   CU_Class : Asis.Unit_Classes;

   May_Have_Public_Subprograms : Boolean := False;
   May_Have_Subprogram_Bodies  : Boolean := False;
   --  These flags are used to define if a number-of-subprograms metrics should
   --  be computed for the given unit.

   May_Have_Public_Types     : Boolean := False;
   May_Have_Type_Definitions : Boolean := False;
   --  These flags are used to define if a number-of-types metrics should
   --  be computed for the given unit.

   --  We place these four flags here to compute them only once, because there
   --  is no sense to compute them for nested (non library-level) program
   --  units.

   The_Unit : Asis.Element;
   --  The top-level element of the program unit from the CU represented by
   --  The_CU

   Global_Output : File_Access;
   --  Output file for global metrics information

   Global_Out_File : File_Type;
   --  File to place the global metrics summed up for all the files processed.

   Output_Dir : String_Access := new String'("");
   --  The name of the directory to place the detailed metrics info in. Is set
   --  by '-d' option.

   XML_Out_File : File_Type;
   --  File to place the XML output.

   Generate_Text_Output : Boolean := True;
   --  If this flag is ON, the metrics output in textual form is generated

   Generate_XML_Output : Boolean := False;
   --  If this flag is ON, the metrics output in XML format is generated

   Source_Output_File : File_Type;
   --  The output file containing detailed metrics for one source

   Indent_String : constant String := "   ";
   --  Indentation level in body complexity report. Should we set it from
   --  some parameter?

   Out_Suffix : String_Access;
   --  The suffix of the source out file

   Global_File_Name : String_Access;
   --  The name of the file to print the global metrics info in. If null, this
   --  output is sent to Stdout

   XML_File_Name : String_Access;
   --  The name of the file to print the XML form of the metrics info in.

   GNATMETRIC_Exit_Status : Ada.Command_Line.Exit_Status :=
     Ada.Command_Line.Success;
   --  Sets to Failure if any problem is detected during the gnatmetric run,
   --  including the attempt to compile illegal source.

end METRICS.Common;
