------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS                            --
--                                                                          --
--     G N A T E L I M . A N A L Y Z E . P R E P A R E _ C O N T E X T      --
--                                                                          --
--                       P r o c e d u r e   B o d y                        --
--                                                                          --
--           Copyright (C) 2003-2004 Ada Core Technologies, Inc.            --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to  the  Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by Ada Core Technologies Inc  (http://www.gnat.com) --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Wide_Text_IO; use Ada.Wide_Text_IO;
with Asis.Exceptions;  use Asis.Exceptions;

separate (Gnatelim.Analyze)
procedure Prepare_Context
  (Gnatmake_Output : String_Access;
   Tree_File       : String)
is
   File : File_Type;
   Result : Boolean;
begin

   --  ??? workaround a problem that gcc doesn't generate ALI files for
   --  RTL components
   Create (File, Name => Base_Name (Tree_File, ".adt") & ".ali");
   Close (File);

   Compile
     (Gnatmake_Output,
      Arg_List.all,
      Result,
      GCC => Gcc);

   if not Result then
      Warning ("gnatelim: Couldn't compile "
                 & To_Wide_String (Gnatmake_Output.all), True);
      raise Fatal_Error;
   end if;

   if not Is_Regular_File (Tree_File) then
      --  There was an error in gnatmake run
      Error ("Could not find the tree file.");
   end if;

   --  Initialize ASIS environment in one-tree mode

   Associate (The_Context, "Gnatelim Context",
              "-C1 " & To_Wide_String (Tree_File));
   Open (The_Context);

   --  May be we need an exception handler here, see gnatpp
end Prepare_Context;
