------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS                            --
--                                                                          --
--                   G N A T E L I M . B I N D _ F I L E                    --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 15113 $
--                                                                          --
--            Copyright (C) 1998-2001 Ada Core Technologies, Inc.           --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to  the  Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by Ada Core Technologies Inc  (http://www.gnat.com) --
--                                                                          --
------------------------------------------------------------------------------

--  This package analyzes the bindfile, extracting all the compilation units
--  that make up the Ada program that is being analyzed

with GNAT.Table;

package Gnatelim.Bind_File is

   type Unit_Name_Record is record
      Name : String_Loc;
      Spec, Postponed, Analyzed, Present_Here : Boolean;
   end record;

   package Unit_Names is new GNAT.Table
     (Unit_Name_Record, Integer, 1, 200, 200);

   procedure Process_Bind_File (Main : String; Bindname : String := "");
   --  Taking the name of the main unit, this procedure tries to obtain
   --  the compilation units upon which the given unit depends
   --  semantically. It uses the Ada or C bind file created for the main unit
   --  to do this, therefore units are returned in the right elaboration order.
   --  If there is no bind file, General_Error is raised. If Bindname is not
   --  empty, it is used as a name of the bind file, otherwise gnatelim will
   --  attempt to construct the bind file name from the main unit name;
   --  in the later case, if both Ada and C bind files are present, Ada bind
   --  file is processed.
   --  All the compilation units located in the bind file are stored inside
   --  Unit_Names table

end Gnatelim.Bind_File;
