------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS                            --
--                                                                          --
--                      G N A T E L I M . E R R O R S                       --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (C) 1998-2003 Ada Core Technologies, Inc.           --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to  the  Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by Ada Core Technologies Inc  (http://www.gnat.com) --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Command_Line; use Ada.Command_Line;
with Ada.Wide_Text_IO; use Ada.Wide_Text_IO;

package body Gnatelim.Errors is

   Spaces : constant Wide_String (1 .. 50) := (others => ' ');

   -------------
   --  Error  --
   -------------

   procedure Error (Msg : Wide_String) is
   begin
      Set_Output (Standard_Error);
      Put_Line (Msg);
      Set_Output (Standard_Output);
      Set_Exit_Status (Failure);
      raise Fatal_Error;
   end Error;

   ---------------
   --  Warning  --
   ---------------

   procedure Warning (Msg : Wide_String; Force : Boolean := False) is
      Indent_Level : Integer;
   begin

      if Warning_Indent_Level > 50 then
         Indent_Level := 50;
      else
         Indent_Level := Warning_Indent_Level;
      end if;

      if not Quiet_Mode then

         if Output_Debug_Information or else Force then
            Set_Output (Standard_Error);
            Put (Spaces (1 .. Indent_Level));
            Put_Line (Msg);
            Set_Output (Standard_Output);
         end if;

      end if;

   end Warning;

end Gnatelim.Errors;
