/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result.output;

import java.io.IOException;
import java.io.OutputStream;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.result.output.Output;

public abstract class ByteOutput
implements Output {
    protected int pos_;
    protected byte[] buffer_ = new byte[4096];
    protected int max_ = 4095;
    private OutputStream out_;
    private static final int BUFFER_SIZE = 4096;

    public ByteOutput(OutputStream outputStream) {
        this.out_ = outputStream;
    }

    public final void printSmallByte(char c) {
        if (this.pos_ == this.max_) {
            this.flushBuffer();
        }
        this.buffer_[this.pos_++] = (byte)c;
    }

    public final void printSmallBytes(char c, int n) {
        if (this.pos_ + n > this.max_) {
            this.flushBuffer(n);
        }
        byte by = (byte)c;
        while (n-- > 0) {
            this.buffer_[this.pos_++] = by;
        }
    }

    public final void printChars(char[] cArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            char c;
            while ((c = cArray[n2++]) < '\u0080' && n2 < n) {
                this.printSmallByte(c);
            }
            this.printChar(c);
        }
    }

    public void printString(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            while ((c = string.charAt(n2++)) < '\u0080' && n2 < n) {
                this.printSmallByte(c);
            }
            this.printChar(c);
        }
    }

    protected void flushBuffer(int n) {
        this.flushBuffer();
        if (n > 4096) {
            this.buffer_ = new byte[n];
            this.max_ = n - 1;
        }
    }

    protected void flushBuffer() {
        try {
            this.out_.write(this.buffer_, 0, this.pos_);
            this.pos_ = 0;
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public final void flush() {
        this.flushBuffer();
        try {
            this.out_.flush();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    private void handleException(IOException iOException) {
        throw new XsltException("output error", iOException);
    }
}

