// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __OrderInfo_h__
#define __OrderInfo_h__

#include "Puma/Array.h"
#include "Puma/Printable.h"
#include "Puma/ACTree.h"
#include "Puma/Unit.h"

using namespace Puma;

namespace Puma {
  class CT_AdviceDecl;
} // namespace Puma

class AspectInfo;

class OrderInfo {
 private:
  AspectInfo *_aspect;
  CT_AdviceDecl *_tree;
  
 public:

  OrderInfo (AspectInfo *ai, CT_AdviceDecl *ad) :
    _aspect (ai), _tree (ad) {}
  CT_AdviceDecl *tree () const { return _tree; }
  AspectInfo *aspect () { return _aspect; }
  const Unit &unit () const {
    return *(Unit*)_tree->token ()->belonging_to ();
  }
  int line () const { return _tree->token ()->location ().line (); }
  int lines () {
    return _tree->end_token()->location().line() - line () + 1;
  }
  
};

#endif // __OrderInfo_h__
