// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ACIntroductionInfo_h__
#define __ACIntroductionInfo_h__

#include "Puma/CProtection.h"

namespace Puma {


class CT_AdviceDecl;
class ACAspectInfo;

/** \file 
 *  Representation of an AspectC++ introduction 'advice'.
 *  \see Puma::ACIntroductionInfo */

/** \class ACIntroductionInfo ACIntroductionInfo.h Puma/infos/acinfos/ACIntroductionInfo.h
 *  An ACIntroductionInfo object represents an AspectC++ introduction 
 *  'advice' declaration. */
class ACIntroductionInfo {
  CT_AdviceDecl *_def_node;
  CProtection::Type _prot;
  ACAspectInfo *_aspect;

public:
  /** Construct an ACIntroductionInfo object.
   *  \param d The corresponding advice declaration syntax tree node.
   *  \param p The protection of the advice (\e public, \e protected,
   *           \e private). */
  ACIntroductionInfo (CT_AdviceDecl *d, CProtection::Type p) :
    _def_node (d), _prot (p) {}

  /** Get the introduction advice declaration syntax tree node. */
  CT_AdviceDecl *def_node () { return _def_node; }
  /** Get the protection of the introduction advice (\e public, 
   *  \e protected, \e private). */
  CProtection::Type prot () { return _prot; }
  
  /** Set the aspect containing the introduction.
   *  \param ai The aspect info. */
  void Aspect (ACAspectInfo *ai) { _aspect = ai; }
  /** Get the aspect containing the introduction. */
  ACAspectInfo *Aspect () { return _aspect; }

};


} // namespace Puma

#endif /* __ACIntroductionInfo_h__ */
