// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Chain_h__
#define __Chain_h__

//
// implements a simple chain
// 

#ifndef __puma
#include <iostream>
using namespace std;
#endif 

namespace Puma {


class Chain {
  Chain *next;

public:
  Chain () { next = 0; }
   
  void select (Chain *c) { next = c; }
  Chain *select () const { return next; }

  Chain *unlink () {
    Chain *res = next;
    if (next) {
      next = next->select ();
    }
    return res;
  }

  void insert (Chain *c) {
    c->select (next);
    next = c;
  }
};

#ifndef __puma


//
// Chain with useage/max counter
// 

class ChainCnt : public Chain {
  const char* name;

public:
  long long max, use;
  
  ChainCnt (const char *n) : name (n) { max = use = 0; }
  ~ChainCnt () {
    cout << "max list " << name << ": " << max << endl;
  }

  Chain *unlink () {
    Chain *c = Chain::unlink ();
    if (c) 
      use--;
    return c;
  }
  
  void insert (Chain *c) {
    use++;
    if(use > max) 
      max = use;
    Chain::insert (c);
  }
};

#endif /* __puma */


} // namespace Puma

#endif /* __Chain_h__ */
