// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __list_h__
#define __list_h__

#include "Puma/ListElement.h"

namespace Puma {


class List {
  ListElement *_first;
  ListElement *_last;

public:
  List () : _first ((ListElement*)0), _last ((ListElement*)0) {}
  List (const List &);
  ~List();

  List &operator = (const List &);
  List &operator += (const List &);
  List operator + (const List &);

  void clear ();

  void append (ListElement &);
  void prepend (ListElement &);
  void insert (ListElement *at, ListElement &element);
  void remove (ListElement *element);
  void kill (ListElement *from, ListElement *to = (ListElement*)0)
   { List discard; cut (discard, from, to); }

  void cut (List &out, ListElement *from, ListElement *to = (ListElement*)0);
  //List *cut (ListElement *from, ListElement *to = (ListElement*)0);
  List *copy (ListElement *from = (ListElement*)0, 
              ListElement *to = (ListElement*)0);
  void paste (ListElement *at, const List &l);
  void paste_before (ListElement *at, const List &l);
  void move (ListElement *at, List &l);
  void move_before (ListElement *at, List &l);

  bool empty () const { return _first == (ListElement*)0; }
  const ListElement *first () const { return _first; }
  const ListElement *last () const { return _last; }
  const ListElement *next (const ListElement *element) const
   { return element->_next; }
  const ListElement *prev (const ListElement *element) const 
   { return element->_prev; }
};


} // namespace Puma

#endif /* __list_h__ */
