// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __sb_filter_h__
#define __sb_filter_h__

#include "Puma/ScanBuffer.h"

namespace Puma {


class SB_Filter : public ScanBuffer {
  ScanBuffer *next_buffer;

public:
  void decorate (ScanBuffer *nb) { next_buffer = nb; }
  char next () { return next_buffer->next (); }
  char *token () { return next_buffer->token (); }
  int len () const { return next_buffer->len (); }
  void reset () { next_buffer->reset (); }
  void retry () { next_buffer->retry (); }
  void accept (int len) { next_buffer->accept (len); }
  void more (int len) { next_buffer->more (len); }
  State state () const { return next_buffer->state (); }
};


} // namespace Puma

#endif /* __sb_filter_h__ */
